/**
 * 日志下载初始化
 */
var LogDownload = {
    tableId: "logTable",
    seItem: null,
    selectedTreeNode: null,
    treeRefreshing: false,
    layerIndex: -1,
};

layui.use(['layer', 'table', 'HussarAjax', 'Hussar', 'jstree'], function() {
    var layer = layui.layer
        , table = layui.table
        , $ = layui.jquery
        , $ax = layui.HussarAjax
        , Hussar = layui.Hussar;

    /**
     * 初始化日志文件目录树
     */
    LogDownload.iniLogTree = function(){
        var $logTree = $("#logTree");
        $logTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath+"/logDownload/logTree",
                        function(result) {
                            if ( result.code == 500) {
                                Hussar.info( result.message );
                            } else {
                                data = result;
                            }
                        },
                        function(data) {
                            Hussar.error("加载日志目录树失败！");
                        });
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['types'],
            types:{
                "directory":{icon: Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dicTypes.png"}
            },
        }).on( 'loaded.jstree', function (e, data) {
            //树加载完成后默认选中根节点
            var inst = data.instance;
            var obj = $logTree.jstree('get_node', "logs");
            LogDownload.selectedTreeNode = obj.original.path;
            inst.select_node(obj);
            //初始化日志文件表格
            LogDownload.iniLogTable();
        });
        //树节点点击事件
        $logTree.bind("activate_node.jstree", function (obj, e) {
            var currentNode = e.node;	//点击的树节点
            LogDownload.selectedTreeNode = currentNode.original.path;
            LogDownload.search();
        });

    };

    /**
     *  日志文件查询
     */
    LogDownload.search = function () {
        var queryData = {};
        queryData['pathId'] = LogDownload.selectedTreeNode;
        table.reload(LogDownload.tableId, {where: queryData});
    }


    /**
     * 	初始化日志文件列表
     */
    LogDownload.iniLogTable= function () {
        table.render({
            elem: "#"+LogDownload.tableId,
            url: Hussar.ctxPath+'/logDownload/logTable',
            page: false,
            id: LogDownload.tableId,
            even: true,
            height: $("body").height() - 26,
            cols: [[
                {type: 'numbers', title: '序号', align: 'center',width:50},
                {field: 'fileName', title: '日志名称', align:'center', sort:true},
                {field: 'fileSize', title: '文件大小(KB)', align:'center',sort:true},
                {field: 'fileLastEditTime', title: '最后修改时间', align:'center',sort:true},
                {field: '', title: '操作', align:'center',style:'cursor: pointer;color:#00a4ff',event: 'download',templet:'<div>下载</div>div>'
                },
            ]],
            where: {
                pathId : LogDownload.selectedTreeNode
            }
        });

        // 监听单元格点击事件
        table.on('tool(log)', function(obj) {
            var data = obj.data;
            if (obj.event == 'download') {
                LogDownload.download(data.fileId);
            }
        });

    }

    /**
     * 日志文件下载
     * @param fileId 文件id
     */
    LogDownload.download = function (fileId) {
        var url = Hussar.ctxPath + "/logDownload/download";
        var form = $("<form></form>").attr("action", url).attr("method", "post");
        form.append($("<input></input>").attr("type", "hidden").attr("name", "fileId").attr("value", fileId));
        form.appendTo('body').submit().remove();
    }


    $(function () {
        //树列表高度
        var bodyH = $("body").height();
        $(".tree-box").css("height", bodyH + "px");
        //初始化日志文件目录树
        LogDownload.iniLogTree();
    });

});
