layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'element'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var jstree = layui.jstree;
    var $ax = layui.HussarAjax;
    var layerView;
    var OrgTreeDemo = {};
    var userTreeArry = [];
    var UserMgr = {};

    $("#userName").click(function () {
        layerView = layer.open({
            type: 1,
            area: ['350px', '400px'],
            fix: false, //不固定
            maxmin: true,
            shadeClose: false,
            shade: 0.4,
            title: "用户树",
            content: $("#userTreeDiv"),
            success: function () {
                var data;
                var ajax = new $ax(Hussar.ctxPath + "/user/userTree", function (result) {
                    data = result;
                }, function (data) {
                    Hussar.error("获取用户树失败！");
                });
                ajax.set("treeType", 3);
                ajax.start();
                OrgTreeDemo.initUserTree(data);
            },
            end:function () {
                $("#userTreeSearch").val("");
                $("#userTreeSearchResult").html("");
                $('#showUserTree').jstree("destroy");
            }
        });
    });
    OrgTreeDemo.initUserTree = function (data) {
        var $tree = $("#showUserTree");
        $tree.jstree({
            core: {
                data: data,
                "multiple": true,
            },
            plugins: ['types', 'checkbox','search'],
            checkbox: {
                keep_selected_style: false,
                three_state: true,
                tie_selection: false
            },
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"}
            },
            search: UserMgr.search(),
            sort:function(a,b){
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            }
        })
        $tree.bind('activate_node.jstree', function (obj, e) {
            var ref = $tree.jstree(true);
            if (e.node.type == "USER") {
                var nodes = ref.get_checked(); //使用get_checked方法
                OrgTreeDemo.getUserCheckedId($tree);
            } else {
                ref.uncheck_node(e.node.id);
                return;
            }
        })
        $tree.bind('loaded.jstree', function (obj, e) {
            //这两句话是在loaded所有的树节点后，然后做的选中操作，这点是需要注意的，loaded.jstree 这个函数
            //取消选中，然后选中某一个节点
            $("#showUserTree").jstree("deselect_all",true);
            //是选中的节点id，然后后面的一个参数 true表示的是不触发默认select_node.change的事件
            var userId = $("#userId").val();
            var ids =  userId.split(",");
            $('#showUserTree').jstree('check_node',ids,true);
            OrgTreeDemo.getUserCheckedId($tree);
        })
    }
    OrgTreeDemo.getUserCheckedId = function (tree) {
        var ref = tree.jstree(true);
        var nodes = ref.get_checked(true);  //使用get_checked方法
        var nds = [];
        var names = '';
        $.each(nodes, function (i, nd) {
            var type = nd.original.type;
            if (type == "USER") {
                nds.push(nd.id);
                names += "," + nd.text
            }
        });
        userTreeArry = [];
        userTreeArry.push(nds);
        userTreeArry.push(names.substring(1));
        return userTreeArry;
    }
    $("#userTreeSave").click(function () {
        var nodes = $("#showUserTree").jstree(true).get_checked();//使用get_checked方法
        if (nodes.length == 0) {
            layer.msg("请选择用户！");
        } else {
            $("#userId").val(userTreeArry[0]);
            $("#userName").val(userTreeArry[1]);
            $("#userTreeSearch").val("");
            $("#userTreeSearchResult").html("");
            $('#showUserTree').jstree("destroy");
            layer.close(layerView);
        }
    })
    $("#userTreeRest").click(function () {
        $("#userTreeSearch").val("");
        $("#userTreeSearchResult").html("");
        var $tree = $("#showUserTree");
        var ref = $tree.jstree(true);
        ref.uncheck_node(userTreeArry[0]);
        userTreeArry = [];
    })
    /**
     * 所有树的模糊查询
     */
    UserMgr.search = function () {
        var to = false;
        //用户树查询
        $("#userTreeSearch").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#userTreeSearch").val();
                var temp =$("#showUserTree").is(":hidden");
                if (temp == true) {
                    $("#showUserTree").show();
                }
                $("#showUserTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $("#userTreeSearchResult").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#showUserTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                    $("#userTreeSearchResult").html("");
                }
            }, 250);
        });
    }
})