/**
 * 初始化用户欢迎页配置详情对话框
 */
var SysWelcomeInfoDlg = {
    sysWelcomeInfoData : {}
};

layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax',"form"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer=layui.layer;
    var $ax=layui.HussarAjax;
    var form=layui.form;
    var table1;
    var layerView;
    var SysWelcome = {
        seItem: null
    };

    /**
     * 初始化按钮事件
     */
    SysWelcome.initButtonEvent = function () {
        $("#btnSave").click(function(){
            SysWelcome.addSubmit();
        });
        $("#add").click(function(){
            SysWelcome.openAddSysWelcome();
        });
        $("#edit").click(function(){
            SysWelcome.openSysWelcomeDetail();
        });
        $("#del").click(function(){
            SysWelcome.delete();
        });
        $("#btnClose").click(function(){
            SysWelcome.closeIndex();
        });
    }

    /**
     * 选中一条结果
     */
    SysWelcome.check = function() {
        var checkStatus = table1.checkStatus('SysWelcomeTable'),
            data = checkStatus.data;
        if (data.length == 0 || data.length > 1) {
            Hussar.info("请选择一条记录！");
            return false;
        } else {
            SysWelcome.seItem = data[0];
            return true;
        }
    };

    /**
     * 选中多条结果
     */
    SysWelcome.checks = function() {
        var checkStatus = table1.checkStatus('SysWelcomeTable'),
            data = checkStatus.data;
        var ids = [];
        if (data.length == 0) {
            Hussar.info("请至少选择一条记录！");
            return false;
        } else {
            for (var i = 0, l = data.length; i < l; i++) {
                var r = data[i];
                ids.push(r.welcomeUrl);
            }
            var eId = ids.join(',');
            SysWelcome.seItem = eId;
            return true;
        }
    };

    /**
     * 点击添加用户欢迎页配置
     */
    SysWelcome.openAddSysWelcome = function () {
        $("#status").val("add");
        layerView=layer.open({
            type : 1,
            area : [ '400px', '300px' ],
            shadeClose : false,
            maxmin : false,
            title : '新增',
            content : $("#viewEvent"),
            success : function() {
                $('#addForm')[0].reset();
                form.render();
            },end : function() {
                $("#userName").val("");
                $("#userId").val("");
                $("#welcomeUrl").val("");
                $("#oldUrl").val("");
                form.render();
            }
        });
    };

    /**
     * 点击修改用户欢迎页配置
     */

    SysWelcome.openSysWelcomeDetail = function () {
        if (this.check()) {
                $("#status").val("edit");
                layerView=layer.open({
                    type : 1,
                    area : [ '400px', '300px' ],
                    shadeClose : false,
                    maxmin : false,
                    title : '修改',
                    content : $("#viewEvent"),
                    success : function() {
                        var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/sysWelcome_update", function(data) {
                            $("#userName").val(data.userName);
                            $("#userId").val(data.userId);
                            $("#welcomeUrl").val(data.welcomeUrl);
                            $("#oldUrl").val(data.welcomeUrl);
                            form.render();
                        }, function(data) {
                            Hussar.error("查询信息失败！");
                        });
                        ajax.set("sysWelcomeUrl",SysWelcome.seItem.welcomeUrl);
                        ajax.start();
                    },end : function() {
                        $("#userName").val("");
                        $("#userId").val("");
                        $("#welcomeUrl").val("");
                        $("#oldUrl").val("");
                        form.render();
                    }
                });
        }
    };
    /**
     * 删除用户欢迎页配置
     */
    SysWelcome.delete = function () {
        if (SysWelcome.checks()) {
            var operation =function(){
                var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/delete",
                    function(data) {
                        if (data.code == 200){
                            $(".layui-laypage-btn").click();
                            Hussar.success("删除成功！");
                        }else {
                            Hussar.error("删除失败！")
                        }
                    }, function(data) {
                        Hussar.error("删除失败！");
                    });
                ajax.set("sysWelcomeUrl", SysWelcome.seItem);
                ajax.start();
            };
            Hussar.confirm("确定要删除吗 ?", operation);
        }
    };


    SysWelcome.initTable = function () {
        layui.use('table', function () {
            var table = layui.table;
            table.render({
                elem: '#SysWelcomeTable',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysWelcome/list',
                cols: [
                    [{
                        type: 'checkbox',
                        width:40
                    },{
                        title: '序号',
                        type: 'numbers',
                        align: 'center'
                    }, {
                        field: 'userName',
                        title: '用户名',
                        sort:false,
                        align:'center'
                    }, {
                        field: 'welcomeUrl',
                        title: '访问地址',
                        align: 'center',
                        sort:false,
                    }
                    ]],
                page: true,
                id: 'SysWelcomeTable',
                even: true
            });
            table1 = table;
        });
    }
    /**
     * 初始化
     */
    $(function () {
        SysWelcome.initTable();
        SysWelcome.initButtonEvent(); //初始化按钮事件
    });
    SysWelcome.closeIndex = function () {
        layer.close(layerView);
        // 执行重载
        table1.reload('SysWelcomeTable', {
            page : {
                curr : 1
            }
        });
    }
    /**
     * 清除数据
     */
    SysWelcome.clearData = function() {
        this.sysWelcomeInfoData = {};
    };

    /**
     * 设置对话框中的数据
     *
     * @param key 数据的名称
     * @param val 数据的具体值
     */
    SysWelcome.set = function(key, val) {
        this.sysWelcomeInfoData[key] = (typeof val == "undefined") ? $("#" + key).val() : val;
        return this;
    };

    /**
     * 设置对话框中的数据
     *
     * @param key 数据的名称
     * @param val 数据的具体值
     */
    SysWelcome.get = function(key) {
        return $("#" + key).val();
    };

    /**
     * 关闭此对话框
     */
    SysWelcomeInfoDlg.close = function() {
        SysWelcome.closeIndex();
    };

    /**
     * 收集数据
     */
    SysWelcome.collectData = function() {
        SysWelcome
            .set('userId')
            .set('welcomeUrl');
    };

    /**
     * 保存
     */
    SysWelcome.addSubmit = function() {
        var type=$("#status").val();
        form.on('submit(save)', function(data){
            if(type=="add"){
                SysWelcome.add();
            }else{
                SysWelcome.edit();
            }
        });

    };
    /**
     * 新增
     */
    SysWelcome.add = function() {
        SysWelcome.clearData();
        SysWelcome.collectData();
        //提交信息
        var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/add", function(data){
            if (data.code == 200) {
                Hussar.success("保存成功！");
            }else {
                Hussar.error(data.message);
            }
            SysWelcome.closeIndex();
        },function(data){
            Hussar.error("添加失败!" + data.responseJSON.message + "!");
        });
        ajax.set(this.sysWelcomeInfoData);
        ajax.start();
    };

    /**
     * 提交修改
     */
    SysWelcome.edit = function() {
        this.clearData();
        this.collectData();
        //提交信息
        var ajax = new $ax(Hussar.ctxPath + "/sysWelcome/update", function(data){
            if (data.code == 200) {
                Hussar.success("修改成功！");
            }else {
                Hussar.error(data.message);
            }
            SysWelcome.closeIndex();
        },function(data){
            Hussar.error("修改失败!" + data.responseJSON.message + "!");
        });
        ajax.set(this.sysWelcomeInfoData);
        ajax.set("oldUrl",$("#oldUrl").val());
        ajax.start();
    };
});
