/**
 * @Description: 定义找回密码页面脚本文件
 * @Author: LiangDong
 * @Date: 2018/4/18.
 */

layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','HussarSecurity'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;	
	var Security = layui.HussarSecurity;	
	var GetPwd = {		    
		    layerIndex: -1,
		    userId: null,
		};
	
	/**
	 * 验证用户名
	 * 如果正确并返回问题
	 */
	GetPwd.validateAccount = function () {
		var userId = $("#userId").val();
		var kaptcha = $("#kaptcha").val();
		var ajax = new $ax(Hussar.ctxPath + "/getBackPwd/getQues",
				function(data) {			
					if (data.code == "200") {						
						$("input[name='pQues']").val(data.message);		
						$("#idArea").addClass("hide");
						$("#quesArea").removeClass("hide");							
						GetPwd.userId = userId;
					} else if (data.code) {
						Hussar.error(data.message);
					}
				}, 
				function(data) {
					Hussar.error("保存失败!");
				});		
		ajax.set("userId", userId);
		ajax.set("kaptcha", kaptcha);
		ajax.start();
	}
	
	/**
	 * 验证问题答案
	 */
	GetPwd.validateKey = function () {
		var pQues = $("#pQues").val();
		var pKey = $("#pKey").val();
		var ajax = new $ax(Hussar.ctxPath + "/getBackPwd/validateKey",
				function(data) {			
					if (data.code == "200") {						
						$("#quesArea").addClass("hide");
						$("#pwdArea").removeClass("hide");							
					} else if (data.code) {
						Hussar.error(data.message);
					}
				}, 
				function(data) {
					Hussar.error("保存失败!");
				});		
		ajax.set("userId", GetPwd.userId);
		ajax.set("pQues", pQues);
		ajax.set("pKey", pKey);
		ajax.start();
	}
	
	/**
	 * 设置新密码
	 */
	GetPwd.setNewPwd = function () {
//		var data = encode64($("#pwdForm").serialize());		//前台加密

		var data = Security.encode($("#pwdForm").serialize());//调用加密方法进行加密

		var ajax = new $ax(Hussar.ctxPath + "/getBackPwd/setNewPwd",
				function(data) {			
					if (data.code == "200") {						
						GetPwd.toLogin();
					} else if (data.code) {
						Hussar.error(data.message);
					}
				}, 
				function(data) {
					Hussar.error("保存失败!");
				});		
		ajax.set("userId", GetPwd.userId);
		ajax.set("data", data);		
		ajax.start();
	}
	
	/**
	 * 去登录
	 */
	GetPwd.toLogin = function () {
        var operation = function () {
            window.location.href = Hussar.ctxPath+"/login";
        };
        Hussar.confirm("密码修改成功，请重新登录。", operation);
	};
	
	
	/**
	 * 初始化按钮事件
	 */
	GetPwd.initButtonEvent = function () {		
		
		//保存用户名和验证码按钮事件
		$("#save1").click(function(){
			form.on('submit(account)', function(data){
				GetPwd.validateAccount();
			});	
		});
		
		//保存问题答案按钮事件
		$("#save2").click(function(){
			form.on('submit(key)', function(data){
				GetPwd.validateKey();
			});	
		});
		
		//保存设置新密码按钮事件
		$("#save3").click(function(){
			form.on('submit(pwd)', function(data){
				GetPwd.setNewPwd();
			});	
		});
		
		//点击验证码图片
		$("#kaptchaImg").click(function(){			
			$("#kaptchaImg").attr('src', '/kaptcha?' + Math.floor(Math.random() * 100)).fadeIn();
		});
		
	}
	
	/**
	 * 初始化表单验证
	 */
	GetPwd.initValidate = function () {
		form.verify({
			pwd: [/^[\S]{6,12}$/ , '密码必须6到12位，且不能出现空格'] 
		});
	}
	

	$(function () { 
		GetPwd.initButtonEvent();	//	初始化按钮事件
		GetPwd.initValidate();	//初始化表单验证
		Security.initSecurityKey();// 初始化加密密钥
	});	
	
});




