/**
 * @Description: 通用前端加密组件
 * @Author: 组件
 * @Date: 2018/7/11.
 */

layui.define([ 'jquery', 'layer', 'HussarAjax','Hussar' ],function(exports) {
	var $ = layui.jquery, $ax = layui.HussarAjax;
	var Hussar = layui.Hussar;
	var HussarSecurity = {
		ctxPath: hussar_path,
	    addCtx: function (ctx) {
	        if (this.ctxPath == "") {
	            this.ctxPath = ctx;
	        }
	    },
		pk: '0',
		securityType:'RSACryptoProvider',
		/* 初始化加密密钥 */
		
		initSecurityKey:function(next) {
			var that = this;
			if("Base64CryptoProvider" == that.securityType){
				return;
			}
			var ajax = new $ax(Hussar.ctxPath + "/security?rand="
					+ (new Date()).valueOf(), function(data) {
				if (data.code == 200) {
					that.pk = data.publicKey;
					that.securityType = data.securityType;
				}
				if(!!next){
					next();
				}
			});
			ajax.start();
		},
		
		encode:function(cipher) {
			cipher = decodeURIComponent(cipher,true); 
			var that = this;
			if ("RSACryptoProvider" == that.securityType) {
					var encrypt = new JSEncrypt();
					encrypt.setPublicKey(that.pk);
					var data = encrypt.encrypt(cipher);
					return data;
			}
			if("AESCryptoProvider" == that.securityType){
				var key = CryptoJS.enc.Utf8.parse(that.pk);
			    var srcs = CryptoJS.enc.Utf8.parse(cipher);
			    var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
			    return encrypted.toString();
			}
			if("Base64CryptoProvider" == that.securityType){
			    var encrypted = encode64(cipher);
			    return encrypted.toString();
			}
		},
	};
	exports('HussarSecurity', HussarSecurity);
});