/**
 * @Description: 资源新增脚本文件
 * @Author: sunZengXin
 * @Date: 2018/3/8.
 */
layui.use(['jquery','layer','Hussar','form', 'HussarAjax', 'element', 'jstree'], function(){
	var form=layui.form,
	    $ = layui.jquery,
        element=layui.element,
	    $ax=layui.HussarAjax,
        jstree=layui.jstree,
	    Hussar = layui.Hussar;

    var ResourceAdd={
        resourceId:''
    };

    /**
	 *  初始化表单验证
     */
    ResourceAdd.initValidate = function () {
        form.verify({
            url : function(value, item){
                var msg="";
                var ajax = new $ax(Hussar.ctxPath + "/resource/sameUrl", function(data) {
                    if(data.length!=0){
                        msg= 'URL名称已存在！';
                    }
                }, function(data) {
                    Hussar.error("查询URL名称是否存在失败！");
                });
                ajax.set("url",value);
                ajax.start();
                return msg;
            },
            permission : function (value, item) {
                if(!/^[a-zA-Z0-9]+\:{1}[a-zA-z0-9\*]+(\:{1}[a-zA-z0-9\*]+){0,1}$/.test(value)){
                    return '格式为 资源:操作 或 资源:操作:实例'
                }
            }
        })
    };

    /**
	 *  初始化按钮事件
     */
    ResourceAdd.initButtonEvent = function () {
    	//资源类型下拉框切换监听
        form.on('select(typeList)', function(data){
            if (data.value == '1') {
                $('#resType').hide();
                $("#urlShow").css("display","block");
                $("#urlNames").attr("lay-verify","required|url");
            } else if (data.value == '2') {
                $("#urlShow").css("display","none");
                $("#urlNames").removeAttr("lay-verify");
                $('#resType').show();
            }
        });

        //提交监听
        form.on('submit(resourceAdd)', function(data){
            var formData = data.field;
            if(formData.isDefault){
                formData.isDefault = 1;
            }else{
                formData.isDefault = 0;
            }
            if(formData.isAudit){
                formData.isAudit = 1;
            }else{
                formData.isAudit = 0;
            }
            if(formData.isRepeatAuthenticate){
                formData.isRepeatAuthenticate = 1;
            }else{
                formData.isRepeatAuthenticate = 0;
            }

            var ajax = new $ax(Hussar.ctxPath + "/resource/resourceSave", function(data) {
                Hussar.success("基本信息保存成功!");
                ResourceAdd.resourceId = data;
                //切换到关联角色Tab页
                $("#roleMsg").removeAttr("style");
                $("#roleMsg").click();
            }, function(data) {
                Hussar.error("保存失败！");
            });
            ajax.setData(formData);
            ajax.start();
            return false;
        });

        /**
         * 保存资源关联角色
         */
        $("#saveRole").click(function(){
            //获取所选择的关联角色id
            var nodes = $("#roleTree").jstree(true).get_checked(true);
            var roleIds =[];
            $.each(nodes, function(i, nd) {
                if(nd.type == 'ROLE'){
                    roleIds.push(nd.original.id);
                }
            });
            var ajax = new $ax(Hussar.ctxPath + "/resource/resourceAddSaveRole", function(data) {
                window.parent.layui.Hussar.success("资源关联角色保存成功！");
                //刷新父页面
                window.parent.ResourceManage.refreshPage();
            }, function(data) {
                Hussar.error("保存失败！");
            });
            ajax.set("resourceId",ResourceAdd.resourceId);
            ajax.set("roleIds",roleIds.join(','));
            ajax.start();
        });
		
    };

    /**
	 *  初始化角色树
     */
    ResourceAdd.initRoleTree = function () {
        var $roleTree = $("#roleTree");//角色树
        $roleTree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleTree",
                        function(result) {
                            data = result;
                        },
                        function(data) {
                            Hussar.error("加载资源关联角色树失败！");
                        });
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['types','search','checkbox'],
            types:{
                "GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/roleGroup.png"},
                "ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/role.png"},
                "isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/root.png"}
            },
            checkbox: {
                keep_selected_style : false,//是否默认选中
                three_state : true,//是否父子级别关联
                tie_selection : false
            },
            search: ResourceAdd.searchRole()
        });
		
    };

    /**
	 *  资源关联角色树查询
     */
    ResourceAdd.searchRole = function () {
        var to = false;
        $("#searchRole").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#searchRole").val();
                var temp = $("#roleTree").is(":hidden");
                if (temp == true) {
                    $("#roleTree").show();
                }
                $("#roleTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#roleTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                }else {
                }
            }, 250);
        });
    };

    /**
     *  页面初始化
     */
    $(function() {
    	ResourceAdd.initValidate();
        ResourceAdd.initButtonEvent();
        ResourceAdd.initRoleTree();
    });

});
