/**
 * @Description: 用户角色审核脚本文件
 * @Author: chenxin
 * @Date: 2018/3/7.
 */

/**
 * 用户角色初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element'], function(){
	
var Hussar = layui.Hussar;
var $ = layui.jquery;
var layer=layui.layer;
var $ax=layui.HussarAjax;
var form=layui.form;
var table1;
var infoWin;
var element = layui.element;

var UserRoleReview = {
	setUid : null,
	setRid : null,
	setOpsType : null,
	setStatus : null
};

/**
 * 页面初始化
 */
UserRoleReview.initPage = function () {
	this.initTable();
	this.initButton();
	this.queryOption();
}

/**
 * 加载列表
 */
UserRoleReview.initTable = function() {
	layui.use('table', function() {
		var table = layui.table;
        var userAccount = $('#userAccount').val();
        var userName = $('#userName').val();
        var type = $("#type option:selected").val();
		table.render({
			elem : '#reviewTable',
			url : Hussar.ctxPath + '/userRoleReview/list',
			cols : [ [
			          {type: 'checkbox',width:40} ,
			          {title : '序号', type : 'numbers', align : 'center',width:50},
			          {title : '用户所属单位', field: 'ORGAN_ALIAS', align : 'center'},
			          {title : '用户账号', field: 'USER_ACCOUNT', align : 'center'},
			          {title : '用户名称', field: 'USER_NAME', align : 'center'},
			          {title : '操作', field: 'OPERATION_TYPE', align : 'center', templet : opType},
			          {title : '用户角色', field: 'ROLE_NAME', align : 'center',event: 'roleDeatil',style:'cursor: pointer;color:#00a4ff'},
			          {title : '状态', field: 'STATUS', align : 'center', templet : evts},
			          ] ],
			page : true,
			even: true,
			id : 'testReload',
            height:$("body").height() - $(".layui-form").outerHeight(true)-30,
			where: {
                userAccount : userAccount,
                userName : userName,
                type : type
			}
		});
		
		// 监听单元格事件
		table.on('tool(reviewTable)', function(obj) {
			var data = obj.data;
			if (obj.event == 'roleDeatil') {
				if(data.ROLE_NAME=""||data.ROLE_NAME==null){
					return;
				}else{
					layer.open({
						type : 1,
						area : [ '500px', '520px' ],
						//shift : 6,
						shadeClose: false,
						title : '角色信息',
						maxmin : false,
						content : $("#reviewPage"),
						success : function() {
							$("#roleMsg").click();
							var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleView",function(result) {
				                $('#roleName').html(result[0][0].roleName);
				                $('#roleYw').html(result[0][0].roleAlias);
				                if(result[2].length!=0){
				                	$("#groupHidden").css("display","");
				                	$('#org').html(result[2][0].groupName);
				                }else{
				                	$("#groupHidden").css("display","none");
				                }
				                $('#resourceTree').jstree("destroy");
				                var resource = [];
				    			for(var i=0; i<result[1].length; i++){
				    				resource.push(result[1][i].resourceId);
				    			} 
				                UserRoleReview.initResTree(resource);
				            },function(data) {
				                Hussar.error("加载角色信息失败！");
				            });
				            ajax.set("id",data.ROLE_ID)
				            ajax.start();
						}
					});
				}
			}
		});
		//状态formmate
		function evts(d) {
			if(d.STATUS==0){
				return '<span style="color:#8B5A00">未审核</span>';
			}
			if(d.STATUS==1){
				return '<span style="color:green">通过</span>';
			}
			if(d.STATUS==2){
				return '<span style="color:red">驳回</span>';
			}
		};
		//操作formmate
		function opType(d) {			
			if(d.OPERATION_TYPE==1){
				return '<span style="color:green">添加</span>';
			}else if(d.OPERATION_TYPE==2){
				return '<span style="color:red">删除</span>';
			}else{
				return '';
			}
		};
		table1 = table;
	});
};


/**
 * 获取状态option
 */
UserRoleReview.queryOption = function() {
	var ajax = new $ax(Hussar.ctxPath + "/userRoleReview/statusOption",
			function(json) {
				$("#type").html("");
				for (var i = 0; i < json.length; i++) {
					$("#type").append("<option value='" + json[i].value + "'>"+ json[i].label+"</option>");
				}
				form.render();
			}, function(data) {
				Hussar.error("获取上级组织机构类型失败！");
			});
	ajax.set(this.deptInfoData);
	ajax.start();
};

/**
 * 选中多条结果
 */
UserRoleReview.check = function() {
	var checkStatus = table1.checkStatus('testReload'), data = checkStatus.data;	
	var ids = [];
	var rids = [];
	var opsTypes = [];	//	操作类型
	var status = []; //状态
	if (data.length == 0) {
		Hussar.info("请至少选择一条记录！");
        //layer.confirm("请至少先选中表格中的某一记录！", { btn: ['确认'],title:'信息'});
		return false;
	} else {
		for (var i = 0, l = data.length; i < l; i++) {
			var r = data[i];
			ids.push(r.USER_ID);
			rids.push(r.ROLE_ID);
			opsTypes.push(r.OPERATION_TYPE);
			status.push(r.STATUS);
		}
		var eId = ids.join(',');
		var rid = rids.join(',');
		var oId = opsTypes.join(',');
		UserRoleReview.setUid = eId;
		UserRoleReview.setRid = rid;
		UserRoleReview.setOpsType = oId;
		UserRoleReview.setStatus=status;
		return true;
	}
};

/**
 * 按钮操作
 */
UserRoleReview.initButton = function () {
	
	/**
	 * 查询
	 */
	$('#search').on('click', function() {
		var userAccount = $('#userAccount');
		var userName = $('#userName');
		var type = $("#type option:selected");
		// 执行重载
		table1.reload('testReload', {
			page : {
				curr : 1
			// 重新从第 1 页开始
			},
			where : {
				userAccount : userAccount.val(),
				userName : userName.val(),
				type : type.val()
			}
		});
	});
	
	
	/**
	 * 打开
	 */
	$("#reviewSubmit").click(function(){
		if (UserRoleReview.check()) {
			var status=UserRoleReview.setStatus;
			for(var i=0;i<status.length;i++){
				if(status[i]=="0"||status[i]=="2"){
					var ajax = new $ax(Hussar.ctxPath + "/userRoleReview/reviewSubmit",function(result) {
						$(".layui-laypage-btn").click();
						Hussar.success("通过成功！");
					}, function(data) {
						Hussar.error("通过失败！");
					});
					ajax.set("userId",UserRoleReview.setUid);
					ajax.set("roleId",UserRoleReview.setRid);
					ajax.set("opsTypeId",UserRoleReview.setOpsType);
					ajax.start();
				}else{
					Hussar.info("请勿重复审核！");
					return  false;
				}
			}
		}
	});

	/**
	 * 拒绝
	 */
	$("#refuseSubmit").click(function(){
		if (UserRoleReview.check()) {
			var status=UserRoleReview.setStatus;
			for(var i=0;i<status.length;i++){
				if(status[i]=="0"){
					var operation =function(){
						var ajax = new $ax(Hussar.ctxPath + "/userRoleReview/refuseSubmit",function(result) {
							$(".layui-laypage-btn").click();
							Hussar.success("驳回成功！");
						}, function(data) {
							Hussar.error("驳回失败！");
						});
						ajax.set("userId",UserRoleReview.setUid);
						ajax.set("roleId",UserRoleReview.setRid);
						ajax.set("opsTypeId",UserRoleReview.setOpsType);
						ajax.start();
					}
					Hussar.confirm("确定要驳回吗 ?", operation);
					return  false;
				}else{
					Hussar.info("请勿重复审核！");
					return  false;
				}
			}
		}
	});
}

/**
 * 加载资源树
 */

UserRoleReview.initResTree = function (resource) {
    var $retree = $("#resourceTree");//资源树
    $retree.jstree({
        core: {
            check_callback: true,
            data: function (obj, callback) {
                var data;
                var ajax = new $ax(Hussar.ctxPath + "/resource/selfResourceTree",function(result) {
                	var arrays = [];
                    for(var i=0; i<result.length; i++){
                    	var arr = {
                    			 id	:	result[i].ID,
                                 parent : result[i].PARENT,
                                 text : result[i].TEXT,
                                 isRes : result[i].ISRES,
                                 type : result[i].TYPE,
                                 state : {selected:false, checked:false, disabled:true},
                                 seq : result[i].SEQ
                    		} 
                        for(var j=0; j<resource.length; j++){
                            if(resource[j] == result[i].ID){
                                arr.state.checked = true;
                                arr.state.selected = true;
                                break;
                            }
                        }
                        arrays.push(arr);
                    }
                    data = arrays;
                }, function(data) {
                    Hussar.error("加载资源树失败！");
                });
                ajax.set("rsourceIds",resource.join(','));
                ajax.start();
                callback.call(this, data);
            }
        },
        plugins: ['types','sort'],
        types:{
        	"isModule":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/module.png"},
        	"isFun":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/function.png"},
        	"1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
        	"2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
        	"isRoot":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/root.png"}
        },
        sort:function(a,b){
            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
        }
    });


};
/**
 * 初始化
 */
$(function() {
	UserRoleReview.initPage();
    $(window).resize(function() {
        UserRoleReview.initTable();
    });
});
});
