/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */

/**
 * 用户管理初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
    var RoleManage = {};
    var element=layui.element;
    var form=layui.form;
/*初始化页面*/
RoleManage.initPage = function() {
	this.initTable();
    this.initResTree();
    this.initFrameHeight()
}
/**
 * 加载资源树
 */

RoleManage.initResTree = function (roles) {
    var $retree = $("#resourceTree");//资源树
    $retree.jstree({
        core: {
            check_callback: true,
            data: function (obj, callback) {
                var data;
                var resource = [];
                for(var i=0; i<roles.length; i++){
    				resource.push(roles[i].resourceId);
    			}
            	var ajax = new $ax(Hussar.ctxPath + "/resource/selfResourceTree",function(result) {
                	var arrays = [];
                    for(var i=0; i<result.length; i++){
                    	var arr = {
                    			 id	:	result[i].ID,
                                 parent : result[i].PARENT,
                                 text : result[i].TEXT,
                                 isRes : result[i].ISRES,
                                 type : result[i].TYPE,
                                 state : {selected:false, checked:false, disabled:true},
                                 seq : result[i].SEQ
                    		} 
                        for(var j=0; j<resource.length; j++){
                            if(resource[j] == result[i].ID){
                                arr.state.checked = true;
                                arr.state.selected = true;
                                break;
                            }
                        }
                        arrays.push(arr);
                    }
                    data = arrays;
                }, function(data) {
                    Hussar.error("加载资源树失败！");
                });
                ajax.set("rsourceIds",resource.join(','));
                ajax.start();
                callback.call(this, data);
            }
        },
        plugins: ['search','types','sort'],
        types:{
        	"isRoot":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/root.png"} ,
        	"isModule":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/module.png"} ,
        	"isFun":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/function.png"} ,
            "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
            "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
        },
        sort:function(a,b){
            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
        },
        search : RoleManage.searchResource()
    });

};

/**
 * 资源树查询
 */
RoleManage.searchResource = function () {
    var to = false;
    $("#searchResource").keyup(function () {
        if (to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $("#searchResource").val();
            var temp = $("#resourceTree").is(":hidden");
            if (temp == true) {
                $("#resourceTree").show();
            }
            $("#resourceTree").jstree(true).search(v);
            //添加索引
            if(v!=''){
                var n = $(".jstree-search").length,con_html;
                if(n>0){
                    con_html = "<em>"+ n +"</em>个匹配项";
                }else{
                    con_html = "无匹配项";
                }
                $(".search-results1").html(con_html);
            }else {
                $(".search-results1").html("");
            }
        }, 250);
    });
};

RoleManage.initTable = function(){
	var nodeId=$("#nodeId").val();
	var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleView",function(result) {
        $('#resourceTree').jstree("destroy");
        RoleManage.initResTree(result[1]);
    },function(data) {
        Hussar.error("加载角色信息失败！");
    });
    ajax.set("id",nodeId)
    ajax.start();
}

RoleManage.initFrameHeight=function(){
	var h3 = $(window).height()-161;
	$("#contentInfo").css("height", h3 + "px");
};

/**
 * 初始化
 */
$(function() {
    RoleManage.initPage();
    $(window).resize(function() {
    	RoleManage.initFrameHeight();
	});
});
});