/**
 * @Description: 角色新增脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */

layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
	var form=layui.form;
    var RoleManage = {};
    var element=layui.element;
    var form;

/*初始化页面*/
RoleManage.initPage = function() {
	this.initResTree();
    this.initButtonEvent();
    this.validator();
    RoleManage.initFrameHeight();
    skin_dom.click(function () {
        skin = $(this).data("skin");
        //树属性全部重置刷新
        RoleManage.initResTree();
    });
}

/**
 * 加载资源树
 */

RoleManage.initResTree = function () {
    var $retree = $("#resourceTree");//资源树
    $retree.jstree({
        core: {
            check_callback: true,
            data: function (obj, callback) {
            	var data;
            	var ajax = new $ax(Hussar.ctxPath + "/resource/resTree",function(result) {
            		var arrays = [];
                    for(var i=0; i<result.length; i++){
                    	var arr = {
                    			 id	:	result[i].ID,
                                 parent : result[i].PARENT,
                                 text : result[i].TEXT,
                                 isRes : result[i].ISRES,
                                 state : {selected:false, checked:false,disabled:false},
                                 type : result[i].TYPE,
                                 seq : result[i].SEQ
                    		}
                    		//如果是敏感系统资源，不可更改
                    		if (result[i].CONSTANT == '1') {
                                arr.state.disabled = true;
                            }
                        arrays.push(arr);
                    }
                    data = arrays;
               }, function(data) {
                   Hussar.error("加载资源树失败！");
               });
               ajax.start();
                callback.call(this, data);
            }
        },
        plugins: ['checkbox','types','search'],
        types: {
            "isModule":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/module.png"} ,
            "isFun":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/function.png"} ,
            "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/resource_menu.png"}, //菜单资源
            "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/resource_btn.png"},  //按钮资源
        },
        checkbox: {
            keep_selected_style : false,
            three_state : true,
            tie_selection : false
        },
        search : RoleManage.searchResource()
    });

};

/**
 * 资源树查询
 */
RoleManage.searchResource = function () {
    var to = false;
    $("#searchResource").keyup(function () {
        if (to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $("#searchResource").val();
            var temp = $("#resourceTree").is(":hidden");
            if (temp == true) {
                $("#resourceTree").show();
            }
            $("#resourceTree").jstree(true).search(v);
            //添加索引
            if(v!=''){
                var n = $(".jstree-search").length,con_html;
                if(n>0){
                    con_html = "<em>"+ n +"</em>个匹配项";
                }else{
                    con_html = "无匹配项";
                }
                $(".search-results1").html(con_html);
            }else {
                $(".search-results1").html("");
            }
        }, 250);
    });
}

/**
 * 获取选中资源id
 */
RoleManage.getCheckedId = function () {
    var ref = $("#resourceTree").jstree(true);
    var nodes = ref.get_checked(true);  //使用get_checked方法
    var nds ='';
    $.each(nodes, function(i, nd) {
    	var type=nd.original.isRes;
    	if(type==1){
    		nds +=","+nd.id;
    	}
    });
        $("#nds").val("");//选择之前重置nds
        $("#nds").val(nds.substring(1));
}


/**
 * 初始化按钮事件
 */
RoleManage.initButtonEvent = function () { 	
    /* 保存操作 */
    $("#saveRole").click(function(){
    	form.on('submit(verify)', function(data){
            var data=$("#nodeId").val();//选中角色树的节点
            var roleName=$("#roleName").val();//角色名称
            var roleYw=$("#roleAlias").val();//角色业务含义
            var ajax = new $ax(Hussar.ctxPath + "/roleManager/addRole", function (roleId) {
            	//刷新父页面
				//parent.location.reload();
            	$("#roleId").val(roleId);
				Hussar.success("保存成功！");
				$("#saveRole").css("display","none");
				$("#reset").css("display","none");
				$("#resourceMsg").removeAttr("style");
				$("#resourceMsg").click();
            }, function () {
                Hussar.error("保存失败！");
            });
            ajax.set("groupId",data);
            ajax.set("roleName",roleName);
            ajax.set("roleAlias",roleYw);
            ajax.start();
    	});
    });
    
    /**
	 * 保存选择资源
	 */
	$("#saveResource").click(function(){
		RoleManage.getCheckedId();
		var ids=$("#nds").val();//选中资源树的节点
	    var ajax = new $ax(Hussar.ctxPath + "/roleManager/saveResource", function(data) {
	        Hussar.success("保存成功！");
	        parent.location.reload();
	    }, function(data) {
	        Hussar.error("保存失败！");
	    });
	    ajax.set("ids",ids);
	    ajax.set("roId",$("#roleId").val())
	    ajax.start();
	});
}

/**
 * 验证表单
 */
RoleManage.validator = function() {
	//自定义校验
	form.verify({
		required : function(value, item){
			if(value.trim()==""){
				$("#roleMsg").click();
				return '必填项不能为空！';
			}
		},
		roleName : function(value, item){
			if(!new RegExp("^[a-zA-Z0-9_\u4e00-\u9fa5\\s·]+$").test(value)){
				return '输入项不能有特殊字符！';
			}
		},
		sameRoleName : function(value, item){
			var oldRoleName=$("#oldRoleName").val().trim();
			if(oldRoleName!=value){
				var msg="";
				var ajax = new $ax(Hussar.ctxPath + "/roleManager/sameRoleName", function(data) {
					if(data.length!=0){
						msg= '角色名称已存在！';
					}
			    }, function(data) {
			        Hussar.error("查询角色名称是否存在失败！");
			    });
			    ajax.set("sameRoleName",value);
			    ajax.start();
			    return msg;
			}
		}
	})
};

RoleManage.initFrameHeight=function(){
	var h3 = $(window).height()-181;
	$("#contentInfo").css("height", h3 + "px");
};

/**
 * 初始化
 */
$(function() {
    RoleManage.initPage();
    $(window).resize(function() {
    	RoleManage.initFrameHeight();
	});
});
});