/**
 * @Description: 定义在线用户脚本文件
 * @Author: liangdong
 * @Date: 2018/3/16.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var table = layui.table;
	
	/**
	 * 在线用户的单例
	 */
	var OnlineUser = {
	    id: "onlineTable",	//表格id
	    seItem: null,		//选中的条目
	    table: null,
	    layerIndex: -1
	};

	/**
	 * 搜索在线用户
	 */
	OnlineUser.search = function () {    
		var userAccount = $('#userAccount').val();
	    var userName = $('#userName').val();
        table.reload('onlineTable', {where:{
            userAccount : userAccount,
            userName : userName
        }});
	}
	
	/**
	 * 终止会话
	 */
	OnlineUser.stopSession = function () {
		if (this.checkIds()) {
			var operation = function() {
				var ajax = new $ax(Hussar.ctxPath + "/online/stopSession",
						function(data) {
							if (data.code == "200") {
								Hussar.success("终止成功!");						
								OnlineUser.search();
							} else if (data.code) {
								Hussar.error(data.message);
							}							
						}, 
						function(data) {
							Hussar.error("终止失败!");
						});
				ajax.set("ids", OnlineUser.seItem);
				ajax.start();
			};
			Hussar.confirm("确定要终止选中的会话吗?", operation);
		}
	}
	
	/**
	 * 会话追踪
	 */
	OnlineUser.sessionTrack = function () {
		if (OnlineUser.check()) {
			OnlineUser.layerIndex = layer.open({
				type : 2,
				maxmin : true,
				title: '会话追踪',	
				area: ['80%', '90%'], //宽高
				content : Hussar.ctxPath+'/securityLog/view2/' + this.seItem,
				success : function() {					
					
				}
			});			
		}
	}

	/**
	 * 检查是否选中一条记录
	 */
	OnlineUser.check = function () {
		var flag = false;
	    var selected = table.checkStatus('onlineTable').data;
	    if (selected && selected.length == 1) {
	    	OnlineUser.seItem = selected[0].sessionId;
	        flag = true;
	    } else {
	    	Hussar.info("请选择一条记录！");
	    }
	    return flag;
	}	
	
	/**
	 * 检查是否选中多条记录
	 */
	OnlineUser.checkIds = function() {
		var selected = table.checkStatus('onlineTable').data;
		var ids = [];
		if (selected.length == 0) {
			Hussar.info("请至少选择一条记录！");
			return false;
		} else {
			for (var i = 0, l = selected.length; i < l; i++) {
				var r = selected[i];
				ids.push(r.sessionId);
			}
			var eId = ids.join(',');
			OnlineUser.seItem = eId;
			return true;
		}
	};

	/**
	 * 关闭弹出窗
	 */
	OnlineUser.closeWin = function () {
	    layer.close(OnlineUser.layerIndex);
	}
	
	/**
	 * 初始化按钮事件
	 */
	OnlineUser.initButtonEvent = function () {
		$("#btnSearch").click(function(){
			OnlineUser.search();
	    });
		$("#btnStopSe").click(function(){
			OnlineUser.stopSession();
	    });
		$("#btnTrackSe").click(function(){
			OnlineUser.sessionTrack();	
		});		
		$("#btnClose").click(function(){
			OnlineUser.closeWin();
		});
	}
	

	/**
	 * 初始化表格
	 */
	OnlineUser.initTableView = function () {
        var userAccount = $('#userAccount').val();
        var userName = $('#userName').val();
		table.render({
			elem: '#onlineTable',				
			url: Hussar.ctxPath+'/online/list',
			page: true,	
			id: 'onlineTable',
            height:$("body").height() - $(".layui-form").outerHeight(true)-26,
			even: true,					  		
			cols: [[{type: 'checkbox',width:40},
			        {title: '序号', type: 'numbers', align: 'center', width:50},
			        {title: '用户账号', field: 'userAccount', align:'center'},
			        {title: '用户名称', field: 'userName', align:'center', event: 'detailEvent', style:'cursor: pointer;color:#00a4ff'},
			        {title: '所属机构名称', field: 'corporationName', align:'center', width:250},		
			        {title: '客户端地址', field: 'remoteaddr', align:'center'},
			        {title: '登录时间', field: 'loginTime', align:'center', sort: true}
			]],
			where: {
                userAccount : userAccount,
                userName : userName
			}
		});		
	}
	
	// 监听单元格事件
	table.on('tool(detail)', function(obj) {
		var data = obj.data;
		if (obj.event == 'detailEvent') {
			layer.open({
				type : 1,
				title: '在线用户明细',
				area : [ '500px', '390px' ],				
				shadeClose : false,
				maxmin : false,
				content : $("#viewEvent"),
				success : function() {
					$('#viewForm')[0].reset();										
					$('#userAccount2').html(data.userAccount);
					$('#userName2').html(data.userName);					
					$('#corporationName').html(data.corporationName);
					$('#loginTime').html(data.loginTime);
					$('#browserType').html(data.browserType);
					$('#remoteaddr').html(data.remoteaddr);
					$('#remotehost').html(data.remotehost);
					$('#remoteport').html(data.remoteport);										
				}
			});
		}
	});

	$(function () { 	
		OnlineUser.initTableView(); //初始化表格    	    
	    OnlineUser.initButtonEvent(); //初始化按钮事件
        $(window).resize(function() {
            OnlineUser.initTableView();
        });
	});
	
});




