/**
 * @Description:职工维护脚本文件
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
layui.use(['jquery','layer','Hussar','jstree','form'], function(){
		var Hussar = layui.Hussar;
		var $ = layui.jquery;
		var layer=layui.layer;
		var form = layui.form;
	var EmplMaintenance = {
			treeId:"orgEmployeeTree",
			infoWin:null, //弹出窗口
			selectId:null,
			isRootChange:'0',
			changeLevel:null
	}
	/*初始化页面*/
	EmplMaintenance.initPage= function(){
		this.initTreeView();//初始化组织树
		this.initOrderTreeView();//初始化排序树
		this.initChangeTreeView();//初始化转移树
		this.initButtonEvent();
		EmplMaintenance.initFrameHeight();
	}
	/*组织机构树右键菜单*/
	EmplMaintenance.menuList=function(node){
		var items={
	                create: null,
	                remove: null,
	                ccp: null,
	                add: {
	                    label: "新增人员",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
	                        //alert(info.id+"+"+info.text);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织上级不同类型组织编码(用于构建下级组织机构编码)
				        	var parentTypeCode=clickedNode.original.parentTypeCode;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	//选中组织机构层级
				        	var struLevel = clickedNode.original.struLevel;
				        	//获取子节点数量
				        	var childNum = clickedNode.children.length;
				        	$.ajax({
				        		type:"POST",
				        		contentType:"application/x-www-form-urlencoded",
				        		url:Hussar.ctxPath+"/orgMain/getOrgRoleByCode",
				        		dataType:"json",
				        		data:{
				        			orgType:orgType
				        		},
				        		async:false,
				        		success:function(data){
				        			$("#orgType").html('');
				        			var hasType = false;
				        			for(var i=0;i<data.length;i++){
				        				if(data[i].TYPENAME=="职工"){
				        					hasType = true;
					        				$("#orgType").val(data[i].ORGANTYPE);
				        				}
				        			}
				        			form.render('select');
				        			if(hasType == false){
				        				Hussar.info("根据组织机构规则，该组织机构无职工！");
				        				return;
				        			}else{
				        				//将选中组织信息放到页面中
					                    $("#orgParentId").val(orgId);
					                    $("#orgParentCode").val(orgCode);
					                    $("#orgParentName").val(orgName);
					                    $("#struLevel").val(struLevel);
					                    $("#childNum").val(childNum);
					                    $("#parentType").val(orgType);
					                    $("#parentTypeCode").val(parentTypeCode);
				        				EmplMaintenance.addOrgInfo();
				        			}
				        		},
				        		error:function(){
				        			Hussar.error("加载失败！");
				        		}
				        	})
				        	
	                    }
	                },
	                sort: {
	                    label: "下级排序",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	//选中组织机构层级
				        	var struLevel = clickedNode.original.struLevel;
				        	layer.open({
		        				type: 1,
		        				btn: [ '取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: false,
		        				shade: 0.4,
		        				title: "下级排序",
		        				content: $('#treeEditOrder'),
		        				btn2: function(index, layero){
		        					//确认按钮回调
		        					var saveTree =function(){
		        			    		$.ajax({
		        			    			url:Hussar.ctxPath+"/orgMain/orgTreeOrder",
		        			    			async:false,
		        			    			data:{
		        			    				treeInfo:$("#output").val()
		        			    			},
		        			    			type:"POST",
		        			        		contentType:"application/x-www-form-urlencoded",
		        			        		success:function(data){
		        			        			EmplMaintenance.refreshTree();
		        			        			Hussar.success("保存成功!");
		        			        			EmplMaintenance.closeWindow();
		        			        		},
		        			        		error:function(){
		        			        			Hussar.error("保存失败!");	
		        			        		}
		        			    			
		        			    		})
		        			    	}
		        			    	Hussar.confirm("确定要保存排序吗?", saveTree);
				                    layer.close(index);
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
		        					$.ajax({
			                            type: "POST",
			                            data:{
			                            	orgId:orgId,
			                            	isEmployee:"1"
			                            },
			                            contentType:"application/x-www-form-urlencoded",
			                            url: Hussar.ctxPath+"/orgMain/orgTreeById",
			                            dataType:"json",
			                            async: false,
			                            success:function(result) {
			                            	var arrays = [];
			    	                        for(var i=0; i<result.length; i++){
			    	                        	var arr = {
			    	                        			 id	:	result[i].ID,
			    	                        			 code:   result[i].CODE,
			    	                        			 text : result[i].TEXT,
			    	                                     parent : result[i].PARENT,
			    	                                     struLevel:result[i].STRULEVEL,
			    	                                     struOrder:result[i].STRUORDER,
			    	                                     struType:result[i].STRUTYPE,
			    	                                     isLeaf:result[i].ISLEAF,
			    	                                     type:result[i].TYPE,
			    	                                     icon:result[i].ICON,
			    	                                     isEmployee:result[i].ISEMPLOYEE
			    	                        		}
			    	                        	arrays.push(arr);
			    	                        }
			    	                        result = arrays;
			                            	$("#orgTreeOrder").jstree(true).settings.core.data = result;
			                            	$("#orgTreeOrder").jstree(true).refresh();
			                            	//返回值在页面显示
			                            	var newResult=[];
			                            	for(var i=0;i<result.length;i++){
			                            		if(result[i].parent!="#"){
			                            			newResult.push(result[i]);
			                            		}
			                            		
			                            	}
			                            	$("#output").val(window.JSON.stringify(newResult));
			                            }
	
			                        });
		        				}
		        			});
	                    }
	                },
	                edit: {
	                    label: "修改",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                    action: function (obj) {
	                        //获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//是否为人员
				        	var isEmployee = clickedNode.original.isEmployee;
					        $("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeEdit?orgId="+orgId);
	                    }
	                },
	                change: {
	                    label: "转移",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织父ID
				        	var orgParentId=clickedNode.parentId;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	//选中组织机构层级
				        	var struLevel = clickedNode.original.struLevel;
				        	layer.open({
		        				type: 1,
		        				btn: ['取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: false,
		        				shade: 0.4,
		        				title: "上级组织机构选择",
		        				content: $('#treeEditChange'),
		        				btn2: function(index, layero){
		        					//获取选中节点
	        	  					var nodes = $("#orgTreeChange").jstree(true).get_checked();//使用get_checked方法
	        	  					if(nodes.length==0){
	        	  						Hussar.info("请先选择上级组织机构！");
	        	  					}else{
		        					//确认按钮回调
		        					var saveTree =function(){
		        						
		        	  						$.ajax({
		        			    			url:Hussar.ctxPath+"/orgMain/orgTreeChange",
		        			    			async:false,
		        			    			data:{
		        			    				orgId:orgId,
		        			    				orgType:orgType,
		        			    				parentId:nodes[0],
			        	  						isRoot:EmplMaintenance.isRootChange,
		        			    				changeLevel:EmplMaintenance.changeLevel
		        			    			},
		        			    			type:"POST",
		        			        		contentType:"application/x-www-form-urlencoded",
		        			        		success:function(data){
		        			        			if(data.success==true){
		        			        				EmplMaintenance.refreshTree();
			        			        			Hussar.success("转移成功!");
			        			        			layer.close(index);
		        			        			}else{
		        			        				Hussar.error("转移失败!该转移不符合组织机构规则!");	
		        			        			}
		        			        		},
		        			        		error:function(){
		        			        			Hussar.error("转移失败!");	
		        			        		}
		        			    			
		        			    		})
		        	  					
		        			    		
		        			    	}
		        			    	Hussar.confirm("确定要转移吗?", saveTree);
	        	  					
				                    layer.close(index);
	        	  					}
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
		        					$.ajax({
			                            type: "POST",
			                            data:{
			                            	orgId:orgId,
			                            	isEmployee:"",
			                            	rootName:"人员组织机构"
			                            },
			                            contentType:"application/x-www-form-urlencoded",
			                            url: Hussar.ctxPath+"/orgMain/orgChangeById",
			                            dataType:"json",
			                            async: false,
			                            success:function(result) {
			                            	EmplMaintenance.selectId=orgId;
			                            	var arrays = [];
			    	                        for(var i=0; i<result.length; i++){
			    	                        	var arr = {
			    	                        			 id	:	result[i].ID,
			    	                        			 code:   result[i].CODE,
			    	                        			 text : result[i].TEXT,
			    	                                     parent : result[i].PARENT,
			    	                                     struLevel:result[i].STRULEVEL,
			    	                                     struOrder:result[i].STRUORDER,
			    	                                     struType:result[i].STRUTYPE,
			    	                                     isLeaf:result[i].ISLEAF,
			    	                                     type:result[i].TYPE,
			    	                                     icon:result[i].ICON,
			    	                                     isEmployee:result[i].ISEMPLOYEE
			    	                        		}
			    	                        	arrays.push(arr);
			    	                        }
			                            	$("#orgTreeChange").jstree(true).settings.core.data = arrays;
			                            	$("#orgTreeChange").jstree(true).refresh();
			                            }
	
			                        });
		        				}
		        			});
	                    }
	                },
	                delete: {
	                    label: "删除",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
	                    	var delOrg =function(){
	                    		$.ajax({
	                    			url:Hussar.ctxPath+"/employee/delEmployeeById",
	                    			async:false,
	                    			data:{
	                    				orgId:orgId
	                    			},
	                    			type:"POST",
	                        		contentType:"application/x-www-form-urlencoded",
	                        		success:function(data){
	                        			if(data.success==true){
	                        				EmplMaintenance.refreshTree();
		                        			Hussar.success("删除成功!");
	                        			}else{
	                        				Hussar.error(data.msg);	
	                        			}
	                        			
	                        		},
	                        		error:function(){
	                        			Hussar.error("删除失败!");	
	                        		}
	                    			
	                    		})
	                    	}
	                    	Hussar.confirm("确定要删除吗?", delOrg);
	                    }
	                }
	           };
				var length = node.parents.length;
				if(length==1){
					delete items.change;  //删除节点 转移
					delete items.add;
					delete items.edit;
					delete items.delete;
					delete items.sort;
				}
				var isEmployee = node.original.isEmployee;
				if(isEmployee=="1"){
					delete items.sort;//删除节点下级排序
					delete items.add;//删除节点 增加
				}else{
					delete items.change;  //删除节点 转移
					delete items.delete;  //删除节点删除
					delete items.edit;//删除节点修改
				}
			return items; 
		
	}
	/*初始化组织机构人员树*/
	EmplMaintenance.initTreeView = function(){
	    var $tree = $("#orgEmployeeTree");
	    $tree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                $.ajax({
	                    type: "POST",
	                    url: Hussar.ctxPath+"/employee/employeeTree",
	                    data:{
	                    	isEmployee:"1"
	                    },
	                    contentType:"application/x-www-form-urlencoded",
	                    dataType:"json",
	                    async: false,
	                    success:function(result) {
	                    	var arrays = [];
	                        for(var i=0; i<result.length; i++){
	                        	var arr = {
	                        			 id	:	result[i].ID,
	                        			 code:   result[i].CODE,
	                        			 text : result[i].TEXT,
	                                     parent : result[i].PARENT,
	                                     struLevel:result[i].STRULEVEL,
	                                     struOrder:result[i].STRUORDER,
	                                     struType:result[i].STRUTYPE,
	                                     isLeaf:result[i].ISLEAF,
	                                     type:result[i].TYPE,
	                                     icon:result[i].ICON,
	                                     isEmployee:result[i].ISEMPLOYEE
	                        		}
	                        	arrays.push(arr);
	                        }
	                        data = arrays;
	                        $("#employeeInfo").attr("src","")
	                    }
	
	                });
	                callback.call(this, data);
	            }
	        },
	        plugins: ['state', 'types', 'contextmenu'],
	        contextmenu: {
	            items: EmplMaintenance.menuList
	        },
	        types:{
                "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"}
            }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
	    		var struId = currentNode.id
	    		var isEmployee = currentNode.original.isEmployee;
	    		if(isEmployee=="1"){
		    		$("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeInfo?struId=" + struId)
	    		}else{
	    			var parent = currentNode.parent;
		    		if(parent=="#"){
		    			$("#employeeInfo").attr("src","")
		    		}else{
		    			$("#employeeInfo").attr("src",Hussar.ctxPath+"/orgMain/orgInfo?struId=" + struId)
		    		}
	    		}
		});
	}
	/*刷新组织机构树*/
	EmplMaintenance.refreshTree = function(){
		$("#orgEmployeeTree").jstree(true).refresh();
	}
	/*初始化组织机构排序树*/
	EmplMaintenance.initOrderTreeView = function(){
	    //初始化数列表
	    var $tree = $("#orgTreeOrder");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {
	                //拖动排序时只允许同级拖动
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: null
	        },
	        plugins: ['state', 'types',"dnd",'contextmenu'],
	        contextmenu: {
	            items: EmplMaintenance.menuList
	        },
	        sort:function(a,b){
	            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
	        },
	        types:{
                "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"}
            }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
				loadOrgInfo(22);
		});
	    //移动树事件
	    $tree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	var newResult=[];
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].struOrder=i+2;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].struOrder=i;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}
	    	oldResult.sort(EmplMaintenance.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
		
	}
	
	/*初始化转移组织树*/
	EmplMaintenance.initChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#orgTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['state', 'types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
                    "1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/com.png"},
                    "2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/dept.png"},
                    "3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/station.png"},
                    "9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/" +theme +"/empl.png"}
                }
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		   $tree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;
		   	   var menuName = obj.node.text;
              var ref =$tree.jstree(true);
              var nodes = ref.get_checked(); //使用get_checked方法
              var otherNode;
              otherNode="";
              //判断是否为根节点，则不能移动
              var length = obj.node.parents.length;
              if(length==1){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到当前组织");
      			  return;
              }
              //判断是否为相同节点，则不能移动
              if(EmplMaintenance.selectId==obj.node.id){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到当前组织");
      			  return;
              }
              //限制选择不能选择当前以及当前子节点
              if(nodes.length>0){
            	  $.each(currentNode.parents, function(i, nd) {
                		if(nd == EmplMaintenance.selectId){
                			ref.uncheck_node(obj.node.id);
                			Hussar.info("不能转移到当前组织");
                			return false;
                		}
                	})
                  
              }
              //限制只能选一个
              if(nodes.length>1){
              	$.each(nodes, function(i, nd) {
              		if(nd != obj.node.id){
              			otherNode = nd;
              		}
              	})
              	ref.uncheck_node(otherNode);
              }
              
            //判断选择几点是否为根节点
              if(length==1){
            	  EmplMaintenance.isRootChange='1';
              }else{
            	  EmplMaintenance.isRootChange='0';
              }
              EmplMaintenance.changeLevel = obj.node.original.struLevel;
              
          });
		}
	/*初始化按钮事件*/
	EmplMaintenance.initButtonEvent = function(){
	    /*排序树保存*/
	    $("#treeBtnSave").click(function(){
	    	var saveTree =function(){
	    		$.ajax({
	    			url:Hussar.ctxPath+"/orgMain/orgTreeOrder",
	    			async:false,
	    			data:{
	    				treeInfo:$("#output").val()
	    			},
	    			type:"POST",
	        		contentType:"application/x-www-form-urlencoded",
	        		success:function(data){
	        			EmplMaintenance.refreshTree();
	        			Hussar.success("保存成功!");
	        			EmplMaintenance.closeWindow();
	        		},
	        		error:function(){
	        			Hussar.error("保存失败!");	
	        		}
	    			
	    		})
	    	}
	    	Hussar.confirm("确定要保存排序吗?", saveTree);
	    });
	    /*排序树重置*/
	    $("#treeBtnReset").click(function(){
	    	EmplMaintenance.closeWindow();
	    });
	    
		
	}
	/*根据组织机构ID展示组织机构信息*/
	EmplMaintenance.loadOrgInfo=function(id){
		$("#employeeInfo").attr("src","/orgMain/orgInfo?struId=" + id)
	}
	/*增加人员*/
	EmplMaintenance.addOrgInfo=function(){
		//获取选中的组织类型
		var orgType = $("#orgType").val();
		//获取上级组织机构ID
		var orgParentId = $("#orgParentId").val();
		//获取上级组织机构编码
		var orgParentCode = $("#orgParentCode").val();
		//获取上级组织机构名称
		var orgParentName = $("#orgParentName").val();
		//获取上级组织机构所在层级
		var struLevel = $("#struLevel").val();
		//获取上级组织机构子节点数量
		var childNum = $("#childNum").val();
		//上级组织机构类型
		var parentType = $("#parentType").val();
		//不同组织机构类型编码(用户构建下级组织机构编码)
		var parentTypeCode = $("#parentTypeCode").val();
		$("#employeeInfo").attr("src",Hussar.ctxPath+"/employee/employeeAdd?orgParentId="+orgParentId+"&orgParentCode="+orgParentCode+"&orgParentName="+orgParentName+"&orgType="+orgType+"&struLevel="+struLevel+"&childNum="+childNum+"&parentType="+parentType+"&parentTypeCode="+parentTypeCode)
	}
	/*排序*/
	EmplMaintenance.up=function(x,y){
		return x.struOrder-y.struOrder
	}
	/*关闭弹窗*/
	EmplMaintenance.closeWindow=function () {
	    layer.close(EmplMaintenance.infoWin);
	};
	EmplMaintenance.initFrameHeight=function(){
		var h = $(window).height()-3;
		$("#employeeInfo").css("height", h + "px");
		$("#orgEmployeeTree").css("height", h + "px");
		
	}
	$(function () {
		EmplMaintenance.initPage();
		$(window).resize(function() {
			EmplMaintenance.initFrameHeight();
		});
	});
});