/**
 * 表格的初始化
 */
var EhcacheMgr = {
	id: "EhcacheMgrTable",	//表格id
	seItem: null,		//选中的条目 array
	table: null,
	layerIndex: -1,
    currentDBName: 'menu_info'
};

layui.use(['jquery', 'layer', 'table', 'jstree', 'HussarAjax', 'Hussar'], function() {

	var layer = layui.layer
		, table = layui.table
		//, tree = layui.tree
		, $ = layui.jquery
		, $ax = layui.HussarAjax
		, Hussar = layui.Hussar;


	//jstree的树
    EhcacheMgr.initDBTree = function () {
		var $tree = $("#dbTree");
		$tree.jstree({
			core: {
				check_callback: true,
				data: function (obj, callback) {
					var data;
					var ajax = new $ax(Hussar.ctxPath+"/ehcache/getAllCacheName",
						function(result) {
							data = result;
						},
						function(data) {
							Hussar.error("加载ehcache数据树失败！");
						});
					ajax.start();
                    callback.call(this, data);
					}
				},

		}).on( 'loaded.jstree', function (e, data) {
			//树加载完成后选中menu_info节点
            var inst = data.instance;
            var obj = $tree.jstree('get_node',EhcacheMgr.currentDBName);
            inst.select_node(obj);
        })

		$tree.bind("activate_node.jstree", function (obj, e) {
			var currentNode = e.node;
			var dat = currentNode.original;
			if (dat.type == 'name') {
                EhcacheMgr.currentDBName = dat.text;
                EhcacheMgr.search();
			}
		});
	};

//----------------------------------------------------↑树丨↓表格-----------------------------------------------------

    /**
	 * 	初始化表格
     */
    EhcacheMgr.initTableView = function () {
        layui.use('table', function(){
            var table = layui.table;
            table.render({
                elem: '#EhcacheMgrTable',
                url: Hussar.ctxPath+'/ehcache/list',
                page: true,
                id: 'EhcacheMgrTable',
                even: true,
                height:$("body").height() - $(".layui-form").outerHeight(true)-26,
                cols: [[{type: 'checkbox',width:40},
                    {type: 'numbers', title: '序号', align: 'center',width:50},
                    {field: 'key', title: '键名', align:'center'},
                    {field: 'value', title: '值', align:'center', templet:value}
                ]],
				where: {
                    cacheName: EhcacheMgr.currentDBName,
					key: ''
				}
            });

        });
    }

    function value(d) {
		return JSON.stringify(d);
    };



	/**
	 * 检查是否选中
	 */
	EhcacheMgr.check = function () {
		var flag = false;
		var selected = table.checkStatus('EhcacheMgrTable').data;
		if (selected && selected.length > 0) {
			EhcacheMgr.seItem = selected;
			flag = true;
		} else {
			// layer.confirm("请至少选择一条记录！ ", { btn: ['确认'],title:'信息'});
            Hussar.info("请至少选择一条记录！");
		}
		return flag;
	};

	/**
	 * 删除字段
	 */
	EhcacheMgr.delete = function () {
		if (EhcacheMgr.check()) {
			var idArr = [];
			EhcacheMgr.seItem.forEach(function (v) {
				idArr.push(v.key);
			});
			var operation = function () {
				var ajax = new $ax(Hussar.ctxPath+"/ehcache/deleteByKeys", function (data) {
					if(data.code == '200'){
						Hussar.info("删除成功！");
						EhcacheMgr.search();
					}else{
						Hussar.info("删除失败！（" + data.mess + "）")
					}
				}, function (data) {
					Hussar.info("删除失败！（" + data.responseJSON.message + "）");
				});
				ajax.set("keys", JSON.stringify(idArr));
				ajax.set("cacheName", EhcacheMgr.currentDBName);
				ajax.start();
			};
			Hussar.confirm("确定要删除吗？", operation);
		}
	};

	/**
	 * 查询字段列表
	 */
	EhcacheMgr.search = function () {
		var queryData = {};
		queryData['key'] = $("#condition").val();
		queryData['cacheName'] = EhcacheMgr.currentDBName;
		table.reload('EhcacheMgrTable', {where: queryData});
	};

	$(function () {
		var bodyH = $("body").height();
		$(".tree-box").css("height", bodyH + "px");
        EhcacheMgr.initDBTree();
        EhcacheMgr.initTableView();
	});
});
