/**
 * 初始化
 */
var JobManager = {
    id: "jobManagerTable",	//表格id
    table: null,
    layerIndex: -1,
    cronLayerData: '', //用于向子layer传递当前cron值
    cronLayerIndex: -1, //cron表达式生成器layer的index容器
    cronInputLayerIndex: -1, //表格上编辑cron弹出的layer
    cronInputLayerUsingTableData: {}, //表格上编辑cron弹出的layer所属的该条表格数据
    currentCronEditorOpenedBy: 'tablePage' //用来临时存放cron编辑器是由哪个UI打开的，可能的值:'addPage'(添加页面),'tablePage'(表格页面)
};


layui.use(['layer', 'table','form', 'HussarAjax','Hussar'], function() {
    var layer = layui.layer
    , table = layui.table
    , form = layui.form
    , $ = layui.jquery
    , $ax = HussarAjax
    ,Hussar = layui.Hussar;

    /**
     * 定义表单验证规则
     */
    form.verify({
        required : function(value){
            if(value.trim()==""){
                return '必填项不能为空！';
            }
        },
        packageName: function(value, item){
            if(!/^([a-zA-Z]+[a-zA-Z0-9]*)+([.][a-zA-Z]+[a-zA-Z0-9]*)+/.test(value)){
                return '类名格式不正确！（由‘.’连接而成的英文数字组合，组合首字母不能是数字）';
            }
        },
        moduleName: function(value, item){
            var label = $(item).parent().prev().contents().filter(function() {return this.nodeType === 3;}).text();
            if(!/^[a-zA-Z\d_]+$/.test(value)){
                return label + '格式不正确！（只允许使用数字、字母和下划线）'
            }
        }
    });

    //监听工具条
    table.on('tool(user)', function(obj){
        var data = obj.data;
        if(obj.event === 'pause' || obj.event === 'resume'){//暂停or恢复
            var ajax = new $ax(
                Hussar.ctxPath + "/job/"+obj.event,
                function (data) {
                    data = data || {};
                    if(data.code == 200){
                        Hussar.info("操作成功！");
                        table.reload('jobManagerTable');
                    }else{
                        Hussar.info("操作失败！（"+(data.message||"未知错误")+"）");
                    }
                },
                function (data) {
                    Hussar.info("操作失败！（"+(data.responseJSON.message || "未知错误")+"）");
                });
            ajax.set('jobName',data.job_name);
            ajax.set('jobGroup',data.job_group);
            ajax.start();
        } else if(obj.event === 'update'){//修改
            JobManager.openEditCron(data);
        } else if(obj.event === 'delete'){//删除
            var operation = function () {
                var ajax = new $ax(Hussar.ctxPath + "/job/delete", function (data) {
                    data = data || {};
                    if(data.code == 200){
                        Hussar.success("删除成功！");
                        table.reload('jobManagerTable');
                    }else{
                        Hussar.error("删除失败！（"+(data.message||"未知错误")+"）");
                    }
                }, function (data) {
                    Hussar.error("删除失败！（"+(data.responseJSON.message || "未知错误")+"）");
                });
                ajax.set('jobName',data.job_name);
                ajax.set('jobGroup',data.job_group);
                ajax.start();
            };
            Hussar.confirm("确定要删除吗", operation);
        }
    });

    /**
     * 查询
     */
    JobManager.search = function () {
        table.reload('jobManagerTable', {where: {job_name: $("#job_name").val(),job_group: $("#job_group").val()}});
    };


    JobManager.reSchedule = function(){
        var tabData = JobManager.cronInputLayerUsingTableData;
        var cronExp = $("#cronPrompt_cron_expression").val();
            if(!cronExp.trim()){
                layer.msg("必填项不能为空！",{
                    icon:5, shift:6
                });
                return false;
            }
            var ajax = new $ax(
                Hussar.ctxPath + "/job/reschedule",
                function (data) {
                    data = data || {};
                    if(data.code == 200){
                        Hussar.success("保存成功！");
                        table.reload('jobManagerTable');
                        layer.close(JobManager.cronInputLayerIndex);
                    }else{
                        Hussar.error("保存失败！（" + (data.message || "未知错误") + "）");
                    }
                },
                function (data) {
                    Hussar.error('保存失败！（表达式不合法）');
                }
            );
            ajax.set('jobName',tabData.job_name);
            ajax.set('jobGroup',tabData.job_group);
            ajax.set('cronExpression',cronExp);
            ajax.start();
    };

    /**
     * 表格上修改任务表达式
     * @param data 选中的表格数据
     */
    JobManager.openEditCron = function(data){
        JobManager.cronInputLayerIndex = layer.open({
            type: 1,
            area: ['450px','170px'],
            shadeClose: false,
            title: "修改任务表达式",
            content: $('#cronPrompt'),
            success:function(){
                $("#cronPrompt_cron_expression").val(data.cron_expression);
                JobManager.cronInputLayerUsingTableData = data;
            }
        });
    };

    JobManager.closeEditCron = function(){
        layer.close(JobManager.cronInputLayerIndex);
    };

    $(function () {
       JobManager.table = table.render({
           elem: '#jobManagerTable'
           ,url: Hussar.ctxPath +'/job/query' //数据接口
           ,page: true //开启分页
           ,limit: 20
           ,cols: [[ //表头
               {title: '序号',type : 'numbers',width:50},
               {title: '任务名', field: 'job_name', templet: '#usernameTpl'},
               {title: '任务组', field: 'job_group'},
               {title: '类名', field: 'job_class_name'},
               {title: '下次执行', field: 'next_fire_time', width: 165},
               {title: '上次执行', field: 'prev_fire_time', width: 165},
               {title: '表达式', field: 'cron_expression'},
               {title: '状态', field: 'trigger_state', width: 110},
               {title: '操作', width: 208, align:'left', toolbar: '#barDemo'}
           ]]
           ,even: true
           ,height:$("body").height() - $(".layui-form").outerHeight(true)-26
       });
    });

    /**
     * 点击添加
     */
    JobManager.openAdd = function () {
        JobManager.layerIndex = layer.open({
            type: 2,
            title: '添加任务',
            area: ['640px', '370px'], //宽高
            fix: false, //不固定
            content: Hussar.ctxPath + '/job/addhtml'
        });
    };

    /**
     * 提交添加 - 提交表单事件
     */
    form.on('submit(quartzJobAdd)', function(data){
        JobManager.addSubmit();
        return false; //阻止表单跳转
    });
    /**
     * 提交添加
     */
    JobManager.addSubmit = function () {
        var ajax = new $ax(Hussar.ctxPath + "/job/add", function (data) {
            data = data || {};
            if(data.code == 200){
                parent.layui.Hussar.success("添加成功！");
                parent.JobManager.table.reload('jobManagerTable');
                JobManager.close();
            }else{
                Hussar.error("添加失败！（" + (data.message || '未知错误') + "）");
            }
        }, function (data) {
            Hussar.error("添加失败！（" + (data.responseJSON.message || '未知错误') + "!");
        });
        ajax.set('jobName',$("#job_name").val());
        ajax.set('jobClassName',$("#job_class_name").val());
        ajax.set('jobGroup',$("#job_group").val());
        ajax.set('cronExpression',$("#cron_expression").val());
        ajax.start();
    };

    /**
     * 打开cron表达式编辑器
     * @param isFromAddPage 从哪点开的，from添加任务表单->true，编辑表达式框->false
     */
    JobManager.openCronEditor = function(isFromAddPage) {
        var editorOptions = {
            type: 2,
            title: '表达式生成器',
            area: ['700px', '530px'], //宽高
            fix: false, //不固定
            content: Hussar.ctxPath + '/job/cron'
            //连续弹出设置
            ,zIndex: layer.zIndex //重点1
            //,success: function(layero){
            //    layer.setTop(layero); //重点2
            //}
        };
        if(isFromAddPage){
            parent.JobManager.cronLayerData = $("#cron_expression").val() || '';
            parent.JobManager.currentCronEditorOpenedBy = 'addPage';
            parent.JobManager.cronLayerIndex = parent.layer.open(editorOptions);
        }else{
            JobManager.cronLayerData = $("#cronPrompt_cron_expression").val() || '';
            JobManager.currentCronEditorOpenedBy = 'tablePage';
            JobManager.cronLayerIndex = layer.open(editorOptions);
        }
    };

    /**
     * 关闭此对话框
     */
    JobManager.close = function () {
        parent.layer.close(window.parent.JobManager.layerIndex);
    };

    JobManager.confirmCron = function (cron){
        var from = JobManager.currentCronEditorOpenedBy;
        var cInput;
        if(from == 'addPage'){
            cInput = layer.getChildFrame('#cron_expression', JobManager.layerIndex);
        } else if(from == 'tablePage'){
            cInput = $("#cronPrompt_cron_expression");
        }
        cInput.val(cron);
        this.closeCron();
    };

    JobManager.closeCron = function () {
        layer.close(JobManager.cronLayerIndex);
    };
});




