/**
 * @Description: 用户管理脚本文件
 * @Author: liangdong
 * @Date: 2018/2/27.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','element','form'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var element = layui.element;
	
	var UserMgr = {
			userTree: $("#userTree"),//用户树
			roleTree: $("#roleTree"),//角色树
			orgTree: $("#orgTree"),//组织机构树
			orderTree: $("#orderTree"),//排序树
			copyRoleTree: $("#copyRoleTree"),//复制角色树
			chooseStaffTree: $("#chooseStaffTree"),//职工选择树
			proxyTree: $("#proxyTree"),//代理用户树
			byProxyTree: $("#byProxyTree"),//被代理用户树
			
			addORedit: '',
			layerIndex: -1,
			selectId: null,	//选中的节点id

			public_role: 'public_role',	//公用角色的id
        	sys_role_group: 'sys_role_group'	//系统角色分组id
	};
	
	/**
	 * 初始化用户树
	 */
	UserMgr.initUserTree = function () {
		$userTree = UserMgr.userTree;//用户树
		$userTree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/userTree",
	                		function(result) { 	 	                
			                	var arrays = [];
		                    	for(var i=0; i<result.length; i++){                    		 
		                    		var arr = {
		                    		    id	:	result[i].ID,
		                    		    parent : result[i].PARENT,
		                    		    text : result[i].TEXT,
		                    		    code : result[i].CODE,
		                    		    organId : result[i].ORGANID,
		                    		    struLevel : result[i].STRULEVEL,
		                    		    struType : result[i].STRUTYPE,
		                    		    struOrder : result[i].STRU_ORDER,		                    		    
		                    		    type : result[i].TYPE		                    		    
		                    		}  		                    		                    		               		                   		
		                    		arrays.push(arr);
		                    	}
		                    	data = arrays;			                                    			
	    					}, 
	    					function(data) {
	    						Hussar.error("加载用户树失败!");
	    					});
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        contextmenu:{
	        	select_node:false,  
	            show_at_node:true, 
	        	'items' : UserMgr.contextmenu
	        },
	        plugins: ['contextmenu','types','search'],
	        types:{
	        	"1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/com.png"},
	        	"2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/dept.png"},
	        	"3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/station.png"}, 
	        	"9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/empl.png"},
	        	"USER":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/user.png"}
	        },	       
	        search : UserMgr.search()	        
	    });
	    
		$userTree.bind("activate_node.jstree", function (obj, e) {        
	        var node = e.node;        
	        if (node.original.code == 'USER') {	        	
	        	UserMgr.detailView(node.id);	//显示用户详情
	        } else {
	        	$('#addEvent').addClass('hide');
	        }
	    });
	};
	
	/**
	 * 用户树节点右键菜单
	 */
	UserMgr.contextmenu = function (node) {
		//不同节点菜单不一样
		var items = {
		    'item1' : {
		        'label' : '新增用户',
		        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
		        'action' : function () {	        	
		        	UserMgr.addUser(node);	//新增用户
		        }
		    },	    	    
		    'item3' : {
		        'label' : '修改',
		        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
		        'action' : function () {
		        	UserMgr.selectId = node.id;
		        	UserMgr.editUser(node.id);	//修改用户
		        }
		    },				    
		    'item5' : {
		        'label' : '转移',
		        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
		        'action' : function () {	
		        	UserMgr.changeOrgEvent(node);	//用户机构转移		        	       		        	
		        }
		    },
		    'item6' : {
		        'label' : '用户排序',
		        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
		        'action' : function () {		        	
		        	UserMgr.userOrderEvent(node.id);	//用户排序操作        		        	
		        }
		    },
		    'item7' : {
		        'label' : '复制角色',
		        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5211.png",
		        'action' : function () {		        		        		        	
		        	UserMgr.copyRoleEvent(node);
		        }
		    },   
		    'item4' : {
		        'label' : '删除',
		        'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
		        'action' : function () {
		        	UserMgr.delUser(node);	//用户删除		        	     	
		        }
		    },
		    
		}
		if(node != undefined){
			//权限判断			
			var shiroAdd = $("#shiroAdd").val();
			var shiroEdit = $("#shiroEdit").val();
			var shiroDel = $("#shiroDel").val();
			var shiroChgOrg = $("#shiroChgOrg").val();
			var shiroCopyRole = $("#shiroCopyRole").val();
			var shiroOrder = $("#shiroOrder").val();
			
			if (node.parent == '#') {	//根节点没有右键菜单
				delete items.item3;
		        delete items.item4;
		        delete items.item5;			
		        delete items.item7;	
		        delete items.item1;  
		        delete items.item6;	
			} else if (node.original.code != 'USER') {	//组织机构		       
		        delete items.item3;
		        delete items.item4;
		        delete items.item5;			
		        delete items.item7;	
		        if (shiroAdd != "hasPermission") {
		        	delete items.item1; 
		        }
		        if (shiroOrder != "hasPermission") {
		        	delete items.item6; 
		        }
		    } else{	//用户
				if (node.original.parent == '11') {
					//系统用户不允许任何操作
                    delete items.item3;
                    delete items.item4;
                    delete items.item5;
                    delete items.item7;
                    delete items.item1;
                    delete items.item6;
                }
		        delete items.item1;  
		        delete items.item6;	
		        if (shiroEdit != "hasPermission") {
		        	delete items.item3; 
		        }
		        if (shiroDel != "hasPermission") {
		        	delete items.item4; 
		        }
		        if (shiroChgOrg != "hasPermission") {
		        	delete items.item5; 
		        }		        
		        if (shiroCopyRole != "hasPermission") {
		        	delete items.item7; 
		        }
		    }
		    return items;
		}
			
	}
	
	/**
	 * 加载角色树
	 */
	UserMgr.initroleTree = function (roles) {
		//显示详情时不显示复选框
		var plugins = [];
		if (UserMgr.addORedit == 'view') {
			plugins = ['search','types'];
		} else {
			plugins = ['checkbox','search','types'];
		}
		
		$roleTree = UserMgr.roleTree;//角色树
	    $roleTree.jstree({
	        core: {        	
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleTree",
	                		function(result) {               	
			                	if(UserMgr.addORedit == 'add'){
			                		var arrays = [];
			                    	for(var i=0; i<result.length; i++){                    		 
			                    		var arr = {
			                    		    id	:	result[i].ID,
			                    		    parent : result[i].PARENT,
			                    		    text : result[i].TEXT,
			                    		    code : result[i].CODE,	                    		    
			                    		    type : result[i].TYPE,
			                    		    state : {selected:false, checked:false,  disabled:false}  
			                    		}  
			                    		//公用角色默认勾选且不可编辑
			                    		if (UserMgr.public_role == result[i].ID) {
			                    			arr.state.checked = true;  
		                    				arr.state.selected = true;
		                    				arr.state.disabled = true;                      				
			                    		}
			                    		//系统管理员角色不可勾选
										if (UserMgr.sys_role_group == result[i].PARENT) {
			                    			arr.state.disabled = true;
										}
			                    		arrays.push(arr);
			                    	}
			                    	data = arrays;
			                	}else if(UserMgr.addORedit == 'edit'){
			                		var arrays = [];
			                    	for(var i=0; i<result.length; i++){                    		 
			                    		var arr = {
			                    		    id	:	result[i].ID,
			                    		    parent : result[i].PARENT,
			                    		    text : result[i].TEXT,
			                    		    code : result[i].CODE,	                    		    
			                    		    type : result[i].TYPE,	                    		  
			                    		    state : {selected:false, checked:false, disabled:false}                				
			                    		}   	                    		
			                    		//公用角色默认勾选且不可编辑
			                    		if (UserMgr.public_role == result[i].ID) {
			                    			arr.state.checked = true;  
		                    				arr.state.selected = true;
		                    				arr.state.disabled = true;                      				
			                    		}
                                        //系统管理员角色不可勾选
                                        if (UserMgr.sys_role_group == result[i].PARENT) {
                                            arr.state.disabled = true;
                                        }
			                    		for(var j=0; j<roles.length; j++){
			                    			if(roles[j] == result[i].ID){
			                    				arr.state.checked = true;  
			                    				arr.state.selected = true;
			                    				break;
			                    			}
			                    		}                  		                   		
			                    		arrays.push(arr);
			                    	}
			                    	data = arrays;
			                	}else if(UserMgr.addORedit == 'view'){	                		
			                		var arrays = [];	                		
			                		var ajax = new $ax(Hussar.ctxPath + "/roleManager/selfRoleTree",function(result) {                		    	                	
			                        	for(var i=0; i<result.length; i++){                    		 
			                        		var arr = {
			                        		    id	:	result[i].ID,
			                        		    parent : result[i].PARENT,
			                        		    text : result[i].TEXT,
			                        		    code : result[i].CODE,	                        		    
			                        		    type : result[i].TYPE,	                        		  
			                        		    state : {selected:false, checked:false, disabled:true}                				
			                        		}   
		
			                        		for(var j=0; j<roles.length; j++){
			                        			if(roles[j] == result[i].ID){
			                        				arr.state.checked = true;  
			                        				arr.state.selected = true;
			                        				break;
			                        			}
			                        		}                  		                   		
			                        		arrays.push(arr);
			                        	}	                        	
			    	                	
			        					}, function(data) {
			        						Hussar.error("加载角色树失败!");
			        					});
			    	                ajax.set("roleIds",roles.join(','));	            
			    	    			ajax.start();
			                		
			                    	data = arrays;
			                	}	                	
	    					}, function(data) {
	    						Hussar.error("加载角色树失败!");
	    					});
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: plugins,
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : true,//是否父子级别关联
	        	tie_selection : false
	        },
	        types:{
	        	"GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/roleGroup.png"},
	        	"ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/role.png"},
	        	"isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/root.png"}
	        },
	        search: UserMgr.search()
	    });        
	}
	
	/**
	 * 加载 组织机构树（变更所属部门）
	 */
	UserMgr.initOrgTree = function () {
		$orgTree = UserMgr.orgTree;//组织机构树
		$orgTree.jstree({
	        core: {          	
	            check_callback: true,	            
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/orgMain/orgTree",function(result) {
			                	var arrays = [];
		                    	for(var i=0; i<result.length; i++){                    		 
		                    		var arr = {
		                    		    id	:	result[i].ID,
		                    		    parent : result[i].PARENT,
		                    		    text : result[i].TEXT,
		                    		    code : result[i].CODE,
		                    		    organId : result[i].ORGANID,
		                    		    struLevel : result[i].STRULEVEL,
		                    		    struType : result[i].STRUTYPE,
		                    		    struOrder : result[i].STRU_ORDER,		                    		    
		                    		    type : result[i].TYPE		                    		    
		                    		}  		                    		                    		               		                   		
		                    		arrays.push(arr);
		                    	}
		                    	data = arrays;	                	
	    					}, function(data) {
	    						Hussar.error("加载组织机构树失败!");
	    					});
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['checkbox','search','types'],
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : false,//是否父子级别关联
	        	tie_selection : false
	        },
	        types:{
	        	"1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/com.png"} ,
	        	"2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/dept.png"} ,
	        	"3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/station.png"} , 
	        	"9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/empl.png"}  
	        },
	        search: UserMgr.search()
	    });	
		$orgTree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;		   
	           var ref =$orgTree.jstree(true);
	           var checkedNodes = ref.get_checked(); //使用get_checked方法
	           var otherNode;   	          	          
	           
	           //判断是否勾选的是和原来相同的所属机构
	           if(UserMgr.selectId==currentNode.id){
	         	  ref.uncheck_node(currentNode.id);
	         	  Hussar.info("变更机构不能和原所属机构相同！");
	   			  return;
	           }
	           
	           //根节点不能勾选	          
	           if (currentNode.parent == '#') {
	        	   ref.uncheck_node(currentNode.id);
	        	   return;
	           }
	           
	           //限制只能选一个
	           if(checkedNodes.length>1){
		           	$.each(checkedNodes, function(i, nd) {
		           		if(nd != currentNode.id){
		           			otherNode = nd;
		           		}
		           	})
		           	ref.uncheck_node(otherNode);
	           }
			});
	}
	
	/**
	 * 初始化职工选择树
	 */
	UserMgr.initChooseStaffTree = function () {
		var orgId = $('#corporationId').val();	
		$chooseStaffTree = UserMgr.chooseStaffTree;		//职工选择树
		$chooseStaffTree.jstree({
			core: {
				check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/employee/employeeTreeById",
	                		function(result) { 
			                	var arrays = [];
		                    	for(var i=0; i<result.length; i++){                    		 
		                    		var arr = {
		                    		    id	:	result[i].ID,
		                    		    parent : result[i].PARENT,
		                    		    text : result[i].TEXT,
		                    		    code : result[i].CODE,
		                    		    organId : result[i].ORGANID,
		                    		    struLevel : result[i].STRULEVEL,
		                    		    struType : result[i].STRUTYPE,
		                    		    struType : result[i].STRU_ORDER,		                    		    
		                    		    type : result[i].TYPE		                    		    
		                    		}  		                    		                    		               		                   		
		                    		arrays.push(arr);
		                    	}
		                    	data = arrays;			                                 			
	    					}, 
	    					function(data) {
	    						Hussar.error("加载职工选择树失败!");
	    					});
	                ajax.set("orgId",orgId);
	    			ajax.start();
	                callback.call(this, data);
	            }
				
			},
			plugins: ['checkbox','types'],
			types:{
	        	"1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/com.png"},
	        	"2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/dept.png"},
	        	"3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/station.png"}, 
	        	"9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/empl.png"}  
	        },
			checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : false,//是否父子级别关联
	        	tie_selection : false
	        },
			
		});		
		$chooseStaffTree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;		   
	           var ref =$chooseStaffTree.jstree(true);
	           var checkedNodes = ref.get_checked(); //使用get_checked方法
	           var otherNode;   
	           
	           //判断选择的是否是职工，否则不能勾选     
	           if (currentNode.original.type != '9') {
	        	   ref.uncheck_node(currentNode.id);
	        	   return;
	           }	           	           
	           
	           //限制只能选一个
	           if(checkedNodes.length>1){
		           	$.each(checkedNodes, function(i, nd) {
		           		if(nd != currentNode.id){
		           			otherNode = nd;
		           		}
		           	})
		           	ref.uncheck_node(otherNode);
	           }
			});
	}
	
	/**
	 * 初始化复制角色树
	 */
	UserMgr.initCopyRoleTree = function () {
		$copyRoleTree = UserMgr.copyRoleTree;	//角色复制树
		$copyRoleTree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/userTree",
	                		function(result) { 
			                	var arrays = [];
		                    	for(var i=0; i<result.length; i++){                    		 
		                    		var arr = {
		                    		    id	:	result[i].ID,
		                    		    parent : result[i].PARENT,
		                    		    text : result[i].TEXT,
		                    		    code : result[i].CODE,
		                    		    organId : result[i].ORGANID,
		                    		    struLevel : result[i].STRULEVEL,
		                    		    struType : result[i].STRUTYPE,
                                        struOrder : result[i].STRU_ORDER,
		                    		    type : result[i].TYPE		                    		    
		                    		}
		                    		if (arr.code == 'USER' && arr.parent == '11') {
		                    			//角色不可复制到系统级用户上
									} else {
                                        arrays.push(arr);
									}
		                    	}
		                    	data = arrays;		                			
	    					}, 
	    					function(data) {
	    						Hussar.error("加载角色复制树失败!");
	    					});
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        contextmenu:{
	        	select_node:false,  
	            show_at_node:true, 
	        	'items' : UserMgr.contextmenu
	        },
	        plugins: ['checkbox','search','types'],
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : false,//是否父子级别关联
	        	tie_selection : false
	        },
	        types:{
	        	"1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/com.png"},
	        	"2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/dept.png"},
	        	"3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/station.png"}, 
	        	"9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/empl.png"},
	        	"USER":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/user.png"}
	        },
	        search : UserMgr.search()
	        
	    });
		$copyRoleTree.on('check_node.jstree', function(event, obj) {
		   var currentNode = obj.node;		   
           var ref =$copyRoleTree.jstree(true);
           var checkedNodes = ref.get_checked(); //使用get_checked方法
           var otherNode;   
           
           //判断选择的是否是用户，否则不能勾选     
           if (currentNode.original.code != 'USER') {
        	   ref.uncheck_node(currentNode.id);
        	   return;
           }           
           //判断是否为相同用户节点，否则不能复制
           if(UserMgr.selectId==currentNode.id){
         	  ref.uncheck_node(currentNode.id);
         	  Hussar.info("不能将角色复制到本用户上");
   			  return;
           }           
		});
	}
	
	/**
	 * 加载 排序树
	 */
	UserMgr.initOrderTree = function (orgId) {
		$orderTree = UserMgr.orderTree;	//排序树	
		$orderTree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {	                
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/orderTree",function(result) {
			                	var arrays = [];
			                	for(var i=0; i<result.length; i++){                    		 
			                		var arr = {
			                		    id	:	result[i].ID,
			                		    parent : result[i].PARENT,
			                		    text : result[i].TEXT,
			                		    code : result[i].CODE,
			                		    organId : result[i].ORGANID,
			                		    struLevel : result[i].STRULEVEL,
			                		    struType : result[i].STRUTYPE,
			                		    struOrder : result[i].STRU_ORDER,		                    		    
			                		    type : result[i].TYPE		                    		    
			                		}  		                    		                    		               		                   		
			                		arrays.push(arr);
			                	}
			                	data = arrays;  
			                	
			                	//返回值在页面显示
		                    	var newResult=[];
		                    	for(var i=0;i<arrays.length;i++){
		                    		if(arrays[i].parent!="#"){
		                    			newResult.push(arrays[i]);
		                    		}                   		
		                    	}
		                    	$("#output").val(window.JSON.stringify(newResult));
			                	
	    					}, function(data) {
	    						Hussar.error("加载用户排序树失败!");
	    					});
	                ajax.set("orgId",orgId);
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['state', 'types', "dnd", 'search'],
	        types:{
	        	"1":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/com.png"},
	        	"2":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/dept.png"},
	        	"3":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/station.png"}, 
	        	"9":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/empl.png"},
	        	"USER":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/user.png"}
	        },
	        search: UserMgr.search(),
	        sort:function(a,b){
	            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
	        }
	    });
	    
	    //移动树事件
	    $orderTree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	var newResult=[];
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].struOrder=i+2;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}	            			
	            		}
	        		}	        		
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].struOrder=i;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}	            			
	            		}
	        		}	        		
	        	}
	    	}
	    	oldResult.sort(UserMgr.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
	}
	
	/**
	 * 排序
	 */
	UserMgr.up = function (x,y) {
		return x.struOrder-y.struOrder;
	}

	/**
	 * 加载 被代理用户树
	 */
	UserMgr.initByProxyTree = function (bproxys) {	
		$byProxyTree = UserMgr.byProxyTree;//被代理用户树
		$byProxyTree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/userTree",function(result) {
	                	if(UserMgr.addORedit == 'add'){
	                		var arrays = [];
		                    for(var i=0; i<result.length; i++){
		                        var arr = {
	                        		id	:	result[i].id,
	                    		    parent : result[i].parent,
	                    		    text : result[i].text,
	                    		    code : result[i].CODE,
	                    		    organId : result[i].organId,
	                    		    struLevel : result[i].struLevel,
	                    		    struType : result[i].struType,
	                    		    struOrder : result[i].STRU_ORDER,
	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	                    		    icon : ""
		                        }
		                        if('USER' == result[i].CODE){
		                            arr.icon = Hussar.ctxPath+"/static/assets/img/treeContext/user.png";
		                        }
		                        if(result[i].parent=="#"){
		                        	arr.state = {opened : true};
		                    	}
		                        arrays.push(arr);
		                    }
		                    data = arrays;
	                	}else if(UserMgr.addORedit == 'edit'){
	                		var arrays = [];
	                    	for(var i=0; i<result.length; i++){                    		 
	                    		var arr = {
	                    		    id	:	result[i].id,
	                    		    parent : result[i].parent,
	                    		    text : result[i].text,
	                    		    code : result[i].CODE,
	                    		    organId : result[i].organId,
	                    		    struLevel : result[i].struLevel,
	                    		    struType : result[i].struType,
	                    		    struOrder : result[i].STRU_ORDER,
	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	                    		    icon : "",
	                    		    state : {selected:false, checked:false}                				
	                    		}   
	                    		if('USER' == result[i].CODE){
		                            arr.icon = Hussar.ctxPath+"/static/assets/img/treeContext/user.png";
		                        }	
	                    		if(result[i].parent=="#"){
		                        	arr.state = {opened : true};
		                    	}
	                    		for(var j=0; j<bproxys.length; j++){
	                    			if(bproxys[j] == result[i].id){
	                    				arr.state.checked = true;  
	                    				arr.state.selected = true;
	                    				break;
	                    			}
	                    		}                  		                   		
	                    		arrays.push(arr);
	                    	}
	                    	data = arrays;
	                	}else if(UserMgr.addORedit == 'view'){
	                		var ajax = new $ax(Hussar.ctxPath + "/user/proxyTree",
	        	            		function(result) {
	        		                	var arrays = [];
	        	                    	for(var i=0; i<result.length; i++){                    		 
	        	                    		var arr = {
	        	                    		    id	:	result[i].id,
	        	                    		    parent : result[i].parent,
	        	                    		    text : result[i].text,
	        	                    		    code : result[i].CODE,
	        	                    		    organId : result[i].organId,
	        	                    		    struLevel : result[i].struLevel,
	        	                    		    struType : result[i].struType,
	        	                    		    struOrder : result[i].STRU_ORDER,
	        	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	        	                    		    icon : "",
	        	                    		    state : {selected:false, checked:false, disabled:true}                				
	        	                    		}   
	        	                    		if('USER' == result[i].CODE){
	        		                            arr.icon = Hussar.ctxPath+"/static/assets/img/treeContext/user.png";
	        		                        }
	        	                    		if(result[i].parent=="#"){
	        		                        	arr.state = {opened : true, disabled:true};
	        		                    	}
	        	                    		for(var j=0; j<bproxys.length; j++){
	        	                    			if(bproxys[j] == result[i].id){
	        	                    				arr.state.checked = true;  
	        	                    				arr.state.selected = true;
	        	                    				break;
	        	                    			}
	        	                    		}                  		                   		
	        	                    		arrays.push(arr);
	        	                    	}
	        	                    	data = arrays;	        	            	
	        						}, function(data) {
	        							
	        						});
	        	                ajax.set("ids",bproxys.join(","));
	        	    			ajax.start();
	                		
	                	}else{
	                		
	                	}
	                	
	    					}, function(data) {
	    						Hussar.error("加载被代理用户树失败!");
	    					});
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['checkbox','search'],
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : true,//是否父子级别关联
	        	tie_selection : false
	        },
	        search: UserMgr.search()
	    });	    
	}

	/**
	 * 加载 当前账户 代理了的用户树
	 */
	UserMgr.initProxyTree = function (proxys) {	
		$proxyTree = UserMgr.proxyTree;//代理用户树
		$proxyTree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/userTree",function(result) {
	                	if(UserMgr.addORedit == 'add'){
	                		var arrays = [];
		                    for(var i=0; i<result.length; i++){
		                        var arr = {
	                        		id	:	result[i].id,
	                    		    parent : result[i].parent,
	                    		    text : result[i].text,
	                    		    code : result[i].CODE,
	                    		    organId : result[i].organId,
	                    		    struLevel : result[i].struLevel,
	                    		    struType : result[i].struType,
	                    		    struOrder : result[i].STRU_ORDER,
	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	                    		    icon : ""
		                        }
		                        if('USER' == result[i].CODE){
		                            arr.icon = Hussar.ctxPath+"/static/assets/img/treeContext/user.png";
		                        }
		                        if(result[i].parent=="#"){
		                        	arr.state = {opened : true};
		                    	}
		                        arrays.push(arr);
		                    }
		                    data = arrays;
	                	}else if(UserMgr.addORedit == 'edit'){
	                		var arrays = [];
	                    	for(var i=0; i<result.length; i++){                    		 
	                    		var arr = {
	                    		    id	:	result[i].id,
	                    		    parent : result[i].parent,
	                    		    text : result[i].text,
	                    		    code : result[i].CODE,
	                    		    organId : result[i].organId,
	                    		    struLevel : result[i].struLevel,
	                    		    struType : result[i].struType,
	                    		    struOrder : result[i].STRU_ORDER,
	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	                    		    icon : "",
	                    		    state : {selected:false, checked:false}                				
	                    		}   
	                    		if('USER' == result[i].CODE){
		                            arr.icon = Hussar.ctxPath+"/static/assets/img/treeContext/user.png";
		                        }
	                    		if(result[i].parent=="#"){
		                        	arr.state = {opened : true};
		                    	}
	                    		for(var j=0; j<proxys.length; j++){
	                    			if(proxys[j] == result[i].id){
	                    				arr.state.checked = true;  
	                    				arr.state.selected = true;
	                    				break;
	                    			}
	                    		}                  		                   		
	                    		arrays.push(arr);
	                    	}
	                    	data = arrays;
	                	}else if(UserMgr.addORedit == 'view'){
	                		var ajax = new $ax(Hussar.ctxPath + "/user/proxyTree",
	        	            		function(result) {
	        		                	var arrays = [];
	        	                    	for(var i=0; i<result.length; i++){                    		 
	        	                    		var arr = {
	        	                    		    id	:	result[i].id,
	        	                    		    parent : result[i].parent,
	        	                    		    text : result[i].text,
	        	                    		    code : result[i].CODE,
	        	                    		    organId : result[i].organId,
	        	                    		    struLevel : result[i].struLevel,
	        	                    		    struType : result[i].struType,
	        	                    		    struOrder : result[i].STRU_ORDER,
	        	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	        	                    		    icon : "",
	        	                    		    state : {selected:false, checked:false, disabled:true}                				
	        	                    		}   
	        	                    		if('USER' == result[i].CODE){
	        		                            arr.icon = Hussar.ctxPath+"/static/assets/img/treeContext/user.png";
	        		                        }
	        	                    		if(result[i].parent=="#"){
	        		                        	arr.state = {opened : true, disabled:true};
	        		                    	}
	        	                    		for(var j=0; j<proxys.length; j++){
	        	                    			if(proxys[j] == result[i].id){
	        	                    				arr.state.checked = true;  
	        	                    				arr.state.selected = true;
	        	                    				break;
	        	                    			}
	        	                    		}                  		                   		
	        	                    		arrays.push(arr);
	        	                    	}
	        	                    	data = arrays;
	        	            	
	        						}, function(data) {
	        							Hussar.error("加载代理用户树失败!");
	        						});
	        	                ajax.set("ids",proxys.join(","));
	        	    			ajax.start();
	                	}else{
	                		
	                	}
	    					}, function(data) {
	    						Hussar.error("加载代理用户树失败!");
	    					});
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['checkbox','search'],
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : true,//是否父子级别关联
	        	tie_selection : false
	        },
	        search: UserMgr.search()
	    });
		
	}
	
/**********************************************Some Operation Start***************************************************/
	//角色复制操作
	UserMgr.copyRoleEvent = function (node) {
		UserMgr.copyRoleTree.jstree("destroy");
		UserMgr.initCopyRoleTree();	//加载排序树
		UserMgr.layerIndex = layer.open({
			type: 1,
			btn: ['取消', '保存'],
			area: ['350px','500px'],
			skin: 'confirm-class',
			fix: false, //不固定
			maxmin: false,
			shadeClose: false,
			shade: 0.4,
			title: "选择角色复制到的用户",
			content: $('#copyRole'),
			btn2: function(index, layero){
				UserMgr.saveCopyRole();
				return false;
			 },  
			success: function() {
				$(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
				UserMgr.selectId = node.id;	//	获得要复制的用户id
			}
		});
	}
	
	//保存角色复制
	UserMgr.saveCopyRole = function () {
		var nodes = $copyRoleTree.jstree(true).get_checked();//获得要复制到的用户            					
		if(nodes.length==0){
			Hussar.info("请选择要复制到的用户！");
		} else {   	 
			var data = {
					copyFrom : 	UserMgr.selectId,
					copyTo : nodes.join(",")
			};    	    	  					
			var saveCopyRole = function () {   	  							
				var ajax = new $ax(Hussar.ctxPath + "/user/copyRole", function(data) {
					if (data.code == "200") {
						Hussar.success("复制成功！（请等待审核）");			    	  									
					} else if (data.code) {
						Hussar.error(data.message);
					} else {
						Hussar.error("复制失败!");
					}			
				}, function(data) {
					Hussar.error("复制失败!");
				});
				ajax.setData(data);   	  							
				ajax.start();
				layer.close(UserMgr.layerIndex);   
			};
			Hussar.confirm("确定要将角色复制到选择的用户上吗?", saveCopyRole);    		                    
		} 
	}
	
	//用户排序操作
	UserMgr.userOrderEvent = function (orgId) {
		UserMgr.orderTree.jstree("destroy");
		UserMgr.initOrderTree(orgId);	//加载排序树
		UserMgr.layerIndex = layer.open({
			type: 1,
			btn: ['取消', '保存'],
			skin: 'confirm-class',
			area: ['350px','500px'],
			fix: false, //不固定
			maxmin: false,
			shadeClose: false,
			shade: 0.4,
			title: "下级用户排序",
			content: $('#userOrder'),
			btn2: function(index, layero){
				UserMgr.saveUserOrder();
                return false;
			 },
			success:function(){
				$(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");                              
			}
		});
	}
	
	//保存用户排序
	UserMgr.saveUserOrder = function () {
		var saveTree =function(){
			var treeInfo = $("#output").val();	//排序信息
			var ajax = new $ax(Hussar.ctxPath + "/user/saveUserOrder", function(data) {
	    		if (data.code == "200") {
	    			Hussar.success("保存成功!");
	    			layer.close(UserMgr.layerIndex);
	    			$("#userTree").jstree(true).refresh();//刷新用户树
	    		} else if (data.code) {
	    			Hussar.error(data.message);
	    		} else {
	    			Hussar.error("保存失败!");
	    		}			
	    	}, function(data) {
	    		Hussar.error("保存失败!");
	    	});
	    	ajax.set("treeInfo",treeInfo);
	    	ajax.start();						    		
    	}
    	Hussar.confirm("确定要保存排序吗?", saveTree);
	}
	
	//加载用户详情
	UserMgr.detailView = function (id) {		
		$('#addEvent').addClass('hide');//先隐藏，数据加载完后再显示	 
		$('.must').addClass('hide');//隐藏必填标识
		UserMgr.addORedit = 'view';
		$("#opsType").html("用户信息");	
		document.getElementById("userForm").reset();
		UserMgr.userTree.jstree("select_node", id);//选中节点
		
		//表单不可编辑，隐藏保存按钮
		$('#userForm input').attr('disabled',true);
		$('.con-full-l input').attr('disabled',false);
		$('#userForm select').attr('disabled',true);
		$('#btnDiv').addClass('hide');
			
		UserMgr.roleTree.jstree("destroy");
		UserMgr.proxyTree.jstree("destroy");
		UserMgr.byProxyTree.jstree("destroy");	        	
		var ajax = new $ax(Hussar.ctxPath + "/user/userInfo",
	    		function(result) {	 
					/*基本信息开始*/
					$(".layui-table-r").show();
					$(".addone").hide();
	    			var user = result[0];
	    			$('#corporationId').val(user[0].corporationId);
	    			$('#userId2').html(user[0].userId);	    			
	    			$('#userName2').html(user[0].userName);	    			
//	    			$('#securityLevel').val(user[0].securityLevel);
	    			$('#maxSessions2').html(user[0].maxSessions);
	    			$('#eMail2').html(user[0].eMail);
	    			// $('#qq2').html(user[0].qq);
	    			$('#mobile2').html(user[0].mobile);
	    			$('#weChat2').html(user[0].weChat);
        			$('#telephone2').html(user[0].telephone);        			
	    			var isSys = $("input[name='isSys2']");
	    			for(var i=0; i<isSys.length; i++){
	    				if(isSys[i].value == user[0].isSys){
	    					isSys[i].checked = true;
	    				}
	    			}
	    			var state = $("input[name='accountStatus2']");
	    			for(var i=0; i<state.length; i++){
	    				if(state[i].value == user[0].accountStatus){
	    					state[i].checked = true;
	    				}
	    			}               			
	    			/*基本信息结束*/
	    			
	    			/*角色信息开始*/
	    			var grantRole = result[1];
	    			var roles = [];
	    			for(var i=0; i<grantRole.length; i++){
	    				roles.push(grantRole[i].grantedRole);
	    			}                			
	    			UserMgr.initroleTree(roles);		    			
	    			/*角色信息结束*/
	    				    			
	    			
	    			/*代理用户信息开始*/
	    			var userProxy = result[2];
	    			var proxys = [];
	    			for(var i=0; i<userProxy.length; i++){
	    				proxys.push(userProxy[i].proxyUserId);
	    			}
	    			UserMgr.initProxyTree(proxys);
	    			/*代理用户信息结束*/
	    			
	    			/*被代理用户信息开始*/
	    			var byProxy = result[3];
	    			var bproxys = [];
	    			for(var i=0; i<byProxy.length; i++){
	    				bproxys.push(byProxy[i].userId);
	    			}
	    			UserMgr.initByProxyTree(bproxys);
	    			/*被代理用户信息结束*/
	    			
	    			$('#baseInfo').click();//Tab标签回到一般信息	
	    			$('#addEvent').removeClass('hide');//显示div	    			
				}, 
				function(data) {
					Hussar.error("加载用户信息失败!");
				});
		ajax.set("id",id);
		ajax.start();
		$('#addEvent').removeClass('hide');//显示新增(修改)div
	}
	
	//用户删除
	UserMgr.delUser = function (node) {
		var operation = function () {
    		var ajax = new $ax(Hussar.ctxPath + "/user/delete",
					function(data) {
    					if(data.code == '200'){
    						Hussar.success("删除成功!");	
    						$('#addEvent').addClass('hide');
    						$("#userTree").jstree(true).refresh();//刷新用户树
    					} else {
    						Hussar.error(data.message);
    					}	    						
					}, 
					function(data) {	    						
						Hussar.error("删除失败!");
					});
			ajax.set("userId", node.id);
			ajax.start();
    		
    	}	        	
    	Hussar.confirm("确定要删除该用户吗?", operation);	   
	}
	
	//用户修改
	UserMgr.editUser = function (userId) {
		$('#addEvent').addClass('hide');//先隐藏，数据加载完后再显示	        	
    	$('#addORedit').attr('value','edit');
    	UserMgr.addORedit = 'edit';
    	document.getElementById("userForm").reset();		        	
    	$("#opsType").html("用户修改");
        $(".addone").show();
        $(".layui-table-r").hide();
        //去掉不可编辑的状态
    	$('#userForm input').attr('disabled',false);
		$('#userForm select').attr('disabled',false);
		$('#btnDiv').removeClass('hide');
		$('.must').removeClass('hide');//显示必填标识	    			

    	$('#baseInfo').click();//Tab标签回到一般信息	
    	UserMgr.roleTree.jstree("destroy");
    	UserMgr.proxyTree.jstree("destroy");
    	UserMgr.byProxyTree.jstree("destroy");
    	UserMgr.chooseStaffTree.jstree("destroy");
    	UserMgr.initChooseStaffTree();	//初始化职工选择树
    	var ajax = new $ax(Hussar.ctxPath + "/user/userInfo",
        		function(result) {	 
    				/*基本信息开始*/
        			var user = result[0];
        			$('#corporationId').val(user[0].corporationId);
        			$('#userId').val(user[0].userId);
        			$("#userId").attr("readonly",true);//用户名不可修改
        			$('#userName').val(user[0].userName);       			
//        			$('#securityLevel').val(user[0].securityLevel);
        			$('#maxSessions').val(user[0].maxSessions);
        			$('#eMail').val(user[0].eMail);
        			// $('#qq').val(user[0].qq);
        			$('#mobile').val(user[0].mobile);
        			$('#weChat').val(user[0].weChat);
        			$('#telephone').val(user[0].telephone);
        			var isSys = $("input[name='isSys']");
        			for(var i=0; i<isSys.length; i++){
        				if(isSys[i].value == user[0].isSys){
        					isSys[i].checked = true;
        				}
        			}
        			var state = $("input[name='accountStatus']");
        			for(var i=0; i<state.length; i++){
        				if(state[i].value == user[0].accountStatus){
        					state[i].checked = true;
        				}
        			}
        			/*基本信息结束*/
        			
        			/*角色信息开始*/
        			var grantRole = result[1];
        			var roles = [];
        			for(var i=0; i<grantRole.length; i++){
        				roles.push(grantRole[i].grantedRole);
        			}                			
        			UserMgr.initroleTree(roles);
        			/*角色信息结束*/        			        			
        			
        			/*代理用户信息开始*/
        			var userProxy = result[2];
        			var proxys = [];
        			for(var i=0; i<userProxy.length; i++){
        				proxys.push(userProxy[i].proxyUserId);
        			}
        			UserMgr.initProxyTree(proxys);
        			/*代理用户信息结束*/
        			
        			/*被代理用户信息开始*/
        			var byProxy = result[3];
        			var bproxys = [];
        			for(var i=0; i<byProxy.length; i++){
        				bproxys.push(byProxy[i].userId);
        			}
        			UserMgr.initByProxyTree(bproxys);
        			/*被代理用户信息结束*/
        			        			
        			$('#addEvent').removeClass('hide');//显示div        			
				}, 
				function(data) {
					Hussar.error("加载用户信息失败!");
				});
    	ajax.set("id",userId);
		ajax.start();
    	$('#addEvent').removeClass('hide');//显示新增(修改)div
	}
	
	//用户转移机构
	UserMgr.changeOrgEvent = function (node) {
		var parent = UserMgr.userTree.jstree("get_node", node.parent);//获取父节点
    	UserMgr.selectId = parent.id;
    	$('#userId3').val(node.id);
    	$('#corporationId3').val(parent.id);
    	$('#permitId3').val(parent.original.PERMITID);
    	UserMgr.orgTree.jstree("destroy");
    	UserMgr.initOrgTree();
    	UserMgr.layerIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            title: '机构变更',
            area: ['350px', '500px'], //宽高
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            content: $('#changeOrg'),
            btn2: function(index, layero){
    			UserMgr.saveChangeOrg();	//保存用户机构转移
    			return false;
    		},
            success:function(){
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
            }
    		
        });	 
	}
	
	//保存用户机构转移
	UserMgr.saveChangeOrg = function () {
		var ref = $("#orgTree").jstree(true);
	    var nodeids = ref.get_checked();  //获取选中的节点对象id   
	    if(nodeids.length == 0){
	    	Hussar.info('请选择要变更的机构！');
	    }else if(nodeids.length > 1){
	    	Hussar.info('只能选择一个要变更的机构！');
	    }else if(nodeids[0] == $('#corporationId2').val()){
	    	Hussar.info('变更机构不能和原所属机构相同！');
	    }else{
	    	$('#corporationId3').val(nodeids[0]);
	    	
	    	var data = $("#changeOrgForm").serialize();	
	    	// 提交信息
	    	var ajax = new $ax(Hussar.ctxPath + "/user/changeOrg", function(data) {
	    		if (data.code == "200") {
	    			Hussar.success("变更成功!");
	    			layer.close(UserMgr.layerIndex);
	    			$("#userTree").jstree(true).refresh();//刷新用户树
	    		} else if (data.code) {
	    			Hussar.error(data.message);
	    		} else {
	    			Hussar.error("变更失败!");
	    		}			
	    	}, function(data) {
	    		Hussar.error("变更失败!");
	    	});
	    	ajax.setData(data);
	    	ajax.start();
	    }
	}
	
	//新增用户
	UserMgr.addUser = function (node) {
		$('#addORedit').attr('value','add');
    	UserMgr.addORedit = 'add';//js中使用
    	document.getElementById("userForm").reset();//重置表单
    	$("#opsType").html("用户新增");
        $(".addone").show();
        $(".layui-table-r").hide();
    	//去掉不可编辑的状态
    	$("#userId").attr("readonly",false);
    	$('#userForm input').attr('disabled',false);
		$('#userForm select').attr('disabled',false);
		$('#btnDiv').removeClass('hide');
		$('.must').removeClass('hide');//显示必填标识	    			
		
    	$('#baseInfo').click();//Tab标签回到一般信息	    
    	$('#corporationId').val(node.id);//公司结构编码
    	$('#permissionStruId').val(node.original.PERMITID);//所属权限组织编码
    	UserMgr.roleTree.jstree("destroy");
    	UserMgr.proxyTree.jstree("destroy");
    	UserMgr.byProxyTree.jstree("destroy");    	
    	UserMgr.initroleTree(); //初始化角色树   	
    	UserMgr.initProxyTree(); //当前账户 代理了的用户树
    	UserMgr.initByProxyTree(); //当前账户 被哪些用户 代理 	        			        	
    	$('#addEvent').removeClass('hide');//显示新增(修改)div
	}
	
	//重置按钮操作
	UserMgr.resetEvent = function () {
		if (UserMgr.addORedit == 'add') {
			//因为form中有隐藏的元素，所以不能直接用form.reset
			$("input[id='userId']").val("");
			var isSys = $("input[name='isSys']");
			for(var i=0; i<isSys.length; i++){
				if(isSys[i].value == '0'){
					isSys[i].checked = true;
				}
			}
			$("input[id='userName']").val("");
			$("input[id='maxSessions']").val("1");
			$("input[id='eMail']").val("");
			// $("input[id='qq']").val("");
			$("input[id='weChat']").val("");
			$("input[id='mobile']").val("");
			$("input[id='telephone']").val("");			
			var accountStatus = $("input[name='accountStatus']");
			for(var i=0; i<accountStatus.length; i++){
				if(accountStatus[i].value == '1'){
					accountStatus[i].checked = true;
				}
			}
			form.render();
		} else if (UserMgr.addORedit == 'edit') {
			UserMgr.editUser(UserMgr.selectId);
		}
	}
	
	//中文名称点击事件
	UserMgr.nameClickEvent = function () {
		var isSys = $("input[name='isSys']:checked").val();
		if (isSys == '1') {	//如果是系统管理员
			//中文名称手动输入，不需要关联人员
			$("input[id='userName']").attr("readonly",false);
		} else if (isSys == '0') {	//如果不是系统管理员
			//中文名称通过关联人员来获取
			$("input[id='userName']").attr("readonly",true);
			UserMgr.chooseStaffTree.jstree("destroy");
			UserMgr.initChooseStaffTree();	//初始化职工选择树
			layer.open({
                type: 1,
                btn: ['取消', '保存'],
                skin: 'confirm-class',
                title: '选择人员',
                area: ['350px', '500px'], //宽高
                fix: false, //不固定
                maxmin: false,
                shadeClose: false,
                content: $('#chooseStaffView'),
                btn2: function(index, layero){
                	var nodes = $chooseStaffTree.jstree(true).get_checked(true);//获得选中的员工节点
  					if(nodes.length==0){
  						Hussar.info("请选择一个人员！");
  					} else if(nodes.length!=1) {
  						Hussar.info("只能选择一个人员！");
  					} else {
  						$("#employeeId").val(nodes[0].id);
  						$("input[id='userName']").val(nodes[0].text);
  						layer.close(index);
  					}
  					return false;
        		},
                success:function(){
                	$(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                }        		
            });	
		}
	}
	
	//用户保存操作
	UserMgr.save = function () {
		UserMgr.getChecked(); //获得树上选中的节点
		var data = $("#userForm").serialize();		
		var userId = $('#userId').val();	
		// 提交信息
		if (UserMgr.addORedit == 'add') {
			var ajax = new $ax(Hussar.ctxPath + "/user/add", function(data) {
				if (data.code == "200") {
					Hussar.success("保存成功！（角色信息请等待审核）");			
					$("#userTree").jstree(true).refresh();//刷新用户树			
					UserMgr.detailView(userId);//加载详情
				} else if (data.code) {
					Hussar.error(data.message);
				} else {
					Hussar.error("保存失败!");
				}			
			}, function(data) {
				Hussar.error("保存失败!");
			});
			ajax.setData(data);
			ajax.start();
		} else if (UserMgr.addORedit == 'edit') {
			var ajax = new $ax(Hussar.ctxPath + "/user/edit", function(data) {
				if (data.code == "200") {
					Hussar.success("保存成功！（角色信息请等待审核）");			
					$("#userTree").jstree(true).refresh();//刷新用户树			
					UserMgr.detailView(userId);//加载详情
				} else if (data.code) {
					Hussar.error(data.message);
				} else {
					Hussar.error("保存失败!");
				}			
			}, function(data) {
				Hussar.error("保存失败!");
			});
			ajax.setData(data);
			ajax.start();
		}				
	}
	
	//用户保存时  获取3棵树上被选中的节点
	UserMgr.getChecked = function () {
		//角色树
		var roleNodes = UserMgr.roleTree.jstree(true).get_checked(true);       
	    var rolends ='';       
	    $.each(roleNodes, function(i, nd) {
	    	if(nd.original.code == 'ROLE'){
	    		rolends +=","+nd.original.id;
	    	}        	
	    });        	        
	    $("#roleIds").val(rolends.substring(1));
	    //代理用户树
	    var proxyNodes = UserMgr.proxyTree.jstree(true).get_checked(true);       
	    var proxynds ='';       
	    $.each(proxyNodes, function(i, nd) {
	    	if(nd.original.code == 'USER'){
	    		proxynds +=","+nd.original.id;
	    	}        	
	    });        	        
	    $("#proxys").val(proxynds.substring(1));
	    //被代理用户树
	    var byproxyNodes = UserMgr.byProxyTree.jstree(true).get_checked(true);       
	    var byproxynds ='';       
	    $.each(byproxyNodes, function(i, nd) {
	    	if(nd.original.code == 'USER'){
	    		byproxynds +=","+nd.original.id;
	    	}        	
	    });        	        
	    $("#byProxys").val(byproxynds.substring(1));
	}
	
	
/**********************************************Some Operation End*****************************************************/
	
	/**
	 * 所有树的模糊查询
	 */
	UserMgr.search = function () {
		var to = false;   
		//用户树查询
		$("#userTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#userTreeSearch").val();   
		        var temp = $userTree.is(":hidden");   
		        if (temp == true) {   
		        	$userTree.show();   
		        }   
		        $userTree.jstree(true).search(v);
		        //添加索引
				if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
				}else {
                    $(".search-results").html("");
				}

		    }, 250);   
		}); 
		//角色复制树查询
		$("#copyRoleTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#copyRoleTreeSearch").val();   
		        var temp = $copyRoleTree.is(":hidden");   
		        if (temp == true) {   
		        	$copyRoleTree.show();   
		        }   
		        $copyRoleTree.jstree(true).search(v);   
		    }, 250);   
		}); 
		//排序树查询
		$("#orderTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#orderTreeSearch").val();   
		        var temp = $orderTree.is(":hidden");   
		        if (temp == true) {   
		        	$orderTree.show();   
		        }   
		        $orderTree.jstree(true).search(v);   
		    }, 250);   
		}); 
		//变更所属部门树查询
		$("#orgTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#orgTreeSearch").val();   
		        var temp = $orgTree.is(":hidden");   
		        if (temp == true) {   
		        	$orgTree.show();   
		        }   
		        $orgTree.jstree(true).search(v);   
		    }, 250);   
		});
		//角色树查询
		$("#roleTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#roleTreeSearch").val();   
		        var temp = $roleTree.is(":hidden");   
		        if (temp == true) {   
		        	$roleTree.show();   
		        }   
		        $roleTree.jstree(true).search(v);   
		    }, 250);   
		});
		//代理用户树查询
		$("#proxyTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#proxyTreeSearch").val();   
		        var temp = $proxyTree.is(":hidden");   
		        if (temp == true) {   
		        	$proxyTree.show();   
		        }   
		        $proxyTree.jstree(true).search(v);   
		    }, 250);   
		});
		//被代理用户树查询
		$("#byProxyTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#byProxyTreeSearch").val();   
		        var temp = $byProxyTree.is(":hidden");   
		        if (temp == true) {   
		        	$byProxyTree.show();   
		        }   
		        $byProxyTree.jstree(true).search(v);   
		    }, 250);   
		});
	}
	
	/**
	 * 初始化按钮事件
	 */
	UserMgr.initButtonEvent = function () {
		//重置按钮事件
		$("#btnReset").click(function(){			
			UserMgr.resetEvent();
		});
		
		//保存按钮事件
		$("#btnSave").click(function(){			
			form.on('submit(go)', function(data){				
				UserMgr.save();
			});			
		});	
		
		//是否系统管理员radio选择事件
		form.on('radio(isSys)',function(data){
			//清空中文名称和关联的员工id
			$("input[id='userName']").val("");
			$("input[id='employeeId']").val("");
		});		
		
		//中文名称点击事件
		$("input[id='userName']").click(function(){	
			UserMgr.nameClickEvent();			 
		});
	};
	
	/**
	 * 初始化表单验证
	 */
	UserMgr.initValidate = function () {
		form.verify({
			required : function(value, item){
				if(value.trim()==""){
					$("#baseInfo").click();
					return '必填项不能为空';
				}
			},
			phone : function(value, item){
				if(!/^1[3|4|5|7|8]\d{9}$/.test(value)){
					$("#baseInfo").click();
					return '请输入正确的手机号'
				}
			},
			email : function(value, item){
				if(value == null || value == ""){
					//非必填项，内容为空时不校验
					return;
				}
				if(!/^[a-z0-9._%-]+@([a-z0-9-]+\.)+[a-z]{2,4}$|^1[3|4|5|7|8]\d{9}$/.test(value)){
					$("#baseInfo").click();
					return '请输入正确的邮箱'
				}
			},
			// qq : function(value, item){
			// 	if(value == null || value == ""){
			// 		//非必填项，内容为空时不校验
			// 		return;
			// 	}
			// 	if(!/^[1-9][0-9]{4,14}$/.test(value)){
			// 		$("#baseInfo").click();
			// 		return '请输入正确的QQ号'
			// 	}
			// },
			sessionNum : function(value, item){
				if(!/^(0|[1-9][0-9]*|-1)$/.test(value)){
					$("#baseInfo").click();
					return '请输入正确的会话数，-1为不限会话数'
				}
			},
			account : function(value, item){		
				if(!/^[a-zA-Z0-9_-]{4,16}$/.test(value)){
					$("#baseInfo").click();
					return '用户账号由4到16位的数字、字母、下划线组成'
				}
			},
			weChat : function(value, item){	
				if(value == null || value == ""){
					//非必填项，内容为空时不校验
					return;
				}
				if( !(/^[a-zA-Z]{1}[-_a-zA-Z0-9]{5,19}$/.test(value) 
						|| /^[1-9][0-9]{4,14}$/.test(value)
						|| /^1[3|4|5|7|8]\d{9}$/.test(value)
						|| /^[a-z0-9._%-]+@([a-z0-9-]+\.)+[a-z]{2,4}$|^1[3|4|5|7|8]\d{9}$/.test(value) ) ){
					$("#baseInfo").click();
					return '请输入正确的微信号'
				}
			},
			telephone : function(value, item){	
				if(value == null || value == ""){
					//非必填项，内容为空时不校验
					return;
				}
				if(!/^[0-9_-]{4,16}$/.test(value)){
					$("#baseInfo").click();
					return '请输入正确的办公电话'
				}
			},
			
		});
	}
	
	/**
	 * 高度自适应调整
	 */
	UserMgr.initFrameHeight = function () {	
		var h = $(window).height()-51;
		var h2 = $(window).height();
		$("#treeArea").css("height", h + "px");
		$(".layui-col-md9").css("height", h2 + "px");
	};
	


	$(function () { 	
		UserMgr.initUserTree(); //初始化用户树	
		UserMgr.initButtonEvent();	//初始化按钮事件
		UserMgr.initValidate();	//初始化表单验证
		UserMgr.initFrameHeight();	//初始化高度				
	    $(window).resize(function() {
	    	UserMgr.initFrameHeight();
		});
	});
	
});

