/**
 * @Description: 资源管理脚本文件
 * @Author: sunZengXin
 * @Date: 2018/3/7.
 */
layui.use(['jquery','layer','Hussar','jstree','form'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var form = layui.form;
	var ResourceManage = {
			treeId:"resTree",
			frameId:"moduleFrame",
			infoWin:null, //弹出窗口
			selectModuleId:"",//模块ID
			selectFunctionId:""//功能ID
	}
	
	/*初始化页面*/
	ResourceManage.initPage= function(){
		ResourceManage.initFrameHeight();
		this.initTreeView();
		this.initOrderTreeView();
		this.initModuleChangeTreeView();
		this.initFunctionChangeTreeView();
		this.initResourceChangeTreeView();
		this.initButtonEvent();
	}
	/*加载资源树*/
	ResourceManage.initTreeView = function(){
	    var $tree = $("#"+ ResourceManage.treeId+"");
	    $tree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                $.ajax({
	                    type: "POST",
	                    url: Hussar.ctxPath + "/resource/resTree",
	                    dataType:"json",
	                    async: false,
	                    success:function(result) {
	                    	var arrays = [];
	                        for(var i=0; i<result.length; i++){
	                        	var arr = {
	                        			 id	:	result[i].ID,
	                        			 code:   result[i].CODE,
	                        			 text : result[i].TEXT,
	                                     parent : result[i].PARENT,
	                                     isLeaf:result[i].ISLEAF,
	                                     type:result[i].TYPE,
	                                     isFun:result[i].ISFUN,
	                                     isRes:result[i].ISRES
	                        		}
	                        	arrays.push(arr);
	                        }
	                        data = arrays;
	                        $("#moduleFrame").attr("src","")
	                    },
	                    error:function(){
	                    	Hussar.error("加载功能模块树失败！");
	                    }
	
	                });
	                callback.call(this, data);
	            }
	        },
	        plugins: ['state', 'types', 'contextmenu', 'search'],
	        types:{
	        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
	        	"isModule":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/module.png"},
	        	"isFun":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/function.png"},
                "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
                "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
	        },
            search: ResourceManage.initTreeSearch(),
	        contextmenu: {
	            items: ResourceManage.menuList
	        }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
	    		var moduleId = currentNode.id
	    		var parent = currentNode.parent
	    		var isLeaf = currentNode.original.isLeaf;
	    		var isFun = currentNode.original.isFun;
	    		var isRes = currentNode.original.isRes;
	    		//判断是否为根节点如果为根节点
	    		if(parent=="#"){
	    			$("#moduleFrame").attr("src","")
	    		}else{
	    			if(isFun==1){
	    				//功能详情跳转
	    				$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/functionView?functionId=" + moduleId)	
	    			}else{
	    				if(isRes==1){
	            			$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/resourceView?resourceId=" + moduleId)	
	    				}else{
	            			$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/moduleView?moduleId=" + moduleId)	
	    				}
	    			}
	    		}
		});
	}
	/*初始化功能模块排序树*/
	ResourceManage.initOrderTreeView = function(){
	    //初始化数列表
	    var $tree = $("#moduleTreeOrder");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {
	                //拖动排序时只允许同级拖动
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: null
	        },
	        plugins: ['state', 'types',"dnd"],
	        sort:function(a,b){
	            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
	        },
	        types:{
	        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
	        	"isModule":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/module.png"},
	        	"isFun":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/function.png"},
                "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
                "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
	        }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
				loadOrgInfo(22);
		});
	    //移动树事件
	    $tree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	var newResult=[];
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].seq=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].seq=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].seq=i+2;
	            			}else{
	            				oldResult[i].seq=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].seq=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].seq=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].seq=i;
	            			}else{
	            				oldResult[i].seq=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}
	    	oldResult.sort(ResourceManage.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
		
	}
	
	/*初始化模块转移树*/
	ResourceManage.initModuleChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#moduleTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['state', 'types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
		        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
		        	"isModule":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/module.png"},
		        	"isFun":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/function.png"},
                    "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
                    "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
		        }
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		    $tree.on('check_node.jstree', function(event, obj) {
  			   var currentNode = obj.node;
  		   	   var moduleName = obj.node.text;
  		   	   var isLeaf = obj.node.original.isLeaf;
                var ref =$tree.jstree(true);
                var nodes = ref.get_checked(); //使用get_checked方法
                var otherNode;
                otherNode="";
              //判断是否为相同节点，则不能移动
                if(ResourceManage.selectModuleId==obj.node.id){
              	  ref.uncheck_node(obj.node.id);
              	  Hussar.info("不能转移到当前模块！");
        			  return;
                }
              //限制选择不能选择当前以及当前子节点
                if(nodes.length>0){
              	  $.each(currentNode.parents, function(i, nd) {
                  		if(nd == ResourceManage.selectModuleId){
                  			ref.uncheck_node(obj.node.id);
                  			Hussar.info("不能转移到当前模块！");
                  			return false;
                  		}
                  	})
                    
                }
                //限制只能选一个
                if(nodes.length>1){
                	$.each(nodes, function(i, nd) {
                		if(nd != obj.node.id){
                			otherNode = nd;
                		}
                	})
                	ref.uncheck_node(otherNode);
                }
                
            });
	}
	
	/*初始化功能转移树*/
	ResourceManage.initFunctionChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#functionTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['state', 'types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
		        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
		        	"isModule":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/module.png"},
		        	"isFun":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/function.png"},
                    "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
                    "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
		        }
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		    $tree.on('check_node.jstree', function(event, obj) {
	  			   var currentNode = obj.node;
	  		   	   var moduleName = obj.node.text;
	  		   	   var isLeaf = obj.node.original.isLeaf;
	                var ref =$tree.jstree(true);
	                var nodes = ref.get_checked(); //使用get_checked方法
	                var otherNode;
	                otherNode="";
	                //判断是否为相同节点，则不能移动
	                if("1"!=isLeaf){
	              	  ref.uncheck_node(obj.node.id);
	              	  Hussar.info("不能转移到当前模块！");
	        			  return;
	                }
	                //限制只能选一个
	                if(nodes.length>1){
	                	$.each(nodes, function(i, nd) {
	                		if(nd != obj.node.id){
	                			otherNode = nd;
	                		}
	                	})
	                	ref.uncheck_node(otherNode);
	                }
	                
	        });
	}
	
	/*初始化资源转移树*/
	ResourceManage.initResourceChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#resourceTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['state', 'types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
		        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
		        	"isModule":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/module.png"},
		        	"isFun":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/function.png"},
                    "1":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_menu.png"}, //菜单资源
                    "2":{'icon' :Hussar.ctxPath+"/static/assets/img/treeContext/resource_btn.png"},  //按钮资源
		        }
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		    $tree.on('check_node.jstree', function(event, obj) {
  			   var currentNode = obj.node;
  		   	   var moduleName = obj.node.text;
  		   	   var isFun = obj.node.original.isFun;
                var ref =$tree.jstree(true);
                var nodes = ref.get_checked(); //使用get_checked方法
                var otherNode;
                otherNode="";
                //判断是否为功能节点
                if("1"!=isFun){
              	  ref.uncheck_node(obj.node.id);
              	  Hussar.info("不能转移到当前模块！");
        			  return;
                }
                //限制只能选一个
                if(nodes.length>1){
                	$.each(nodes, function(i, nd) {
                		if(nd != obj.node.id){
                			otherNode = nd;
                		}
                	})
                	ref.uncheck_node(otherNode);
                }
                
            });
	}
	/*刷新功能模块树*/
	ResourceManage.refreshTree = function(){
		$("#"+ ResourceManage.treeId+"").jstree(true).refresh();
	}
	/*加载资源树右键点击菜单*/
	ResourceManage.menuList=function(node){
		var items={
	            create: null,
	            remove: null,
	            ccp: null,
	            add: {
	                label: "新增模块",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
	                    //alert(info.id+"+"+info.text);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	//选中模块名称
			        	var moduleName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/moduleAdd?moduleId=" + moduleId)
			        	
	                }
	            },
	            addFunction: {
	                label: "新增功能",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	//选中模块编码
			        	var moduleCode=clickedNode.original.code;
			        	//选中模块名称
			        	var moduleName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/functionAdd?moduleId=" + moduleId)
	                }
	            },
	            addResource: {
	                label: "新增资源",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var functionId=clickedNode.id;
			        	//选中功能编码
			        	var functionCode=clickedNode.original.code;
			        	//选中功能名称
			        	var functionName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/resourceAdd?functionId=" + functionId)
	                }
	            },
	            edit: {
	                label: "修改",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	//选中模块名称
			        	var moduleName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/moduleEdit?moduleId=" + moduleId)
	                }
	            },
	            changeModule: {
                    label: "转移",
                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
                    action: function (obj) {
                    	//获取点击的节点信息
                    	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	layer.open({
	        				type: 1,
	        				btn: ['取消', '保存'],
	        				skin: 'confirm-class',
	        				area: ['350px','500px'],
	        				fix: false, //不固定
	        				maxmin: false,
	        				shadeClose: false,
	        				shade: 0.4,
	        				title: "模块选择",
	        				content: $('#moduleTreeEditChange'),
	        				btn2: function(index, layero){
	        					//获取选中节点
        	  					var nodes = $("#moduleTreeChange").jstree(true).get_checked();//使用get_checked方法
        	  					if(nodes.length==0){
        	  						Hussar.info("请先选择上级模块！");
        	  					}else{
	        					//确认按钮回调
	        					var saveTree =function(){
	        	  						$.ajax({
	        			    			url:Hussar.ctxPath + "/resource/moduleTreeChange",
	        			    			async:false,
	        			    			data:{
	        			    				moduleId:moduleId,
	        			    				parentId:nodes[0]
	        			    			},
	        			    			type:"POST",
	        			        		contentType:"application/x-www-form-urlencoded",
	        			        		success:function(data){
        			        				ResourceManage.refreshTree();
	        			        			Hussar.success("转移成功!");
	        			        			layer.close(index);
	        			        		},
	        			        		error:function(){
	        			        			Hussar.error("转移失败!");	
	        			        		}
	        			    		})
	        			    	}
	        			    	Hussar.confirm("确定要转移吗?", saveTree);
			                    layer.close(index);
        	  					}
	        				 },
	        				success:function(index){
                                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
	        					$("#treeName").html("模块树");
	        					$.ajax({
		                            type: "POST",
		                            data:{
		                            	moduleId:moduleId,
		                            	isLeaf:"0"
		                            },
		                            contentType:"application/x-www-form-urlencoded",
		                            url: Hussar.ctxPath + "/resource/moduleChangeById",
		                            dataType:"json",
		                            async: false,
		                            success:function(result) {
	                            		ResourceManage.selectModuleId=moduleId;
	                            		var arrays = [];
	        	                        for(var i=0; i<result.length; i++){
	        	                        	var arr = {
	       	                        			 id	:	result[i].ID,
	       	                        			 code:   result[i].CODE,
	       	                        			 text : result[i].TEXT,
	       	                                     parent : result[i].PARENT,
	       	                                     isLeaf:result[i].ISLEAF,
	       	                                     type:result[i].TYPE,
	       	                                     isFun:result[i].ISFUN,
	       	                                     isRes:result[i].ISRES
	       	                        		}
	        	                        	arrays.push(arr);
	        	                        }
	        	                        result = arrays;
		                            	$("#moduleTreeChange").jstree(true).settings.core.data = result;
		                            	$("#moduleTreeChange").jstree(true).refresh();
		                            }

		                        });
	        				}
	        			});
                    }
                },
	            moduleSort: {
	                label: "下级排序",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	//选中模块名称
			        	var moduleName=clickedNode.text;
			        	//是否为根节点
			        	var length = clickedNode.parents.length;
			        	var isRoot;
			        	if(length>1){
			        		isRoot=false;
			        	}else{
			        		isRoot=true;
			        	}
			        	layer.open({
	        				type: 1,
	        				btn: ['取消', '保存'],
	        				skin: 'confirm-class',
	        				area: ['350px','500px'],
	        				fix: false, //不固定
	        				maxmin: false,
	        				shadeClose: false,
	        				shade: 0.4,
	        				title: "模块排序",
	        				content: $('#treeEditOrder'),
	        				btn2: function(index, layero){
	        					//确认按钮回调
	        					var saveTree =function(){
	        						$.ajax({
	        			    			url:Hussar.ctxPath + "/resource/moduleTreeOrder",
	        			    			async:false,
	        			    			data:{
	        			    				treeInfo:$("#output").val()
	        			    			},
	        			    			type:"POST",
	        			        		contentType:"application/x-www-form-urlencoded",
	        			        		success:function(data){
	        			        			ResourceManage.refreshTree();
	        			        			Hussar.success("保存成功!");
	        			        			layer.close(index);
	        			        		},
	        			        		error:function(){
	        			        			Hussar.error("保存失败!");	
	        			        		}
	        			    			
	        			    		})
	        			    	}
	        			    	Hussar.confirm("确定要保存排序吗?", saveTree);
			                    layer.close(index);
	        				 },
	        				success:function(){
                                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
	        					$.ajax({
		                            type: "POST",
		                            data:{
		                            	moduleId:moduleId,
		                            	isRoot:isRoot
		                            },
		                            contentType:"application/x-www-form-urlencoded",
		                            url:Hussar.ctxPath +  "/resource/moduleTreeById",
		                            dataType:"json",
		                            async: false,
		                            success:function(result) {
		                            	var arrays = [];
	        	                        for(var i=0; i<result.length; i++){
	        	                        	var arr = {
	       	                        			 id	:	result[i].ID,
	       	                        			 text : result[i].TEXT,
	       	                                     parent : result[i].PARENT,
	       	                                     isLeaf:result[i].ISLEAF,
	       	                                     type:result[i].TYPE,
	       	                                     seq:result[i].SEQ
	       	                        		}
	        	                        	arrays.push(arr);
	        	                        }
	        	                        result=arrays ;
		                            	$("#moduleTreeOrder").jstree(true).settings.core.data = result;
		                            	$("#moduleTreeOrder").jstree(true).refresh();
		                            	//返回值在页面显示
		                            	var newResult=[];
		                            	for(var i=0;i<result.length;i++){
		                            		if(result[i].parent!="#"){
		                            			newResult.push(result[i]);
		                            		}
		                            		
		                            	}
		                            	$("#output").val(window.JSON.stringify(newResult));
		                            }
	
		                        });
	        				}
	        			});
	                }
	            },
	            editFunction: {
	                label: "修改",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var functionId=clickedNode.id;
			        	//选中功能名称
			        	var functionName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/functionEdit?functionId=" + functionId)
	                }
	            },
	            changeFunction: {
                    label: "转移",
                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
                    action: function (obj) {
                    	//获取点击的节点信息
                    	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var functionId=clickedNode.id;
			        	layer.open({
	        				type: 1,
	        				btn: ['取消', '保存'],
	        				skin: 'confirm-class',
	        				area: ['350px','500px'],
	        				fix: false, //不固定
	        				maxmin: false,
	        				shadeClose: false,
	        				shade: 0.4,
	        				title: "模块选择",
	        				content: $('#functionTreeEditChange'),
	        				btn2: function(index, layero){
	        					//获取选中节点
        	  					var nodes = $("#functionTreeChange").jstree(true).get_checked();//使用get_checked方法
        	  					if(nodes.length==0){
        	  						Hussar.info("请先选择上级模块！");
        	  					}else{
	        					//确认按钮回调
	        					var saveTree =function(){
	        						
	        	  						$.ajax({
	        			    			url:Hussar.ctxPath + "/resource/functionTreeChange",
	        			    			async:false,
	        			    			data:{
	        			    				functionId:functionId,
	        			    				parentId:nodes[0]
	        			    			},
	        			    			type:"POST",
	        			        		contentType:"application/x-www-form-urlencoded",
	        			        		success:function(data){
        			        				ResourceManage.refreshTree();
	        			        			Hussar.success("转移成功!");
	        			        			layer.close(index);
	        			        		},
	        			        		error:function(){
	        			        			Hussar.error("转移失败!");	
	        			        		}
	        			    			
	        			    		})
	        	  					
	        			    		
	        			    	}
	        			    	Hussar.confirm("确定要转移吗?", saveTree);
        	  					
			                    layer.close(index);
        	  					}
	        				 },
	        				success:function(index){
                                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
	        					$("#treeName").html("模块树");
	        					$.ajax({
		                            type: "POST",
		                            data:{
		                            	functionId:functionId,
		                            	isLeaf:""
		                            },
		                            contentType:"application/x-www-form-urlencoded",
		                            url:Hussar.ctxPath +  "/resource/moduleChangeById",
		                            dataType:"json",
		                            async: false,
		                            success:function(result) {
		                            	if(result.length==1){
		                            		Hussar.info("无上级模块可转移！");
		                            	}else{
		                            		ResourceManage.selectFunctionId=functionId;
		                            		var arrays = [];
		        	                        for(var i=0; i<result.length; i++){
		        	                        	var arr = {
		       	                        			 id	:	result[i].ID,
		       	                        			 code:   result[i].CODE,
		       	                        			 text : result[i].TEXT,
		       	                                     parent : result[i].PARENT,
		       	                                     isLeaf:result[i].ISLEAF,
		       	                                     type:result[i].TYPE,
		       	                                     isFun:result[i].ISFUN,
		       	                                     isRes:result[i].ISRES
		       	                        		}
		        	                        	arrays.push(arr);
		        	                        }
		        	                        result=arrays ;
			                            	$("#functionTreeChange").jstree(true).settings.core.data = result;
			                            	$("#functionTreeChange").jstree(true).refresh();
		                            	}
		                            	
		                            }

		                        });
	        				}
	        			});
                    }
                },
	            functionSort: {
	                label: "下级排序",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	//选中模块名称
			        	var moduleName=clickedNode.text;
			        	//是否为根节点
			        	var length = clickedNode.parents.length;
			        	var isRoot;
			        	if(length>1){
			        		isRoot=false;
			        	}else{
			        		isRoot=true;
			        	}
			        	layer.open({
	        				type: 1,
	        				btn: ['取消','保存'],
	        				skin: 'confirm-class',
	        				area: ['350px','500px'],
	        				fix: false, //不固定
	        				maxmin: false,
	        				shadeClose: false,
	        				shade: 0.4,
	        				title: "功能排序",
	        				content: $('#treeEditOrder'),
	        				btn2: function(index, layero){
	        					//确认按钮回调
	        					var saveTree =function(){
	        						$.ajax({
	        			    			url:Hussar.ctxPath + "/resource/functionTreeOrder",
	        			    			async:false,
	        			    			data:{
	        			    				treeInfo:$("#output").val()
	        			    			},
	        			    			type:"POST",
	        			        		contentType:"application/x-www-form-urlencoded",
	        			        		success:function(data){
	        			        			ResourceManage.refreshTree();
	        			        			Hussar.success("保存成功!");
	        			        			layer.close(index);
	        			        		},
	        			        		error:function(){
	        			        			Hussar.error("保存失败!");	
	        			        		}
	        			    			
	        			    		})
	        			    	}
	        			    	Hussar.confirm("确定要保存排序吗?", saveTree);
			                    layer.close(index);
	        				 },
	        				success:function(){
                                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
	        					$.ajax({
		                            type: "POST",
		                            data:{
		                            	moduleId:moduleId,
		                            	moduleName:moduleName,
		                            	isRoot:isRoot
		                            },
		                            contentType:"application/x-www-form-urlencoded",
		                            url:Hussar.ctxPath +  "/resource/functionTreeById",
		                            dataType:"json",
		                            async: false,
		                            success:function(result) {
		                            	var arrays = [];
	        	                        for(var i=0; i<result.length; i++){
	        	                        	var arr = {
	        	                        			 id	:	result[i].ID,
		       	                        			 text : result[i].TEXT,
		       	                                     parent : result[i].PARENT,
		       	                                     isLeaf:result[i].ISLEAF,
		       	                                     type:result[i].TYPE,
		       	                                     seq:result[i].SEQ
	       	                        		}
	        	                        	arrays.push(arr);
	        	                        }
	        	                        result=arrays ;
		                            	$("#moduleTreeOrder").jstree(true).settings.core.data = result;
		                            	$("#moduleTreeOrder").jstree(true).refresh();
		                            	//返回值在页面显示
		                            	var newResult=[];
		                            	for(var i=0;i<result.length;i++){
		                            		if(result[i].parent!="#"){
		                            			newResult.push(result[i]);
		                            		}
		                            		
		                            	}
		                            	$("#output").val(window.JSON.stringify(newResult));
		                            }
	
		                        });
	        				}
	        			});
	                }
	            },
	            view: {
	                label: "查看",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/55.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中模块ID
			        	var moduleId=clickedNode.id;
			        	//选中模块名称
			        	var moduleName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/moduleView?moduleId=" + moduleId)
	                }
	            },
	            delete: {
	                label: "删除",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中组织ID
			        	var moduleId=clickedNode.id;
	                	var delOrg =function(){
	                		$.ajax({
	                			url:Hussar.ctxPath + "/resource/delModule",
	                			async:false,
	                			data:{
	                				moduleId:moduleId
	                			},
	                			type:"POST",
	                    		contentType:"application/x-www-form-urlencoded",
	                    		dataType:"json",
	                    		success:function(data){
	                    			if(data.success==true){
	                    				ResourceManage.refreshTree();
	                        			Hussar.success("删除成功！");
	                    			}else{
	                    				Hussar.error("删除失败！（存在下级模块或下级功能！）");	
	                    			}
	                    		},
	                    		error:function(){
	                    			Hussar.error("删除失败！");	
	                    		}
	                			
	                		})
	                	}
	                	Hussar.confirm("确定要删除吗？", delOrg);
	                }
	            },
	            editResource: {
	                label: "修改",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var resourceId=clickedNode.id;
			        	//选中功能名称
			        	var resourceName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	$("#moduleFrame").attr("src",Hussar.ctxPath + "/resource/resourceEdit?resourceId=" + resourceId)
	                }
	            },
	            changeResource: {
                    label: "转移",
                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
                    action: function (obj) {
                    	//获取点击的节点信息
                    	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中资源ID
			        	var resourceId=clickedNode.id;
			        	layer.open({
	        				type: 1,
	        				btn: ['取消','保存'],
	        				skin: 'confirm-class',
	        				area: ['350px','500px'],
	        				fix: false, //不固定
	        				maxmin: false,
	        				shadeClose: false,
	        				shade: 0.4,
	        				title: "功能选择",
	        				content: $('#resourceTreeEditChange'),
	        				btn2: function(index, layero){
	        					//获取选中节点
        	  					var nodes = $("#resourceTreeChange").jstree(true).get_checked();//使用get_checked方法
        	  					if(nodes.length==0){
        	  						Hussar.info("请先选择上级模块！");
        	  					}else{
	        					//确认按钮回调
	        					var saveTree =function(){
	        						
	        	  						$.ajax({
	        			    			url:Hussar.ctxPath + "/resource/resourceTreeChange",
	        			    			async:false,
	        			    			data:{
	        			    				resourceId:resourceId,
	        			    				parentId:nodes[0]
	        			    			},
	        			    			type:"POST",
	        			        		contentType:"application/x-www-form-urlencoded",
	        			        		success:function(data){
        			        				ResourceManage.refreshTree();
	        			        			Hussar.success("转移成功！");
	        			        			layer.close(index);
	        			        		},
	        			        		error:function(){
	        			        			Hussar.error("转移失败！");	
	        			        		}
	        			    			
	        			    		})
	        	  					
	        			    		
	        			    	}
	        			    	Hussar.confirm("确定要转移吗？", saveTree);
        	  					
			                    layer.close(index);
        	  					}
	        				 },
	        				success:function(index){
                                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
	        					$.ajax({
		                            type: "POST",
		                            data:{
		                            	resourceId:resourceId
		                            },
		                            contentType:"application/x-www-form-urlencoded",
		                            url:Hussar.ctxPath +  "/resource/resourceChangeById",
		                            dataType:"json",
		                            async: false,
		                            success:function(result) {
		                            	if(result.length==1){
		                            		Hussar.info("无上级模块可转移！");
		                            	}else{
		                            		var arrays = [];
		        	                        for(var i=0; i<result.length; i++){
		        	                        	var arr = {
		       	                        			 id	:	result[i].ID,
		       	                        			 code:   result[i].CODE,
		       	                        			 text : result[i].TEXT,
		       	                                     parent : result[i].PARENT,
		       	                                     isLeaf:result[i].ISLEAF,
		       	                                     type:result[i].TYPE,
		       	                                     isFun:result[i].ISFUN,
		       	                                     isRes:result[i].ISRES
		       	                        		}
		        	                        	arrays.push(arr);
		        	                        }
		        	                        result=arrays ;
			                            	$("#resourceTreeChange").jstree(true).settings.core.data = result;
			                            	$("#resourceTreeChange").jstree(true).refresh();
		                            	}
		                            	
		                            }

		                        });
	        				}
	        			});
                    }
                },
	            resourceSort: {
	                label: "下级排序",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var functionId=clickedNode.id;
			        	//选中功能名称
			        	var functionName=clickedNode.text;
			        	//是否为根节点
			        	var length = clickedNode.parents.length;
			        	var isRoot;
			        	if(length>1){
			        		isRoot=false;
			        	}else{
			        		isRoot=true;
			        	}
			        	layer.open({
	        				type: 1,
	        				btn: [ '取消','保存'],
	        				skin: 'confirm-class',
	        				area: ['350px','500px'],
	        				fix: false, //不固定
	        				maxmin: false,
	        				shadeClose: false,
	        				shade: 0.4,
	        				title: "资源排序",
	        				content: $('#treeEditOrder'),
	        				btn2: function(index, layero){
	        					//确认按钮回调
	        					var saveTree =function(){
	        						$.ajax({
	        			    			url:Hussar.ctxPath + "/resource/resourceTreeOrder",
	        			    			async:false,
	        			    			data:{
	        			    				treeInfo:$("#output").val()
	        			    			},
	        			    			type:"POST",
	        			        		contentType:"application/x-www-form-urlencoded",
	        			        		success:function(data){
	        			        			ResourceManage.refreshTree();
	        			        			Hussar.success("保存成功！");
	        			        			layer.close(index);
	        			        		},
	        			        		error:function(){
	        			        			Hussar.error("保存失败！");	
	        			        		}
	        			    			
	        			    		})
	        			    	}
	        			    	Hussar.confirm("确定要保存排序吗？", saveTree);
			                    layer.close(index);
	        				 },
	        				success:function(){
                                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
	        					$.ajax({
		                            type: "POST",
		                            data:{
		                            	functionId:functionId,
		                            	functionName:functionName,
		                            	isRoot:isRoot
		                            },
		                            contentType:"application/x-www-form-urlencoded",
		                            url:Hussar.ctxPath +  "/resource/resourceTreeById",
		                            dataType:"json",
		                            async: false,
		                            success:function(result) {
		                            	var arrays = [];
	        	                        for(var i=0; i<result.length; i++){
	        	                        	var arr = {
	        	                        			 id	:	result[i].ID,
		       	                        			 text : result[i].TEXT,
		       	                                     parent : result[i].PARENT,
		       	                                     isLeaf:result[i].ISLEAF,
		       	                                     type:result[i].TYPE,
		       	                                     seq:result[i].SEQ
	       	                        		}
	        	                        	arrays.push(arr);
	        	                        }
	        	                        result=arrays ;
		                            	$("#moduleTreeOrder").jstree(true).settings.core.data = result;
		                            	$("#moduleTreeOrder").jstree(true).refresh();
		                            	//返回值在页面显示
		                            	var newResult=[];
		                            	for(var i=0;i<result.length;i++){
		                            		if(result[i].parent!="#"){
		                            			newResult.push(result[i]);
		                            		}
		                            		
		                            	}
		                            	$("#output").val(window.JSON.stringify(newResult));
		                            }
	
		                        });
	        				}
	        			});
	                }
	            },
	            delFunction: {
	                label: "删除",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var functionId=clickedNode.id;
			        	//选中功能名称
			        	var functionName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	var delFunction =function(){
	                		$.ajax({
	                			url:Hussar.ctxPath + "/resource/delFunction",
	                			async:false,
	                			data:{
	                				functionId:functionId
	                			},
	                			type:"POST",
	                    		contentType:"application/x-www-form-urlencoded",
	                    		dataType:"json",
	                    		success:function(data){
	                    			if(data.success==true){
	                    				ResourceManage.refreshTree();
	                        			Hussar.success("删除成功！");
	                    			}else{
	                    				Hussar.error("删除失败！（存在下级资源！）");	
	                    			}
	                    		},
	                    		error:function(){
	                    			Hussar.error("删除失败！");	
	                    		}
	                			
	                		})
	                	}
	                	Hussar.confirm("确定要删除吗？", delFunction);
	                }
	            },
	            delResource: {
	                label: "删除",
	                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                action: function (obj) {
	                	//获取点击的节点信息
	                	var inst = $.jstree.reference(obj.reference);
						var clickedNode = inst.get_node(obj.reference);
			        	//选中功能ID
			        	var resourceId=clickedNode.id;
			        	//选中功能名称
			        	var resourceName=clickedNode.text;
			        	//选中模块是否为根节点
			        	var isLeaf = clickedNode.original.isLeaf;
			        	//获取子节点数量
			        	var childNum = clickedNode.children.length;
			        	var delResource =function(){
	                		$.ajax({
	                			url:Hussar.ctxPath + "/resource/delResource",
	                			async:false,
	                			data:{
	                				resourceId:resourceId
	                			},
	                			type:"POST",
	                    		contentType:"application/x-www-form-urlencoded",
	                    		dataType:"json",
	                    		success:function(data){
	                    			if(data.success==true){
	                    				ResourceManage.refreshTree();
	                        			Hussar.success("删除成功！");
	                    			}else{
	                    				Hussar.error("删除失败！（该资源已关联角色！）");	
	                    			}
	                    		},
	                    		error:function(){
	                    			Hussar.error("删除失败！");	
	                    		}
	                			
	                		})
	                	}
	                	Hussar.confirm("确定要删除吗？", delResource);
	                }
	            }
	       };
		   var length = node.parents.length;
	       var isLeaf = node.original.isLeaf;
	       var isFun = node.original.isFun;
	       var isRes = node.original.isRes;
	       var child = node.children;
           if(child.length==0){
        	delete items.moduleSort;  //删除节点 下级模块排序 
           	delete items.functionSort;  //删除节点 下级功能排序 
           	delete items.resourceSort;  //删除节点 下级资源排序
           }
	       //判断是否为末级节点
	       if(isLeaf==0){
	    	   delete items.view;
	    	   delete items.addFunction;
	    	   delete items.functionSort;  //删除节点 下级功能排序 
	       }else{
	    	  delete items.add;  //删除节点 增加下级 
	          delete items.moduleSort;  //删除节点 下级模块排序 
	          delete items.resourceSort;  //删除节点 下级资源排序  
	          delete items.view;  
	       }
	       //判断是否为功能
	       if(isFun==1){
	    	   delete items.addFunction;
	    	   delete items.add;  //删除节点 增加下级 
	           delete items.moduleSort;  //删除节点 下级模块排序
	           delete items.functionSort;  //删除节点 下级功能排序  
	           delete items.view;
	           delete items.delete;
	           delete items.edit;
	           delete items.changeModule; //删除节点  转移模块
	       }else{
	    	   delete items.delFunction;
	    	   delete items.addResource;
	    	   delete items.editFunction;
	    	   delete items.changeFunction;//删除节点 转移功能
	    	   delete items.resourceSort;  //删除节点 下级资源排序
	       }
	       //判断是否为资源
	       if(isRes==1){
	    	   delete items.add;  //删除节点 增加下级 
	           delete items.moduleSort;  //删除节点 下级模块排序
	           delete items.functionSort;  //删除节点 下级功能排序  
	           delete items.resourceSort;  //删除节点 下级资源排序  
	           delete items.delete;
	           delete items.edit;
	           delete items.changeModule; //删除节点  转移模块
	           delete items.changeFunction;//删除节点 转移功能
	       }else{
	    	   delete items.editResource;
	    	   delete items.delResource;
	    	   delete items.changeResource;//删除节点 转移资源
	       }
	       //判断是否为根节点
	       if(length==1){
	    	   delete items.edit;
	    	   delete items.delete;
	    	   delete items.view;
	    	   delete items.addFunction;
	    	   delete items.functionSort;  //删除节点 下级功能排序  
	           delete items.resourceSort;  //删除节点 下级资源排序
	           delete items.changeModule; //删除节点  转移模块
	           delete items.changeFunction;//删除节点 转移功能
	       }
		return items; 
	}
	/*排序*/
	ResourceManage.up=function(x,y){
		return x.seq-y.seq
	}
	ResourceManage.initFrameHeight=function(){
		var h = $(window).height()-10;
		$("#moduleFrame").css("height", h + "px");
		$("#treeArea").css("height", h-51 + "px");
		
	}
	/*初始化点击事件*/
	ResourceManage.initButtonEvent = function(){
		
	}

	/*初始化树查询*/
    ResourceManage.initTreeSearch = function () {
        var to = false;
        //资源树查询
        $("#resTreeSearch").keyup(function () {
            if (to) { clearTimeout(to); }
            to = setTimeout(function () {
                var v = $("#resTreeSearch").val();
                var temp = $("#resTree").is(":hidden");
                if (temp == true) {
                    $("#resTree").show();
                }
                $("#resTree").jstree(true).search(v);
                //添加索引
                if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                }else {
                    $(".search-results").html("");
                }

            }, 250);
        });
    }
	
	$(function () {
		ResourceManage.initPage();
        var h = $(window).height();
        $(".con-full").css("height", h + "px");
		$(window).resize(function() {
			ResourceManage.initFrameHeight();
		});
	});
});