/**
 * @Description: 定义登陆页面脚本文件
 * @Author: liangdong
 * @Date: 2018/3/14.
 */

layui.use(['jquery','layer','Hussar','HussarAjax','form'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	
	var Login = {		    
		    layerIndex: -1,		   
		};
	
	Login.initButtonEvent = function () {
		$("#login").click(function(){
			var username = $("input[name='username']").val().trim();	
			var cipher = $("input[name='cipher']").val().trim();				
			if (username == "") {
				$(".error").html("用户名不能为空");
                $("input[name='username']").addClass("errorTip");
			} else if (cipher == "") {
				$(".error").html("密码不能为空");
                $("input[name='cipher']").addClass("errorTip");
			} else {
                $(".login-form input").removeClass("errorTip");
				Login.login();
			}
		});

        $(".login-form input").blur(function(){
            var loginVal = $(this).val().trim();

            if (loginVal != "") {
                $(this).removeClass("errorTip");
            } else {
                $(this).addClass("errorTip");
            }
        });
	}
	
	Login.login = function () {				
		var cipher = $("input[name='cipher']").val();		
		var params = encode64(cipher);	
		$("input[name='cipher']").val(params);
		$("#login").attr("disabled",true);	//防止多次提交	
		var data = $("#tokenForm").serialize();
		var ajax = new $ax(Hussar.ctxPath + "/login", function(data) {
			if (data.code == 200) {
				window.location.href = window.location.origin +"/"+Hussar.ctxPath;
			}	
		}, function(data) {			
			$(".error").html(data.responseJSON.result);
			$("#login").attr("disabled",false);
		});
		ajax.setData(data);
		ajax.start();

	}			
	

	$(function () { 
		Login.initButtonEvent();	//	初始化按钮事件	
		//Enter触发登录按钮事件
		$(document).keyup(function(event){
            if(event.keyCode ==13){
                $("#login").click();
            }
        });
	});	
	
});




