layui.use(['jquery','Hussar','HussarAjax','form'], function(){
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var $ax = layui.HussarAjax;
    var form = layui.form;

    form.verify({
        specials: function(value) {
            if (!new RegExp("^[a-zA-Z0-9_\u4e00-\u9fa5\\s·]+$").test(value)) {
                return '输入项不能有特殊字符！';
            }
        }
    });

    var SingleDict = {
        layerIndex: -1,
        dictId: "", //若id存在，则为修改，否则为新增
        dictTypeId: "" //新增所用的字典类别id
    };

    SingleDict.initButtonEvent = function () {
        $("#btnSave").click(function(){
            form.on('submit(saveDictSingle)', function(data){
                SingleDict.save();
            });
        });
        $("#btnClose").click(function(){
            SingleDict.closeWin(false);
        });
    };

    SingleDict.closeWin = function (isRefresh) {//关闭弹出窗口
        var index = window.parent.layer.getFrameIndex(window.name);
        if(isRefresh) window.parent.Dict.refreshTreeAndTable();
        window.parent.layer.close(index);
    };

    SingleDict.save = function () {
        var operation = !($("#hiddenDictId").val())?'add':'update';
        $("#dictName").val(function(index,oldvalue){ return oldvalue.trim(); });
        $("#dictValue").val(function(index,oldvalue){ return oldvalue.trim(); });
        var data = $("#singleDictForm").serialize();
        console.log("SINGLE DICT SAVE", data);
        // 提交信息
        var ajax = new $ax(Hussar.ctxPath + "/sys/dic/" + operation + "_single", function(data) {
            data = data || {};
            if (data.code == "200") {
                parent.layui.Hussar.success("保存成功！");
                SingleDict.closeWin(true);
            } else {
                Hussar.error("保存失败！（" + (data.message || '未知错误') + "）");
            }
        }, function(data) {
            Hussar.error("保存失败！（" + (data.responseJSON.message || '未知错误') + "）");
        });
        ajax.setData(data);
        ajax.start();
    };

    $(function () {
        SingleDict.dictId = $("#dictId").val();
        SingleDict.dictTypeId = $("#dictTypeId").val();
        SingleDict.initButtonEvent();
    });

});




