var OrganType = {
    id : "typeTable", // 表格id
    seItem : null, // 选中的条目
    table : null,
    layerIndex : -1
};
/**
 * 加载列表
 */




layui.use(['layer', 'table', 'HussarAjax', 'Hussar','laydate'], function() {

    var layer = layui.layer
        , table = layui.table
        , $ = layui.jquery
        , $ax = layui.HussarAjax
        ,laydate = layui.laydate
        , Hussar = layui.Hussar;

	var ts = laydate.render({
	   	elem: '#startDate',
        type : 'datetime',
        done: function (value,date) {	
       	 if (value !== '') {
       		 te.config.min.year = date.year;
	        	 te.config.min.month = date.month - 1;
	        	 te.config.min.date = date.date;
	        	 te.config.min.hours = date.hours;
	        	 te.config.min.minutes = date.minutes;
	        	 te.config.min.seconds = date.seconds;
       	 } else {
       		 te.config.min.year = '';
	        	 te.config.min.month = '';
	        	 te.config.min.date = '';
	        	 te.config.min.hours = '';
	        	 te.config.min.minutes = '';
	        	 te.config.min.seconds = '';
       	 }
       	 	        	 
        }
	});
	var te = laydate.render({
	   	 elem: '#endDate',
	     type : 'datetime',              
	     done: function (value,date) {			    	 
	    	 if (value !== '') {
	    		 ts.config.max.year = date.year;
	        	 ts.config.max.month = date.month - 1;
	        	 ts.config.max.date = date.date;
	        	 ts.config.max.hours = date.hours;
	        	 ts.config.max.minutes = date.minutes;
	        	 ts.config.max.seconds = date.seconds;
	    	 } else {
	    		 ts.config.max.year = '2099';
	        	 ts.config.max.month = '11';
	        	 ts.config.max.date = '31';
	        	 ts.config.max.hours = '0';
	        	 ts.config.max.minutes = '0';
	        	 ts.config.max.seconds = '0';
	    	 }
	    	 	 
	     }
	});
	
    /**
     * 初始化表格的列
     */
    OrganType.initColumn = function () {
        return {
            elem: '#typeTable'
            ,url:Hussar.ctxPath+'/attachment/getAttachmentList'
            ,request: {
                pageName: 'curr' //页码的参数名称，默认：page
                ,limitName: 'nums' //每页数据量的参数名，默认：limit
            },
            method:"post",
            height:$("body").height() - $(".layui-form").outerHeight(true)-26,
            cols: [[
                {type:'checkbox', width:40},
                {title: '序号',type : 'numbers',width:50},
                {title: '附件名称', field: 'ATTACHMENT_NAME',event: 'detailEvent',templet : function(d){
                	var type=d.ATTACHMENT_TYPE.toUpperCase();
    	            if(type=="BMP"||type=="JPG"||type=="JPEG"||type=="PNG"||type=="GIF"||type=="PCD"||type=="PSD"||type=="DXF"){
    	            	return "<a style='color:#00a4ff;cursor: pointer'>"+d.ATTACHMENT_NAME+"</a>"
    	            }else{
    	            	return d.ATTACHMENT_NAME;
    	            }
    				
                }},
                {title: '附件路径', field: 'ATTACHMENT_DIR'},
                {title: '附件类型', field: 'ATTACHMENT_TYPE',width:100},
                {title: '上传者', field: 'UPLOAD_PER'},
                {title: '上传时间', field: 'UPLOAD_DATE',sort:true}
            ]]
            ,page: true
        }
    };

/*
 * 检测是否选中
 */
	OrganType.check = function(){
		var flag = false;
		var selected = table.checkStatus('typeTable').data;
		if (selected && selected.length > 0) {
			OrganType.seItem = selected;
			flag = true;
		} else {
			Hussar.info("请先选中表格中的某一记录！");
		}
		return flag;
	};
	/*
	 * 删除操作
	 */
	OrganType.delete = function () {
		var nameArr = [];
		if (OrganType.check()) {
			var idArr = [];
			OrganType.seItem.forEach(function (v) {
				idArr.push(v.id);
				nameArr.push(v.ATTACHMENT_NAME);
	        });
			var operation = function () {
				var ajax = new $ax(Hussar.ctxPath+"/attachment/delete", function () {
						layer.msg("删除成功!");
						table.reload('typeTable');
					}, function (data) {
						layer.msg("删除成功!");
						table.reload('typeTable');
					});
				ajax.set("fileId",JSON.stringify(idArr));
				ajax.set("attachmentName",JSON.stringify(nameArr));
				ajax.start();
			};
	
			layer.confirm("是否删除字段 " + nameArr.join('、') + "?", { icon: 3, title:'提示'}, operation);
		}
	};
	
	/*
	 * 附件下载
	 */
	
	OrganType.download = function () {
		var nameArr = [];
		if (OrganType.check()) {
			var idArr = [];
			OrganType.seItem.forEach(function (v) {
				idArr.push(v.ID);
				nameArr.push(v.ATTACHMENT_NAME);
	        });
			if(idArr.length==1){
				location.href=window.location.origin +"/"+Hussar.ctxPath+"/attachment/fileDownload/?fileId="+idArr.toString();
			}
			else{
				location.href=window.location.origin +"/"+Hussar.ctxPath+"/attachment/BatchDownload/?fileId="+idArr.toString();
			}
		}	
			
	};
	
	/*
	 * 查询
	 */
	
	OrganType.search = function () {
	    layui.use(['table'], function() {
	        var table = layui.table
	        , $ = layui.jquery;
	        var attachment_name = $("#attachment_name").val();
	        var dateStart = $("#startDate").val();
			var dateEnd = $("#endDate").val();
	        table.reload('typeTable', {page: {curr: 1},where:{
	        	attachmentName: attachment_name,
	        	dateStart : dateStart,
				dateEnd : dateEnd
	        }});
	    });
	};
	
	
	
	/**
	 * 初始化
	 */
	$(function () {
	    
	    	$('#typeTable').attr('lay-even', true);
	        var table = layui.table;
	        table.render(OrganType.initColumn());

	        table.on('tool(attachment)', function(obj){ //注：tool是工具条事件名，test是table原始容器的属性 lay-filter="对应的值"
	            var data = obj.data //获得当前行数据
	            var type=data.ATTACHMENT_TYPE.toUpperCase();
	            if(type=="BMP"||type=="JPG"||type=="JPEG"||type=="PNG"||type=="GIF"||type=="PCD"||type=="PSD"||type=="DXF"){
	            	if(obj.event == 'detailEvent') {
		                var img = "<img src=\""+Hussar.ctxPath+"/attachment/showPicture?image="+data.ID+"\" height=\"100%\"/>";
		                layer.open({
		                    type: 1,
		                    title: false, //不显示标题
		                    area: ['80%', '80%'],
		                    content: img, //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响
		            });
		            }
	            }
	        });
	   
	});
});