/**
 * @Description: 接口管理脚本文件
 * @Author: chenxin
 * @Date: 2018/3/7.
 */

/**
 * 用户角色初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','table'], function(){
	
var Hussar = layui.Hussar;
var $ = layui.jquery;
var layer=layui.layer;
var $ax=layui.HussarAjax;
var form=layui.form;
var table = layui.table;
var layerView;

var IdtableManage = {
	seItem : null
};

/**
 * 页面初始化
 */
IdtableManage.initPage = function () {
	this.initTable();
	this.initButton();
}

/**
 * 加载列表
 */
IdtableManage.initTable = function() {
		table.render({
			elem : '#idtableTable',
			url : Hussar.ctxPath+'/idtable/list',
			cols : [ [
			          {type: 'checkbox'} ,
			          {title : '序号', type : 'numbers', align : 'center',width:40},
			          {title : '业务中文名称', field: 'idDesc', align : 'center'},
			          {title : '业务名称', field: 'fieldName', align : 'center', event: 'detailEvent', style:'cursor: pointer;color:#00a4ff'},
			          {title : '业务表名', field: 'tableName', align : 'center'},
			          {title : '当前编号', field: 'idValue', align : 'center'},
			          {title : '递增值', field: 'cacheSize', align : 'center'},
			          {title : '编号长度', field: 'idLength', align : 'center'}
			          
			          ] ],
			page : true,
			even: true,
			id : 'tableReload',
            height:$("body").height() - $(".layui-form").outerHeight(true)-30
		});
};

/**
 * 选中一条结果
 */
IdtableManage.check = function() {
	var checkStatus = table.checkStatus('tableReload'), data = checkStatus.data;
	if (data.length == 0 || data.length > 1) {
        Hussar.info("请选择一条记录！");
		return false;
	} else {
		IdtableManage.seItem = data[0];
		return true;
	}
};

/**
 * 选中多条结果
 */
IdtableManage.checks = function() {
	var checkStatus = table.checkStatus('tableReload'), data = checkStatus.data;
	var ids = [];
	if (data.length == 0) {
		Hussar.info("请至少选择一条记录！");
		return false;
	} else {
		for (var i = 0, l = data.length; i < l; i++) {
			var r = data[i];
			ids.push(r.idId);
		}
		var eId = ids.join(',');
		IdtableManage.seItem = eId;
		return true;
	}
};

/**
 * 按钮操作
 */
IdtableManage.initButton = function () {
	
	/**
	 * 查询
	 */
	$('#search').on('click', function() {
		var serIdDesc = $('#serIdDesc').val();
		var serFieldName = $('#serFieldName').val();
		var serTableName = $('#serTableName').val();
		// 执行重载
		table.reload('tableReload', {
			page : {
				curr : 1
			// 重新从第 1 页开始
			},
			where : {
				serIdDesc : serIdDesc,
				serFieldName:serFieldName,
				serTableName:serTableName
			}
		});
	});
	
	/**
	 * 新增
	 */
	$("#add").click(function(){
		$("#status").val("add");
		$("#idValue").val("");
		$("#idId").val("");
		layerView=layer.open({
			type : 1,
			title: '最大号表新增',
			area : [ '850px', '400px' ],
			//shift : 6,
			shadeClose : false,
			maxmin : false,
			content : $("#viewEvent"),
			success : function() {
				$('#addForm')[0].reset();
				$("#fieldName").removeAttr("disabled");
				$("#tableName").removeAttr("disabled");
				$("#idSuffix").attr("disabled","disabled");
				$("#idPrefix").attr("disabled","disabled");
				form.render();
			}
		});
	});
	
	/**
	 * 修改
	 */
	$("#edit").click(function(){
		if (IdtableManage.check()) {
			$("#status").val("edit");
			$("#idValue").val(IdtableManage.seItem.idValue);
			$("#idId").val(IdtableManage.seItem.idId);
			layerView=layer.open({
				type : 1,
				title: '最大号表修改',
				area : [ '850px', '400px' ],
				//shift : 6,
				shadeClose: false,
				maxmin : false,
				content : $("#viewEvent"),
				success : function() {
					$("#fieldName").attr("disabled","disabled");
					$("#tableName").attr("disabled","disabled");
					$("input[name='fieldName']").val(IdtableManage.seItem.fieldName);
					$("#tableName").val(IdtableManage.seItem.tableName.toUpperCase());
					$("input[name='idDesc']").val(IdtableManage.seItem.idDesc);
					$("input[name='cacheSize']").val(IdtableManage.seItem.cacheSize);
					$("input[name='idLength']").val(IdtableManage.seItem.idLength);
					$("input[name='idPrefix']").val(IdtableManage.seItem.idPrefix);
					$("input[name='idSuffix']").val(IdtableManage.seItem.idSuffix);
					var isPrefix = $("input[name='isPrefix']");
        			for(var i=0; i<isPrefix.length; i++){
        				if(isPrefix[i].value == IdtableManage.seItem.isPrefix){
        					isPrefix[i].checked = true;
        				}
        			}
        			if(IdtableManage.seItem.isPrefix=="0"){
        				$("#idPrefix").attr("disabled","disabled");
        				$("#idPrefix").removeAttr("lay-verify");
        			}else{
        				$("#idPrefix").removeAttr("disabled");
        				$("#idPrefix").attr("lay-verify","required");
        			}
        			var isSuffix = $("input[name='isSuffix']");
        			for(var i=0; i<isSuffix.length; i++){
        				if(isSuffix[i].value == IdtableManage.seItem.isSuffix){
        					isSuffix[i].checked = true;
        				}
        			}
        			if(IdtableManage.seItem.isSuffix=="0"){
        				$("#idSuffix").attr("disabled","disabled");
        				$("#idSuffix").removeAttr("lay-verify");
        			}else{
        				$("#idSuffix").removeAttr("disabled");
        				$("#idSuffix").attr("lay-verify","required");
        			}
        			var isGlobal = $("input[name='isGlobal']");
        			for(var i=0; i<isGlobal.length; i++){
        				if(isGlobal[i].value == IdtableManage.seItem.isGlobal){
        					isGlobal[i].checked = true;
        				}
        			}
					form.render();
				}
			});
		}
	});
	// 监听单元格事件
	table.on('tool(tableList)', function(obj) {
		var data = obj.data;
		if (obj.event == 'detailEvent') {
			layer.open({
				type : 1,
				title: '最大号表明细',
				area : [ '450px', '500px' ],				
				shadeClose: false,
				maxmin : false,
				content : $("#viewEventDetail"),
				success : function() {
					$('#viewForm')[0].reset();										
					$('#fieldNameDetail').html(data.fieldName);
					$('#tableNameDetail').html(data.tableName);
					$('#idValueDetail').html(data.idValue);
					$('#idDescDetail').html(data.idDesc);
					$('#cacheSizeDetail').html(data.cacheSize);
					$('#idLengthDetail').html(data.idLength);
					$('#idPrefixDetail').html(data.idPrefix);
					$('#idSuffixDetail').html(data.idSuffix);
					if(data.isPrefix==0){
						$('#isPrefixDetail').html("否");
						$("#prefixDivDetail").attr("style","display:none;");
						
					}else{
						$('#isPrefixDetail').html("是");
						$("#prefixDivDetail").removeAttr("style");
						
					}
					if(data.isSuffix==0){
						$('#isSuffixDetail').html("否");
						$("#suffixDivDetail").attr("style","display:none;");
					}else{
						$('#isSuffixDetail').html("是");
						$("#suffixDivDetail").removeAttr("style");
					}
					if(data.isGlobal==0){
						$('#isGlobalDetail').html("否");
					}else{
						$('#isGlobalDetail').html("是");
					}
				}
			});
		}
	});
	/**
	 * 删除
	 */
	$("#del").click(function() {
		if (IdtableManage.checks()) {
			var operation =function(){
				var ajax = new $ax(Hussar.ctxPath + "/idtable/delByIds",
						function() {
								// 执行重载
								table.reload('tableReload', {
									page : {
										curr : 1
									// 重新从第 1 页开始
									}
								});
								Hussar.success("删除成功!");
							}, function(data) {
								Hussar.error("删除失败!");
						});
						ajax.set("id", IdtableManage.seItem);
						ajax.start();
						};
			Hussar.confirm("确定要删除吗 ?", operation);
			//layer.confirm("确定要删除吗 ?", {title:'提示'}, operation);//{icon: 3, title:'提示'}
			}
		});
	
	/**
	 * 保存
	 */
	$("#btnSave").click(function(){
		form.on('submit(verify)', function(data){
			var data = data.field;
			var idValue = $("#idValue").val();
			var idLength =$("#idLength").val();
			var cacheSize = $("#cacheSize").val();
			if(idLength>6||idLength<1){
				Hussar.valid("编号长度必须介于1-6之间！");
				return false;
			}
			if(cacheSize>9||cacheSize<1){
				Hussar.valid("递增值必须介于1-9之间！");
				return false;
			}
		    // 提交信息
			var type=$("#status").val();
			var url;
			if(type=="add"){
				url="/idtable/addSave";
			}else{
				url="/idtable/editSave";
				//判断当前编号长度是否大于等于设置长度
				if(idLength<idValue.length){
					Hussar.valid("编号长度不可以小于当前编号长度！");
					return false;
				}
			}
		    var ajax = new $ax(Hussar.ctxPath + url, function(data) {
		    	if(data=='ERROR'){
		    		Hussar.valid('业务名称和业务表名已存在！');
		    		return false;
		    	}
		    	Hussar.success("保存成功");
		        layer.close(layerView);
		        $('#searchForm')[0].reset();
		        $('#addForm')[0].reset();
		        // 执行重载
				table.reload('tableReload', {
					page : {
						curr : 1
					// 重新从第 1 页开始
					}
				});
		    }, function(data) {
		        Hussar.error("保存失败!");
		    });
		    ajax.setData(data);
		    ajax.start();
		});
	});
	
	/**
	 * 关闭
	 */
	$("#btnClose").click(function(){
		layer.close(layerView);
	})
	
	/**
	 * 是否有前缀按钮点击事件
	 */
	form.on('radio(isPrefix)', function(data){
		if(data.value=="0"){
			$("#idPrefix").attr("disabled","disabled");
			$("#idPrefix").removeAttr("lay-verify");
			$("#idPrefix").val("");
		}else{
			$("#idPrefix").removeAttr("disabled");
			$("#idPrefix").attr("lay-verify","required");
			$("#idPrefix").val("");
		}
	});
	
	/**
	 * 是否有后缀按钮点击事件
	 */
	form.on('radio(isSuffix)', function(data){
		if(data.value=="0"){
			$("#idSuffix").attr("disabled","disabled");
			$("#idSuffix").removeAttr("lay-verify");
			$("#idSuffix").val("");
		}else{
			$("#idSuffix").removeAttr("disabled");
			$("#idSuffix").attr("lay-verify","required");
			$("#idSuffix").val("");
		}
	}); 


}


/**
 * 初始化
 */
$(function() {
	IdtableManage.initPage();
});
});