/**
 * @Description: 定义组织机构规则脚本文件
 * @Author: liangdong
 * @Date: 2018/2/27.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	
	/**
	 * 组织机构规则的单例
	 */
	var SysOrgRule = {
	    id: "ruleTable",	//表格id
	    seItem: null,		//选中的条目
	    table: null,
	    layerIndex: -1
	};

	/**
	 * 搜索组织机构规则
	 */
	SysOrgRule.search = function () {    
		var parentType = $('#parentType').val();
	    var lowerType = $('#lowerType').val();
	    layui.use(['table'], function() {
	        var table = layui.table;
	        table.reload('ruleTable', {page: {curr: 1},where:{
	        	parentType : parentType,
				lowerType : lowerType
	        }});
	    });	 
	}

	layui.use(['layer', 'table'], function() {
		var layer = layui.layer
	    , table = layui.table;
		
		/**
		 * 检查是否选中一条记录
		 */
		SysOrgRule.check = function () {
			var flag = false;
		    var selected = table.checkStatus('ruleTable').data;
		    if (selected && selected.length == 1) {
		    	SysOrgRule.seItem = selected;
		        flag = true;
		    } else {		
                Hussar.info("请选择一条记录！");
		    }
		    return flag;
		}
		
		/**
		 * 检查是否选中多条记录
		 */
		SysOrgRule.checkIds = function() {
			var selected = table.checkStatus('ruleTable').data;
			var ids = [];
			if (selected.length == 0) {
				Hussar.info("请至少选择一条记录！");
				return false;
			} else {
				for (var i = 0, l = selected.length; i < l; i++) {
					var r = selected[i];
					ids.push(r.RULEID);
				}
				var eId = ids.join(',');
				SysOrgRule.seItem = eId;
				return true;
			}
		};
	});

	/**
	 * 新增组织机构规则
	 */
	SysOrgRule.add = function () {    
	    $("#status").val("add");
	    SysOrgRule.layerIndex = layer.open({
	        type: 1,
	        title: '组织规则新增',
	        area: ['685px', '300px'], //宽高
	        fix: false, //不固定
	        maxmin: false,
	        shadeClose: false,
	        content: $('#addEvent'),
	        success:function(){
	            //重置form
	        	$('#ruleForm')[0].reset();
	            $("#parentOrg2").attr("disabled",false);
	            $("#sonOrg2").attr("disabled",false);
	        }
	    });
	}

	/**
	 * 修改组织机构规则
	 */
	SysOrgRule.edit = function () {
		if(this.check()){
			$("#status").val("edit");
			SysOrgRule.layerIndex = layer.open({
		        type: 1,
		        title: '组织规则修改',
		        area: ['685px', '300px'], //宽高
		        fix: false, //不固定
		        maxmin: false,
		        shadeClose: false,
		        content: $('#addEvent'),
		        success:function(){
		        	$('#ruleForm')[0].reset();
		        	$("#ruleId2").val(SysOrgRule.seItem[0].RULEID);//id                    	
	                $("#parentOrg2").val(SysOrgRule.seItem[0].PARENTORGCODE);//上级组织类型
	                $("#sonOrg2").val(SysOrgRule.seItem[0].SONTYPECODE);//下级组织类型
	                $("#ruleNote2").val(SysOrgRule.seItem[0].RULENOTE);//描述         
	                $("#parentOrg2").attr("disabled",true);
	                $("#sonOrg2").attr("disabled",true);
		        }
		    });					
		}
	}

	/**
	 * 删除组织机构规则
	 */
	SysOrgRule.del = function () {
		if(this.checkIds()){
			var operation = function() {
				var ajax = new $ax(Hussar.ctxPath + "/orgRule/delete",
						function(data) {							
							if (data.code == "200") {
								Hussar.success("删除成功!");						
								SysOrgRule.search();
							} else if (data.code) {
								Hussar.error(data.message);
							}
						}, 
						function(data) {
							Hussar.error("删除失败!");
						});
				ajax.set("eId", SysOrgRule.seItem);
				ajax.start();
			};
			Hussar.confirm("确定要删除选中的记录吗?", operation);
		}		
	}

	/**
	 * 保存组织机构规则
	 */	
	SysOrgRule.save = function () {  			
	    var that = this;            
	    var status = $("#status").val();
	    var ruleId = $("#ruleId2").val();//id            
	    var parentOrg = $("#parentOrg2").val();//上级组织类型
	    var sonOrg = $("#sonOrg2").val();//下级组织类型
	    var ruleNote = $("#ruleNote2").val();//描述    
	    if(status == "add"){    	
	    	var ajax = new $ax(Hussar.ctxPath + "/orgRule/add",
					function(data) {
	    				if(data.code == "200"){
	    					Hussar.success("保存成功!");  
	    					SysOrgRule.closeWin();//关闭弹窗
							SysOrgRule.search();//查询列表	
	    				}else if(data.code = "500") {
	    					Hussar.valid(data.message);
	    				}else{
	    					Hussar.valid("保存失败!");
	    				}	    								
					}, 
					function(data) {
						Hussar.valid("保存失败!");
					});
	    	ajax.setData({      		
	    		parentOrg: parentOrg,
	    		sonOrg: sonOrg,
	    		ruleNote: ruleNote
	    	});
			ajax.start();    	    	    	    	    	        
	    }else if(status == "edit"){
	    	var ajax = new $ax(Hussar.ctxPath + "/orgRule/edit",
					function(data) {
	    				if(data.code == "200"){
	    					Hussar.success("保存成功!");    					
	    				}else if(data.code = "500") {
	    					Hussar.valid(data.message);
	    				}else{
	    					Hussar.valid("保存失败!");
	    				}
	    				SysOrgRule.closeWin();
						SysOrgRule.search();					
					}, 
					function(data) {
						Hussar.valid("保存失败!");
					});
	    	ajax.setData({  
	    		ruleId: ruleId,
	    		parentOrg: parentOrg,
	    		sonOrg: sonOrg,
	    		ruleNote: ruleNote
	    	});
			ajax.start();     	    	    	        
	    }
	}

	/**
	 * 关闭弹出窗
	 */
	SysOrgRule.closeWin = function () {
	    layer.close(SysOrgRule.layerIndex);
	}
	
	/**
	 * 初始化按钮事件
	 */
	SysOrgRule.initButtonEvent = function () {
		$("#btnSearch").click(function(){
			SysOrgRule.search();
	    });
		$("#btnAdd").click(function(){
			SysOrgRule.add();
	    });
		$("#btnEdit").click(function(){
			SysOrgRule.edit();		
		});
		$("#btnDel").click(function(){
			SysOrgRule.del();
		});

		$("#btnSave").click(function(){
			form.on('submit(go)', function(data){
				SysOrgRule.save();
			});			
		});
		$("#btnClose").click(function(){
			SysOrgRule.closeWin();
		});
	}

	/**
	 * 初始化下拉框
	 */
	SysOrgRule.initSelectTags = function () {	
		//获取组织结构类型名称option
		$.ajax({  
	        type : "post",
	        async : false,
	        url : Hussar.ctxPath+"/orgType/orgTypeOption",  
	        dataType:"json",
	        success : function(json) {  
	        	$("#parentType").append("<option value=''>上级类型</option>"); 
	        	$("#lowerType").append("<option value=''>下级类型</option>");  
	        	$("select[name^='orgType']").append("<option value=''></option>");   
	            for (var i = 0; i < json.length; i++) {  
	            	$("select[name^='orgType']").append("<option value='" + json[i].organType + "'>" + json[i].typeName + "</option>");  
	            }  
	            form.render();
	        },
	        error:function () {
	             $.showInforDlg("操作提示","获取组织机构类型名称失败！", 0);
	        }
	    });
	}

	/**
	 * 初始化表格
	 */
	SysOrgRule.initTableView = function () {			
		layui.use('table', function(){
			var table = layui.table;
			table.render({
				elem: '#ruleTable',				
				url: Hussar.ctxPath+'/orgRule/list',
				page: true,	
				id: 'ruleTable',
				even: true,
                height:$("body").height() - $(".layui-form").outerHeight(true)-26,
				request: {
					pageName: 'curr', //页码的参数名称，默认：page
		  		   	limitName: 'nums' //每页数据量的参数名，默认：limit  		   	
		  		},	  		
				cols: [[{type: 'checkbox',width:40},
				        {type: 'numbers', title: '序号', align: 'center',width:50},
				        {field: 'PARENTORG', title: '上级类型', align:'center',width:130},
				        {field: 'SONTYPE', title: '下级类型', align:'center',width:200},
				        {field: 'RULENOTE', title: '规则描述', align:'left'}
				]],
			});			
			
		});
	}

	$(function () { 
		SysOrgRule.initSelectTags(); //初始化下拉框
		SysOrgRule.initTableView(); //初始化表格    	    
	    SysOrgRule.initButtonEvent(); //初始化按钮事件
	});
	
});




