/**
 * @Description: 菜单维护脚本文件
 * @Author: sunZengXin
 * @Date: 2018/3/15
 */
layui.use(['jquery','layer','Hussar','jstree','form'], function(){
		var Hussar = layui.Hussar;
		var $ = layui.jquery;
		var layer=layui.layer;
		var form = layui.form;
	var MenuManage = {
			treeId:"menuTree",
			infoWin:null, //弹出窗口
			selectId:"",
			childLevel:1
	}
	/*初始化页面*/
	MenuManage.initPage= function(){
		this.initTreeView();
		this.initOrderTreeView();
		this.initChangeTreeView();
		this.initButtonEvent();
		MenuManage.initFrameHeight();
	}
	/*组织机构树右键菜单*/
	MenuManage.menuList=function(node){
		var items={
	                create: null,
	                remove: null,
	                ccp: null,
	                add: {
	                    label: "新增菜单",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	//选中菜单名称
				        	var menuName=clickedNode.text;
				        	//选中菜单的层级
				        	var length = clickedNode.parents.length;
				        	//获取子节点数量
				        	var childNum = clickedNode.children.length;
				        	$("#menuFrame").attr("src",Hussar.ctxPath+"/menu/menuAdd?menuId=" + menuId+"&length="+length)
	                    }
	                },
	                edit: {
	                    label: "修改",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                    action: function (obj) {
	                        //获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							//选中菜单ID
				        	var menuId=clickedNode.id;
				        	//选中菜单的层级
				        	var length = clickedNode.parents.length;
				        	$("#menuFrame").attr("src",Hussar.ctxPath+"/menu/menuInfoEdit?menuId="+menuId+"&length="+length);
	                    }
	                },
	                change: {
	                    label: "转移",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单
				        	var menuId=clickedNode.id;
				        	//所选节点包含多少级
				        	var childLevel = 1;
				        	//获取下级数量
				        	var childNum = clickedNode.children.length;
				        	//全部下级数量
				        	var totalChildNum = clickedNode.children_d.length;
				        	if(childNum!=0){
				        		if(childNum == totalChildNum){
				        			childLevel +=1;
				        		}else{
				        			childLevel+=2;
				        		}
				        	}
				        	layer.open({
		        				type: 1,
		        				btn: ['取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: true,
		        				shade: 0.4,
		        				title: "上级菜单选择",
		        				content: $('#treeEditChange'),
		        				btn2: function(index, layero){
		        					//获取选中节点
	        	  					var nodes = $("#menuTreeChange").jstree(true).get_checked();//使用get_checked方法
	        	  					if(nodes.length==0){
	        	  						Hussar.info("请先选择上级菜单！");
	        	  					}else{
		        					//确认按钮回调
		        					var saveTree =function(){
		        						
		        	  						$.ajax({
		        			    			url:Hussar.ctxPath+"/menu/menuTreeChange",
		        			    			async:false,
		        			    			data:{
		        			    				menuId:menuId,
		        			    				parentId:nodes[0]
		        			    			},
		        			    			type:"POST",
		        			        		contentType:"application/x-www-form-urlencoded",
		        			        		success:function(data){
	        			        				MenuManage.refreshTree();
		        			        			Hussar.success("转移成功！");
		        			        			layer.close(index);
		        			        		},
		        			        		error:function(){
		        			        			Hussar.error("转移失败！");	
		        			        		}
		        			    			
		        			    		})
		        			    	}
		        			    	Hussar.confirm("确定要转移吗？", saveTree);
	        	  					
				                    layer.close(index);
	        	  					}
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
		        					$.ajax({
			                            type: "POST",
			                            data:{
			                            	menuId:menuId
			                            },
			                            contentType:"application/x-www-form-urlencoded",
			                            url: Hussar.ctxPath+"/menu/menuTree",
			                            dataType:"json",
			                            async: false,
			                            success:function(result) {
			                            	MenuManage.selectId=menuId;
			                            	var arrays = [];
			    	                        for(var i=0; i<result.length; i++){
			    	                        	var arr = {
			    	                        			 id	:	result[i].ID,
			    	                        			 code:   result[i].CODE,
			    	                        			 text : result[i].TEXT,
			    	                                     parent : result[i].PARENT,
			    	                                     isLeaf:result[i].ISLEAF,
			    	                                     type:result[i].TYPE,
			    	                                     seq:result[i].SEQ
			    	                        		}
			    	                        	arrays.push(arr);
			    	                        }
			    	                        result = arrays;
			                            	MenuManage.childLevel=childLevel;
			                            	$("#menuTreeChange").jstree(true).settings.core.data = result;
			                            	$("#menuTreeChange").jstree(true).refresh();
			                            }
	
			                        });
		        				}
		        			});
	                    }
	                },
	                up:{
	                	label: "上移",
	                	icon : Hussar.ctxPath+"/static/assets/img/treeContext/511101.png",
	                	action: function (obj) {
	                		//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	MenuManage.singleMove(menuId, 'up');
	                	}
	                },
	                down:{
	                	label: "下移",
	                	icon : Hussar.ctxPath+"/static/assets/img/treeContext/511102.png",
	                	action: function (obj) {
	                		//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	MenuManage.singleMove(menuId, 'down');
	                	}
	                },
	                sort: {
	                    label: "下级排序",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
				        	
				        	//是否为根节点
				        	var length = clickedNode.parents.length;
				        	var isRoot;
				        	if(length>1){
				        		isRoot=false;
				        	}else{
				        		isRoot=true;
				        	}
				        	//选中菜单名称
				        	var menuName=clickedNode.text;
				        	layer.open({
		        				type: 1,
		        				btn: ['取消','保存'],
		        				skin: 'confirm-class',
		        				area: ['350px','500px'],
		        				fix: false, //不固定
		        				maxmin: false,
		        				shadeClose: true,
		        				shade: 0.4,
		        				title: "下级排序",
		        				content: $('#treeEditOrder'),
		        				btn2: function(index, layero){
		        					//确认按钮回调
		        					var saveTree =function(){
		        			    		$.ajax({
		        			    			url:Hussar.ctxPath+"/menu/menuTreeOrder",
		        			    			async:false,
		        			    			data:{
		        			    				treeInfo:$("#output").val()
		        			    			},
		        			    			type:"POST",
		        			        		contentType:"application/x-www-form-urlencoded",
		        			        		success:function(data){
		        			        			MenuManage.refreshTree();
		        			        			Hussar.success("保存成功！");
		        			        			MenuManage.closeWindow();
		        			        		},
		        			        		error:function(){
		        			        			Hussar.error("保存失败！");	
		        			        		}
		        			    			
		        			    		})
		        			    	}
		        			    	Hussar.confirm("确定要保存排序吗？", saveTree);
				                    layer.close(index);
		        				 },
		        				success:function(){
                                    $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                                    $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
		        					$.ajax({
			                            type: "POST",
			                            data:{
			                            	menuId:menuId,
			                            	isRoot:isRoot
			                            },
			                            contentType:"application/x-www-form-urlencoded",
			                            url: Hussar.ctxPath+"/menu/menuTreeById",
			                            dataType:"json",
			                            async: false,
			                            success:function(result) {
			                            	var arrays = [];
			    	                        for(var i=0; i<result.length; i++){
			    	                        	var arr = {
			    	                        			 id	:	result[i].ID,
			    	                        			 code:   result[i].CODE,
			    	                        			 text : result[i].TEXT,
			    	                                     parent : result[i].PARENT,
			    	                                     isLeaf:result[i].ISLEAF,
			    	                                     type:result[i].TYPE,
			    	                                     seq:result[i].SEQ
			    	                        		}
			    	                        	arrays.push(arr);
			    	                        }
			    	                        result = arrays;
			                            	$("#menuTreeOrder").jstree(true).settings.core.data = result;
			                            	$("#menuTreeOrder").jstree(true).refresh();
			                            	//返回值在页面显示
			                            	var newResult=[];
			                            	for(var i=0;i<result.length;i++){
			                            		if(result[i].parent!="#"){
			                            			newResult.push(result[i]);
			                            		}
			                            		
			                            	}
			                            	$("#output").val(window.JSON.stringify(newResult));
			                            }
	
			                        });
		        				}
		        			});
	                    }
	                },
	                delete: {
	                    label: "删除",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中菜单ID
				        	var menuId=clickedNode.id;
	                    	var delMenu =function(){
	                    		$.ajax({
	                    			url:Hussar.ctxPath+"/menu/delMenuById",
	                    			async:false,
	                    			data:{
	                    				menuId:menuId
	                    			},
	                    			type:"POST",
	                        		contentType:"application/x-www-form-urlencoded",
	                        		success:function(data){
	                        			if(data.success==true){
	                        				MenuManage.refreshTree();
		                        			Hussar.success("删除成功！");
	                        			}else{
	                        				Hussar.error("删除失败！（请先删除下级菜单！）");
	                        			}
	                        		},
	                        		error:function(){
	                        			Hussar.error("删除失败！");	
	                        		}
	                    			
	                    		})
	                    	}
	                    	Hussar.confirm("确定要删除吗？", delMenu);
	                    }
	                }
	           };
		       var shiroAdd=$("#shiroAdd").val();
		       var shiroOrder=$("#shiroOrder").val();
		       var shiroChange=$("#shiroChange").val();
			   var shiroEdit=$("#shiroEdit").val();
		       var shiroDel=$("#shiroDel").val();
		       if(shiroAdd!="add"){
		    	   delete items.add;
		       }
		       if(shiroOrder!="order"){
		    	   delete items.sort;
		       }
		       if(shiroChange!="change"){
		    	   delete items.change;
		       }
		       if(shiroEdit!="edit"){
		    	   delete items.edit;
		       }
		       if(shiroDel!="del"){
		    	   delete items.delete;
		       }
			   if(node.parent=="#"){
				   //如果为根节点没有删除，修改功能
				   delete items.delete;  //删除节点 删除
				   delete items.edit;  //删除节点 修改
				   delete items.change;//删除节点转移 
			   }
	           var child = node.children;
	           if(child.length==0){
	           	delete items.sort;  //删除节点 下级排序  
	           };
	           //判断是否为第三级菜单，目前菜单最多只能三级
	           if(node.parents.length>3){
	        	   delete items.add; //删除节点 新增 
	           };
	           //判断是否为末及菜单
	           if(node.original.isLeaf=='1'){
	        	   delete items.add; //删除节点 新增 
	           }
	           
	           //上移下移
	           var id = node.id;
               var n = $("#"+id);
               if (n.index() == 0) {//非第一个
            	   delete items.up;  //删除节点 上移  
               }
               if (n.next().length == 0) {//非最后一个
            	   delete items.down;  //删除节点 上移 
               }
			return items; 
		
	}
    /**
     * 上移下移方法
     * @param id 组织机构id
     * @param direction 方向 'up' | 'down'
     */
	MenuManage.singleMove = function(id, direction){
        var layerIndex = layer.open({type: 3});
        $.ajax({
            url:Hussar.ctxPath+"/menu/singleMove",
            //async:false,
            data:{
                menuId: id,
                isUp: direction == 'up'
            },
            type:"POST",
            success:function(data){
                layer.close(layerIndex);
                MenuManage.refreshTree();
            },
            error:function(){
                layer.close(layerIndex);
                Hussar.error("操作失败！");
            }
        });
    };
	/*初始化组织机构树*/
	MenuManage.initTreeView = function(){
	    var $tree = $("#menuTree");
	    $tree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                $.ajax({
	                    type: "POST",
	                    url:Hussar.ctxPath+ "/menu/menuTree",
	                    dataType:"json",
	                    async: false,
	                    success:function(result) {
	                    	var arrays = [];
	                        for(var i=0; i<result.length; i++){
	                        	var arr = {
	                        			 id	:	result[i].ID,
	                        			 code:   result[i].CODE,
	                        			 text : result[i].TEXT,
	                                     parent : result[i].PARENT,
	                                     isLeaf:result[i].ISLEAF,
	                                     type:result[i].TYPE,
	                                     seq:result[i].SEQ
	                        		}
	                        	arrays.push(arr);
	                        }
	                        data = arrays;
	                        $("#menuInfo").attr("src","")
	                    }
	
	                });
	                callback.call(this, data);
	            }
	        },
	        plugins: ['state', 'types', 'contextmenu'],
	        contextmenu: {
	            items: MenuManage.menuList
	        },
	        types:{
	        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
	        	"0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/menu.png"},
	        	"1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/rootMenu.png"}
	        }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
	    		var menuId = currentNode.id
	    		var parent = currentNode.parent
	    		//选中菜单的层级
	        	var length = currentNode.parents.length;
	    		//判断是否为根节点如果为根节点
	    		if(parent=="#"){
	    			$("#menuFrame").attr("src","")
	    		}else{
	    			$("#menuFrame").attr("src",Hussar.ctxPath+"/menu/menuInfo?menuId=" + menuId+"&length="+length)
	    		}
		});
	}
	/*刷新组织机构树*/
	MenuManage.refreshTree = function(){
		$("#menuTree").jstree(true).refresh();
		$("#menuFrame").attr("src","");
	}
	/*初始化组织机构排序树*/
	MenuManage.initOrderTreeView = function(){
	    //初始化数列表
	    var $tree = $("#menuTreeOrder");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {
	                //拖动排序时只允许同级拖动
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: null
	        },
	        plugins: ['state', 'types',"dnd",'contextmenu'],
	        contextmenu: {
	            items: MenuManage.menuList
	        },
	        types:{
	        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
	        	"0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/menu.png"},
	        	"1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/rootMenu.png"}
	        },
	        sort:function(a,b){
	            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
	        }
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
				loadMenuInfo(22);
		});
	    //移动树事件
	    $tree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	var newResult=[];
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].seq=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].seq=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].seq=i+2;
	            			}else{
	            				oldResult[i].seq=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].seq=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].seq=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].seq=i;
	            			}else{
	            				oldResult[i].seq=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}
	    	oldResult.sort(MenuManage.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
		
	}
	/*初始化转移菜单树*/
	MenuManage.initChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#menuTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['state', 'types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:{
		        	"isRoot":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/root.png"},
		        	"0":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/menu.png"},
		        	"1":{'icon':Hussar.ctxPath+"/static/assets/img/treeContext/rootMenu.png"}
		        }
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		   $tree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;
		   	   var menuName = obj.node.text;
		   	   var isLeaf=obj.node.original.isLeaf;
              var ref =$tree.jstree(true);
              var nodes = ref.get_checked(); //使用get_checked方法
              //转移目标所处层级 
              var parentsLength = obj.node.parents.length -1;
              var otherNode;
              otherNode="";
              var totalLevel = MenuManage.childLevel +parentsLength;
              if(totalLevel>3){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("菜单不能超过三级！");
      			  return;
              }
              //如果菜单为末级菜单则不能移动
              if(isLeaf==1){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到末级菜单！");
      			  return;
              }
              //判断是否为相同节点，则不能移动
              if(MenuManage.selectId==obj.node.id){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到当前菜单！");
      			  return;
              }
              //限制选择不能选择当前以及当前子节点
              if(nodes.length>0){
            	  $.each(currentNode.parents, function(i, nd) {
                		if(nd == MenuManage.selectId){
                			ref.uncheck_node(obj.node.id);
                			Hussar.info("不能转移到当前菜单！");
                			return false;
                		}
                	})
                  
              }
              //限制只能选一个
              if(nodes.length>1){
              	$.each(nodes, function(i, nd) {
              		if(nd != obj.node.id){
              			otherNode = nd;
              		}
              	})
              	ref.uncheck_node(otherNode);
              }
              
          });
		}
	/*初始化按钮事件*/
	MenuManage.initButtonEvent = function(){
	    /*排序树保存*/
	    $("#treeBtnSave").click(function(){
	    	var saveTree =function(){
	    		$.ajax({
	    			url:Hussar.ctxPath+"/menu/menuTreeOrder",
	    			async:false,
	    			data:{
	    				treeInfo:$("#output").val()
	    			},
	    			type:"POST",
	        		contentType:"application/x-www-form-urlencoded",
	        		success:function(data){
	        			MenuManage.refreshTree();
	        			Hussar.success("保存成功！");
	        			MenuManage.closeWindow();
	        		},
	        		error:function(){
	        			Hussar.error("保存失败！");	
	        		}
	    			
	    		})
	    	}
	    	Hussar.confirm("确定要保存排序吗？", saveTree);
	    });
	    /*排序树重置*/
	    $("#treeBtnReset").click(function(){
	    	MenuManage.closeWindow();
	    });
	    
		
	}
	/*根据组织机构ID展示组织机构信息*/
	MenuManage.loadMenuInfo=function(id){
		$("#menuInfo").attr("src",Hussar.ctxPath+"/menu/menuInfo?struId=" + id)
	}
	/*增加下级*/
	MenuManage.addMenuInfo=function(){
		 layer.close(MenuManage.infoWin);
		//获取选中的组织类型
		var orgType = $("#orgType").val();
		//获取上级组织机构ID
		var orgParentId = $("#orgParentId").val();
		//获取上级组织机构编码
		var orgParentCode = $("#orgParentCode").val();
		//获取上级组织机构名称
		var orgParentName = $("#orgParentName").val();
		//获取上级组织机构所在层级
		var struLevel = $("#struLevel").val();
		//获取上级组织机构子节点数量
		var childNum = $("#childNum").val();
		$("#menuInfo").attr("src",Hussar.ctxPath+"/menu/menuInfoAdd?orgParentId="+orgParentId+"&orgParentCode="+orgParentCode+"&orgParentName="+orgParentName+"&orgType="+orgType+"&struLevel="+struLevel+"&childNum="+childNum)
	}
	/*排序*/
	MenuManage.up=function(x,y){
		return x.seq-y.seq
	}
	/*关闭弹窗*/
	MenuManage.closeWindow=function () {
	    layer.close(MenuManage.infoWin);
	};
	MenuManage.initFrameHeight=function(){
		var h = $("body").height()-5;
		$("#menuFrame").css("height", h + "px");
		$("#menuTree").css("height", h + "px");
	}
	$(function () {
		MenuManage.initPage();
		$(window).resize(function() {
			MenuManage.initFrameHeight();
		});
	});
});