/**
 * 表格的初始化
 */
var RedisMgr = {
	id: "RedisMgrTable",	//表格id
	seItem: null,		//选中的条目 array
	table: null,
	layerIndex: -1
};



layui.use(['jquery', 'layer', 'table', 'jstree', 'HussarAjax', 'Hussar'], function() {

	var layer = layui.layer
		, table = layui.table
		//, tree = layui.tree
		, $ = layui.jquery
		, $ax = layui.HussarAjax
		, Hussar = layui.Hussar;

	//以下为用layui的tree实现的树的代码
	//RedisMgr.getTreeData = function(){
	//	var data = [];
	//	var ajax = new $ax("/redis/getAllRedisDatabaseList",
	//		function(result) {
	//			console.log(result);
	//			data = result;
	//			if(Array.isArray(data) && data[0]){
	//				var firstCh = data[0].children[0];
	//				RedisMgr.currentDBName = firstCh?firstCh.name:'';
	//				RedisMgr.currentDBText = (data[0].name || '') + ' -> ' + RedisMgr.currentDBName;
	//			}
	//		},
	//		function(data) {
	//			Hussar.info("加载redis数据库树失败！");
	//		});
	//	ajax.async = false;
	//	ajax.start();
	//	return data;
	//};

	//以下为用layui的tree实现的树的代码
	//tree({
	//	elem: '#dbTree'
	//	,click: function(item){
	//		if (item.type == 'table') {
	//			RedisMgr.currentDBName = item.name;
	//			RedisMgr.currentDBText = [item.pname, item.name].join(' -> ');
	//			$('#currentDbName').text(RedisMgr.currentDBText);
	//			table.reload('DictTable', {
	//				where: {NoSQLDbName: item.name, selectKey: $("#condition").val()},
	//				page: {curr: 1, limit: 10}
	//			});
	//		}
	//	}
	//	,nodes: RedisMgr.getTreeData()
	//});

	//jstree的树
	RedisMgr.initUserTree = function () {
		var $tree = $("#dbTree");//用户树
		$tree.jstree({
			core: {
				check_callback: true,
				data: function (obj, callback) {
					var data;
					var ajax = new $ax("/redis/getAllRedisDatabaseList",
						function(result) {
							data = result
						},
						function(data) {
							Hussar.error("加载reids数据库树失败！");
						});
					ajax.start();
					//{
					//	id          : "string" // required
					//	parent      : "string" // required
					//	text        : "string" // node text
					//	icon        : "string" // string for custom
					//	state       : {
					//		opened    : boolean  // is the node open
					//		disabled  : boolean  // is the node disabled
					//		selected  : boolean  // is the node selected
					//	},
					//	li_attr     : {}  // attributes for the generated LI node
					//	a_attr      : {}  // attributes for the generated A node
					//}
					callback.call(this, (function(arr){
						//var arr = JSON.parse(data);
						var res = [];
						if(Array.isArray(arr)){
							arr.forEach(function(v){
								res.push({text: v.name, id: ''+v.id, parent: ''+(v.pid||'#'), type: v.type});
							});
						}
						console.log(res);
						return res;
					})(data));
				}
			},
			plugins: []
		}).on('loaded.jstree', function(e, data){
			var inst = data.instance;
			console.log(e);
			console.log(data);
			inst.select_node('2');
		});

		$tree.bind("activate_node.jstree", function (obj, e) {
			var currentNode = e.node;
			var dat = currentNode.original;
			RedisMgr.currentDBName = dat.text;
			//{
			//	"id": "2",
			//	"text": "DB0",
			//	"icon": true,
			//	"parent": "1",
			//	"parents": ["1", "#"],
			//	"children": [],
			//	"children_d": [],
			//	"state": {"loaded": true, "opened": false, "selected": true, "disabled": false},
			//	"li_attr": {"id": "2"},
			//	"a_attr": {"href": "#", "id": "2_anchor"},
			//	"original": {"text": "DB0", "id": "2", "parent": "1", "type": "table"},
			//	"type": "default"
			//}
			if (dat.type == 'table') {
				layui.use(['table'], function () {
					table.reload('RedisMgrTable', {where: {NoSQLDbName: dat.text, selectKey: $("#condition").val()}});
				});
			}
		});
	};

//----------------------------------------------------↑树丨↓表格-----------------------------------------------------



	/**
	 * 检查是否选中
	 */
	RedisMgr.check = function () {
		var flag = false;
		var selected = table.checkStatus('RedisMgrTable').data;
		if (selected && selected.length > 0) {
			RedisMgr.seItem = selected;
			flag = true;
		} else {
			// layer.confirm("请至少选择一条记录！ ", { btn: ['确认'],title:'信息'});
            Hussar.info("请至少选择一条记录！");
		}
		return flag;
	};

	/**
	 * 删除字段
	 */
	RedisMgr.delete = function () {
		if (RedisMgr.check()) {
			var idArr = [];
			RedisMgr.seItem.forEach(function (v) {
				idArr.push(v.key);
			});
			var operation = function () {
				var ajax = new $ax("/redis/deleteNoSQLKeys", function (data) {
					if(data.status == 'success'){
						Hussar.info("删除成功！");
						RedisMgr.search();
					}else{
						Hussar.info("删除失败！（" + data.mess + "）")
					}
				}, function (data) {
					Hussar.info("删除失败！（" + data.responseJSON.message + "）");
				});
				ajax.set("keys", JSON.stringify(idArr));
				ajax.set("NoSQLDbName", RedisMgr.currentDBName);
				ajax.start();
			};

			Hussar.confirm("确定要删除吗？", operation);
		}
	};

	/**
	 * 查询字段列表
	 */
	RedisMgr.search = function () {
		var queryData = {};
		queryData['selectKey'] = $("#condition").val();
		queryData['NoSQLDbName'] = RedisMgr.currentDBName;
		table.reload('RedisMgrTable', {where: queryData});
	};

	$(function () {
		var bodyH = $("body").height();
		$(".tree-box").css("height", bodyH + "px");

		RedisMgr.currentDBName = 'DB0';
		RedisMgr.initUserTree(); //初始化用户树
		table.render({
            elem: '#RedisMgrTable'
            ,url: '/redis/showRedisDBValue' //数据接口
            ,page: true //开启分页
			,limit: 20
            ,cols: [[ //表头
                {type:'checkbox', width: 40},
				{title: '序号', type: 'numbers',width:50},
                {title: '键名', field: 'key', width: '30%'},
                {title: '类型', field: 'type'},
                {title: '值', field: 'value', width: '50%'}
            ]]
            ,even: true
            ,height: bodyH - $(".layui-form").outerHeight(true)-26
		});
		table.reload('RedisMgrTable', {where: {NoSQLDbName: RedisMgr.currentDBName}});
		//$('#currentDbName').text(RedisMgr.currentDBText);
	});
});
