/**
 * @Description: 定义用户个人信息脚本文件
 * @Author: liangdong
 * @Date: 2018/3/15.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','element','form','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var element = layui.element;
	var form = layui.form;
	var table = layui.table;
	
	var UserInfo = {	
			roleTree: $("#roleTree"),//角色树
			proxyTree: $("#proxyTree"),//代理用户树
			byProxyTree: $("#byProxyTree"),//被代理用户树
		    layerIndex: -1
		};
	
	/**
	 * 树的模糊查询
	 */
	UserInfo.search = function () {
		var to = false;   
		//角色树查询
		$("#roleTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#roleTreeSearch").val();   
		        var temp = $roleTree.is(":hidden");   
		        if (temp == true) {   
		        	$roleTree.show();   
		        }   
		        $roleTree.jstree(true).search(v); 
		        //添加索引
				if(v!=''){
                    var n = $(".jstree-search").length,con_html;
                    if(n>0){
                        con_html = "<em>"+ n +"</em>个匹配项";
                    }else{
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
				}else {
                    $(".search-results").html("");
				}
		    }, 250);   
		}); 
		//代理用户树查询
		$("#proxyTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#proxyTreeSearch").val();   
		        var temp = $proxyTree.is(":hidden");   
		        if (temp == true) {   
		        	$proxyTree.show();   
		        }   
		        $proxyTree.jstree(true).search(v);   
		    }, 250);   
		}); 
		//被代理用户树查询
		$("#byProxyTreeSearch").keyup(function () {   
		    if (to) { clearTimeout(to); }   
		    to = setTimeout(function () {   
		        var v = $("#byProxyTreeSearch").val();   
		        var temp = $byProxyTree.is(":hidden");   
		        if (temp == true) {   
		        	$byProxyTree.show();   
		        }   
		        $byProxyTree.jstree(true).search(v);   
		    }, 250);   
		}); 
	}
	
	UserInfo.showUserInfo = function () {
		var ajax = new $ax(Hussar.ctxPath + "/user/currentUserInfo",
    		function(result) {	 				
	        	$('#userForm')[0].reset();	//	重置form
				/*基本信息开始*/
    			var user = result[0];
    			$('#corporationId').val(user[0].corporationId);
    			$('#userId').val(user[0].userId);    			
    			$('#userName').val(user[0].userName);    			
//    			$('#securityLevel').val(user[0].securityLevel);
    			$('#maxSessions').val(user[0].maxSessions);
    			$('#eMail').val(user[0].eMail);
    			$('#qq').val(user[0].qq);
    			$('#mobile').val(user[0].mobile); 
    			$('#weChat').val(user[0].weChat);
    			$('#telephone').val(user[0].telephone);
    			var isSys = $("input[name='isSys']");
    			for(var i=0; i<isSys.length; i++){
    				if(isSys[i].value == user[0].isSys){
    					isSys[i].checked = true;    				
    				}
    			}    			
    			var state = $("input[name='accountStatus']");
    			for(var i=0; i<state.length; i++){
    				if(state[i].value == user[0].accountStatus){
    					state[i].checked = true;
    				}
    			}    
    			form.render();
    			$('#userForm input').attr('disabled',true);
    			$('.con-full-l input').attr('disabled',false);
    			$('#userForm select').attr('disabled',true); 	
    			/*基本信息结束*/
    			
    			/*角色信息开始*/
    			var grantRole = result[1];
    			var roles = [];
    			for(var i=0; i<grantRole.length; i++){
    				roles.push(grantRole[i].grantedRole);
    			}     
    			UserInfo.initroleTree(roles);
    			/*角色信息结束*/    			    			
    			
    			/*代理用户信息开始*/
    			var userProxy = result[3];
    			var proxys = [];
    			for(var i=0; i<userProxy.length; i++){
    				proxys.push(userProxy[i].proxyUserId);
    			}
    			UserInfo.initProxyTree(proxys);
    			/*代理用户信息结束*/
    			
    			/*被代理用户信息开始*/
    			var byProxy = result[4];
    			var bproxys = [];
    			for(var i=0; i<byProxy.length; i++){
    				bproxys.push(byProxy[i].userId);
    			}
    			UserInfo.initByProxyTree(bproxys);
    			/*被代理用户信息结束*/    			
			}, 
			function(data) {
				Hussar.error("加载用户信息失败!");
			});		
		ajax.start();
	}
	
	/**
	 * 加载角色树
	 */
	UserInfo.initroleTree = function (roles) {	
		$roleTree = UserInfo.roleTree;//角色树
	    $roleTree.jstree({
	        core: {        	
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/roleManager/selfRoleTree",function(result) {                	
	                	var arrays = [];
                    	for(var i=0; i<result.length; i++){                    		 
                    		var arr = {
                				id	:	result[i].ID,
                    		    parent : result[i].PARENT,
                    		    text : result[i].TEXT,
                    		    code : result[i].CODE,	                    		    
                    		    type : result[i].TYPE,
                    		    state : {selected:false, checked:false, disabled:true}                				
                    		}   

                    		for(var j=0; j<roles.length; j++){
                    			if(roles[j] == result[i].ID){
                    				arr.state.checked = true;  
                    				arr.state.selected = true;
                    				break;
                    			}
                    		}                  		                   		
                    		arrays.push(arr);
                    	}
                    	data = arrays;
	                	
    					}, function(data) {
    						Hussar.error("加载角色树失败!");
    					});
	                ajax.set("roleIds",roles.join(','));	            
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['search','types'],
	        types:{
	        	"GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/roleGroup.png"} ,
	        	"ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/role.png"} ,
	        	"isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/root.png"} 
	        },	       
	        search: UserInfo.search()
	    });        
	}
	
	/**
	 * 加载 代理用户树
	 */
	UserInfo.initProxyTree = function (proxys) {	
		$proxyTree = UserInfo.proxyTree;//代理用户树
		$proxyTree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/proxyTree",
	            		function(result) {
		                	var arrays = [];
	                    	for(var i=0; i<result.length; i++){                    		 
	                    		var arr = {
	                    		    id	:	result[i].id,
	                    		    parent : result[i].parent,
	                    		    text : result[i].text,
	                    		    CODE : result[i].CODE,
	                    		    organId : result[i].organId,
	                    		    struLevel : result[i].struLevel,
	                    		    struType : result[i].struType,
	                    		    STRU_ORDER : result[i].STRU_ORDER,
	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	                    		    icon : "",
	                    		    state : {selected:false, checked:false, disabled:true}                				
	                    		}   
	                    		if('USER' == result[i].CODE){
		                            arr.icon = Hussar.ctxPath+"/static/assets/img/person.png";
		                        }
	                    		if(result[i].parent=="#"){
		                        	arr.state = {opened : true, disabled:true};
		                    	}
	                    		for(var j=0; j<proxys.length; j++){
	                    			if(proxys[j] == result[i].id){
	                    				arr.state.checked = true;  
	                    				arr.state.selected = true;
	                    				break;
	                    			}
	                    		}                  		                   		
	                    		arrays.push(arr);
	                    	}
	                    	data = arrays;
	            	
						}, function(data) {
							Hussar.error("加载代理用户树失败!");
						});
	                ajax.set("ids",proxys.join(","));
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['checkbox','search'],
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : true,//是否父子级别关联
	        	tie_selection : false
	        },
	        search: UserInfo.search()
	    });
		
	}
	
	/**
	 * 加载 被代理用户树
	 */
	UserInfo.initByProxyTree = function (bproxys) {	
		$byProxyTree = UserInfo.byProxyTree;//被代理用户树
		$byProxyTree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                var ajax = new $ax(Hussar.ctxPath + "/user/proxyTree",
                		function(result) {
		                	var arrays = [];
	                    	for(var i=0; i<result.length; i++){                    		 
	                    		var arr = {
	                    		    id	:	result[i].id,
	                    		    parent : result[i].parent,
	                    		    text : result[i].text,
	                    		    CODE : result[i].CODE,
	                    		    organId : result[i].organId,
	                    		    struLevel : result[i].struLevel,
	                    		    struType : result[i].struType,
	                    		    STRU_ORDER : result[i].STRU_ORDER,
	                    		    GLOBAL_ORDER : result[i].GLOBAL_ORDER,
	                    		    icon : "",
	                    		    state : {selected:false, checked:false, disabled:true}                				
	                    		}   
	                    		if('USER' == result[i].CODE){
		                            arr.icon = Hussar.ctxPath+"/static/assets/img/person.png";
		                        }
	                    		if(result[i].parent=="#"){
		                        	arr.state = {opened : true, disabled:true};
		                    	}
	                    		for(var j=0; j<bproxys.length; j++){
	                    			if(bproxys[j] == result[i].id){
	                    				arr.state.checked = true;  
	                    				arr.state.selected = true;
	                    				break;
	                    			}
	                    		}                  		                   		
	                    		arrays.push(arr);
	                    	}
	                    	data = arrays;                	
    					}, function(data) {
    						Hussar.error("加载被代理用户树失败!");
    					});
	                ajax.set("ids",bproxys.join(","));
	    			ajax.start();
	                callback.call(this, data);
	            }
	        },
	        plugins: ['checkbox','search'],
	        checkbox: {
	        	keep_selected_style : false,//是否默认选中
	        	three_state : true,//是否父子级别关联
	        	tie_selection : false
	        },
	        search: UserInfo.search()
	    });	    
	}
	
	/**
	 * 初始化角色表
	 */
	UserInfo.initTableView = function (roles) {
		table.render({
			elem : '#roleTable',
			url : '/roleManager/selfList',
			cols : [
				[  
			{
				title : '序号',
				type : 'numbers',
				align : 'center',
				width:50
			}, {
				field : 'ROLE_NAME',
				title : '角色名称',
				align : 'center'
			}, {
				field : 'ORGAN_ALIAS',
				title : '所属组织机构',
				align : 'center'
			}, {
				field : 'IS_SYS',
				title : '是否是系统角色',
				templet : adminEvts,
				align : 'center',
				sort: true
			} ] ],
//			page : true,
			id : 'roleTable',
			even: true,
			where: {
				roleIds : roles.join(",")
			}
		});
		
		//是否是系统角色formater
		function adminEvts(obj) {
			var flag="";
			if(obj.IS_SYS==1){
				flag="checked";
			}
			return '<input type="checkbox"  value="'+obj.IS_SYS+'" lay-skin="switch" lay-text="是|否" disabled '+flag+'>'
		}
	}
	

	$(function () { 
		UserInfo.showUserInfo();	
	});
	
});




