/**
 * @Description: 角色管理脚本文件
 * @Author: chenxin
 * @Date: 2018/2/27.
 */

/**
 * 用户管理初始化
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','element'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var jstree=layui.jstree;
	var form=layui.form;
    var RoleManage = {};
    var element=layui.element;
    var form;
/*初始化页面*/
RoleManage.initPage = function() {
    this.initTree();
    this.contextmenu();
    RoleManage.initFrameHeight();
}
RoleManage.initTree = function () {
//初始化数列表
    var $tree = $("#powerTree");//权限树
    $tree.jstree({
        core: {
            check_callback: true,
            data: function (obj, callback) {
                var data;
                var ajax = new $ax(Hussar.ctxPath + "/roleManager/roleTree",function(result) {
                	var arrays = [];
                    for(var i=0; i<result.length; i++){
                    	var arr = {
                    			 id	:	result[i].ID,
                    			 code : result[i].CODE,
                    			 parent : result[i].PARENT,
                    			 type : result[i].TYPE,
                    			 text : result[i].TEXT
                    		} 
                        arrays.push(arr); 
                    }
                    data = arrays;
                }, function(data) {
                    Hussar.error("加载角色列表失败！");
                });
                ajax.start();
                callback.call(this, data);
            }
        },
        contextmenu:{
            select_node:true,
            show_at_node:true,
            'items' : RoleManage.contextmenu
        },
        plugins: ['contextmenu','types','search'],
        types:{
        	"GROUP":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/roleGroup.png"},
        	"ROLE":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/role.png"},
        	"isRoot":{'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/root.png"}
        },        
        search : RoleManage.search()

    });
    $tree.bind('activate_node.jstree', function (obj,e){
        if(e.node.original.code == 'ROLE'){
        	$("#roleIframe").attr("src","/roleManager/roleViewPage?id=" + e.node.id)
        }else if(e.node.original.code == 'GROUP'&&e.node.original.parent != '#'){
        	$("#roleIframe").attr("src","/roleManager/roleGroupViewPage?id=" + e.node.id)
        }else{
        	$("#roleIframe").attr("src","")
        }
    })
};

/**
 * 树查询
 */
RoleManage.search = function () {
    var to = false;
    $("#txtIndustryArea").keyup(function () {
        if (to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $("#txtIndustryArea").val();
            var temp = $("#powerTree").is(":hidden");
            if (temp == true) {
                $("#powerTree").show();
            }
            $("#powerTree").jstree(true).search(v);
            //添加索引
            if(v!=''){
                var n = $(".jstree-search").length,con_html;
                if(n>0){
                    con_html = "<em>"+ n +"</em>个匹配项";
                }else{
                    con_html = "无匹配项";
                }
                $(".search-results").html(con_html);
            }else {
                $(".search-results").html("");
            }
        }, 250);
    });
}
/**
 * 右键菜单
 */
RoleManage.contextmenu = function (node) {
//不同节点菜单不一样
    var items = {
        'item1' : {
                'label' : '新增角色分组',
                'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
                'action' : function () {
                	$("#roleIframe").attr("src","/roleManager/roleAddGroupPage?type=add&id="+node.id);
                }
            },
        'item2' : {
            'label' : '新增角色',
            'action' : function () { /* 写点击处理函数 */
            	$("#roleIframe").attr("src","/roleManager/roleAddPage?id="+node.id);
            },
            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png"
        },
        'item3' : {
            'label' : '修改',
            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
            'action' : function () {
            	$("#roleIframe").attr("src","/roleManager/roleEditPage?id="+node.id);
            }
        },
        'item4' : {
            'label' : '回收权限',
            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
            'action' : function () {
                var operation = function() {
                    var ajax = new $ax(Hussar.ctxPath + "/roleManager/reclaimPerm",
                        function() {
                            Hussar.success("回收权限成功！");
                            $("#roleIframe").attr("src","/roleManager/roleViewPage?id=" + node.id)
                        },
                        function(data) {
                            Hussar.error("回收权限成功！");
                        });
                    ajax.set("id", node.id);
                    ajax.start();
                };
                Hussar.confirm("确定要回收权限吗?", operation);
            }
        },
        'item5' : {
            'label' : '删除',
            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
            'action' : function () {
            		var operation = function() {
                        var ajax = new $ax(Hussar.ctxPath + "/roleManager/delRole",
                            function(data) {
                        	if(data.code=="200"){
                        		Hussar.success("删除成功！");
                                $("#powerTree").jstree(true).refresh();//刷新权限树
                                window.location.reload();
                        	}
                        	else if (data.code == "500") {
					            Hussar.error("删除失败！("+data.message+")");
					        }
                            },
                            function(data) {
                                Hussar.error("删除失败！");
                            });
                        ajax.set("id", node.id);
                        ajax.start();
                    };
                    Hussar.confirm("确定要删除吗?", operation);
                
            }
        },
        'item6' : {
            'label' : '修改',
            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
            'action' : function () {
            	$("#roleIframe").attr("src","/roleManager/roleAddGroupPage?type=edit&id="+node.id);
            }
        },
        'item7' : {
            'label' : '删除',
            'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
            'action' : function () {
            		var operation = function() {
            			var ajax = new $ax(Hussar.ctxPath + "/roleManager/searchRoleToGroup",
                                function(data) {
            				if(data.length!=0){
            					Hussar.info("请先删除角色！");
            				}else{
            					var ajax = new $ax(Hussar.ctxPath + "/roleManager/delGroup",
                                        function() {
                                            Hussar.success("删除成功！");
                                            $("#powerTree").jstree(true).refresh();//刷新权限树
                                            window.location.reload();
                                        },
                                        function(data) {
                                            Hussar.error("删除失败！");
                                        });
                                    ajax.set("id", node.id);
                                    ajax.start();
            				}
                                },
                                function(data) {
                                    Hussar.error("查询角色分组下是否存在角色失败！");
                                });
                            ajax.set("id", node.id);
                            ajax.start();
                    };
                    Hussar.confirm("确定要删除吗?", operation);
                
            }
        }
    };
    if(node!=undefined){
    	if(node.original.code == 'ROLE'){
    		var ajax = new $ax(Hussar.ctxPath + "/roleManager/queryPerm",function(json) {//角色是否有权限
                if(json.length==0){//角色下无权限删除回收权限菜单
                    delete items.item4;
                }
            }, function(data) {
                Hussar.error("获取角色权限失败！");
            });
            ajax.set("id", node.id);
            ajax.start();
    	}
            if (node.original.code == 'GROUP'&&node.original.parent != '#') {
            	var shiroAdd=$("#shiroAdd").val();
            	var editGroup=$("#editGroup").val();
            	var delGroup=$("#delGroup").val();
            	if(shiroAdd!="add"){
            		delete items.item2;
            	}
            	if(editGroup!="editGroup"){
            		delete items.item6;
            	}
            	if(delGroup!="delGroup"){
            		delete items.item7;
            	}
            	delete items.item1;
            	delete items.item3;
            	delete items.item4;
            	delete items.item5;
            } else if(node.original.parent == '#'){
            	var saveGroup=$("#saveGroup").val();
            	if(saveGroup!="saveGroup"){
            		delete items.item1;
            	}
            	delete items.item3;
            	delete items.item4;
            	delete items.item5;
            	delete items.item6;
            	delete items.item7;
            }else{
            	var shiroEdit=$("#shiroEdit").val();
            	var shiroDel=$("#shiroDel").val();
            	var shiroRec=$("#shiroRec").val();
            	if(shiroEdit!="edit"){
            		delete items.item3;
            	}
            	if(shiroRec!="rec"){
            		delete items.item4;
            	}
            	if(shiroDel!="del"){
            		delete items.item5;
            	}
                delete items.item1;  //删除节点 items
                delete items.item2; 
                delete items.item6;
            	delete items.item7;
            }
            return items;
    }

};

RoleManage.initFrameHeight=function(){
	var h = $(window).height()-60;
	var h2 = $(window).height()-10;
	$("#roleIframe").css("height", h2 + "px");
	$("#roleInfo").css("height", h + "px");
};

/**
 * 初始化
 */
$(function() {
    RoleManage.initPage();
    $(window).resize(function() {
    	RoleManage.initFrameHeight();
	});
});
});