/**
 * @Description: 会话追踪脚本文件
 * @Author: liangdong
 * @Date: 2018/4/10.
 */
layui.use(['jquery','layer','Hussar','jstree','form','laydate','HussarAjax'], function(){
	
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var form = layui.form;
	var laydate = layui.laydate;
	var $ax = layui.HussarAjax;
	var table1;
	var layerWindow;
	
	var SessionTrace = {};
	
	/**
	 * 初始化页面
	 */
	SessionTrace.initPage = function () {
		this.initTable();
	}
	
	/**
	 * 加载table
	 */
	SessionTrace.initTable = function() {
		var id = $('#sessionId').val();
		var isQuery = "1";
		if (id != "" && id != undefined) {
			isQuery = "2";
		}	
		layui.use('table', function() {
			var table = layui.table;			
			table.render({
				elem : '#logTable',
				url : '/securityLog/list',
				cols : [ [
				          {title : '序号', type : 'numbers', align : 'center',width:40},
				          {title : '用户账号', field: 'userId', align : 'center'},
				          {title : '用户名称', field: 'userName', align : 'center',event : 'logEvents',style:'cursor: pointer;color:#00a4ff'},
				          {title : '日志类型', field: 'logTypeName', align : 'center'},
				          {title : '操作时间', field: 'logTime', align : 'center',sort: true, width : 180},
				          {title : '客户端地址', field: 'remoteaddr', align : 'center', width : 150},
				          {title : '操作业务含义', field: 'resourceAlias', align : 'left', width : 180}
				          ] ],
				page : true,
				even: true,
				id : 'logTable',
				where: {
					sessionId: id,
					isQuery : isQuery//点击查询时，显示查询结果
				}
                ,height:$("body").height() - $(".layui-form").outerHeight(true)-26
			});
			
			// 监听单元格事件
			table.on('tool(logTable)', function(obj) {
				var data = obj.data;
				if (obj.event == 'logEvents') {
					layerWindow=layer.open({
						type : 1,
						title: '用户操作明细',
						area : [ '70%', '80%' ],
						//shift : 1,
						shadeClose : true,
						maxmin : false,
						shadeClose: false,
						content : $("#logDetail"),
						success : function() {
							$("#userId").html(data.userId);
							$("#userName").html(data.userName);
							$("#corporationName").html(data.corporationName);
							$("#logTime").html(data.logTime);							
							$("#resourceAlias").html(data.resourceAlias);
							$("#logTypeName").html(data.logTypeName);
							$("#logContent").html(data.logContent);
							form.render();
							
//							$("#userLevel").html(data.userLevel);$("#corporationId").html(data.corporationId);$("#securityLevel").html(data.securityLevel);
//							$("#logTypeCode").html(data.logType);$("#resourceId").html(data.resourceId);
//							$("#remoteaddr").html(data.remoteaddr);$("#remotehost").html(data.remotehost);$("#remoteport").html(data.remoteport);
//							$("#localaddr").html(data.localaddr);$("#localhost").html(data.localhost);$("#localport").html(data.localport);
						}
					});
				}
			});
			table1 = table;
		});
	};
	
	/**
	 * 选中一条结果
	 */
	SessionTrace.check = function() {
		var checkStatus = table1.checkRadioStatus('logTable'), data = checkStatus.data;
		if (data.length == 0 || data.length > 1) {
			// layer.confirm("请先选中表格中的某一记录！ ", { btn: ['确认'],title:'信息'});
            Hussar.info("请先选中表格中的某一记录！");
			return false;
		} else {
			SessionTrace.seItem = data[0];
			return true;
		}
	};
	    			
	
	/**
	 * 初始化
	 */
	$(function() {
		SessionTrace.initPage();		
	});

});