/**
 * @Description: 安全日志脚本文件
 * @Author: chenxin
 * @Date: 2018/3/15.
 */
layui.use(['jquery','layer','Hussar','jstree','form','laydate','HussarAjax'], function(){
	
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var form = layui.form;
	var laydate = layui.laydate;
	var $ax = layui.HussarAjax;
	var table1;
	var layerWindow;
	var ts = laydate.render({
	   	elem: '#startDate',
        type : 'datetime',
        done: function (value,date) {	
       	 if (value !== '') {
       		 te.config.min.year = date.year;
	        	 te.config.min.month = date.month - 1;
	        	 te.config.min.date = date.date;
	        	 te.config.min.hours = date.hours;
	        	 te.config.min.minutes = date.minutes;
	        	 te.config.min.seconds = date.seconds;
       	 } else {
       		 te.config.min.year = '';
	        	 te.config.min.month = '';
	        	 te.config.min.date = '';
	        	 te.config.min.hours = '';
	        	 te.config.min.minutes = '';
	        	 te.config.min.seconds = '';
       	 }
       	 	        	 
        }
	});
	var te = laydate.render({
	   	 elem: '#endDate',
	     type : 'datetime',              
	     done: function (value,date) {			    	 
	    	 if (value !== '') {
	    		 ts.config.max.year = date.year;
	        	 ts.config.max.month = date.month - 1;
	        	 ts.config.max.date = date.date;
	        	 ts.config.max.hours = date.hours;
	        	 ts.config.max.minutes = date.minutes;
	        	 ts.config.max.seconds = date.seconds;
	    	 } else {
	    		 ts.config.max.year = '2099';
	        	 ts.config.max.month = '11';
	        	 ts.config.max.date = '31';
	        	 ts.config.max.hours = '0';
	        	 ts.config.max.minutes = '0';
	        	 ts.config.max.seconds = '0';
	    	 }
	    	 	 
	     }
	});
	
	var SecurityLog = {
			seItem : null // 选中的条目
		};
	
	/**
	 * 初始化页面
	 */
	SecurityLog.initPage = function () {
		this.initTable();
		this.queryOption();
		this.initButton();		
	}
	
	/**
	 * 加载table
	 */
	SecurityLog.initTable = function() {
		var id = $('#sessionId').val();
		var isQuery = "1";
		if (id != "" && id != undefined) {
			isQuery = "2";
		}	
		layui.use('table', function() {
			var table = layui.table;			
			table.render({
				elem : '#logTable',
				url : '/securityLog/list',
				cols : [ [
				          {type: 'radio',align : 'center',width: 50} ,
				          {title : '序号', type : 'numbers', align : 'center',width: 50},
				          {title : '用户账号', field: 'userId', align : 'center'},
				          {title : '用户名称', field: 'userName', align : 'center',event : 'logEvents',style:'cursor: pointer;color:#00a4ff'},
				          {title : '日志类型', field: 'logTypeName', align : 'center'},
				          {title : '客户端地址', field: 'remoteaddr', align : 'center'},
				          {title : '操作时间', field: 'logTime', align : 'center',sort: true},
				          {title : '操作业务含义', field: 'resourceAlias', align : 'center'}
				          ] ],
				page : true,
				even: true,
				id : 'logTable',
				where: {
					sessionId: id,
					isQuery : isQuery//点击查询时，显示查询结果
				}
                ,height:$("body").height() - $(".layui-form").outerHeight(true)-26
			});
			
			// 监听单元格事件
			table.on('tool(logTable)', function(obj) {
				var data = obj.data;
				if (obj.event == 'logEvents') {
					layerWindow=layer.open({
						type : 1,
						area : [ '60%', '70%' ],
						//shift : 1,
						shadeClose: false,
						title : '日志详情',
						maxmin : false,
						content : $("#logDetail"),
						success : function() {
							$("#userId").html(data.userId);$("#userName").html(data.userName);
							$("#corporationName").html(data.corporationName);$("#logTime").html(data.logTime);
							$("#resourceAlias").html(data.resourceAlias);$("#logTypeName").html(data.logTypeName);
							$("#logContent").html(data.logContent);
							form.render();
						}
					});
				}
			});
			table1 = table;
		});
	};
	
	/**
	 * 选中一条结果
	 */
	SecurityLog.check = function() {
		var checkStatus = table1.checkRadioStatus('logTable'), data = checkStatus.data;
		if (data.length == 0 || data.length > 1) {
			// layer.confirm("请先选中表格中的某一记录！ ", { btn: ['确认'],title:'信息'});
            Hussar.info("请选择一条记录！");
			return false;
		} else {
			SecurityLog.seItem = data[0];
			return true;
		}
	};
	
	/**
	 * 获取日志类型option
	 */
	SecurityLog.queryOption = function() {
		var ajax = new $ax(Hussar.ctxPath + "/securityLog/logTypeOption",
				function(json) {
					$("#logType").html("");
					$("#logType").append("<option value=''>日志类型查询</option>");
					for (var i = 0; i < json.length; i++) {
						$("#logType").append("<option value='" + json[i].resTypeId + "'>"+ json[i].resTypeName+"</option>");
					}
					form.render();
				}, function(data) {
					Hussar.error("获取上级组织机构类型失败！");
				});
		ajax.set(this.deptInfoData);
		ajax.start();
	};
	    
	/**
	 * 按钮操作
	 */
	SecurityLog.initButton = function () {
		//查询
		$('#search').on('click', function() {
			var dateStart = $("#startDate").val();
			var dateEnd = $("#endDate").val();
			var logType = $("#logType").val();
			var cName = $("#cName").val();
			var cAdress = $("#cAdress").val();
			var userAcount = $("#userAcount").val();
			// 执行重载
			table1.reload('logTable', {
				page : {
					curr : 1
				// 重新从第 1 页开始
				},
				where : {
					dateStart : dateStart,
					dateEnd : dateEnd,
					logType : logType,
					cName : cName,
					cAdress : cAdress,
					userAcount : userAcount,
					isQuery : "2",//点击查询时，显示查询结果
					sessionId :""//清空上次reload传来的参数
				}
			});
		});
		
		//会话追踪
		$("#sessionTracking").click(function(){
			if(SecurityLog.check()){
				table1.reload('logTable', {
					page : {
						curr : 1
					},
					where : {
						logType : "",
						sessionId : SecurityLog.seItem.sessionId
					}
				});
			}
		})

		//返回
		$("#back").click(function(){
			layer.close(layerWindow);
		})
	}			
	
	/**
	 * 初始化
	 */
	$(function() {
		SecurityLog.initPage();		
	});

});