/**
 * @Description: 定义在线用户历史记录历史记录脚本文件
 * @Author: liangdong
 * @Date: 2018/3/16.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','form','laydate','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer = layui.layer;
	var $ax = layui.HussarAjax;
	var form = layui.form;
	var laydate = layui.laydate;
	var table = layui.table;
		
	/**
	 * 在线用户历史记录的单例
	 */
	var OnlineUserHist = {
	    id: "onlineHistTable",	//表格id
	    seItem: null,		//选中的条目
	    table: null,
	    layerIndex: -1
	};

	/**
	 * 搜索在线用户历史记录
	 */
	OnlineUserHist.search = function () {    
		var userId = $('#userId').val();
	    var corporationName = $('#corporationName').val();
	    var remoteaddr = $('#remoteaddr').val();
	    var startTime = $('#startTime').val();
	    var endTime = $('#endTime').val();
	    layui.use(['table'], function() {
	        var table = layui.table;
	        table.reload('onlineHistTable', {page: {curr: 1},where:{
	        	userId : userId,
	        	corporationName : corporationName,
	        	remoteaddr : remoteaddr,
	        	startTime : startTime,
	        	endTime : endTime
	        }});
	    });	 
	}
	
	/**
	 * 会话追踪
	 */
	OnlineUserHist.sessionTrack = function () {
		if (OnlineUserHist.check()) {
			OnlineUserHist.layerIndex = layer.open({
				type : 2,
				maxmin : true,
				title: '会话追踪',	
				area: ['80%', '90%'], //宽高
				content : '/securityLog/view2/' + this.seItem[0].sessionId,
				success : function() {							
					
				}
			});			
		}	
	}

	/**
	 * 检查是否选中一条记录
	 */
	OnlineUserHist.check = function () {
		var flag = false;
	    var selected = table.checkStatus('onlineHistTable').data;
	    if (selected && selected.length == 1) {
	    	OnlineUserHist.seItem = selected;
	        flag = true;
	    } else {
	    	Hussar.info("请选择一条记录！");
	    }
	    return flag;
	}
	
	/**
	 * 检查是否选中多条记录
	 */
	OnlineUserHist.checkIds = function() {
		var selected = table.checkStatus('onlineHistTable').data;
		var ids = [];
		if (selected.length == 0) {
			Hussar.info("请至少选择一条记录！");
			return false;
		} else {
			for (var i = 0, l = selected.length; i < l; i++) {
				var r = selected[i];
				ids.push(r.ruleId);
			}
			var eId = ids.join(',');
			OnlineUserHist.seItem = eId;
			return true;
		}
	};				

	/**
	 * 关闭弹出窗
	 */
	OnlineUserHist.closeWin = function () {
	    layer.close(OnlineUserHist.layerIndex);
	}
	
	/**
	 * 初始化按钮事件
	 */
	OnlineUserHist.initButtonEvent = function () {
		$("#btnSearch").click(function(){
			OnlineUserHist.search();
	    });		
		$("#btnTrackSe").click(function(){
			OnlineUserHist.sessionTrack();	
		});		
		$("#btnClose").click(function(){
			OnlineUserHist.closeWin();
		});
	}
	
	/**
	 * 初始化时间控件
	 */
	OnlineUserHist.initLaydate = function () {		
		var ts = laydate.render({
		   	 elem: '#startTime',
	         type : 'datetime',
	         done: function (value,date) {	
	        	 if (value !== '') {
	        		 te.config.min.year = date.year;
		        	 te.config.min.month = date.month - 1;
		        	 te.config.min.date = date.date;
		        	 te.config.min.hours = date.hours;
		        	 te.config.min.minutes = date.minutes;
		        	 te.config.min.seconds = date.seconds;
	        	 } else {
	        		 te.config.min.year = '';
		        	 te.config.min.month = '';
		        	 te.config.min.date = '';
		        	 te.config.min.hours = '';
		        	 te.config.min.minutes = '';
		        	 te.config.min.seconds = '';
	        	 }
	        	 	        	 
	         }
		});
		var te = laydate.render({
		   	 elem: '#endTime',
		     type : 'datetime',              
		     done: function (value,date) {			    	 
		    	 if (value !== '') {
		    		 ts.config.max.year = date.year;
		        	 ts.config.max.month = date.month - 1;
		        	 ts.config.max.date = date.date;
		        	 ts.config.max.hours = date.hours;
		        	 ts.config.max.minutes = date.minutes;
		        	 ts.config.max.seconds = date.seconds;
		    	 } else {
		    		 ts.config.max.year = '2099';
		        	 ts.config.max.month = '11';
		        	 ts.config.max.date = '31';
		        	 ts.config.max.hours = '0';
		        	 ts.config.max.minutes = '0';
		        	 ts.config.max.seconds = '0';
		    	 }
		    	 	 
		     }
		});
	}
	

	/**
	 * 初始化表格
	 */
	OnlineUserHist.initTableView = function () {			
		layui.use('table', function(){
			var table = layui.table;
			table.render({
				elem: '#onlineHistTable',				
				url: '/onlineHist/list',
				page: true,	
				id: 'onlineHistTable',
				even: true,					  		
				cols: [[{type: 'checkbox',width: 40},
				        {title: '序号', type: 'numbers', align: 'center',width: 50},
				        {title: '用户账号', field: 'userId', align:'center'},
				        {title: '用户名称', field: 'userName', align:'center',  event: 'detailEvent', style:'cursor: pointer;color:#00a4ff'},
				        {title: '所属机构名称', field: 'corporationName', align:'center', width:250},
				        {title: '客户端地址', field: 'remoteaddr', align:'center'},
				        {title: '登录时间', field: 'loginTime', align:'center', sort: true}
				]],
                height:$("body").height() - $(".layui-form").outerHeight(true)-26
			});			
			
		});
	}
	
	// 监听单元格事件
	table.on('tool(detail)', function(obj) {
		var data = obj.data;
		if (obj.event == 'detailEvent') {
			OnlineUserHist.layerIndex = layer.open({
				type : 1,
				title: '历史用户明细',
				area : [ '500px', '420px' ],				
				shadeClose : false,
				maxmin : false,
				content : $("#viewEvent"),
				success : function() {
					$('#viewForm')[0].reset();			
					$('#userId2').html(data.userId);
					$('#userName2').html(data.userName);					
					$('#corporationName2').html(data.corporationName);
					$('#loginTime').html(data.loginTime);
					$('#logoffTime').html(data.logoffTime);
					$('#browserType').html(data.browserType);
					$('#remoteaddr2').html(data.remoteaddr);
					$('#remotehost').html(data.remotehost);
					$('#remoteport').html(data.remoteport);										
				}
			});			
		}
	});

	$(function () { 	
		OnlineUserHist.initLaydate();	//初始化时间控件
		OnlineUserHist.initTableView(); //初始化表格    	    
	    OnlineUserHist.initButtonEvent(); //初始化按钮事件
	});
	
});