/**
 * @Description: 组织机构维护脚本文件
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
layui.use(['jquery','layer','Hussar','jstree','form'], function(){
		var Hussar = layui.Hussar;
		var $ = layui.jquery;
		var layer=layui.layer;
		var form = layui.form;
	var OrgMaintenance = {
			treeId:"orgTree",
			infoWin:null, //弹出窗口
			selectId:null,
			isRootChange:'0',
			changeLevel:null
	}
	/*初始化页面*/
	OrgMaintenance.initPage= function(){
		this.initTreeView();//初始化组织树
		this.initOrderTreeView();//初始化排序树
		this.initChangeTreeView();//初始化转移树
		this.initButtonEvent();
		OrgMaintenance.initFrameHeight();
	}
	/*组织机构树右键菜单*/
	OrgMaintenance.menuList=function(node){
		var items={
	                create: null,
	                remove: null,
	                ccp: null,
	                add: {
	                    label: "新增下级",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5011.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
	                        //alert(info.id+"+"+info.text);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织上级不同类型组织编码(用于构建下级组织机构编码)
				        	var parentTypeCode=clickedNode.original.parentTypeCode;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	//选中组织机构层级
				        	var struLevel = clickedNode.original.struLevel;
				        	//获取子节点数量
				        	var childNum = clickedNode.children.length;
				        	var length = clickedNode.parents.length;
				        	var isRoot='';
				        	if(length==1){
				        		isRoot='1';
				        	}
				        	$.ajax({
				        		type:"POST",
				        		contentType:"application/x-www-form-urlencoded",
				        		url:"/orgMain/getOrgRoleByCode",
				        		dataType:"json",
				        		data:{
				        			orgType:orgType,
				        			isRoot:isRoot
				        		},
				        		async:false,
				        		success:function(data){
				        			$("#orgType").html('');
				        			var isEmpl = false;
				        			for(var i=0;i<data.length;i++){
				        				if(data[i].typeName!="职工"){
				        					$("#orgType").append("<input type='radio' lay-filter='orgType' name='orgType' value='"+data[i].ORGANTYPE+"' title='"+data[i].TYPENAME+"' >");
				        				}else{
				        					isEmpl=true;
				        				}
				        			}
				        			form.render('select');
				        			if(data.length==0){
				        				Hussar.info("根据组织机构规则，该组织机构无下级！");
				        				return false;
				        			}else if(data.length==1&isEmpl==true){
				        				Hussar.info("根据组织机构规则，该组织机构无下级！");
				        				return false;
				        			}
				        			layer.open({
				        				type: 1,
				        				btn: ['关闭','确认'],
				        				area: ['500px','200px'],
				        				skin: 'confirm-class',
				        				fix: false, //不固定
				        				maxmin: false,
				        				shadeClose: false,
				        				shade: 0.4,
				        				title: "下级类型选择",
				        				content: $('#selectOrgType'),
				        				btn2: function(index, layero){
				        					//确认按钮回调
				        					var isClose = OrgMaintenance.addOrgInfo();
				        					if(isClose==true){
				        						layer.close(index);
				        					}
				        				 },
				        				success:function(){
				        					document.getElementById("orgTypeSelect").reset();
				        					//将选中组织信息放到页面中
						                    $("#orgParentId").val(orgId);
						                    $("#orgParentCode").val(orgCode);
						                    $("#orgParentName").val(orgName);
						                    $("#struLevel").val(struLevel);
						                    $("#childNum").val(childNum);
						                    $("#parentType").val(orgType);
						                    $("#parentTypeCode").val(parentTypeCode);
						                    
				        				}
				        			});
				        		},
				        		error:function(){
				        			
				        		}
				        	})
				        	
	                    }
	                },
	                edit: {
	                    label: "修改",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/53.png",
	                    action: function (obj) {
	                        //获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
							//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	$("#orgInfo").attr("src","/orgMain/orgInfoEdit?orgId="+orgId);
	                    }
	                },
	                change: {
	                    label: "转移",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5411.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	//选中组织机构层级
				        	var struLevel = clickedNode.original.struLevel;
				        	layer.open({
		        				type: 1,
		        				btn: ['关闭','确认'],
		        				skin: 'confirm-class',
		        				area: ['500px','400px'],
		        				fix: false, //不固定
		        				maxmin: true,
		        				shadeClose: false,
		        				shade: 0.4,
		        				title: "上级组织机构选择",
		        				content: $('#treeEditChange'),
		        				btn2: function(index, layero){
		        					//获取选中节点
	        	  					var nodes = $("#orgTreeChange").jstree(true).get_checked();//使用get_checked方法
	        	  					if(nodes.length==0){
	        	  						Hussar.info("请先选择上级组织机构！");
	        	  					}else{
		        					//确认按钮回调
		        					var saveTree =function(){
		        						
		        	  						$.ajax({
		        			    			url:"/orgMain/orgTreeChange",
		        			    			async:false,
		        			    			data:{
		        			    				orgId:orgId,
		        			    				orgType:orgType,
		        			    				parentId:nodes[0],
		        			    				isRoot:OrgMaintenance.isRootChange,
		        			    				changeLevel:OrgMaintenance.changeLevel
		        			    			},
		        			    			type:"POST",
		        			        		contentType:"application/x-www-form-urlencoded",
		        			        		success:function(data){
		        			        			if(data.success==true){
		        			        				OrgMaintenance.refreshTree();
			        			        			Hussar.success("转移成功！");
			        			        			layer.close(index);
		        			        			}else{
		        			        				Hussar.error("转移失败！（该转移不符合组织机构规则！）");	
		        			        			}
		        			        		},
		        			        		error:function(){
		        			        			Hussar.error("转移失败！");	
		        			        		}
		        			    			
		        			    		})
		        	  					
		        			    		
		        			    	}
		        			    	Hussar.confirm("确定要转移吗？", saveTree);
	        	  					
				                    layer.close(index);
	        	  					}
		        				 },
		        				success:function(){
		        					$.ajax({
			                            type: "POST",
			                            data:{
			                            	orgId:orgId
			                            },
			                            contentType:"application/x-www-form-urlencoded",
			                            url: "/orgMain/orgChangeById",
			                            dataType:"json",
			                            async: false,
			                            success:function(result) {
			                            	OrgMaintenance.selectId=orgId;
			                            	var arrays = [];
			    	                        for(var i=0; i<result.length; i++){
			    	                        	var arr = {
			    	                        			 id	:	result[i].ID,
			    	                        			 code:   result[i].CODE,
			    	                        			 text : result[i].TEXT,
			    	                                     parent : result[i].PARENT,
			    	                                     struLevel:result[i].STRULEVEL,
			    	                                     isLeaf:result[i].ISLEAF,
			    	                                     type:result[i].TYPE,
			    	                                     icon:result[i].ICON
			    	                        		}
			    	                        	arrays.push(arr);
			    	                        }
			    	                        result=arrays;
			                            	$("#orgTreeChange").jstree(true).settings.core.data = result;
			                            	$("#orgTreeChange").jstree(true).refresh();
			                            }
	
			                        });
		        				}
		        			});
	                    }
	                },
	                up:{
	                	label: "上移",
	                	icon : Hussar.ctxPath+"/static/assets/img/treeContext/511101.png",
	                	action: function (obj) {
	                		//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
	                		OrgMaintenance.singleMove(orgId, 'up');
	                	}
	                },
	                down:{
	                	label: "下移",
	                	icon : Hussar.ctxPath+"/static/assets/img/treeContext/511102.png",
	                	action: function (obj) {
	                		//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
	                		OrgMaintenance.singleMove(orgId, 'down');
	                	}
	                },
	                sort: {
	                    label: "下级排序",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/5111.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
				        	//选中组织编码
				        	var orgCode=clickedNode.original.code;
				        	//选中组织名称
				        	var orgName=clickedNode.text;
				        	//选中组织类型
				        	var orgType = clickedNode.original.struType;
				        	//选中组织机构层级
				        	var struLevel = clickedNode.original.struLevel;
				        	var length = clickedNode.parents.length;
				        	var isRoot;
				        	if(length>1){
				        		isRoot=false;
				        	}else{
				        		isRoot=true;
				        	}
				        	layer.open({
		        				type: 1,
		        				btn: ['关闭','确认'],
		        				skin: 'confirm-class',
		        				area: ['500px','400px'],
		        				fix: false, //不固定
		        				maxmin: true,
		        				shadeClose: false,
		        				shade: 0.4,
		        				title: "下级排序",
		        				content: $('#treeEditOrder'),
		        				btn2: function(index, layero){
		        					//确认按钮回调
		        					var saveTree =function(){
		        			    		$.ajax({
		        			    			url:"/orgMain/orgTreeOrder",
		        			    			async:false,
		        			    			data:{
		        			    				treeInfo:$("#output").val()
		        			    			},
		        			    			type:"POST",
		        			        		contentType:"application/x-www-form-urlencoded",
		        			        		success:function(data){
		        			        			OrgMaintenance.refreshTree();
		        			        			Hussar.success("保存成功！");
		        			        			OrgMaintenance.closeWindow();
		        			        		},
		        			        		error:function(){
		        			        			Hussar.error("保存失败！");	
		        			        		}
		        			    			
		        			    		})
		        			    	}
		        			    	Hussar.confirm("确定要保存排序吗？", saveTree);
				                    layer.close(index);
		        				 },
		        				success:function(){
		        					$.ajax({
			                            type: "POST",
			                            data:{
			                            	orgId:orgId,
			                            	isRoot:isRoot
			                            },
			                            contentType:"application/x-www-form-urlencoded",
			                            url: "/orgMain/orgTreeById",
			                            dataType:"json",
			                            async: false,
			                            success:function(result) {
			                            	var arrays = [];
			    	                        for(var i=0; i<result.length; i++){
			    	                        	var arr = {
			    	                        			 id	:	result[i].ID,
			    	                        			 code:   result[i].CODE,
			    	                        			 text : result[i].TEXT,
			    	                                     parent : result[i].PARENT,
			    	                                     struLevel:result[i].STRULEVEL,
			    	                                     struOrder:result[i].STRUORDER,
			    	                                     isLeaf:result[i].ISLEAF,
			    	                                     type:result[i].TYPE,
			    	                                     icon:result[i].ICON
			    	                        		}
			    	                        	arrays.push(arr);
			    	                        }
			    	                        result = arrays;
			                            	$("#orgTreeOrder").jstree(true).settings.core.data = result;
			                            	$("#orgTreeOrder").jstree(true).refresh();
			                            	//返回值在页面显示
			                            	var newResult=[];
			                            	for(var i=0;i<result.length;i++){
			                            		if(result[i].parent!="#"){
			                            			newResult.push(result[i]);
			                            		}
			                            		
			                            	}
			                            	$("#output").val(window.JSON.stringify(newResult));
			                            }
	
			                        });
		        				}
		        			});
	                    }
	                },
	                delete: {
	                    label: "删除",
	                    'icon' : Hussar.ctxPath+"/static/assets/img/treeContext/57.png",
	                    action: function (obj) {
	                    	//获取点击的节点信息
	                    	var inst = $.jstree.reference(obj.reference);
							var clickedNode = inst.get_node(obj.reference);
				        	//选中组织ID
				        	var orgId=clickedNode.id;
	                    	var delOrg =function(){
	                    		$.ajax({
	                    			url:"/orgMain/delOrgById",
	                    			async:false,
	                    			data:{
	                    				struId:orgId
	                    			},
	                    			type:"POST",
	                        		contentType:"application/x-www-form-urlencoded",
	                        		success:function(data){
	                        			if(data.success==true){
	                        				OrgMaintenance.refreshTree();
		                        			Hussar.success("删除成功！");
	                        			}else{
	                        				Hussar.error(data.msg);	
	                        			}
	                        			
	                        		},
	                        		error:function(){
	                        			Hussar.error("删除失败！");	
	                        		}
	                    			
	                    		})
	                    	}
	                    	Hussar.confirm("确定要删除吗？", delOrg);
	                    }
	                }
	           };
				var length = node.parents.length;
				if(length==1){
					delete items.change;  //删除节点 转移
					delete items.edit;  //删除节点 修改
					delete items.delete;  //删除节点 删除
				}
	           var child = node.children;
	           if(child.length==0){
	           	delete items.sort;  //删除节点 下级排序  
	           }
	           var id = node.id;
               var n = $("#"+id);
               if (n.index() == 0) {//非第一个
            	   delete items.up;  //删除节点 上移  
               }
               if (n.next().length == 0) {//非最后一个
            	   delete items.down;  //删除节点 上移 
               }
			return items; 
		
	}
    /**
     * 上移下移方法
     * @param id 组织机构id
     * @param direction 方向 'up' | 'down'
     */
	OrgMaintenance.singleMove = function(id, direction){
        var layerIndex = layer.open({type: 3});
        $.ajax({
            url:"/orgMain/singleMove",
            //async:false,
            data:{
                orgId: id,
                isUp: direction == 'up'
            },
            type:"POST",
            success:function(data){
                layer.close(layerIndex);
                OrgMaintenance.refreshTree();
            },
            error:function(){
                layer.close(layerIndex);
                Hussar.error("操作失败！");
            }
        });
    };
	/*初始化组织机构树*/
	OrgMaintenance.initTreeView = function(){
	    var $tree = $("#orgTree");
	    $tree.jstree({
	        core: {
	            check_callback: true,
	            data: function (obj, callback) {
	                var data;
	                $.ajax({
	                    type: "POST",
	                    data:{
	                    	isEmployee:""
	                    },
	                    url: "/orgMain/orgTree",
	                    contentType:"application/x-www-form-urlencoded",
	                    dataType:"json",
	                    async: false,
	                    success:function(result) {
	                    	var arrays = [];
	                        for(var i=0; i<result.length; i++){
	                        	var arr = {
	                        			 id	:	result[i].ID,
	                        			 code:   result[i].CODE,
	                        			 text : result[i].TEXT,
	                                     parent : result[i].PARENT,
	                                     struLevel:result[i].STRULEVEL,
	                                     struOrder:result[i].STRUORDER,
	                                     struType:result[i].STRUTYPE,
	                                     isLeaf:result[i].ISLEAF,
	                                     type:result[i].TYPE,
	                                     icon:result[i].ICON
	                        		}
	                        	arrays.push(arr);
	                        }
	                        data = arrays;
	                        $("#orgInfo").attr("src","")
	                    }
	
	                });
	                callback.call(this, data);
	            }
	        },
	        plugins: ['state', 'types', 'contextmenu'],
	        contextmenu: {
	            items: OrgMaintenance.menuList
	        },
	        types:icon
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
	    		var struId = currentNode.id;
	    		var parent = currentNode.parent;
	    		if(parent=="#"){
	    			$("#orgInfo").attr("src","")
	    		}else{
	    			$("#orgInfo").attr("src","/orgMain/orgInfo?struId=" + struId)
	    		}
	    		//OrgMaintenance。loadOrgInfo(struId)
		});
	}
	/*刷新组织机构树*/
	OrgMaintenance.refreshTree = function(){
		$("#orgTree").jstree(true).refresh();
	}
	/*初始化组织机构排序树*/
	OrgMaintenance.initOrderTreeView = function(){
	    //初始化数列表
	    var $tree = $("#orgTreeOrder");
	    $tree.data('jstree', false).empty();
	    $tree.jstree({
	        core: {
	            check_callback: function (operation, node, node_parent, node_position, more) {
	                //拖动排序时只允许同级拖动
	            	if(operation=='move_node'){
	                	if(node.parent==node_parent.parent||node_parent.parent==null){
	                    	return false;
	                    }else{
	                    	return true;
	                    }
	                }else{
	                	return true;
	                }
	            },
	            data: null
	        },
	        plugins: ['state', 'types',"dnd",'contextmenu'],
	        contextmenu: {
	            items: OrgMaintenance.menuList
	        },
	        sort:function(a,b){
	            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
	        },
	        types:icon
	    });
	    $tree.bind("activate_node.jstree", function (obj, e) {
			// 处理代码
			// 获取当前节点
				var currentNode = e.node;
				loadOrgInfo(22);
		});
	    //移动树事件
	    $tree.bind('move_node.jstree', function (e, data) {
	    	//移动的组织ID
	    	var id = data.node.id;
	    	//移动之前的位置
	    	var oldPosition = data.old_position;
	    	//移动后的位置
	    	var position = data.position;
	    	//原地未动
	    	if(oldPosition==position){
	    		return;
	    	}
	    	var oldResult = JSON.parse($("#output").val());
	    	//根据目前的位置对于树结果进行重新排序
	    	var newResult=[];
	    	//向上移动
	    	if(position-oldPosition<0){
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<position){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=oldPosition){
	            				oldResult[i].struOrder=i+2;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}else{//向下移动
	    		for(var i=0;i<oldResult.length;i++){
	        		if(i<oldPosition){
	        			oldResult[i].struOrder=i+1;
	        		}else{
	            		if(oldResult[i].id==id){
	            			oldResult[i].struOrder=position+1;
	            		}else{
	            			if(i<=position){
	            				oldResult[i].struOrder=i;
	            			}else{
	            				oldResult[i].struOrder=i+1;
	            			}
	            			
	            		}
	        		}
	        		
	        	}
	    	}
	    	oldResult.sort(OrgMaintenance.up);
	    	$("#output").val(window.JSON.stringify(oldResult));
	    });
		
	}
	
	/*初始化转移组织树*/
	OrgMaintenance.initChangeTreeView = function(){
		    //初始化数列表
		    var $tree = $("#orgTreeChange");
		    $tree.data('jstree', false).empty();
		    $tree.jstree({
		        plugins: ['state', 'types','checkbox'],
		        core: {
		            check_callback: true,
		            data: null,
			        multiple: false//单选
		        },
		        sort:function(a,b){
		            return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
		        },
		        checkbox: {
		            keep_selected_style : false,
		            three_state : false,
		            tie_selection : false
		        },
		        types:icon
		    });
		    $tree.bind("activate_node.jstree", function (obj, e) {
				// 处理代码
				// 获取当前节点
					var currentNode = e.node;
			});
		   $tree.on('check_node.jstree', function(event, obj) {
			   var currentNode = obj.node;
		   	   var menuName = obj.node.text;
              var ref =$tree.jstree(true);
              var nodes = ref.get_checked(); //使用get_checked方法
              var otherNode;
              otherNode="";
              //判断是否为相同节点，则不能移动
              if(OrgMaintenance.selectId==obj.node.id){
            	  ref.uncheck_node(obj.node.id);
            	  Hussar.info("不能转移到当前组织！");
      			  return;
              }
              //限制选择不能选择当前以及当前子节点
              if(nodes.length>0){
            	  $.each(currentNode.parents, function(i, nd) {
                		if(nd == OrgMaintenance.selectId){
                			ref.uncheck_node(obj.node.id);
                			Hussar.info("不能转移到当前组织！");
                			return false;
                		}
                	})
                  
              }
              //限制只能选一个
              if(nodes.length>1){
              	$.each(nodes, function(i, nd) {
              		if(nd != obj.node.id){
              			otherNode = nd;
              		}
              	})
              	ref.uncheck_node(otherNode);
              }
              var length = obj.node.parents.length;
              //判断选择几点是否为根节点
              if(length==1){
            	  OrgMaintenance.isRootChange='1';
              }else{
            	  OrgMaintenance.isRootChange='0';
              }
              OrgMaintenance.changeLevel = obj.node.original.struLevel;
              
          });
		}
	/*初始化按钮事件*/
	OrgMaintenance.initButtonEvent = function(){
	    /*排序树保存*/
	    $("#treeBtnSave").click(function(){
	    	var saveTree =function(){
	    		$.ajax({
	    			url:"/orgMain/orgTreeOrder",
	    			async:false,
	    			data:{
	    				treeInfo:$("#output").val()
	    			},
	    			type:"POST",
	        		contentType:"application/x-www-form-urlencoded",
	        		success:function(data){
	        			OrgMaintenance.refreshTree();
	        			Hussar.success("保存成功!");
	        			OrgMaintenance.closeWindow();
	        		},
	        		error:function(){
	        			Hussar.error("保存失败!");	
	        		}
	    			
	    		})
	    	}
	    	Hussar.confirm("确定要保存排序吗?", saveTree);
	    });
	    /*排序树重置*/
	    $("#treeBtnReset").click(function(){
	    	OrgMaintenance.closeWindow();
	    });
	    
		
	}
	/*根据组织机构ID展示组织机构信息*/
	OrgMaintenance.loadOrgInfo=function(id){
		$("#orgInfo").attr("src","/orgMain/orgInfo?struId=" + id)
	}
	/*增加下级*/
	OrgMaintenance.addOrgInfo=function(){
		var data = $("#orgTypeSelect").serialize();
		if(data==null ||data==""){
			Hussar.info("请先选择下级类型！");
			return false;
		}
		 layer.close(OrgMaintenance.infoWin);
		//上级组织机构类型
		var parentType = $("#parentType").val();
		//获取选中的组织类型
		var orgType = "";
		var orgTypeName = '';
		var orgTypes = $("input[name='orgType']");
		for(var i=0; i<orgTypes.length; i++){
				if(orgTypes[i].checked == true){
					orgType = orgTypes[i].value;
					orgTypeName = orgTypes[i].title;
				};
		}
		//获取上级组织机构ID
		var orgParentId = $("#orgParentId").val();
		//获取上级组织机构编码
		var orgParentCode = $("#orgParentCode").val();
		//获取上级组织机构名称
		var orgParentName = $("#orgParentName").val();
		//获取上级组织机构所在层级
		var struLevel = $("#struLevel").val();
		//获取上级组织机构子节点数量
		var childNum = $("#childNum").val();
		//不同组织机构类型编码(用户构建下级组织机构编码)
		var parentTypeCode = $("#parentTypeCode").val();
		$("#orgInfo").attr("src","/orgMain/orgInfoAdd?orgParentId="+orgParentId+"&orgType="+orgType+"&childNum="+childNum+"&orgTypeName="+orgTypeName);
		return true;
	}
	/*排序*/
	OrgMaintenance.up=function(x,y){
		return x.struOrder-y.struOrder
	}
	/*关闭弹窗*/
	OrgMaintenance.closeWindow=function () {
	    layer.close(OrgMaintenance.infoWin);
	};
	OrgMaintenance.initFrameHeight=function(){
		var h = $(window).height()-3;
		$("#orgInfo").css("height", h + "px");
		$("#orgTree").css("height", h + "px");
		
	}

	$(function () {
		OrgMaintenance.initPage();
		$(window).resize(function() {
			OrgMaintenance.initFrameHeight();
		});
	});
});