/**
 * @Description: 组织机构修改
 * @Author: sunZengXin
 * @Date: 2018/2/6.
 */
layui.use(['jquery','layer','Hussar','form', 'laydate','table'], function(){
	var form=layui.form,
		laydate = layui.laydate,
		$ = layui.jquery,
		Hussar = layui.Hussar,
		table = layui.table;
	  //日期
	  laydate.render({
	    elem: '#beginDate'
	  });
	  laydate.render({
	    elem: '#endDate'
	  });
	//监听提交
	  form.on('submit(orgInfoEdit)', function(data){
		  var formData = data.field;
		  if(formData.beginDate>formData.endDate){
			  Hussar.info("失效日期不能早于生效日期！");
			  return false;
		  }
		  $.ajax({
				type:"POST",
				contentType:"application/x-www-form-urlencoded",
				url:"/orgMain/orgInfoEditSave",
				data:formData,
				async:false,
				success:function(data){
					Hussar.success("保存成功!");
					//刷新父页面
					parent.location.reload();
				},
				error:function(){
					Hussar.error("保存失败!");			
				}
			})
	    return false;
	  });
	  
	//负责人选择
	$("#principalName").click(function(){
		layer.open({
			type: 1,
			btn: ['关闭','确认'],
			skin: 'confirm-class',
			area: ['85%', '90%'], //宽高
			fix: false, //不固定
			maxmin: false,
			shadeClose: false,
			shade: 0.4,
			title: "选择负责人",
			content: $("#principalDiv"),
			btn2: function(index, layero){
				var checkRadioStatus =  table.checkRadioStatus("principalReload");
				if(checkRadioStatus.data.length==0){
						Hussar.info("请选择一条记录！");
						return false;
				}
				var data = checkRadioStatus.data[0];
				$("#principalName").val(data.USERNAME);
				$("#principalId").val(data.USERID);
				layer.close(index);
			 },
			success:function(){
				table.render({
				    elem: '#principal'
				    ,url:'/orgMain/principalSelect'
				    ,request: {
				    		  pageName: 'curr' //页码的参数名称，默认：page
				    		  ,limitName: 'nums' //每页数据量的参数名，默认：limit
				    		},
				    height: 'full-210',
				    method:"post"
				    ,cols: [[
				      { type : 'radio', align : 'center',width:50},
				      {title : '序号', type : 'numbers', align : 'center',width:50},
				      {field:'USERNAME', align : 'center',width:100, title: '姓名'}
				      ,{field:'DEPARTMENTNAME', title: '所属部门'}
				    ]]
				  ,page: true
				  ,id:"principalReload"
				 });
				
			}
		});
	})
	$('#search').on('click', function() {
		var userName = $('#userName').val();
		var departmentName = $('#departmentName').val();
		// 执行重载
		table.reload('principalReload', {
			page : {
				curr : 1
			// 重新从第 1 页开始
			},
			where : {
				userName : userName,
				departmentName : departmentName
			}
		});
	});
});