(function() {
    $(document).ready(function() {
        gridView.initPage();
    });
    window.operateEvents = {
     'click .RoleOfedit': function(e, value, row, index) {
        var rows = row;
                infoWin = $("#viewEvent").createLayerWindow({
                    type: 1,
                    title: "数据字典修改",
                    shadeClose: false,
                    shade: true,
                    maxmin: false, //开启最大化最小化按钮
                    area: ["500px", "350px"],
                    success: function () {
                    	//重置form
                        $("#typeForm").formReset();
                    	$("#type2").val(rows.type);
                    	$("#key2").val(rows.key);
                    	$("#value2").val(rows.value);
                    	$("#sort2").val(rows.sort);
                    	$(":radio[name='status2'][value='" + rows.status + "']").prop("checked", "checked");
                    	$("#mark2").val(rows.mark);
                    }
                });
     /*   var checkView = $("#workStatus").val();
        if(checkView=='view'){
        	$("#btnSave").hide();
        	$("#type1").attr("disabled","disabled");
        	$("#key").attr("disabled","disabled");
        	$("#value").attr("disabled","disabled");
        	$("#sort").attr("disabled","disabled");
        	$("input[name='status']").attr("disabled","disabled");
        	$("#mark").attr("disabled","disabled");
        	$("#workStatus").val("");
        }*/
     }
   };
   function operateFormatter(value, row, index) {
   return [
   '<a href="#" class="RoleOfedit">'+value+'</a>',
   ].join('');
 }
    var gridView ={
        /**
         * parameter
         */
        gridColumns: [
            [
                {
                    checkbox: true
                },
                {
                    field: 'id',
                    title: 'id',
                    visible: false
                },
                {
                    field: 'number',
                    title: '序号',
                    align:'center',
                    formatter: function (value, row, index) {
                        return index+1;
                    }
                },
                {
                    field: 'type',
                    title: '字典分类',
                    align:'center'
                },
                {
                    field: 'key',
                    title: '键',
                    align:'center',
                    events: operateEvents,
                    formatter: operateFormatter
                    },{
                    field: 'value',
                    title: '值',
                    align:'center'
                },{
                    field: 'sort',
                    title: '顺序',
                    align:'center'
                },{
                    field: 'status',
                    title: '是否启用',
                    align:'center',
                    formatter : function (value, row, index) {
                if (row.status == 0) {
                    return '是';
                }
                if (row['status'] == 1) {
                    return '否';
                }
                return value;
                }
                },{
                    field: 'mark',
                    title: '备注',
                    align:'center'
                }
            ]
        ],
        $table: $('#typeTable'),
        /*初始化页面*/
        initPage: function() {
            var that = this;
            //初始化表格
            that.initTableView();
            //初始化树列表
            that.initTreeView();
            that.initButtonEvent();
        },
        initTableView:function(){
            var self = this;
            self.$table.bootstrapTable({
                method: 'post',
                cache: false,
                striped: true, //是否显示行间隔色
                sidePagination: "client", //分页方式：client客户端分页，server服务端分页（*）
                url: "json/dataManagement.json",
                height: $(".frameBody").height() - $(".searchBox").outerHeight(true),
                showColumns: false,
                queryParams: self.queryParams,
                pagination: true,
                sortable: true,
                sortOrder: "desc",     //排序方式
                clickToSelect: true,    //是否启用点击选中行
                minimumCountColumns: 2,
                pageNumber: 1, //初始化加载第一页，默认第一页
                pageSize: 2, //每页的记录行数（*）
                pageList: [2,10,15,20,50], //可供选择的每页的行数（*）
                uniqueId: "id", //每一行的唯一标识，一般为主键列
                showExport: false,
                exportDataType: 'all',
                columns: self.gridColumns
            });
        },
        queryParams: function () {
            var type =$('#type').val();
            var temp = {
                pageSize: this.pageSize,   //页面大小
                pageNumber: this.pageNumber, //页码
                type:type
            };
            return temp;
        },
        initButtonEvent:function(){
            var that = this;
            var infoWin;
            /*查询*/
            $("#search").click(function searcha() {
                $('#typeTable').bootstrapTable('destroy');
                that.initTableView();
            });

            /*新增*/
            $("#add").click(function(){
                that.addForm();
            });


            /*修改*/
            $('#edit').click(function(){
                that.editForm();
            });

            /*删除*/
            $('#del').click(function(){
                that.delForm();
            });

            /*保存*/
            $("#btnSave").click(function () {
                that.saveForm();
            });

            /*关闭*/
            $("#btnClose").click(function () {
                that.closeWindow();
            });


        },
        addForm:function () {
            var that = this;
            $("#workStatus").val("add");
            infoWin = $("#addEvent").createLayerWindow({
                type: 1,
                title : "数据字典新增",
                shadeClose: false,
                shade: true,
                maxmin: false, //开启最大化最小化按钮
                area: ['500px', '350px'],
                success:function(){
                    //重置form
                    $("#typeForm").formReset();
                }
            });
        },
        editForm:function () {
            var that = this;
            $("#workStatus").val("edit");
            //获取列表选择的记录
            var rows = $("#typeTable").bootstrapTable('getSelections');
            if(rows.length<=0){
                $.showInforDlg("提示","请选择一条修改的记录", 0);
            }else if(rows.length > 1){
                $.showInforDlg("提示","请选择一条修改的记录", 0);
            }else{
                infoWin = $("#addEvent").createLayerWindow({
                    type: 1,
                    title: "数据字典修改",
                    shadeClose: false,
                    shade: true,
                    maxmin: false, //开启最大化最小化按钮
                    area: ["500px", "350px"],
                    success: function () {
                    	//重置form
                        $("#typeForm").formReset();
                    	$("#type1").val(rows[0].type);
                    	$("#key").val(rows[0].key);
                    	$("#value").val(rows[0].value);
                    	$("#sort").val(rows[0].sort);
                    	$(":radio[name='status'][value='" + rows[0].status + "']").prop("checked", "checked");
                    	$("#mark").val(rows[0].mark);
                    }
                });
            }
        },
        delForm:function () {
            var that = this;
            var rows = $('#typeTable') .bootstrapTable('getAllSelections');
            var ids = [];
            if(rows.length == 0){
                $.showInforDlg("提示","请选择要删除的记录", 0);
            }else{
                layer.confirm('确认删除吗?', { icon: 3,title:'提示'}, function(index){
                    for (var i = 0, l = rows.length; i < l; i++) {
                        var r = rows[i];
                        ids.push(r.id);
                    }
                    var eId = ids.join(',');
                    $.ajax({
                        traditional:true,//这使json格式的字符不会被转码
                        data: {eId:eId},
                        async : false,
                        type: "post",
                        url: "",
                        success: function(data){
                            $('#typeTable').bootstrapTable('destroy');
                            that.initTableView();
                            if(data == "success"){
                                $.showInforDlg("提示","删除成功", 0);
                            }else{
                                $.showInforDlg("提示","删除失败", 0);
                            }
                        }
                    });
                    layer.close(index);
                });
            }
        },
        saveForm:function () {
            var that = this;
            var status = $("#workStatus").val();
            if(status == "add"){
                $.ajax({
                    type: "post",
                    url: "",
                    async : false,
                    data:{},
                    success: function(data){
                        if(data == "success"){
                            $.showInforDlg("操作提示","保存成功！", 0);
                            $('#typeTable').bootstrapTable('destroy');
                            that.initTableView();
                        }else{
                            $.showInforDlg("操作提示","保存失败！", 0);
                        }
                        layer.close(infoWin);
                    },
                    error:function () {
                        $.showInforDlg("操作提示","保存失败！", 0);
                        layer.close(infoWin);
                    }
                });
            }else if(status == "edit"){
                $.ajax({
                    type: "post",
                    url: "",
                    async : false,
                    data:{},
                    success: function(data){
                        if(data == "success"){
                            $.showInforDlg("操作提示","修改成功！", 0);
                            $('#typeTable').bootstrapTable('destroy');
                            that.initTableView();
                        }else{
                            $.showInforDlg("操作提示","修改失败！", 0);
                        }
                        layer.close(infoWin);
                    },
                    error:function () {
                        $.showInforDlg("操作提示","修改失败！", 0);
                        layer.close(infoWin);
                    }
                });
            }
        },
        initTreeView:function () {
            //初始化数列表
            var $tree = $("#orgTree");
            $tree.jstree({
                core: {
                    check_callback: true,
                    data: function (obj, callback) {
                        var data;
                        $.ajax({
                            type: "POST",
                            url: "/dataManager/dataTree",
                            dataType:"json",
                            async: false,
                            success:function(result) {
                                data = result
                            }

                        });
                        callback.call(this, data);
                    }
                },
                plugins: ['state','types','contextmenu'],
                contextmenu: {
                    items: {
                        create: null,
                        remove: null,
                        ccp: null,
                        show: {
                            label: "显示机构信息",
                            action: function (obj) {
                                alert(1);
                            }
                        },
                        add: {
                            label: "增加下级",
                            action: function (obj) {
                                alert(2);
                            }
                        },
                        sort: {
                            label: "下级排序",
                            action: function (obj) {
                                alert(3);
                            }
                        },
                        edit: {
                            label: "修改",
                            action: function (obj) {
                                alert(4);
                            }
                        },
                        delete: {
                            label: "撤销",
                            action: function (obj) {
                                alert(5);
                            }
                        }
                    }
                }
            });
        },
        closeWindow:function () {
            layer.close(infoWin);
        }
        
    }
})(this);