/**
 * @Description: 缓存管理
 * @Author: szx
 * @Date: 2018/2/6.
 */
var infoWin;
function viewCache(id){
	infoWin = $("#addEvent").createLayerWindow({
            type: 1,
            title : "缓存明细",
            shadeClose: false,
            shade: true,
            maxmin: false, //开启最大化最小化按钮
            area: ['480px', '450px'],
            success:function(){
                //重置form
                $("#typeForm").formReset();
            }
            });
	};
(function() {
    $(document).ready(function() {
        gridView.initPage();
    });
    var gridView ={
        /**
         * parameter
         */
        gridColumns: [
            [
                {
                    checkbox: true
                },
                {
                    field: 'id',
                    title: 'id',
                    visible: false
                },
                {
                    field: 'number',
                    title: '序号',
                    align:'center',
                    formatter: function (value, row, index) {
                        return index+1;
                    }
                },
                {
                    field: 'cacheGroup',
                    title: '缓存组名',
                    align:'center'
                },{
                    field: 'cacheName',
                    title: '缓存名称',
                    align:'center',
                    formatter: function (value, row, index) {
                        return "<a href='javascript:void(0);' onclick='viewCache("+row.id+")'>"+ value +"</a>";
                    }
                },{
                    field: 'cacheHits',
                    title: '命中次数',
                    align:'center'
                },{
                    field: 'cacheMisses',
                    title: '失误次数',
                    align:'center'
                },{
                    field: 'memoryMaxSize',
                    title: '缓存最大容量',
                    align:'center'
                },{
                    field: 'memoryStoreSize',
                    title: '缓存已用容量',
                    align:'center'
                }
            ]
        ],
        $table: $('#typeTable'),
        /*初始化页面*/
        initPage: function() {
            var that = this;
            //初始化表格
            that.initTableView();
            that.initButtonEvent();
        },
        initTableView:function(){
            var self = this;
            self.$table.bootstrapTable({
                method: 'post',
                cache: false,
                striped: true, //是否显示行间隔色
                sidePagination: "client", //分页方式：client客户端分页，server服务端分页（*）
                url: 'json/cacheManager.json',
                height: $(".frameBody").height() - $(".searchBox").outerHeight(true),
                showColumns: false,
                queryParams: self.queryParams,
                pagination: true,
                sortable: true,
                sortOrder: "desc",     //排序方式
                clickToSelect: true,    //是否启用点击选中行
                minimumCountColumns: 2,
                pageNumber: 1, //初始化加载第一页，默认第一页
                pageSize: 10, //每页的记录行数（*）
                pageList: [10, 15, 20, 50], //可供选择的每页的行数（*）
                uniqueId: "id", //每一行的唯一标识，一般为主键列
                showExport: false,
                exportDataType: 'all',
                columns: self.gridColumns
            });
        },
        queryParams: function () {
            var orgType =$('#orgType').val();
            var orgName =$('#orgName').val();
            var parentType =$('#parentType').val();
            var temp = {
                pageSize: this.pageSize,   //页面大小
                pageNumber: this.pageNumber, //页码
                orgType:orgType,
                orgName:orgName,
                parentType:parentType
            };
            return temp;
        },
        initButtonEvent:function(){
            var that = this;
            /*查询*/
            $("#search").click(function searcha() {
                $('#typeTable').bootstrapTable('destroy');
                that.initTableView();
            });
            /*缓存清理*/
            $('#cache_del').click(function(){
                that.delCache();
            });

            /*清空*/
            $("#cacheClear").click(function () {
                that.formDelCache();
            });
			/*清空当前缓存所在组的缓存*/
			$("#groupClear").click(function () {
                that.delGroupCache();
            });
            /*返回*/
            $("#cacheClose").click(function () {
                that.closeWindow();
            });


        },
        formDelCache:function () {
            var that = this;
            var key = $("#cacheKey").val();
            layer.confirm('确认要清空所选缓存吗?此操作不可恢复!', {icon: 3,title:'提示'}, function(index){
                $.ajax({
                    traditional:true,//这使json格式的字符不会被转码
                    data: {eId:key},
                    async : false,
                    type: "post",
                    url: "",
                    success: function(data){
                        $('#typeTable').bootstrapTable('destroy');
                        that.initTableView();
                        if(data == "success"){
                            $.showInforDlg("提示","删除成功", 0);
                        }else{
                            $.showInforDlg("提示","删除失败", 0);
                        }
                    }
                });
                layer.close(index);
            });
        },
        delGroupCache:function () {
            var that = this;
            var key = $("#cacheKey").val();
            layer.confirm('确认要清空所选缓存吗?此操作不可恢复!', { icon: 3,title:'提示'}, function(index){
                $.ajax({
                    traditional:true,//这使json格式的字符不会被转码
                    data: {eId:key},
                    async : false,
                    type: "post",
                    url: "",
                    success: function(data){
                        $('#typeTable').bootstrapTable('destroy');
                        that.initTableView();
                        if(data == "success"){
                            $.showInforDlg("提示","删除成功", 0);
                        }else{
                            $.showInforDlg("提示","删除失败", 0);
                        }
                    }
                });
                layer.close(index);
            });
        },
        delCache:function () {
            var that = this;
            var rows = $('#typeTable') .bootstrapTable('getAllSelections');
            var ids = [];
            if(rows.length == 0){
                $.showInforDlg("提示","请选择要删除的记录", 0);
            }else{
                layer.confirm('确认删除吗?', {icon: 3,title:'提示'}, function(index){
                    for (var i = 0, l = rows.length; i < l; i++) {
                        var r = rows[i];
                        ids.push(r.id);
                    }
                    var eId = ids.join(',');
                    $.ajax({
                        traditional:true,//这使json格式的字符不会被转码
                        data: {eId:eId},
                        async : false,
                        type: "post",
                        url: "",
                        success: function(data){
                            $('#typeTable').bootstrapTable('destroy');
                            that.initTableView();
                            if(data == "success"){
                                $.showInforDlg("提示","删除成功", 0);
                            }else{
                                $.showInforDlg("提示","删除失败", 0);
                            }
                        }
                    });
                    layer.close(index);
                });
            }
        },
        closeWindow:function () {
            layer.close(infoWin);
        }
    }

})(this);