/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sign.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.sign.service.SignService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryDto;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import sun.swing.SwingUtilities2;

@Service
public class SignServiceImpl
implements SignService {
    private static Logger logger = LoggerFactory.getLogger(SignServiceImpl.class);

    public void getSign(String taskId, String userName, String tenantCode, HttpServletResponse response) {
        String taskCode = this.getTaskCode(taskId, tenantCode);
        byte[] ret = new byte[]{};
        ret = SignServiceImpl.getImage(userName, taskCode);
        try {
            int len;
            response.setContentType("image/png");
            ServletOutputStream output = response.getOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(ret);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                output.write(buf, 0, len);
            }
            output.flush();
            output.close();
        }
        catch (Exception e1) {
            logger.error("system.ProcessServiceImpl.getProcess error {}" + e1);
        }
    }

    private String getTaskCode(String taskId, String tenantCode) {
        String taskCode = "";
        TaskQueryDto taskQueryDto = new TaskQueryDto();
        taskQueryDto.setTaskId(taskId);
        ApiResponse res = TaskEngineService.queryTaskByTaskId((TaskQueryDto)taskQueryDto);
        Map map = (Map)res.getData();
        if (MapUtils.isNotEmpty((Map)map)) {
            taskCode = String.valueOf(map.get("approvalNumber"));
        }
        return taskCode;
    }

    private static byte[] getImage(String userName, String Identifycode) {
        try {
            int width = 100;
            int height = 50;
            int fontSize = 35;
            ClassPathResource classPathResource = new ClassPathResource("font/simsun.ttf");
            InputStream inputStream = null;
            try {
                inputStream = classPathResource.getInputStream();
            }
            catch (Exception e) {
                e.getMessage();
            }
            Font dynamicFont = null;
            try {
                dynamicFont = Font.createFont(0, inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Font font = dynamicFont.deriveFont(0, fontSize);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D g1 = (Graphics2D)bi.getGraphics();
            g1.setBackground(null);
            g1.clearRect(0, 0, width, height);
            g1.setFont(font);
            g1.setPaint(new Color(0, 0, 0));
            g1.setComposite(AlphaComposite.getInstance(10, 0.9f));
            g1.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            SignServiceImpl.printString(g1, userName, (width - userName.length() * fontSize) / 2 + 0, (height - fontSize) / 2 + 23, fontSize);
            SignServiceImpl.printStringIdentifycode(g1, Identifycode, 15, 47, 6);
            g1.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void printString(Graphics2D g2d, String str, int x, int y, int fontSize) {
        FontMetrics metrics = SwingUtilities2.getFontMetrics(null, g2d.getFont());
        for (char ca : str.toCharArray()) {
            int px = metrics.stringWidth("" + ca);
            g2d.drawString("" + ca, x + (fontSize - px) / 2, y);
            x += fontSize;
        }
    }

    private static void printStringIdentifycode(Graphics2D g2d, String str, int x, int y, int fontSize) {
        Font font = new Font("\u5b8b\u4f53", 0, 13);
        g2d.setFont(font);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(null, g2d.getFont());
        for (char ca : str.toCharArray()) {
            int px = metrics.stringWidth("" + ca);
            g2d.drawString("" + ca, x + (fontSize - px) / 2, y);
            x += fontSize;
        }
    }
}

