/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class JobFileUtil {
    private static final String fileSeparator = System.getProperty("file.separator");

    public static List<String> getClassName(String packageName) {
        return JobFileUtil.getClassName(packageName, true);
    }

    public static List<String> getClassName(String packageName, boolean childPackage) {
        String type;
        String packagePath;
        List<String> fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null && "file".equals(type = url.getProtocol())) {
            fileNames = JobFileUtil.getClassNameByFile(url.getPath(), null, childPackage);
        }
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        ArrayList<String> classNames = new ArrayList<String>();
        File file = new File(filePath);
        File[] childFiles = file.listFiles();
        if (ToolUtil.isEmpty((Object)childFiles)) {
            return classNames;
        }
        for (File childFile : childFiles) {
            int index;
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                classNames.addAll(JobFileUtil.getClassNameByFile(childFile.getPath(), classNames, childPackage));
                continue;
            }
            String classesSeparator = "classes" + fileSeparator;
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class") || (index = childFilePath.lastIndexOf(classesSeparator)) == -1) continue;
            childFilePath = childFilePath.substring(index + classesSeparator.length(), childFilePath.length() - 6);
            childFilePath = childFilePath.replace(fileSeparator, ".");
            classNames.add(childFilePath);
        }
        return classNames;
    }
}

