/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.rest.config;

import com.jxdinfo.hussar.config.properties.RestProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.rest.auth.filter.RestAuthFilter;
import com.jxdinfo.hussar.rest.auth.security.DataSecurityAction;
import com.jxdinfo.hussar.rest.auth.security.impl.Base64SecurityAction;
import com.jxdinfo.hussar.rest.config.condition.RestCondition;
import java.util.Collection;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RestConfig {
    @Autowired
    RestProperties restProperties;

    @Bean
    @Conditional(value={RestCondition.class})
    public RestAuthFilter jwtAuthenticationTokenFilter() {
        return new RestAuthFilter();
    }

    @Bean
    @Conditional(value={RestCondition.class})
    FilterRegistrationBean filterRegistrationBean() {
        RestAuthFilter bean = (RestAuthFilter)((Object)SpringContextHolder.getBean(RestAuthFilter.class));
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)bean);
        registration.setUrlPatterns((Collection)this.restProperties.getUrlPattern());
        registration.setName("myFilter");
        return registration;
    }

    @Bean
    public DataSecurityAction dataSecurityAction() {
        return new Base64SecurityAction();
    }
}

