/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.rest.auth.util;

import com.jxdinfo.hussar.config.properties.JwtProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtil {
    @Autowired
    private JwtProperties jwtProperties;

    public String getUsernameFromToken(String token) {
        return this.getClaimFromToken(token).getSubject();
    }

    public Date getIssuedAtDateFromToken(String token) {
        return this.getClaimFromToken(token).getIssuedAt();
    }

    public Date getExpirationDateFromToken(String token) {
        return this.getClaimFromToken(token).getExpiration();
    }

    public String getAudienceFromToken(String token) {
        return this.getClaimFromToken(token).getAudience();
    }

    public String getPrivateClaimFromToken(String token, String key) {
        return this.getClaimFromToken(token).get((Object)key).toString();
    }

    public String getMd5KeyFromToken(String token) {
        return this.getPrivateClaimFromToken(token, this.jwtProperties.getMd5Key());
    }

    public Claims getClaimFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.jwtProperties.getSecret()).parseClaimsJws(token).getBody();
    }

    public void parseToken(String token) throws JwtException {
        Jwts.parser().setSigningKey(this.jwtProperties.getSecret()).parseClaimsJws(token).getBody();
    }

    public Boolean isTokenExpired(String token) {
        try {
            Date expiration = this.getExpirationDateFromToken(token);
            return expiration.before(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        catch (ExpiredJwtException expiredJwtException) {
            return true;
        }
    }

    public String generateToken(String userName, String randomKey) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(this.jwtProperties.getMd5Key(), randomKey);
        return this.doGenerateToken(claims, userName);
    }

    private String doGenerateToken(Map<String, Object> claims, String subject) {
        Date createdDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date expirationDate = new Date(createdDate.getTime() + this.jwtProperties.getExpiration() * 1000L);
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, this.jwtProperties.getSecret()).compact();
    }

    public String getRandomKey() {
        return ToolUtil.getRandomString((int)6);
    }
}

