/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.rest.auth.controller;

import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.rest.auth.controller.dto.AuthRequest;
import com.jxdinfo.hussar.rest.auth.util.JwtTokenUtil;
import com.jxdinfo.hussar.rest.auth.validator.IReqValidator;
import com.jxdinfo.hussar.rest.bsp.service.SysInterfaceRestService;
import com.jxdinfo.hussar.rest.common.exception.BizExceptionEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="AuthController", description="\u7528\u6237\u9a8c\u8bc1\u83b7\u53d6\u9a8c\u8bc1\u4ee4\u724c")
public class AuthController {
    @Autowired
    private JwtTokenUtil jwtTokenUtil;
    @Resource
    private IReqValidator reqValidator;
    @Resource
    private SysInterfaceRestService sysInterfaceRestService;

    @RequestMapping(value={"${hussar.jwt.auth-path}"})
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u4ee4\u724c", notes="\u83b7\u53d6\u9a8c\u8bc1\u4ee4\u724c", httpMethod="GET", produces="application/json;charset=UTF-8")
    public ApiResponse<?> createAuthenticationToken(AuthRequest authRequest) {
        boolean validate = this.reqValidator.validate(authRequest);
        if (validate) {
            String randomKey = this.jwtTokenUtil.getRandomKey();
            String token = this.jwtTokenUtil.generateToken(authRequest.getUserName(), randomKey);
            Date issuedAtDate = this.jwtTokenUtil.getIssuedAtDateFromToken(token);
            Date expirationDate = this.jwtTokenUtil.getExpirationDateFromToken(token);
            String userName = this.jwtTokenUtil.getUsernameFromToken(token);
            this.sysInterfaceRestService.updateInterfaceUser(userName, issuedAtDate, expirationDate, token);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("token", token);
            result.put("expirationDate", expirationDate);
            return ApiResponse.data(result);
        }
        return ApiResponse.fail((int)BizExceptionEnum.AUTH_REQUEST_ERROR.getCode(), (String)BizExceptionEnum.AUTH_REQUEST_ERROR.getMessage());
    }
}

