/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.rest.auth.filter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.config.properties.JwtProperties;
import com.jxdinfo.hussar.config.properties.RestProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.util.RenderUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.rest.auth.util.JwtTokenUtil;
import com.jxdinfo.hussar.rest.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.rest.common.persistence.dao.SysInterfaceUserRestMapper;
import com.jxdinfo.hussar.rest.common.persistence.model.SysInterfaceUserRest;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.OncePerRequestFilter;

public class RestAuthFilter
extends OncePerRequestFilter {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Autowired
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    private JwtProperties jwtProperties;
    @Autowired
    private RestProperties restProperties;
    @Autowired
    SysInterfaceUserRestMapper sysInterfaceUserRestMapper;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        SysInterfaceUserRest sysInterfaceUserRest;
        block6: {
            String requestHeader = request.getHeader(this.jwtProperties.getHeader());
            String authToken = null;
            sysInterfaceUserRest = null;
            if (ToolUtil.isNotEmpty((Object)requestHeader) && requestHeader.startsWith(this.restProperties.getTokenHeaderCode())) {
                authToken = requestHeader.substring(this.restProperties.getTokenHeaderCode().length());
                sysInterfaceUserRest = (SysInterfaceUserRest)((Object)this.sysInterfaceUserRestMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"token_value", (Object)authToken)));
                try {
                    if (ToolUtil.isEmpty((Object)((Object)sysInterfaceUserRest))) {
                        RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_NOT_EXIST.getCode().intValue(), BizExceptionEnum.TOKEN_NOT_EXIST.getMessage()));
                        return;
                    }
                    boolean flag = this.jwtTokenUtil.isTokenExpired(authToken);
                    if (flag) {
                        RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_EXPIRED.getCode().intValue(), BizExceptionEnum.TOKEN_EXPIRED.getMessage()));
                        return;
                    }
                    break block6;
                }
                catch (JwtException e) {
                    RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_ERROR.getCode().intValue(), BizExceptionEnum.TOKEN_ERROR.getMessage()));
                    return;
                }
            }
            RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_ERROR.getCode().intValue(), BizExceptionEnum.TOKEN_ERROR.getMessage()));
            return;
        }
        if (ToolUtil.isNotEmpty((Object)((Object)sysInterfaceUserRest))) {
            BigDecimal connectNum = sysInterfaceUserRest.getConnectNum();
            BigDecimal addCount = new BigDecimal("1");
            BigDecimal result = connectNum.add(addCount);
            sysInterfaceUserRest.setConnectNum(result);
            this.sysInterfaceUserRestMapper.updateById((Object)sysInterfaceUserRest);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

