/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.rest.auth.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.jxdinfo.hussar.config.properties.JwtProperties;
import com.jxdinfo.hussar.config.properties.RestProperties;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.rest.auth.converter.BaseTransferEntity;
import com.jxdinfo.hussar.rest.auth.security.DataSecurityAction;
import com.jxdinfo.hussar.rest.auth.util.JwtTokenUtil;
import com.jxdinfo.hussar.rest.common.exception.BizExceptionEnum;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class WithSignMessageConverter
extends FastJsonHttpMessageConverter {
    @Autowired
    JwtProperties jwtProperties;
    @Autowired
    JwtTokenUtil jwtTokenUtil;
    @Autowired
    DataSecurityAction dataSecurityAction;
    @Autowired
    private RestProperties restProperties;

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream in = inputMessage.getBody();
        Object o = JSON.parseObject((InputStream)in, (Charset)super.getFastJsonConfig().getCharset(), BaseTransferEntity.class, (Feature[])super.getFastJsonConfig().getFeatures());
        BaseTransferEntity baseTransferEntity = (BaseTransferEntity)o;
        String token = HttpKit.getRequest().getHeader(this.jwtProperties.getHeader()).substring(7);
        String md5KeyFromToken = this.jwtTokenUtil.getMd5KeyFromToken(token);
        String object = baseTransferEntity.getObject();
        String json = this.dataSecurityAction.unlock(object);
        String encrypt = MD5Util.encrypt((String)(object + md5KeyFromToken));
        if (!encrypt.equals(baseTransferEntity.getSign())) {
            System.out.println("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25,\u6570\u636e\u88ab\u6539\u52a8\u8fc7!");
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SIGN_ERROR);
        }
        System.out.println("\u7b7e\u540d\u6821\u9a8c\u6210\u529f!");
        return JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
    }
}

