/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.reportsnapshot.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.application.enums.StorageTypeEnum;
import com.jxdinfo.hussar.application.excel.Vo.IStyleData;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.excel.service.IExcelExporterService;
import com.jxdinfo.hussar.application.excel.service.IExcelImportService;
import com.jxdinfo.hussar.application.reportsnapshot.Vo.SnapShotVo;
import com.jxdinfo.hussar.application.reportsnapshot.dao.SysReportSnapshotMapper;
import com.jxdinfo.hussar.application.reportsnapshot.model.ReportSnapshotDocument;
import com.jxdinfo.hussar.application.reportsnapshot.model.SysReportSnapshot;
import com.jxdinfo.hussar.application.reportsnapshot.service.ISysReportSnapShotService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.reportsnapshot.service.impl.SysReportSnapShotServiceImpl")
public class SysReportSnapShotServiceImpl
extends HussarServiceImpl<SysReportSnapshotMapper, SysReportSnapshot>
implements ISysReportSnapShotService {
    @Resource
    private SysReportSnapshotMapper sysReportSnapshotMapper;
    @Resource
    private IExcelExporterService excelExporterService;
    @Resource
    private IExcelImportService excelImportService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Value(value="${report.storage:default}")
    private String storage;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String REPORT_SNAPSHOT = "report_snapshot";
    @Resource
    private GridFsTemplate gridFsTemplate;
    private static final Logger logger = LoggerFactory.getLogger(SysReportSnapShotServiceImpl.class);

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addSnapshot(SnapShotVo sysReportSnapshot) {
        boolean isAdd;
        SysReportSnapshot maxSeqSnapshot;
        SecurityUser userDetails;
        String designInformation = null;
        if (HussarUtils.isEmpty((Object)sysReportSnapshot.getSnapshotId())) {
            Map<String, Object> workbookData = this.fixWorkbookData(sysReportSnapshot);
            try {
                designInformation = OBJECT_MAPPER.writeValueAsString(workbookData);
                sysReportSnapshot.setDesignInformation(designInformation);
            }
            catch (JsonProcessingException e) {
                logger.error("\u65e0\u6cd5\u5c06 workbookData \u8f6c\u6362\u4e3a JSON", (Throwable)e);
                throw new RuntimeException("\u65e0\u6cd5\u5c06 workbookData \u8f6c\u6362\u4e3a JSON", e);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(userDetails = BaseSecurityUtil.getUser()))) {
            sysReportSnapshot.setCreateName(userDetails.getUserName());
            sysReportSnapshot.setLastEditorName(userDetails.getUserName());
        }
        int maxSnapshotSeq = 0;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(SysReportSnapshot::getSeq);
        queryWrapper.select(new SFunction[]{SysReportSnapshot::getSeq});
        queryWrapper.eq(SysReportSnapshot::getReportId, (Object)sysReportSnapshot.getReportId());
        Page page = new Page(1L, 1L);
        Page resultPage = (Page)this.sysReportSnapshotMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = resultPage.getRecords();
        SysReportSnapshot sysReportSnapshot2 = maxSeqSnapshot = HussarUtils.isNotEmpty((Object)records) ? (SysReportSnapshot)records.get(0) : null;
        if (HussarUtils.isNotEmpty((Object)maxSeqSnapshot)) {
            maxSnapshotSeq = maxSeqSnapshot.getSeq();
            sysReportSnapshot.setSeq(maxSnapshotSeq + 1);
        } else {
            sysReportSnapshot.setSeq(1);
        }
        if (HussarUtils.isNotEmpty((Object)sysReportSnapshot.getSnapshotName())) {
            sysReportSnapshot.setSnapshotName(sysReportSnapshot.getSnapshotName() + "_" + (maxSnapshotSeq + 1));
        } else {
            sysReportSnapshot.setSnapshotName(String.valueOf(maxSnapshotSeq));
        }
        if (HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue())) {
            sysReportSnapshot.setDesignInformation(null);
        }
        if (isAdd = this.save((BaseEntity)sysReportSnapshot)) {
            Long generatedId = sysReportSnapshot.getSnapshotId();
            if (HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue())) {
                String mongoId = SysReportSnapShotServiceImpl.getMongoId(sysReportSnapshot.getReportId(), sysReportSnapshot.getSnapshotId());
                this.storeDesignInfoToGridFS(mongoId, sysReportSnapshot.getSnapshotId(), designInformation);
            }
            return generatedId;
        }
        return null;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editSnapshot(SysReportSnapshot sysReportSnapshot) {
        String designInformation;
        SecurityUser userDetails = BaseSecurityUtil.getUser();
        if (HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue()) && HussarUtils.isNotEmpty((Object)(designInformation = sysReportSnapshot.getDesignInformation()))) {
            String mongoId = SysReportSnapShotServiceImpl.getMongoId(sysReportSnapshot.getReportId(), sysReportSnapshot.getSnapshotId());
            this.storeDesignInfoToGridFS(mongoId, sysReportSnapshot.getSnapshotId(), designInformation);
            sysReportSnapshot.setDesignInformation(null);
        }
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            sysReportSnapshot.setLastEditorName(userDetails.getUserName());
        }
        boolean updated = this.updateById((BaseEntity)sysReportSnapshot);
        return updated;
    }

    public Boolean delSnapshotByReportId(Long reportId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReportSnapshot::getReportId, (Object)reportId);
        List<SysReportSnapshot> snapshots = this.getSysReportSnapshotByReportId(reportId);
        boolean isDel = this.remove((Wrapper)queryWrapper);
        if (isDel && HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue())) {
            for (SysReportSnapshot snapshot : snapshots) {
                ReportSnapshotDocument document = (ReportSnapshotDocument)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)SysReportSnapShotServiceImpl.getMongoId(snapshot.getReportId(), snapshot.getSnapshotId()))), ReportSnapshotDocument.class, REPORT_SNAPSHOT);
                if (document != null && document.getDesignInformation().startsWith("GRIDFS:")) {
                    this.deleteGridFSFile(document.getDesignInformation());
                }
                this.deleteMongoSnapshotDocument(snapshot.getReportId(), snapshot.getSnapshotId());
            }
        }
        return isDel;
    }

    public Boolean delSnapshot(List<Long> snapshotIds) {
        ArrayList<SysReportSnapshot> snapshots = new ArrayList<SysReportSnapshot>();
        for (Long snapshotId : snapshotIds) {
            SysReportSnapshot snapshot = (SysReportSnapshot)((SysReportSnapshotMapper)this.baseMapper).selectById(snapshotId);
            if (snapshot == null) continue;
            snapshots.add(snapshot);
        }
        boolean result = this.removeByIds(snapshotIds);
        if (result && HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue())) {
            for (Long snapshotId : snapshotIds) {
                SysReportSnapshot snapshot = (SysReportSnapshot)((SysReportSnapshotMapper)this.baseMapper).selectById(snapshotId);
                if (!HussarUtils.isNotEmpty((Object)snapshot)) continue;
                String mongoId = SysReportSnapShotServiceImpl.getMongoId(snapshot.getReportId(), snapshotId);
                this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)), REPORT_SNAPSHOT);
            }
        }
        return result;
    }

    public List<SysReportSnapshot> getSysReportSnapshotByReportId(Long reportId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReportSnapshot::getReportId, (Object)reportId);
        List sysReportSnapshots = ((SysReportSnapshotMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReportSnapshots;
    }

    public List<SysReportSnapshot> getSysReportSnapshotVoByReportId(Long reportId) {
        return this.sysReportSnapshotMapper.selectSysReportSnapshotsByReportId(reportId);
    }

    public SysReportSnapshot getSysReportSnapshotById(Long snapshotId) {
        String designInformation;
        SysReportSnapshot snapshot = (SysReportSnapshot)((SysReportSnapshotMapper)this.baseMapper).selectById(snapshotId);
        if (HussarUtils.isNotEmpty((Object)snapshot) && HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue()) && HussarUtils.isNotEmpty((Object)(designInformation = this.getDesignInformationFromMongo(snapshot.getReportId(), snapshotId)))) {
            if (designInformation.startsWith("GRIDFS:")) {
                String actualData = this.readDesignInfoFromGridFS(designInformation);
                if (HussarUtils.isNotEmpty((Object)actualData)) {
                    snapshot.setDesignInformation(actualData);
                }
            } else {
                snapshot.setDesignInformation(designInformation);
            }
        }
        return snapshot;
    }

    public Map<String, Object> fixWorkbookData(SnapShotVo snapshot) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        try {
            designMap = (Map)objectMapper.readValue(snapshot.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue((Object)designMap, IWorkbookData.class);
        List resources = workbookData.getResources();
        HashMap autoFilter = new HashMap();
        if (HussarUtils.isNotEmpty((Object)resources)) {
            Optional<String> sheetFilterPluginData = resources.stream().filter(resource -> "SHEET_FILTER_PLUGIN".equals(resource.get("name"))).map(resource -> (String)resource.get("data")).findFirst();
            sheetFilterPluginData.ifPresent(data -> {
                ObjectMapper objectMapper2 = new ObjectMapper();
                try {
                    if (HussarUtils.isNotEmpty((Object)data)) {
                        Map filter = (Map)objectMapper2.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        autoFilter.putAll(filter);
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            workbook.setForceFormulaRecalculation(true);
            Map sheetsMap = new HashMap();
            if (HussarUtils.isNotEmpty((Object)designMap) && HussarUtils.isNotEmpty((Object)((Map)designMap.get("sheets")))) {
                sheetsMap = (Map)designMap.get("sheets");
            }
            HashMap styles = new HashMap();
            Map sheets = workbookData.getSheets();
            List sheetIds = workbookData.getSheetOrder();
            List<String> fixSheet = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)sheetIds)) {
                if (HussarUtils.isNotEmpty((Object)snapshot.getLoadedSheetIds())) {
                    for (String sheetId : sheetIds) {
                        if (snapshot.getLoadedSheetIds().contains(sheetId)) continue;
                        fixSheet.add(sheetId);
                    }
                } else {
                    fixSheet = sheetIds;
                }
            }
            if (HussarUtils.isNotEmpty(fixSheet)) {
                for (String sheetId : fixSheet) {
                    Map sheetMap = (Map)sheetsMap.get(sheetId);
                    IWorksheetData sheetData = (IWorksheetData)sheets.get(sheetId);
                    List dataSetCommonParamConfig = new ArrayList();
                    List loopAreas = new ArrayList();
                    if (HussarUtils.isNotEmpty((Object)snapshot.getDataSetCommonParamConfig())) {
                        dataSetCommonParamConfig = snapshot.getDataSetCommonParamConfig();
                    }
                    if (HussarUtils.isNotEmpty((Object)snapshot.getLoopArea())) {
                        loopAreas = snapshot.getLoopArea();
                    }
                    IWorksheetData worksheetData = this.excelImportService.convertSheet(this.excelExporterService.processSheet(workbook, sheetId, workbookData, loopAreas, dataSetCommonParamConfig, sheetIds, Boolean.valueOf(true), autoFilter, null), styles);
                    IWorksheetData.copyData((IWorksheetData)worksheetData, (IWorksheetData)sheetData);
                    this.putSheetMap(worksheetData, sheetMap);
                }
                if (HussarUtils.isNotEmpty(fixSheet)) {
                    Map<String, IStyleData> styleMap = new HashMap();
                    if (HussarUtils.isNotEmpty((Object)designMap) && HussarUtils.isNotEmpty(designMap.get("styles"))) {
                        styleMap = (Map)designMap.get("styles");
                    }
                    for (Map.Entry entry : styles.entrySet()) {
                        String key = (String)entry.getKey();
                        IStyleData styleData = (IStyleData)entry.getValue();
                        styleMap.put(key, styleData);
                    }
                    designMap.put("styles", styleMap);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return designMap;
    }

    private Map<String, Object> putSheetMap(IWorksheetData source, Map<String, Object> sheetMap) {
        sheetMap.put("rowCount", source.getRowCount());
        sheetMap.put("columnCount", source.getColumnCount());
        sheetMap.put("freeze", source.getFreeze());
        sheetMap.put("cellData", source.getCellData());
        sheetMap.put("mergeData", source.getMergeData());
        sheetMap.put("rowData", source.getRowData());
        sheetMap.put("columnData", source.getColumnData());
        sheetMap.put("custom", source.getCustom());
        return sheetMap;
    }

    public String getDesignInformationFromMongo(String reportId, Long snapshotId) {
        if (!HussarUtils.equals((Object)this.storage, (Object)StorageTypeEnum.MONGODB.getValue())) {
            return null;
        }
        String mongoId = SysReportSnapShotServiceImpl.getMongoId(reportId, snapshotId);
        ReportSnapshotDocument document = (ReportSnapshotDocument)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)), ReportSnapshotDocument.class, REPORT_SNAPSHOT);
        return document != null ? document.getDesignInformation() : null;
    }

    private ReportSnapshotDocument storeDesignInfoToGridFS(String mongoId, Long snapshotId, String designInformation) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(designInformation.getBytes(StandardCharsets.UTF_8));
            ObjectId fileId = this.gridFsTemplate.store((InputStream)inputStream, mongoId + ".json", "application/json");
            ReportSnapshotDocument document = new ReportSnapshotDocument();
            document.setMongodbId(mongoId);
            document.setSnapshotId(snapshotId);
            document.setDesignInformation("GRIDFS:" + fileId.toString());
            this.mongoTemplate.save((Object)document, REPORT_SNAPSHOT);
            return document;
        }
        catch (Exception e) {
            logger.error("\u5b58\u50a8\u5230GridFS\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u5b58\u50a8\u5230GridFS\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    private void deleteGridFSFile(String designInformation) {
        if (HussarUtils.isNotEmpty((Object)designInformation) && designInformation.startsWith("GRIDFS:")) {
            try {
                String fileIdStr = designInformation.substring(7);
                this.gridFsTemplate.delete(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(fileIdStr))));
            }
            catch (Exception e) {
                logger.error("\u5220\u9664GridFS\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u5220\u9664GridFS\u6587\u4ef6\u5931\u8d25", e);
            }
        }
    }

    private void deleteMongoSnapshotDocument(String reportId, Long snapshotId) {
        String mongoId = SysReportSnapShotServiceImpl.getMongoId(reportId, snapshotId);
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)), REPORT_SNAPSHOT);
    }

    /*
     * Exception decompiling
     */
    private String readDesignInfoFromGridFS(String designInformation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getMongoId(String formId, Long snapshotId) {
        return String.format("%s:%s", formId, snapshotId);
    }
}

