/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.reportgroup.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.reportgroup.Vo.SysReportGroupVo;
import com.jxdinfo.hussar.application.reportgroup.dao.SysReportGroupMapper;
import com.jxdinfo.hussar.application.reportgroup.model.SysReportGroup;
import com.jxdinfo.hussar.application.reportgroup.service.ISysReportGroupService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.sync.union.dto.SyncGroupDto;
import com.jxdinfo.hussar.sync.sync.union.service.ReportSyncService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.reportgroup.service.impl.SysReportGroupImpl")
public class SysReportGroupServiceImpl
extends HussarServiceImpl<SysReportGroupMapper, SysReportGroup>
implements ISysReportGroupService {
    @Resource
    private ReportSyncService reportSyncService;
    @Resource
    private ISysReportService sysReportService;
    @Resource
    private SysReportGroupMapper sysReportGroupMapper;
    private static final Long MODEL_ID = 5L;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> addReportGroup(SysReportGroup sysReportGroup) {
        SysReportGroup maxSeqReport;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(SysReportGroup::getSeq);
        Page page = new Page(1L, 1L);
        Page resultPage = (Page)this.sysReportGroupMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = resultPage.getRecords();
        SysReportGroup sysReportGroup2 = maxSeqReport = HussarUtils.isNotEmpty((Object)records) ? (SysReportGroup)records.get(0) : null;
        if (HussarUtils.isNotEmpty((Object)maxSeqReport)) {
            int maxGroupSeq = maxSeqReport.getSeq();
            sysReportGroup.setSeq(Integer.valueOf(maxGroupSeq + 1));
        } else {
            sysReportGroup.setSeq(Integer.valueOf(1));
        }
        SecurityUser userDetails = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            sysReportGroup.setCreateName(userDetails.getUserName());
        }
        this.save((BaseEntity)sysReportGroup);
        this.reportSyncService.syncReportGroup("add", this.convertToSyncGroupDto(sysReportGroup));
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> editReportGroup(SysReportGroup sysReportGroup) {
        SecurityUser userDetails = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            sysReportGroup.setLastEditorName(userDetails.getUserName());
        }
        boolean updated = this.updateById((BaseEntity)sysReportGroup);
        this.reportSyncService.syncReportGroup("edit", this.convertToSyncGroupDto(sysReportGroup));
        return ApiResponse.success((Object)updated);
    }

    public ApiResponse<Boolean> editReportGroups(List<SysReportGroup> sysReportGroups) {
        return ApiResponse.success((Object)this.updateBatchById(sysReportGroups));
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> delReportGroup(List<Long> reportGroupIds) {
        for (Long reportGroupId : reportGroupIds) {
            if (!HussarUtils.isNotEmpty((Object)this.sysReportService.getSysReportByGroupId(reportGroupId))) continue;
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff0c\u5206\u7ec4\u4e0b\u5b58\u5728\u62a5\u8868!");
        }
        boolean removed = this.removeByIds(reportGroupIds);
        if (HussarUtils.isNotEmpty(reportGroupIds)) {
            Long reportGroupId;
            reportGroupId = reportGroupIds.get(0);
            SysReportGroup reportGroup = new SysReportGroup();
            reportGroup.setGroupId(reportGroupId);
            this.reportSyncService.syncReportGroup("del", this.convertToSyncGroupDto(reportGroup));
        }
        return ApiResponse.success((Object)removed);
    }

    public ApiResponse<SysReportGroup> getSysReportGroupById(Long reportGroupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReportGroup::getGroupId, (Object)reportGroupId);
        SysReportGroup sysReportGroup = (SysReportGroup)((SysReportGroupMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysReportGroup);
    }

    public ApiResponse<List<SysReportGroup>> getSysReportGroupByName(String reportGroupName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(SysReportGroup::getGroupName, (Object)reportGroupName);
        List sysReportGroups = ((SysReportGroupMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysReportGroups);
    }

    public List<SysReportGroup> getAllSysReportGroup() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByAsc(SysReportGroup::getSeq);
        List sysReportGroups = ((SysReportGroupMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReportGroups;
    }

    public ApiResponse<List<SysReportGroupVo>> getAllReportAndGroup() {
        ArrayList<SysReportGroupVo> sysReportGroupVos = new ArrayList<SysReportGroupVo>();
        List<SysReportGroup> sysReportGroups = this.getAllSysReportGroup();
        List sysReportList = this.sysReportService.getSysReportVo();
        Map<Long, List<SysReport>> groupedReports = sysReportList.stream().filter(report -> report.getReportGroupId() != null).collect(Collectors.groupingBy(SysReport::getReportGroupId));
        List ungroupedReports = sysReportList.stream().filter(report -> report.getReportGroupId() == null).collect(Collectors.toList());
        SysReportGroupVo sysReportGroupVoNoGroup = new SysReportGroupVo();
        sysReportGroupVoNoGroup.setSysReports(ungroupedReports);
        sysReportGroupVos.add(sysReportGroupVoNoGroup);
        for (SysReportGroup sysReportGroup : sysReportGroups) {
            SysReportGroupVo sysReportGroupVo = new SysReportGroupVo();
            sysReportGroupVo.setGroupId(sysReportGroup.getGroupId());
            sysReportGroupVo.setGroupName(sysReportGroup.getGroupName());
            sysReportGroupVo.setGroupType(sysReportGroup.getGroupType());
            sysReportGroupVo.setGroupIcon(sysReportGroup.getGroupIcon());
            sysReportGroupVo.setGroupIconType(sysReportGroup.getGroupIconType());
            sysReportGroupVo.setGroupIconColor(sysReportGroup.getGroupIconColor());
            sysReportGroupVo.setDescription(sysReportGroup.getDescription());
            sysReportGroupVo.setSeq(sysReportGroup.getSeq());
            sysReportGroupVo.setCreateTime(sysReportGroup.getCreateTime());
            sysReportGroupVo.setLastTime(sysReportGroup.getLastTime());
            sysReportGroupVo.setCreator(sysReportGroup.getCreator());
            sysReportGroupVo.setLastEditor(sysReportGroup.getLastEditor());
            List reportsInGroup = groupedReports.getOrDefault(sysReportGroup.getGroupId(), new ArrayList());
            sysReportGroupVo.setSysReports(reportsInGroup);
            sysReportGroupVos.add(sysReportGroupVo);
        }
        return ApiResponse.success(sysReportGroupVos);
    }

    public ApiResponse<Boolean> editGroupAndReport(List<SysReportGroupVo> sysReportGroupVoList) {
        for (int i = 0; i < sysReportGroupVoList.size(); ++i) {
            sysReportGroupVoList.get(i).setSeq(Integer.valueOf(i));
            if (HussarUtils.isEmpty((Object)sysReportGroupVoList.get(i).getSysReports())) continue;
            for (int j = 0; j < sysReportGroupVoList.get(i).getSysReports().size(); ++j) {
                ((SysReport)sysReportGroupVoList.get(i).getSysReports().get(j)).setSeq(j);
                ((SysReport)sysReportGroupVoList.get(i).getSysReports().get(j)).setReportGroupId(sysReportGroupVoList.get(i).getGroupId());
            }
        }
        List reportGroups = sysReportGroupVoList.stream().map(entity -> {
            SysReportGroup sysReportGroup = new SysReportGroup();
            BeanUtils.copyProperties((Object)entity, (Object)sysReportGroup);
            return sysReportGroup;
        }).collect(Collectors.toList());
        this.updateBatchById(reportGroups);
        ArrayList reportList = new ArrayList();
        for (SysReportGroupVo sysReportGroupVo : sysReportGroupVoList) {
            reportList.addAll(sysReportGroupVo.getSysReports());
        }
        boolean result = this.sysReportService.updateBatchById(reportList);
        List haveGroupList = reportGroups.stream().filter(reportGroup -> HussarUtils.isNotEmpty((Object)reportGroup.getGroupId())).collect(Collectors.toList());
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<Page<SysReportGroup>> getSysReportGroupByNameByPage(String reportGroupName, int pageNum, int pageSize) {
        Page page = new Page((long)pageNum, (long)pageSize);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(SysReportGroup::getGroupName, (Object)reportGroupName);
        Page sysReportGroups = (Page)((SysReportGroupMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysReportGroups);
    }

    private SyncGroupDto convertToSyncGroupDto(SysReportGroup sysReportGroup) {
        SyncGroupDto syncGroupDto = new SyncGroupDto();
        syncGroupDto.setGroupId(sysReportGroup.getGroupId());
        syncGroupDto.setGroupName(sysReportGroup.getGroupName());
        syncGroupDto.setParentModelId(MODEL_ID);
        syncGroupDto.setGroupIcon(sysReportGroup.getGroupIcon());
        return syncGroupDto;
    }
}

