/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.Util.ReportHookUtil;
import com.jxdinfo.hussar.application.enums.ReportHookEnum;
import com.jxdinfo.hussar.application.hook.service.IReportHookService;
import com.jxdinfo.hussar.application.report.dao.SysReportMapper;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.reportgroup.model.SysReportGroup;
import com.jxdinfo.hussar.application.reportgroup.service.ISysReportGroupService;
import com.jxdinfo.hussar.application.reportsnapshot.service.ISysReportSnapShotService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.sync.union.dto.SyncReportDto;
import com.jxdinfo.hussar.sync.sync.union.service.ReportSyncService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.report.service.impl.SysReportImpl")
public class SysReportServiceImpl
extends HussarServiceImpl<SysReportMapper, SysReport>
implements ISysReportService {
    @Resource
    private ReportSyncService reportSyncService;
    @Resource
    private SysReportMapper sysReportMapper;
    @Resource
    private ISysReportGroupService sysReportGroupService;
    @Resource
    private ISysReportSnapShotService sysReportSnapShotService;
    private static Logger logger = LoggerFactory.getLogger(SysReportServiceImpl.class);
    private static final Long MODEL_ID = 5L;
    private static final String STRATEGY = "5";
    private static final String RES_PATH = "/report/";

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addReport(SysReport sysReport) {
        SysReport maxSeqReport;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)sysReport.getReportGroupId())) {
            queryWrapper.eq(SysReport::getReportGroupId, (Object)sysReport.getReportGroupId());
        } else {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysReport::getReportGroupId)).or()).eq(SysReport::getReportGroupId, (Object)"");
            });
        }
        queryWrapper.orderByDesc(SysReport::getSeq);
        Page page = new Page(1L, 1L);
        Page resultPage = (Page)this.sysReportMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = resultPage.getRecords();
        SysReport sysReport2 = maxSeqReport = HussarUtils.isNotEmpty((Object)records) ? (SysReport)records.get(0) : null;
        if (HussarUtils.isNotEmpty((Object)maxSeqReport)) {
            int maxReportSeq = maxSeqReport.getSeq();
            sysReport.setSeq(maxReportSeq + 1);
        } else {
            sysReport.setSeq(1);
        }
        boolean isAdd = this.save((BaseEntity)sysReport);
        if (isAdd) {
            this.reportSyncService.syncReport("add", this.convertToSyncReportDto(sysReport));
            Long generatedId = sysReport.getReportId();
            return generatedId;
        }
        return null;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editReport(SysReport sysReport) {
        boolean updated = this.updateById((BaseEntity)sysReport);
        this.reportSyncService.syncReport("edit", this.convertToSyncReportDto(sysReport));
        return updated;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editReports(List<SysReport> sysReports) {
        return this.updateBatchById(sysReports);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean delReport(List<Long> reportIds) {
        boolean removed = this.removeByIds(reportIds);
        if (HussarUtils.isNotEmpty(reportIds)) {
            Long reportId = reportIds.get(0);
            SysReport sysReport = new SysReport();
            sysReport.setReportId(reportId);
            this.reportSyncService.syncReport("del", this.convertToSyncReportDto(sysReport));
            for (Long id : reportIds) {
                this.sysReportSnapShotService.delSnapshotByReportId(id);
            }
        }
        return removed;
    }

    public List<SysReport> getSysReportByGroupId(Long reportGroupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)reportGroupId)) {
            queryWrapper.eq(SysReport::getReportGroupId, (Object)reportGroupId);
        } else {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysReport::getReportGroupId)).or()).eq(SysReport::getReportGroupId, (Object)"");
            });
        }
        queryWrapper.orderByAsc(SysReport::getSeq);
        List sysReports = ((SysReportMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReports;
    }

    public List<SysReport> getSysReportVoByGroupId(Long reportGroupId) {
        return this.sysReportMapper.selectReportsByGroupId(reportGroupId);
    }

    public List<SysReport> getSysReportVo() {
        return this.sysReportMapper.selectReports();
    }

    public SysReport getSysReportById(Long reportId) {
        return this.getSysReportById(reportId, null);
    }

    public SysReport getSysReportById(Long reportId, String exParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String serviceName = ReportHookEnum.REPORT_HOOK_SERVICE_IMPL.getValue();
        String preHookName = ReportHookUtil.getPreHookName(exParam);
        if (HussarUtils.isNotEmpty((Object)preHookName)) {
            serviceName = preHookName + serviceName;
        }
        IReportHookService reportHookService = null;
        try {
            reportHookService = (IReportHookService)SpringUtil.getBean((String)serviceName, IReportHookService.class);
        }
        catch (Exception e) {
            logger.error("\u672a\u80fd\u627e\u5230Bean: {}", (Object)serviceName);
        }
        if (HussarUtils.isNotEmpty((Object)reportHookService)) {
            reportId = reportHookService.getSysReportBefore(reportId, exParam);
        }
        if (HussarUtils.isEmpty((Object)reportId)) {
            return null;
        }
        queryWrapper.eq(SysReport::getReportId, (Object)reportId);
        SysReport sysReport = (SysReport)((SysReportMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)reportHookService)) {
            reportHookService.getSysReportAfter(sysReport, exParam);
        }
        return sysReport;
    }

    public List<SysReport> getSysReportByName(String reportName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(SysReport::getReportName, (Object)reportName);
        List sysReports = ((SysReportMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReports;
    }

    public List<SysReport> getAllSysReport() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List sysReports = ((SysReportMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReports;
    }

    public Boolean addMenu(Long reportId) {
        SysReport sysReport = this.getSysReportById(reportId);
        SyncReportDto syncReportDto = this.convertToSyncReportDto(sysReport);
        if (HussarUtils.isNotEmpty((Object)sysReport.getReportGroupId())) {
            SysReportGroup sysReportGroup = (SysReportGroup)this.sysReportGroupService.getSysReportGroupById(sysReport.getReportGroupId()).getData();
            syncReportDto.setGroupId(sysReportGroup.getGroupId());
            syncReportDto.setGroupName(sysReportGroup.getGroupName());
            syncReportDto.setGroupIcon(sysReportGroup.getGroupIcon());
        }
        this.reportSyncService.addMenu(syncReportDto);
        sysReport.setIsMenu("1");
        this.editReport(sysReport);
        return true;
    }

    public Boolean delMenu(Long reportId) {
        SysReport sysReport = this.getSysReportById(reportId);
        this.reportSyncService.delMenu(reportId);
        sysReport.setIsMenu("0");
        this.editReport(sysReport);
        return true;
    }

    public Boolean isMenu(Long reportId) {
        SysReport sysReport;
        if (HussarUtils.isNotEmpty((Object)reportId) && HussarUtils.isNotEmpty((Object)(sysReport = (SysReport)this.sysReportMapper.selectById(reportId))) && HussarUtils.equals((Object)"1", (Object)sysReport.getIsMenu())) {
            return true;
        }
        return false;
    }

    private SyncReportDto convertToSyncReportDto(SysReport sysReport) {
        SyncReportDto syncReportDto = new SyncReportDto();
        syncReportDto.setReportId(sysReport.getReportId());
        syncReportDto.setReportName(sysReport.getReportName());
        syncReportDto.setReportIcon(sysReport.getReportIcon());
        syncReportDto.setParentModelId(MODEL_ID);
        syncReportDto.setPath(RES_PATH);
        syncReportDto.setStrategy(STRATEGY);
        return syncReportDto;
    }
}

