/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.Util.HussarReportThreadUtil;
import com.jxdinfo.hussar.application.enums.ReportErrorCodeEnum;
import com.jxdinfo.hussar.application.excel.Vo.ICellData;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.report.Dto.ReportErrorDto;
import com.jxdinfo.hussar.application.report.Dto.ReportErrorResultDto;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportExpImpService;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.reportgroup.model.SysReportGroup;
import com.jxdinfo.hussar.application.reportgroup.service.ISysReportGroupService;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.dataset.service.IDataSetGroupService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.mail.core.exceptions.IORuntimeException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.report.dashboard.model.ReportDashEntry;
import com.jxdinfo.hussar.report.dashboard.service.IReportDashEntryService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.report.service.impl.SysReportExpImpServiceImpl")
public class SysReportExpImpServiceImpl
implements ISysReportExpImpService {
    private static final int MAX_NAME = 50;
    private static final int START_NAME = 0;
    private static Logger logger = LoggerFactory.getLogger(SysReportExpImpServiceImpl.class);
    @Value(value="${hussar-formdesign.workspace}")
    private String workspace;
    @Value(value="${data-set.data-stream.enable:true}")
    private Boolean streamEnable;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private ISysReportService sysReportService;
    @Resource
    private ISysReportGroupService sysReportGroupService;
    @Resource
    private IDataSetService dataSetService;
    @Autowired
    private OssService ossService;
    @Autowired
    private IReportDashEntryService reportDashEntryService;
    @Autowired
    private IDataSetGroupService dataSetGroupService;

    public static <T> T readFileToObject(String filePath, Class<T> clazz) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try {
                String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                return (T)JSON.parseObject((String)text, clazz);
            }
            catch (IOException e) {
                ToolUtil.getLogger(SysReportExpImpServiceImpl.class).error("\u8bfb\u53d6\u6587\u4ef6\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}" + e.getMessage());
                throw new RuntimeException();
            }
        }
        return null;
    }

    public Void export(List<Long> reportId) {
        HussarReportThreadUtil.executeDesignTask(() -> {
            try {
                this.exportReport(reportId);
            }
            catch (Exception e) {
                ToolUtil.getLogger(SysReportExpImpServiceImpl.class).error("\u5bfc\u51fa\u62a5\u8868\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            TransmittableThreadLocalHolder.clear((String)"exportCacheKey");
        });
        return null;
    }

    public Void importReport(List<MultipartFile> files) {
        String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
        String tempFileName = this.workspace + File.separator + "report_import";
        String basePath = FileUtil.posixPath((String[])new String[]{tempFileName, UUID.randomUUID().toString()});
        File tempRootDir = null;
        try {
            tempRootDir = Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]).toFile();
            for (MultipartFile file : files) {
                String originalFilename = file.getOriginalFilename();
                if (originalFilename == null || !originalFilename.endsWith(".hrp")) {
                    ImportStatusVo importStatusVo = ImportStatusVo.put((int)0, (String)"\u5bfc\u5165\u5931\u8d25", (boolean)false, (boolean)true);
                    Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                    ReportErrorDto error = new ReportErrorDto();
                    error.setName("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
                    HashMap<String, Integer> reportError = new HashMap<String, Integer>();
                    reportError.put("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e", ReportErrorCodeEnum.FILE_NOT_HUSSAR.getCode());
                    error.setError(reportError);
                    errors.put(UUID.randomUUID().toString(), error);
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                    throw new BaseException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a .hrp \u6587\u4ef6");
                }
                File tempFile = new File(tempRootDir, originalFilename);
                file.transferTo(tempFile);
            }
        }
        catch (IOException e) {
            logger.error("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            ImportStatusVo importStatusVo = ImportStatusVo.put((int)0, (String)"\u5bfc\u5165\u5931\u8d25", (boolean)false, (boolean)true);
            Map<String, ReportErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            ReportErrorDto error = new ReportErrorDto();
            error.setName("\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
            HashMap<String, Integer> reportError = new HashMap<String, Integer>();
            reportError.put("reportError", ReportErrorCodeEnum.FILE_NOT_CREATE.getCode());
            error.setError(reportError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            throw new BaseException("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        File finalTempRootDir = tempRootDir;
        HussarReportThreadUtil.executeDesignTask(() -> {
            try {
                this.importReports(finalTempRootDir);
            }
            catch (Exception e) {
                ToolUtil.getLogger(SysReportExpImpServiceImpl.class).error("\u5bfc\u5165\u62a5\u8868\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                if (HussarUtils.isNotEmpty((Object)importCacheKey)) {
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)0, (String)"\u5bfc\u5165\u62a5\u8868\u65f6\u53d1\u751f\u5f02\u5e38", (boolean)false, (boolean)true));
                }
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        return null;
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class) : ImportStatusVo.put((int)1, (String)"\u6b63\u5728\u5bfc\u5165", (boolean)false, (boolean)false)));
    }

    public Long exportReport(List<Long> reportId) {
        String tempFileName = this.workspace + File.separator + "report";
        String basePath = FileUtil.posixPath((String[])new String[]{tempFileName, UUID.randomUUID().toString()});
        ArrayList<Long> fileIds = new ArrayList<Long>();
        Long zipId = null;
        String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
        try {
            int index = 0;
            for (Long id : reportId) {
                String reportPath = FileUtil.posixPath((String[])new String[]{basePath, id.toString()});
                String reportName = this.exportReportInfo(id, reportPath, ++index, exportCacheKey);
                fileIds.add(this.fileEncrypt(reportName, reportPath));
            }
            HashMap<String, Integer> nameRepeat = new HashMap<String, Integer>();
            String projectBackPath = basePath;
            projectBackPath = projectBackPath + File.separator + System.currentTimeMillis() + File.separator;
            String zipFolderPath = FileUtil.posixPath((String[])new String[]{projectBackPath, "exportReportBatch"});
            Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
            HashMap<Long, String> idMaps = new HashMap<Long, String>();
            for (Long id : fileIds) {
                idMaps.put(id, "");
            }
            this.copyFilesToFolder(idMaps, zipFolderPath, nameRepeat);
            zipId = this.fileEncrypt("\u62a5\u8868\u6279\u91cf\u5bfc\u51fa", zipFolderPath);
            File file = new File(zipFolderPath);
            if (HussarUtils.isNotEmpty((Object)exportCacheKey)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)index, (String)"\u5bfc\u51fa\u6210\u529f", (Long)zipId, (boolean)false));
            }
            if (file.exists()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (HussarException e) {
            logger.error("\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)0, (String)e.getMessage(), null, (boolean)true));
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38\uff1a{}", (Throwable)e);
            if (HussarUtils.isNotEmpty((Object)exportCacheKey)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)0, (String)"\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38", null, (boolean)true));
            }
            throw new BaseException("\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38");
        }
        finally {
            try {
                File baseFile = new File(basePath);
                if (baseFile.exists()) {
                    FileUtils.deleteDirectory((File)baseFile);
                }
            }
            catch (IOException e) {
                logger.error("\u6e05\u7406\u4e34\u65f6\u76ee\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        return zipId;
    }

    public String exportReportInfos(List<Long> reportId, String basePath) {
        HashMap map = new HashMap();
        ArrayList<SysReport> sysReportList = new ArrayList<SysReport>();
        for (Long id : reportId) {
            SysReport sysReport = this.sysReportService.getSysReportById(id);
            sysReportList.add(sysReport);
        }
        List<Long> uniqueDatasetIds = sysReportList.stream().map(SysReport::getDataset).filter(Objects::nonNull).map(datasetJson -> (List)JSON.parseObject((String)datasetJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0])).filter(Objects::nonNull).flatMap(Collection::stream).map(item -> Long.parseLong((String)item.get("id"))).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(uniqueDatasetIds)) {
            this.exportDataSet(uniqueDatasetIds, basePath);
        }
        List<Long> uniqueGroupIds = sysReportList.stream().map(SysReport::getReportGroupId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.exportReportGroup(uniqueGroupIds, basePath);
        map.put("report", sysReportList);
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "report.json"}));
        return ((SysReport)sysReportList.get(0)).getReportName();
    }

    public String exportReportInfo(Long reportId, String basePath, int index, String exportCacheKey) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        SysReport sysReport = this.sysReportService.getSysReportById(reportId);
        ArrayList uniqueDatasetIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)exportCacheKey)) {
            HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)index, (String)("\u6b63\u5728\u5bfc\u51fa" + sysReport.getReportName() + "\u8bbe\u8ba1\u5668\u4fe1\u606f"), null, (boolean)false));
        }
        try {
            List<Long> dataSetIds;
            Optional.ofNullable(sysReport.getDataset()).map(datasetJson -> (List)JSON.parseObject((String)datasetJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0])).filter(Objects::nonNull).ifPresent(datasetList -> uniqueDatasetIds.addAll(datasetList.stream().map(item -> (String)item.get("id")).map(Long::valueOf).distinct().collect(Collectors.toList())));
            HashSet tmpDataSetIds = new HashSet(uniqueDatasetIds);
            String json = sysReport.getDesignInformation();
            List<Long> dashboardIds = null;
            if (HussarUtils.isNotEmpty((Object)json)) {
                dashboardIds = this.getDashboardIds(json);
            }
            if (HussarUtils.isNotEmpty(dashboardIds)) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(ReportDashEntry::getEntryId, dashboardIds);
                List dashboards = this.reportDashEntryService.list((Wrapper)queryWrapper);
                map = new HashMap();
                map.put("dashboard", dashboards);
                this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "dashboard.json"}));
                dashboards.forEach(dashboard -> tmpDataSetIds.add(dashboard.getDatasourceId()));
            }
            if (HussarUtils.isNotEmpty(dataSetIds = new ArrayList<Long>(tmpDataSetIds))) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)index, (String)("\u6b63\u5728\u5bfc\u51fa" + sysReport.getReportName() + "\u6570\u636e\u96c6\u4fe1\u606f"), null, (boolean)false));
                if (this.streamEnable.booleanValue()) {
                    map = new HashMap();
                    Map dataStreamMap = this.dataSetService.exportDataStream(dataSetIds);
                    map.put("dataStream", (List<Object>)dataStreamMap.get("dataStream"));
                    this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "dataStream.json"}));
                    dataSetIds = (List)dataStreamMap.get("dataSetIds");
                }
            }
            this.exportDataSet(dataSetIds, basePath);
            ArrayList<Long> uniqueGroupIds = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty((Object)sysReport.getReportGroupId())) {
                uniqueGroupIds.add(sysReport.getReportGroupId());
                this.exportReportGroup(uniqueGroupIds, basePath);
            }
            map = new HashMap();
            map.put("report", (List<Object>)sysReport);
            this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "report.json"}));
        }
        catch (HussarException e) {
            throw new HussarException(e.getExceptionCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38\uff1a{}", (Throwable)e);
            if (HussarUtils.isEmpty((Object)exportCacheKey)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)0, (String)"\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38", null, (boolean)true));
            }
            if (HussarUtils.isEmpty((Object)sysReport)) {
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)0, (String)ReportErrorCodeEnum.REPORT_NOT_FOUND.getMessage(), null, (boolean)true));
            }
            throw new BaseException("\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5f02\u5e38");
        }
        return sysReport.getReportName();
    }

    public void exportReportGroup(List<Long> groupIds, String basePath) {
        HashMap map = new HashMap();
        ArrayList<SysReportGroup> sysReportGroupList = new ArrayList<SysReportGroup>();
        if (HussarUtils.isNotEmpty(groupIds)) {
            for (Long groupId : groupIds) {
                SysReportGroup sysReportGroup = (SysReportGroup)this.sysReportGroupService.getById((Serializable)groupId);
                sysReportGroupList.add(sysReportGroup);
            }
        }
        map.put("reportGroup", sysReportGroupList);
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "reportGroup.json"}));
    }

    public void exportDataSet(List<Long> dataSetIds, String basePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataSet", this.dataSetService.processDataSetExport(dataSetIds));
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "dataSet.json"}));
    }

    private void writeToFile(Object object, String path) {
        String json = JSON.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(json, path);
    }

    public Long fileEncrypt(String appName, String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String oldFormat = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss");
                String fileName = appName + "_" + oldFormat + ".hrp";
                File parentDir = new File(path).getParentFile();
                String zipPath = parentDir.getAbsolutePath() + File.separator + fileName;
                ZipUtil.zip((String)path, (String)zipPath);
                Long id = this.fileUpload(zipPath);
                File zipFile = new File(zipPath);
                zipFile.delete();
                return id;
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public Boolean importReports(File tempRootDir) {
        int index = 0;
        String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
        String originalFilename = null;
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)index, null, (boolean)false, (boolean)false));
        ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey);
        HashMap errors = new HashMap();
        importStatusVo.setData(errors);
        File[] tempFiles = tempRootDir.listFiles();
        if (tempFiles != null) {
            for (File tempFile : tempFiles) {
                try {
                    ++index;
                    originalFilename = tempFile.getName();
                    ArrayList errorList = new ArrayList();
                    errors.put(originalFilename, errorList);
                    String unZipPath = tempRootDir.getAbsolutePath() + File.separator + "unzip_" + System.currentTimeMillis();
                    com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)unZipPath);
                    File unZipDirectory = new File(unZipPath);
                    Collection filesInZip = FileUtils.listFiles((File)unZipDirectory, null, (boolean)true);
                    for (File fileInZip : filesInZip) {
                        if (!fileInZip.getName().endsWith(".hrp")) continue;
                        this.importSingleReportFile(originalFilename, fileInZip, importCacheKey, index, (ImportStatusVo<Map<String, List<ReportErrorDto>>>)importStatusVo);
                    }
                }
                catch (HussarException e) {
                    logger.error("\u5bfc\u5165\u62a5\u8868\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
                catch (Exception e) {
                    logger.error("\u6587\u4ef6\u89e3\u538b\u5f02\u5e38", (Object)e.getMessage());
                    ReportErrorDto error = new ReportErrorDto();
                    error.setName("\u6587\u4ef6\u89e3\u538b\u5f02\u5e38");
                    HashMap<String, ReportErrorResultDto> reportError = new HashMap<String, ReportErrorResultDto>();
                    reportError.put("reportError", new ReportErrorResultDto(Integer.valueOf(ReportErrorCodeEnum.FILE_NOT_UNZIP.getCode()), ReportErrorCodeEnum.FILE_NOT_UNZIP.getMessage()));
                    error.setError(reportError);
                    ((List)((Map)importStatusVo.getData()).get(originalFilename)).add(error);
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                }
            }
            if (tempRootDir.exists()) {
                FileUtils.deleteQuietly((File)tempRootDir);
            }
        }
        importStatusVo.setMsg("\u5bfc\u5165\u5b8c\u6210");
        importStatusVo.setFinishFlag(true);
        importStatusVo.setStatus(index);
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        return true;
    }

    private Boolean importSingleReportFile(String outerFilename, File file, String importCacheKey, int index, ImportStatusVo<Map<String, List<ReportErrorDto>>> importStatusVo) {
        String reportName = null;
        Long reportId = null;
        try {
            Map dashboard;
            Map sysReportGroup;
            List errorResultDtos;
            File tempDir = Files.createTempDirectory("reportImport_", new FileAttribute[0]).toFile();
            String originalFilename = file.getName();
            if (HussarUtils.isEmpty((Object)originalFilename) || !originalFilename.endsWith(".hrp")) {
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
            }
            File tempFile = new File(tempDir, originalFilename);
            FileUtils.copyFile((File)file, (File)tempFile);
            String unZipPath = tempDir.getAbsolutePath();
            com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)unZipPath);
            String reportPath = FileUtil.posixPath((String[])new String[]{unZipPath, "report.json"});
            String reportGroupPath = FileUtil.posixPath((String[])new String[]{unZipPath, "reportGroup.json"});
            String dataSetPath = FileUtil.posixPath((String[])new String[]{unZipPath, "dataSet.json"});
            String dataStreamPath = FileUtil.posixPath((String[])new String[]{unZipPath, "dataStream.json"});
            String dashboardPath = FileUtil.posixPath((String[])new String[]{unZipPath, "dashboard.json"});
            Map sysReportMap = SysReportExpImpServiceImpl.readFileToObject(reportPath, Map.class);
            if (HussarUtils.isEmpty((Object)sysReportMap)) {
                ReportErrorDto error = new ReportErrorDto();
                error.setName(originalFilename);
                HashMap<String, ReportErrorResultDto> reportError = new HashMap<String, ReportErrorResultDto>();
                reportError.put("importError", new ReportErrorResultDto(Integer.valueOf(ReportErrorCodeEnum.REPORT_NOT_EXIT.getCode()), ReportErrorCodeEnum.REPORT_NOT_EXIT.getMessage()));
                error.setError(reportError);
                ((List)((Map)importStatusVo.getData()).get(outerFilename)).add(error);
                importStatusVo.setErrorFlag(true);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
                return false;
            }
            SysReport sysReport = (SysReport)JSON.parseObject((String)((JSONObject)sysReportMap.get("report")).toString(), SysReport.class);
            reportName = sysReport.getReportName();
            reportId = sysReport.getReportId();
            Map dataSet = SysReportExpImpServiceImpl.readFileToObject(dataSetPath, Map.class);
            importStatusVo.setMsg("\u6b63\u5728\u5bfc\u5165" + reportName + "\u6570\u636e\u96c6");
            importStatusVo.setStatus(index);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
            if (HussarUtils.isNotEmpty((Object)dataSet) && HussarUtils.isNotEmpty((Object)(errorResultDtos = this.dataSetService.importDataSet((String)dataSet.get("dataSet"))))) {
                ReportErrorDto error = new ReportErrorDto();
                error.setName(reportName);
                if (HussarUtils.isNotEmpty((Object)reportId)) {
                    error.setId(reportId);
                }
                HashMap<String, List> reportError = new HashMap<String, List>();
                reportError.put("dataSetError", errorResultDtos);
                error.setError(reportError);
                ((List)((Map)importStatusVo.getData()).get(outerFilename)).add(error);
                importStatusVo.setErrorFlag(true);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
                return false;
            }
            importStatusVo.setMsg("\u6b63\u5728\u5bfc\u5165" + reportName + "\u8bbe\u8ba1\u5668\u4fe1\u606f");
            importStatusVo.setStatus(index);
            sysReport.setIsMenu("0");
            try {
                if (HussarUtils.isNotEmpty((Object)this.sysReportService.getSysReportById(sysReport.getReportId()))) {
                    this.sysReportService.editReport(sysReport);
                } else {
                    this.sysReportService.addReport(sysReport);
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u5165\u62a5\u8868\u5931\u8d25", (Throwable)e);
                ReportErrorResultDto reportError = new ReportErrorResultDto(Integer.valueOf(ReportErrorCodeEnum.REPORT_IMPORT_ADD_OR_EDIT_ERROR.getCode()), ReportErrorCodeEnum.REPORT_IMPORT_ADD_OR_EDIT_ERROR.getMessage());
                String errorName = "reportError";
                this.handleError(outerFilename, errorName, reportId, reportName, reportError, importCacheKey, importStatusVo);
                return false;
            }
            Map dataStreamMap = SysReportExpImpServiceImpl.readFileToObject(dataStreamPath, Map.class);
            if (HussarUtils.isNotEmpty((Object)dataStreamMap)) {
                try {
                    this.dataSetService.saveOrUpdateBatchDataStream(dataStreamMap);
                }
                catch (HussarException e) {
                    logger.error("\u5bfc\u5165\u6570\u636e\u6d41\u5931\u8d25,\u539f\u56e0\uff1a{}", (Object)e.getMessage());
                    ReportErrorResultDto reportError = new ReportErrorResultDto(e.getExceptionCode(), e.getMessage());
                    String errorName = "dataStreamError";
                    this.handleError(outerFilename, errorName, reportId, reportName, reportError, importCacheKey, importStatusVo);
                    return false;
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u5165\u6570\u636e\u6d41\u5931\u8d25,\u539f\u56e0\uff1a{}", (Object)e.getMessage());
                    ReportErrorResultDto reportError = new ReportErrorResultDto(Integer.valueOf(ReportErrorCodeEnum.DATA_STREAM_IMPORT_ERROR.getCode()), ReportErrorCodeEnum.DATA_STREAM_IMPORT_ERROR.getMessage());
                    String errorName = "dataStreamError";
                    this.handleError(outerFilename, errorName, reportId, reportName, reportError, importCacheKey, importStatusVo);
                    return false;
                }
            }
            if (HussarUtils.isNotEmpty((Object)(sysReportGroup = SysReportExpImpServiceImpl.readFileToObject(reportGroupPath, Map.class)))) {
                List sysReportGroupList = JSON.parseArray((String)((JSONArray)sysReportGroup.get("reportGroup")).toString(), SysReportGroup.class);
                try {
                    this.sysReportGroupService.saveOrUpdateBatch((Collection)sysReportGroupList);
                }
                catch (Exception e) {
                    ReportErrorResultDto reportError = new ReportErrorResultDto(Integer.valueOf(ReportErrorCodeEnum.DATA_GROUP_IMPORT_ERROR.getCode()), ReportErrorCodeEnum.DATA_GROUP_IMPORT_ERROR.getMessage());
                    String errorName = "dataGroupError";
                    this.handleError(outerFilename, errorName, reportId, reportName, reportError, importCacheKey, importStatusVo);
                    return false;
                }
            }
            if (HussarUtils.isNotEmpty((Object)(dashboard = SysReportExpImpServiceImpl.readFileToObject(dashboardPath, Map.class)))) {
                List dashboardList = JSON.parseArray((String)((JSONArray)dashboard.get("dashboard")).toString(), ReportDashEntry.class);
                try {
                    this.reportDashEntryService.saveOrUpdateBatch((Collection)dashboardList);
                }
                catch (Exception e) {
                    ReportErrorResultDto reportError = new ReportErrorResultDto(Integer.valueOf(ReportErrorCodeEnum.DASHBOARD_IMPORT_ERROR.getCode()), ReportErrorCodeEnum.DASHBOARD_IMPORT_ERROR.getMessage());
                    String errorName = "dashboardError";
                    this.handleError(outerFilename, errorName, reportId, reportName, reportError, importCacheKey, importStatusVo);
                    return false;
                }
            }
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6IO\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            ReportErrorDto error = new ReportErrorDto();
            error.setName(reportName);
            if (HussarUtils.isNotEmpty(reportId)) {
                error.setId(reportId);
            }
            HashMap<String, Integer> reportError = new HashMap<String, Integer>();
            reportError.put("reportError", ReportErrorCodeEnum.FILE_IO.getCode());
            error.setError(reportError);
            ((List)((Map)importStatusVo.getData()).get(outerFilename)).add(error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
        }
        catch (IORuntimeException e) {
            logger.error("ZIP\u6587\u4ef6\u89e3\u538b\u5f02\u5e38", (Throwable)e);
            ReportErrorDto error = new ReportErrorDto();
            error.setName(file.getName());
            if (HussarUtils.isNotEmpty(reportId)) {
                error.setId(reportId);
            }
            HashMap<String, Integer> reportError = new HashMap<String, Integer>();
            reportError.put("reportError", ReportErrorCodeEnum.FILE_NOT_UNZIP.getCode());
            error.setError(reportError);
            ((List)((Map)importStatusVo.getData()).get(outerFilename)).add(error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
        }
        return true;
    }

    public void copyFilesToFolder(Map<Long, String> fileIds, String basicPath, Map<String, Integer> nameRepeat) {
        String[] ids = new String[fileIds.size()];
        ArrayList<Long> idList = new ArrayList<Long>(fileIds.keySet());
        for (int i = 0; i < idList.size(); ++i) {
            ids[i] = String.valueOf(idList.get(i));
        }
        List attachmentManagerModels = this.ossService.getByFileIds(ids);
        for (AttachmentManagerModel attachmentManagerModel : attachmentManagerModels) {
            Long id = attachmentManagerModel.getId();
            String name = fileIds.get(id);
            if (HussarUtils.isNotEmpty((Object)(name = this.verifyName(name)))) {
                String modelAttachmentName = attachmentManagerModel.getAttachmentName();
                String[] split = modelAttachmentName.split("\\.");
                String splitLast = split[split.length - 1];
                attachmentManagerModel.setAttachmentName(name + "." + splitLast);
            }
            Long attachmentId = attachmentManagerModel.getId();
            String attachmentType = attachmentManagerModel.getAttachmentType();
            String attachmentName = attachmentManagerModel.getAttachmentName();
            String pre = "";
            int index = attachmentName.lastIndexOf(".");
            if (index > -1) {
                pre = attachmentName.substring(0, index);
            }
            if (pre.length() > 50) {
                pre = pre.substring(0, 50);
            }
            attachmentName = pre + "." + attachmentManagerModel.getAttachmentType();
            attachmentManagerModel.setAttachmentName(attachmentName);
            String destinationPath = FileUtil.posixPath((String[])new String[]{basicPath, attachmentName});
            if (new File(destinationPath).exists()) {
                String fileName;
                if (nameRepeat.containsKey(destinationPath)) {
                    Integer repeatCount = nameRepeat.get(destinationPath);
                    fileName = attachmentManagerModel.getAttachmentName().substring(0, attachmentManagerModel.getAttachmentName().lastIndexOf(".")) + "(" + (repeatCount + 1) + ")." + attachmentType;
                    nameRepeat.put(destinationPath, repeatCount + 1);
                } else {
                    fileName = attachmentManagerModel.getAttachmentName().substring(0, attachmentManagerModel.getAttachmentName().lastIndexOf(".")) + "(1)." + attachmentType;
                    nameRepeat.put(destinationPath, 1);
                }
                destinationPath = FileUtil.posixPath((String[])new String[]{basicPath, fileName});
            }
            this.copyFileById(attachmentId, destinationPath);
        }
    }

    private void copyFileById(Long sourceFileId, String destinationPath) {
        ApiResponse download = this.ossService.backgroundDownload(sourceFileId);
        byte[] data = (byte[])download.getData();
        try {
            FileUtils.writeByteArrayToFile((File)new File(destinationPath), (byte[])data);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u5f02\u5e38", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    private String verifyName(String name) {
        if (HussarUtils.isNotEmpty((Object)name)) {
            name = name.replace("\\", "");
            name = name.replace("/", "");
            name = name.replace(":", "");
            name = name.replace("*", "");
            name = name.replace("?", "");
            name = name.replace("\"", "");
            name = name.replace(">", "");
            name = name.replace("<", "");
            name = name.replace("|", "");
            name = name.replace("$", "");
            name = name.replace("#", "");
            name = name.replace("&", "");
            name = name.replace("%", "");
            name = name.replace("~", "");
            name = name.replace("{", "");
            name = name.replace("}", "");
            name = name.replace("[", "");
            name = name.replace("]", "");
        }
        return name;
    }

    public Long zipFile(String zipFolderPath, String zipFolderName) throws Exception {
        File parentDir = new File(zipFolderPath).getParentFile();
        String zipPath = parentDir.getAbsolutePath() + File.separator + zipFolderName + ".zip";
        ZipUtil.zip((String)zipFolderPath, (String)zipPath);
        MockMultipartFile multipartFile = new MockMultipartFile(zipFolderName + ".zip", zipFolderName + ".zip", ".zip", Files.newInputStream(Paths.get(zipPath, new String[0]), new OpenOption[0]));
        ApiResponse longApiResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        Long data = (Long)longApiResponse.getData();
        return data;
    }

    private List<Long> getDashboardIds(String json) {
        ArrayList<Long> dashboardIds = new ArrayList<Long>();
        JSONObject rootObject = (JSONObject)JsonUtil.parse((String)json, JSONObject.class);
        JSONObject workBook = rootObject.getJSONObject("workBook");
        IWorkbookData workbookData = (IWorkbookData)JSON.parseObject((String)workBook.toJSONString(), IWorkbookData.class);
        Map sheets = workbookData.getSheets();
        for (IWorksheetData sheet : sheets.values()) {
            Map cellData = sheet.getCellData();
            for (Map row : cellData.values()) {
                for (ICellData cell : row.values()) {
                    Map valueMap;
                    Map custom;
                    if (!HussarUtils.isNotEmpty((Object)cell.getCustom()) || !HussarUtils.isNotEmpty((custom = cell.getCustom()).get("CHART_CONFIG")) || !(valueMap = (Map)custom.get("CHART_CONFIG")).containsKey("entryId")) continue;
                    dashboardIds.add(Long.parseLong(valueMap.get("entryId").toString()));
                }
            }
        }
        return dashboardIds;
    }

    private void handleError(String outerFilename, String errorName, Long reportId, String reportName, ReportErrorResultDto errorResultDto, String importCacheKey, ImportStatusVo<Map<String, List<ReportErrorDto>>> importStatusVo) {
        ReportErrorDto error = new ReportErrorDto();
        error.setId(reportId);
        error.setName(reportName);
        HashMap<String, ReportErrorResultDto> reportError = new HashMap<String, ReportErrorResultDto>();
        reportError.put(errorName, errorResultDto);
        error.setError(reportError);
        ((List)((Map)importStatusVo.getData()).get(outerFilename)).add(error);
        importStatusVo.setErrorFlag(true);
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, importStatusVo);
    }
}

