/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.dataset.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.application.Util.ReportHookUtil;
import com.jxdinfo.hussar.application.dataset.service.IDatasetService;
import com.jxdinfo.hussar.application.enums.ReportHookEnum;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.hook.service.IReportDatasetHookService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.dataset.service.impl.DatasetServiceImpl")
public class DatasetServiceImpl
implements IDatasetService {
    @Resource
    private IDataSetEngineService dataSetEngineService;
    @Resource
    private ISysReportService reportService;
    private static Logger logger = LoggerFactory.getLogger(DatasetServiceImpl.class);

    public List<DataSetExecuteVO> executeDefaultResult(Long reportId, String sheetId, Map<String, List<SuperQueryConditionDto>> superQueryConditionDtoMap) {
        IWorksheetData sheet;
        ArrayList<DataSetExecuteVO> dataSetExecuteVOList = new ArrayList();
        SysReport report = (SysReport)this.reportService.getById((Serializable)reportId);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        List<DataSetCommonParam> dataSetCommonParams = new ArrayList<DataSetCommonParam>();
        try {
            designMap = (Map)objectMapper.readValue(report.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue(designMap.get("workBook"), IWorkbookData.class);
        if (HussarUtils.isNotEmpty((Object)sheetId) && HussarUtils.isNotEmpty((Object)(sheet = (IWorksheetData)workbookData.getSheets().get(sheetId)))) {
            dataSetCommonParams = this.getDataSetCommonParams(sheet, superQueryConditionDtoMap);
        }
        if (HussarUtils.isEmpty(dataSetCommonParams)) {
            return null;
        }
        dataSetExecuteVOList = this.formatResult(dataSetCommonParams);
        return dataSetExecuteVOList;
    }

    public List<DataSetExecuteVO> formatResult(List<DataSetCommonParam> dataSetCommonParams) {
        return this.formatResult(dataSetCommonParams, null);
    }

    public List<DataSetExecuteVO> formatResult(List<DataSetCommonParam> dataSetCommonParams, String exParam) {
        List<DataSetExecuteVO> dataSetExecuteVOList = new ArrayList();
        String serviceName = ReportHookEnum.REPORT_DATASET_HOOK_SERVICE_IMPL.getValue();
        String preHookName = ReportHookUtil.getPreHookName(exParam);
        if (HussarUtils.isNotEmpty((Object)preHookName)) {
            serviceName = preHookName + serviceName;
        }
        IReportDatasetHookService reportDatasetHookService = null;
        try {
            reportDatasetHookService = (IReportDatasetHookService)SpringUtil.getBean((String)serviceName, IReportDatasetHookService.class);
        }
        catch (Exception e) {
            logger.error("\u672a\u80fd\u627e\u5230Bean: {}", (Object)serviceName);
        }
        if (HussarUtils.isNotEmpty((Object)reportDatasetHookService)) {
            reportDatasetHookService.formatResultBefore(dataSetCommonParams, exParam);
        }
        dataSetExecuteVOList = (List)this.dataSetEngineService.executeDataSetParam(dataSetCommonParams).getData();
        if (HussarUtils.isNotEmpty((Object)reportDatasetHookService)) {
            reportDatasetHookService.formatResultAfter(dataSetExecuteVOList, exParam);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (HussarUtils.isNotEmpty(dataSetExecuteVOList)) {
            for (DataSetExecuteVO dataSetExecuteVO : dataSetExecuteVOList) {
                String value = dataSetExecuteVO.getReturnValue();
                try {
                    JsonNode jsonNode = objectMapper.readTree(value);
                    if (jsonNode.isArray() || !jsonNode.isObject()) continue;
                    Map mapValue = (Map)objectMapper.readValue(value, Map.class);
                    boolean foundList = false;
                    for (Map.Entry entry : mapValue.entrySet()) {
                        if (!(entry.getValue() instanceof List)) continue;
                        List firstList = (List)entry.getValue();
                        String listJsonString = objectMapper.writeValueAsString((Object)firstList);
                        dataSetExecuteVO.setReturnValue(listJsonString);
                        foundList = true;
                        break;
                    }
                    if (foundList) continue;
                    dataSetExecuteVO.setReturnValue("[]");
                }
                catch (Exception e) {
                    System.err.println("\u65e0\u6548\u7684 JSON \u5b57\u7b26\u4e32: " + value);
                }
            }
        }
        return dataSetExecuteVOList;
    }

    public List<DataSetCommonParam> getDataSetCommonParams(IWorksheetData sheet, Map<String, List<SuperQueryConditionDto>> superQueryConditionDtoMap) {
        ArrayList<DataSetCommonParam> dataSetCommonParams = new ArrayList<DataSetCommonParam>();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map custom = sheet.getCustom();
        if (HussarUtils.isNotEmpty((Object)custom)) {
            Map sheetCustomMap = (Map)objectMapper.convertValue((Object)custom, Map.class);
            Object useDataSetList = sheetCustomMap.get("useDataSetList");
            Object defaultFilters = sheetCustomMap.get("defaultFilters");
            Map<Object, Object> superQueryConditionMap = new HashMap();
            if (HussarUtils.isNotEmpty(superQueryConditionDtoMap)) {
                superQueryConditionMap = superQueryConditionDtoMap;
            }
            if (HussarUtils.isNotEmpty(defaultFilters)) {
                List defaultFiltersMap = (List)objectMapper.convertValue(defaultFilters, ArrayList.class);
                for (Map defaultFiltersMapItem : defaultFiltersMap) {
                    String dataSetId = (String)defaultFiltersMapItem.get("sourceId");
                    ArrayList<Object> superQueryConditionList = new ArrayList<Object>();
                    SuperQueryConditionDto superQueryConditionDto = new SuperQueryConditionDto();
                    superQueryConditionDto.setField((String)defaultFiltersMapItem.get("field"));
                    superQueryConditionDto.setRule((String)defaultFiltersMapItem.get("rule"));
                    superQueryConditionDto.setMatch((String)defaultFiltersMapItem.get("match"));
                    superQueryConditionDto.setVal(defaultFiltersMapItem.get("val"));
                    superQueryConditionList.add(superQueryConditionDto);
                    if (HussarUtils.isNotEmpty(superQueryConditionMap) && HussarUtils.isNotEmpty((Object)superQueryConditionMap.get(dataSetId))) {
                        List selSuperQueryConditionList = (List)superQueryConditionMap.get(dataSetId);
                        List filteredSuperQueryConditionList = superQueryConditionList.stream().filter(condition -> selSuperQueryConditionList.stream().noneMatch(existing -> Objects.equals(existing.getField(), condition.getField()))).collect(Collectors.toList());
                        superQueryConditionList.clear();
                        superQueryConditionList.addAll(filteredSuperQueryConditionList);
                        superQueryConditionList.addAll(selSuperQueryConditionList);
                    }
                    superQueryConditionMap.put(dataSetId, superQueryConditionList);
                }
            }
            if (HussarUtils.isNotEmpty(useDataSetList)) {
                List useDataSetListMap = (List)objectMapper.convertValue(useDataSetList, ArrayList.class);
                Collection<Map> uniqueUseDataSetList = useDataSetListMap.stream().collect(Collectors.toMap(item -> {
                    Map dataSet = (Map)objectMapper.convertValue(item.get("dataSet"), Map.class);
                    return (String)dataSet.get("id");
                }, item -> item, (existing, replacement) -> existing)).values();
                for (Map useDataSetListMapItem : uniqueUseDataSetList) {
                    DataSetCommonParam dataSetCommonParam = new DataSetCommonParam();
                    Map dataSet = (Map)objectMapper.convertValue(useDataSetListMapItem.get("dataSet"), Map.class);
                    DataSetCondition dataSetCondition = new DataSetCondition();
                    dataSetCondition.setDataSetId((String)dataSet.get("id"));
                    dataSetCondition.setPagination(false);
                    dataSetCondition.setDataSetFunctionType("CUSTOM_SQL");
                    if (HussarUtils.isNotEmpty(superQueryConditionMap) && HussarUtils.isNotEmpty((Object)superQueryConditionMap.get(dataSet.get("id")))) {
                        dataSetCondition.setSuperQueryConditionDto((List)superQueryConditionMap.get(dataSet.get("id")));
                    }
                    dataSetCommonParam.setDataSetCondition(dataSetCondition);
                    dataSetCommonParams.add(dataSetCommonParam);
                }
            }
        }
        return dataSetCommonParams;
    }

    public List<DataSetExecuteVO> executeDefaultResultByPage(Long reportId, String sheetId, List<DataSetCommonParam> dataSetCommonParam) {
        return this.executeDefaultResultByPage(reportId, sheetId, dataSetCommonParam, null);
    }

    public List<DataSetExecuteVO> executeDefaultResultByPage(Long reportId, String sheetId, List<DataSetCommonParam> dataSetCommonParam, String exParam) {
        IWorksheetData sheet;
        ArrayList<DataSetExecuteVO> dataSetExecuteVOList = new ArrayList();
        SysReport report = this.reportService.getSysReportById(reportId, exParam);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        List<DataSetCommonParam> dataSetCommonParams = HussarUtils.isNotEmpty(dataSetCommonParam) ? dataSetCommonParam : new ArrayList<DataSetCommonParam>();
        try {
            designMap = (Map)objectMapper.readValue(report.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue(designMap.get("workBook"), IWorkbookData.class);
        if (HussarUtils.isNotEmpty((Object)sheetId) && HussarUtils.isNotEmpty((Object)(sheet = (IWorksheetData)workbookData.getSheets().get(sheetId)))) {
            dataSetCommonParams = this.getDataSetCommonParamsByPage(sheet, dataSetCommonParams);
        }
        if (HussarUtils.isEmpty(dataSetCommonParams)) {
            return null;
        }
        dataSetExecuteVOList = this.formatResult(dataSetCommonParams, exParam);
        return dataSetExecuteVOList;
    }

    public List<DataSetCommonParam> getDataSetCommonParamsByPage(IWorksheetData sheet, List<DataSetCommonParam> dataSetCommonParams) {
        if (HussarUtils.isEmpty(dataSetCommonParams)) {
            dataSetCommonParams = new ArrayList<DataSetCommonParam>();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map custom = sheet.getCustom();
        if (HussarUtils.isNotEmpty((Object)custom)) {
            Map sheetCustomMap = (Map)objectMapper.convertValue((Object)custom, Map.class);
            Object useDataSetList = sheetCustomMap.get("useDataSetList");
            Object defaultFilters = sheetCustomMap.get("defaultFilters");
            HashMap<String, List> superQueryConditionMap = new HashMap<String, List>();
            for (DataSetCommonParam dataSetCommonParam : dataSetCommonParams) {
                if (!HussarUtils.isNotEmpty((Object)dataSetCommonParam.getDataSetCondition().getSuperQueryConditionDto())) continue;
                superQueryConditionMap.put(dataSetCommonParam.getDataSetCondition().getDataSetId(), dataSetCommonParam.getDataSetCondition().getSuperQueryConditionDto());
            }
            if (HussarUtils.isNotEmpty(defaultFilters)) {
                List defaultFiltersMap = (List)objectMapper.convertValue(defaultFilters, ArrayList.class);
                for (Map defaultFiltersMapItem : defaultFiltersMap) {
                    String dataSetId = (String)defaultFiltersMapItem.get("sourceId");
                    ArrayList<Object> superQueryConditionList = new ArrayList<Object>();
                    SuperQueryConditionDto superQueryConditionDto = new SuperQueryConditionDto();
                    superQueryConditionDto.setField((String)defaultFiltersMapItem.get("field"));
                    superQueryConditionDto.setRule((String)defaultFiltersMapItem.get("rule"));
                    superQueryConditionDto.setMatch((String)defaultFiltersMapItem.get("match"));
                    superQueryConditionDto.setVal(defaultFiltersMapItem.get("val"));
                    superQueryConditionList.add(superQueryConditionDto);
                    if (HussarUtils.isNotEmpty(superQueryConditionMap) && HussarUtils.isNotEmpty(superQueryConditionMap.get(dataSetId))) {
                        List selSuperQueryConditionList = (List)superQueryConditionMap.get(dataSetId);
                        List filteredSuperQueryConditionList = superQueryConditionList.stream().filter(condition -> selSuperQueryConditionList.stream().noneMatch(existing -> Objects.equals(existing.getField(), condition.getField()))).collect(Collectors.toList());
                        superQueryConditionList.clear();
                        superQueryConditionList.addAll(filteredSuperQueryConditionList);
                        superQueryConditionList.addAll(selSuperQueryConditionList);
                    }
                    superQueryConditionMap.put(dataSetId, superQueryConditionList);
                }
            }
            if (HussarUtils.isNotEmpty(useDataSetList)) {
                List useDataSetListMap = (List)objectMapper.convertValue(useDataSetList, ArrayList.class);
                List list = useDataSetListMap.stream().map(item -> {
                    Map dataSet = (Map)objectMapper.convertValue(item.get("dataSet"), Map.class);
                    return (String)dataSet.get("id");
                }).distinct().collect(Collectors.toList());
                for (DataSetCommonParam dataSetCommonParam : dataSetCommonParams) {
                    dataSetCommonParam.getDataSetCondition().setSuperQueryConditionDto((List)superQueryConditionMap.get(dataSetCommonParam.getDataSetCondition().getDataSetId()));
                    list.remove(dataSetCommonParam.getDataSetCondition().getDataSetId());
                }
                if (HussarUtils.isNotEmpty(list)) {
                    for (String id : list) {
                        DataSetCommonParam dataSetCommonParam = new DataSetCommonParam();
                        DataSetCondition dataSetCondition = new DataSetCondition();
                        dataSetCondition.setDataSetId(id);
                        dataSetCondition.setPagination(false);
                        dataSetCondition.setDataSetFunctionType("CUSTOM_SQL");
                        if (HussarUtils.isNotEmpty(superQueryConditionMap) && HussarUtils.isNotEmpty(superQueryConditionMap.get(String.valueOf(id)))) {
                            dataSetCondition.setSuperQueryConditionDto((List)superQueryConditionMap.get(id));
                        }
                        dataSetCondition.setCurrent(1);
                        dataSetCondition.setSize(2000);
                        dataSetCommonParam.setDataSetCondition(dataSetCondition);
                        dataSetCommonParams.add(dataSetCommonParam);
                    }
                }
            }
        }
        return dataSetCommonParams;
    }
}

