/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.Util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbookCustomPropertyUtil {
    private static final Logger logger = LoggerFactory.getLogger(WorkbookCustomPropertyUtil.class);

    public static void setWorkbookCustomProperty(XSSFWorkbook workbook, String propertyName, String propertyValue) {
        try {
            POIXMLProperties props = workbook.getProperties();
            POIXMLProperties.CustomProperties customProps = props.getCustomProperties();
            if (HussarUtils.isNotEmpty((Object)propertyValue)) {
                customProps.addProperty(propertyName, propertyValue);
            }
        }
        catch (Exception e) {
            logger.warn("\u8bbe\u7f6e\u5de5\u4f5c\u7c3f\u81ea\u5b9a\u4e49\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)propertyName, (Object)e);
        }
    }

    public static String getWorkbookCustomProperty(XSSFWorkbook workbook, String propertyName) {
        try {
            POIXMLProperties props = workbook.getProperties();
            POIXMLProperties.CustomProperties customProps = props.getCustomProperties();
            CTProperty propertyValue = customProps.getProperty(propertyName);
            if (propertyValue != null) {
                String jsonContent;
                String value = propertyValue.toString();
                if (value.contains("<xml-fragment") && value.contains("<doc:lpwstr>") && (jsonContent = WorkbookCustomPropertyUtil.extractJsonFromXml(value)) != null && !jsonContent.isEmpty()) {
                    return jsonContent;
                }
                if (!value.contains("xsi:nil=\"true\"") && !value.isEmpty()) {
                    return value;
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u5de5\u4f5c\u7c3f\u81ea\u5b9a\u4e49\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)propertyName, (Object)e);
            return null;
        }
    }

    public static String extractJsonFromXml(String xmlContent) {
        try {
            int start = xmlContent.indexOf("<doc:lpwstr>");
            int end = xmlContent.indexOf("</doc:lpwstr>");
            if (start != -1 && end != -1 && end > start) {
                return xmlContent.substring(start + 12, end).trim();
            }
            return xmlContent;
        }
        catch (Exception e) {
            logger.warn("\u4eceXML\u4e2d\u63d0\u53d6JSON\u5185\u5bb9\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)xmlContent, (Object)e);
            return xmlContent;
        }
    }

    public static String getWorkbookCustomKey(String preName, String sheetName, int startRow, int startCol) {
        return preName + sheetName + ":" + startRow + "," + startCol;
    }
}

