/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.Util;

import com.jxdinfo.hussar.application.report.Vo.FileDownloadVo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.Util.UrlDownloadUtil")
public class UrlDownloadUtil {
    private static final Logger logger = LoggerFactory.getLogger(UrlDownloadUtil.class);
    private static int connectTimeout = 5000;
    private static int readTimeout = 5000;

    @Value(value="${report.fileDown.connectTimeout:5000}")
    public void setConnectTimeout(int connectTimeout) {
        UrlDownloadUtil.connectTimeout = connectTimeout;
    }

    @Value(value="${report.fileDown.readTimeout:5000}")
    public void setReadTimeout(int readTimeout) {
        UrlDownloadUtil.readTimeout = readTimeout;
    }

    /*
     * Exception decompiling
     */
    public static byte[] downloadFileFromUrl(String fileUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static FileDownloadVo downloadFileWithHeaderFileName(String fileUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String extractFileNameFromUrl(String fileUrl) {
        if (fileUrl == null || fileUrl.isEmpty()) {
            return null;
        }
        try {
            String fileName;
            URL url = new URL(fileUrl);
            String path = url.getPath();
            if (path != null && !path.isEmpty() && !(fileName = path.substring(path.lastIndexOf(47) + 1)).isEmpty()) {
                try {
                    return URLDecoder.decode(fileName, "UTF-8");
                }
                catch (Exception e) {
                    logger.debug("URL\u89e3\u7801\u6587\u4ef6\u540d\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6\u540d: {}", (Object)fileName);
                    return fileName;
                }
            }
        }
        catch (Exception e) {
            logger.debug("\u4eceURL\u63d0\u53d6\u6587\u4ef6\u540d\u5931\u8d25: {}", (Object)fileUrl);
        }
        return null;
    }

    private static String extractFileNameFromHeader(HttpURLConnection connection) {
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        logger.debug("\u539f\u59cbContent-Disposition\u5934\u90e8: {}", (Object)contentDisposition);
        if (contentDisposition != null) {
            int filenameStarIndex = contentDisposition.indexOf("filename*=");
            if (filenameStarIndex != -1) {
                String fileName = contentDisposition.substring(filenameStarIndex + 10);
                if (fileName.startsWith("UTF-8''")) {
                    try {
                        String encodedFileName = fileName.substring(7);
                        return URLDecoder.decode(encodedFileName, "UTF-8");
                    }
                    catch (Exception e) {
                        logger.warn("UTF-8\u89e3\u7801\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6\u540d: {}", (Object)fileName);
                        return fileName;
                    }
                }
                return fileName;
            }
            int filenameIndex = contentDisposition.indexOf("filename=");
            if (filenameIndex != -1) {
                String recoveredFileName;
                String fileName = contentDisposition.substring(filenameIndex + 9);
                logger.debug("\u63d0\u53d6\u7684\u539f\u59cb\u6587\u4ef6\u540d: {}", (Object)fileName);
                if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
                    fileName = fileName.substring(1, fileName.length() - 1);
                }
                if ((recoveredFileName = UrlDownloadUtil.recoverFileNameEncoding(fileName)) != null) {
                    logger.debug("\u6062\u590d\u540e\u7684\u6587\u4ef6\u540d: {}", (Object)recoveredFileName);
                    return recoveredFileName;
                }
                logger.warn("\u6587\u4ef6\u540d\u7f16\u7801\u6062\u590d\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6\u540d: {}", (Object)fileName);
                return fileName;
            }
        }
        return null;
    }

    private static String recoverFileNameEncoding(String fileName) {
        String result;
        byte[] bytes;
        try {
            bytes = fileName.getBytes("ISO-8859-1");
            result = new String(bytes, "UTF-8");
            if (UrlDownloadUtil.isValidFileName(result)) {
                return result;
            }
        }
        catch (Exception e) {
            logger.debug("ISO-8859-1\u5230UTF-8\u8f6c\u6362\u5931\u8d25: {}", (Object)fileName);
        }
        try {
            bytes = fileName.getBytes("ISO-8859-1");
            result = new String(bytes, "GBK");
            if (UrlDownloadUtil.isValidFileName(result)) {
                return result;
            }
        }
        catch (Exception e) {
            logger.debug("ISO-8859-1\u5230GBK\u8f6c\u6362\u5931\u8d25: {}", (Object)fileName);
        }
        try {
            bytes = fileName.getBytes();
            result = new String(bytes, "UTF-8");
            if (UrlDownloadUtil.isValidFileName(result)) {
                return result;
            }
        }
        catch (Exception e) {
            logger.debug("\u7cfb\u7edf\u9ed8\u8ba4\u7f16\u7801\u8f6c\u6362\u5931\u8d25: {}", (Object)fileName);
        }
        return null;
    }

    private static boolean isValidFileName(String fileName) {
        if (fileName == null || fileName.length() == 0 || fileName.equals("")) {
            return false;
        }
        if (fileName.contains("=") && fileName.contains("&") && fileName.contains(",")) {
            return false;
        }
        if (fileName.length() > 255) {
            return false;
        }
        return fileName.matches(".*[a-zA-Z0-9\u4e00-\u9fa5_.-]+.*");
    }
}

