/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.Util;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class FormulaUtils {
    public static Object evaluateFormula(String formulaExpression, Sheet sheet) {
        CellValue cellValue;
        Workbook workbook = sheet.getWorkbook();
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        int lastRowNum = sheet.getLastRowNum();
        Row tempRow = sheet.createRow(lastRowNum + 1);
        Cell tempCell = tempRow.createCell(0);
        tempCell.setCellFormula(FormulaUtils.replaceJS(formulaExpression));
        try {
            cellValue = evaluator.evaluate(tempCell);
        }
        catch (Exception e) {
            return false;
        }
        sheet.removeRow(tempRow);
        switch (cellValue.getCellType()) {
            case NUMERIC: {
                return cellValue.getNumberValue();
            }
            case STRING: {
                return cellValue.getStringValue();
            }
            case BOOLEAN: {
                return cellValue.getBooleanValue();
            }
        }
        return false;
    }

    public static String replaceJS(String formulaExpression) {
        formulaExpression = formulaExpression.replace("===", "=").replace("==", "=").replace("!=", "<>").replace("ISEMPTY", "ISBLANK");
        return formulaExpression;
    }
}

