/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.reportsnapshot.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.application.excel.Vo.IStyleData;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.excel.service.IExcelExporterService;
import com.jxdinfo.hussar.application.excel.service.IExcelImportService;
import com.jxdinfo.hussar.application.reportsnapshot.Vo.SnapShotVo;
import com.jxdinfo.hussar.application.reportsnapshot.dao.SysReportSnapshotMapper;
import com.jxdinfo.hussar.application.reportsnapshot.model.SysReportSnapshot;
import com.jxdinfo.hussar.application.reportsnapshot.service.ISysReportSnapShotService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.reportsnapshot.service.impl.SysReportSnapShotServiceImpl")
public class SysReportSnapShotServiceImpl
extends HussarServiceImpl<SysReportSnapshotMapper, SysReportSnapshot>
implements ISysReportSnapShotService {
    @Resource
    private SysReportSnapshotMapper sysReportSnapshotMapper;
    @Resource
    private IExcelExporterService excelExporterService;
    @Resource
    private IExcelImportService excelImportService;

    public Long addSnapshot(SnapShotVo sysReportSnapshot) {
        SecurityUser userDetails;
        if (HussarUtils.isEmpty((Object)sysReportSnapshot.getSnapshotId())) {
            Map<String, Object> workbookData = this.fixWorkbookData(sysReportSnapshot);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String designInformation = objectMapper.writeValueAsString(workbookData);
                sysReportSnapshot.setDesignInformation(designInformation);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("\u65e0\u6cd5\u5c06 workbookData \u8f6c\u6362\u4e3a JSON", e);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(userDetails = BaseSecurityUtil.getUser()))) {
            sysReportSnapshot.setCreateName(userDetails.getUserName());
            sysReportSnapshot.setLastEditorName(userDetails.getUserName());
        }
        int maxSnapshotSeq = 0;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReportSnapshot::getReportId, (Object)sysReportSnapshot.getReportId());
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(SysReportSnapshot::getSeq)).last("LIMIT 1");
        SysReportSnapshot maxSeqSnapshot = (SysReportSnapshot)((SysReportSnapshotMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)maxSeqSnapshot)) {
            maxSnapshotSeq = maxSeqSnapshot.getSeq();
            sysReportSnapshot.setSeq(maxSnapshotSeq + 1);
        } else {
            sysReportSnapshot.setSeq(1);
        }
        if (HussarUtils.isNotEmpty((Object)sysReportSnapshot.getSnapshotName())) {
            sysReportSnapshot.setSnapshotName(sysReportSnapshot.getSnapshotName() + "_" + (maxSnapshotSeq + 1));
        } else {
            sysReportSnapshot.setSnapshotName(String.valueOf(maxSnapshotSeq));
        }
        boolean isAdd = this.save((BaseEntity)sysReportSnapshot);
        if (isAdd) {
            Long generatedId = sysReportSnapshot.getSnapshotId();
            return generatedId;
        }
        return null;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editSnapshot(SysReportSnapshot sysReportSnapshot) {
        SecurityUser userDetails = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            sysReportSnapshot.setLastEditorName(userDetails.getUserName());
        }
        boolean updated = this.updateById((BaseEntity)sysReportSnapshot);
        return updated;
    }

    public Boolean delSnapshotByReportId(Long reportId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReportSnapshot::getReportId, (Object)reportId);
        boolean isDel = this.remove((Wrapper)queryWrapper);
        return isDel;
    }

    public Boolean delSnapshot(List<Long> snapshotIds) {
        return this.removeByIds(snapshotIds);
    }

    public List<SysReportSnapshot> getSysReportSnapshotByReportId(Long reportId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReportSnapshot::getReportId, (Object)reportId);
        List sysReportSnapshots = ((SysReportSnapshotMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReportSnapshots;
    }

    public List<SysReportSnapshot> getSysReportSnapshotVoByReportId(Long reportId) {
        return this.sysReportSnapshotMapper.selectSysReportSnapshotsByReportId(reportId);
    }

    public SysReportSnapshot getSysReportSnapshotById(Long snapshotId) {
        return (SysReportSnapshot)((SysReportSnapshotMapper)this.baseMapper).selectById(snapshotId);
    }

    public Map<String, Object> fixWorkbookData(SnapShotVo snapshot) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map designMap = null;
        try {
            designMap = (Map)objectMapper.readValue(snapshot.getDesignInformation(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        IWorkbookData workbookData = (IWorkbookData)objectMapper.convertValue((Object)designMap, IWorkbookData.class);
        List resources = workbookData.getResources();
        HashMap autoFilter = new HashMap();
        if (HussarUtils.isNotEmpty((Object)resources)) {
            Optional<String> sheetFilterPluginData = resources.stream().filter(resource -> "SHEET_FILTER_PLUGIN".equals(resource.get("name"))).map(resource -> (String)resource.get("data")).findFirst();
            sheetFilterPluginData.ifPresent(data -> {
                ObjectMapper objectMapper2 = new ObjectMapper();
                try {
                    if (HussarUtils.isNotEmpty((Object)data)) {
                        Map filter = (Map)objectMapper2.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        autoFilter.putAll(filter);
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            workbook.setForceFormulaRecalculation(true);
            Map sheetsMap = new HashMap();
            if (HussarUtils.isNotEmpty((Object)designMap) && HussarUtils.isNotEmpty((Object)((Map)designMap.get("sheets")))) {
                sheetsMap = (Map)designMap.get("sheets");
            }
            HashMap styles = new HashMap();
            if (HussarUtils.isNotEmpty((Object)snapshot.getLoadedSheetIds())) {
                Map sheets = workbookData.getSheets();
                List sheetIds = workbookData.getSheetOrder();
                ArrayList<String> fixSheet = new ArrayList<String>();
                for (String sheetId : sheetIds) {
                    if (snapshot.getLoadedSheetIds().contains(sheetId)) continue;
                    fixSheet.add(sheetId);
                }
                for (String sheetId : fixSheet) {
                    Map sheetMap = (Map)sheetsMap.get(sheetId);
                    IWorksheetData sheetData = (IWorksheetData)sheets.get(sheetId);
                    IWorksheetData worksheetData = this.excelImportService.convertSheet(this.excelExporterService.processSheet(workbook, sheetId, workbookData, new ArrayList(), null, sheetIds, Boolean.valueOf(true), autoFilter, null), styles);
                    IWorksheetData.copyData((IWorksheetData)worksheetData, (IWorksheetData)sheetData);
                    this.putSheetMap(worksheetData, sheetMap);
                }
                if (HussarUtils.isNotEmpty(fixSheet)) {
                    Map<String, IStyleData> styleMap = new HashMap();
                    if (HussarUtils.isNotEmpty((Object)designMap) && HussarUtils.isNotEmpty(designMap.get("styles"))) {
                        styleMap = (Map)designMap.get("styles");
                    }
                    for (Map.Entry entry : styles.entrySet()) {
                        String key = (String)entry.getKey();
                        IStyleData styleData = (IStyleData)entry.getValue();
                        styleMap.put(key, styleData);
                    }
                    designMap.put("styles", styleMap);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return designMap;
    }

    private Map<String, Object> putSheetMap(IWorksheetData source, Map<String, Object> sheetMap) {
        sheetMap.put("rowCount", source.getRowCount());
        sheetMap.put("columnCount", source.getColumnCount());
        sheetMap.put("freeze", source.getFreeze());
        sheetMap.put("cellData", source.getCellData());
        sheetMap.put("mergeData", source.getMergeData());
        sheetMap.put("rowData", source.getRowData());
        sheetMap.put("columnData", source.getColumnData());
        sheetMap.put("custom", source.getCustom());
        return sheetMap;
    }
}

