/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.excel.service.impl;

import com.jxdinfo.hussar.application.Util.ExcalConvertUtil;
import com.jxdinfo.hussar.application.config.DefaultReport;
import com.jxdinfo.hussar.application.excel.Vo.BorderData;
import com.jxdinfo.hussar.application.excel.Vo.BorderStyleData;
import com.jxdinfo.hussar.application.excel.Vo.ICellData;
import com.jxdinfo.hussar.application.excel.Vo.IMergeData;
import com.jxdinfo.hussar.application.excel.Vo.IStyleData;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.excel.enums.AlignConstants;
import com.jxdinfo.hussar.application.excel.enums.CellValueType;
import com.jxdinfo.hussar.application.excel.service.IExcelImportService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.excel.service.impl.ExcelImportImpl")
public class ExcelImportServiceImpl
implements IExcelImportService {
    @Resource
    private ISysReportService sysReportService;
    @Resource
    private DefaultReport defaultReport;

    public IWorkbookData handleExcelImport(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".xls") && !fileName.endsWith(".xlsx")) {
            System.out.println("\u8bf7\u4f7f\u7528.xlsx\u7c7b\u578b\u6587\u4ef6,\u6216.xls\u7c7b\u578b\u6587\u4ef6");
            return null;
        }
        if (fileName.endsWith(".xls")) {
            file = ExcalConvertUtil.convertXlsToXlsx(file);
        }
        try {
            return this.convert(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long importReport(MultipartFile file) {
        int dotIndex;
        SysReport sysReport = new SysReport();
        IWorkbookData workbookData = this.handleExcelImport(file);
        if (HussarUtils.isEmpty((Object)workbookData)) {
            return null;
        }
        HashMap<String, IWorkbookData> designInformation = new HashMap<String, IWorkbookData>();
        designInformation.put("workBook", workbookData);
        sysReport.setDesignInformation(JsonUtil.toJson(designInformation));
        String originalFilename = file.getOriginalFilename();
        if (HussarUtils.isNotEmpty((Object)originalFilename) && (dotIndex = originalFilename.lastIndexOf(46)) > 0) {
            originalFilename = originalFilename.substring(0, dotIndex);
        }
        sysReport.setReportName(originalFilename);
        return this.sysReportService.addReport(sysReport);
    }

    /*
     * Exception decompiling
     */
    public IWorkbookData convert(MultipartFile file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IWorksheetData convertSheet(Sheet sheet, Map<String, IStyleData> styles) {
        XSSFSheet xssfSheet;
        IWorksheetData sheetData = new IWorksheetData();
        sheetData.setId(UUID.randomUUID().toString().substring(0, 21));
        sheetData.setName(sheet.getSheetName());
        sheetData.setCellData(new HashMap());
        sheetData.setMergeData(new ArrayList());
        sheetData.setRowData(new HashMap());
        sheetData.setColumnData(new HashMap());
        if (sheet instanceof XSSFSheet && (xssfSheet = (XSSFSheet)sheet).getPaneInformation() != null) {
            PaneInformation paneInfo = xssfSheet.getPaneInformation();
            short startColumn = paneInfo.getVerticalSplitPosition();
            short startRow = paneInfo.getHorizontalSplitPosition();
            HashMap<String, Integer> freeze = new HashMap<String, Integer>();
            freeze.put("startRow", Integer.valueOf(startRow));
            freeze.put("ySplit", Integer.valueOf(startRow));
            freeze.put("startColumn", Integer.valueOf(startColumn));
            freeze.put("xSplit", Integer.valueOf(startColumn));
            sheetData.setFreeze(freeze);
        }
        int firstRow = sheet.getFirstRowNum();
        int lastRow = sheet.getLastRowNum();
        short maxCols = 0;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            IMergeData mergeData = new IMergeData();
            mergeData.setStartRow(region.getFirstRow());
            mergeData.setStartColumn(region.getFirstColumn());
            mergeData.setEndRow(region.getLastRow());
            mergeData.setEndColumn(region.getLastColumn());
            sheetData.getMergeData().add(mergeData);
        }
        for (int rowNum = firstRow; rowNum <= lastRow; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            short height = row.getHeight();
            HashMap<String, Double> rowProps = new HashMap<String, Double>();
            rowProps.put("h", (double)height / 20.0 * 1.333);
            sheetData.getRowData().put(String.valueOf(rowNum), rowProps);
            HashMap<Integer, ICellData> rowData = new HashMap<Integer, ICellData>();
            int firstCell = row.getFirstCellNum();
            short lastCell = row.getLastCellNum();
            if (lastCell > maxCols) {
                maxCols = lastCell;
            }
            for (int cellNum = firstCell; cellNum < lastCell; ++cellNum) {
                int width;
                String styleId;
                Cell cell = row.getCell(cellNum);
                if (cell == null) continue;
                ICellData cellData = new ICellData();
                cellData.setT(this.getCellType(cell.getCellType()));
                if (cell.getCellType() == CellType.FORMULA) {
                    cellData.setT(this.getCellType(cell.getCachedFormulaResultType()));
                    cellData.setF(this.getCellValue(cell));
                    cellData.setV(this.getFormulaValue(cell));
                } else {
                    cellData.setV(this.getCellValue(cell));
                }
                if (cell.getCellStyle() != null && (styleId = this.getStyleId(cell, sheet, styles)) != null) {
                    cellData.setS(styleId);
                }
                rowData.put(cellNum, cellData);
                if (sheet.isColumnHidden(cellNum) || (width = sheet.getColumnWidth(cellNum)) <= 0 || sheetData.getColumnData().containsKey(String.valueOf(cellNum))) continue;
                HashMap<String, Double> colProps = new HashMap<String, Double>();
                colProps.put("w", (double)width * 7.0 / 256.0);
                sheetData.getColumnData().put(String.valueOf(cellNum), colProps);
            }
            if (rowData.isEmpty()) continue;
            sheetData.getCellData().put(rowNum, rowData);
        }
        int defaultRow = this.defaultReport.getRow();
        int defaultColumn = this.defaultReport.getColumn();
        sheetData.setRowCount(Math.max(lastRow + 1, defaultRow));
        sheetData.setColumnCount(Math.max(maxCols, defaultColumn));
        return sheetData;
    }

    private String getStyleId(Cell cell, Sheet sheet, Map<String, IStyleData> styles) {
        BorderStyleData borderStyleData;
        short rotation;
        XSSFFont font;
        XSSFColor bgColor;
        XSSFCellStyle style = (XSSFCellStyle)cell.getCellStyle();
        String styleId = UUID.randomUUID().toString().substring(0, 8);
        IStyleData styleData = new IStyleData();
        if (cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell)) {
            HashMap<String, String> n = new HashMap<String, String>();
            n.put("pattern", cell.getCellStyle().getDataFormatString());
            styleData.setN(n);
        }
        if ((bgColor = this.getBackgroundColor(style, sheet)) != null) {
            styleData.setBg(this.rgbToMap(bgColor));
        }
        if ((font = style.getFont()) != null) {
            styleData.setFf(font.getFontName());
            styleData.setFs(Integer.valueOf(font.getFontHeightInPoints()));
            HashMap<String, Object> ul = new HashMap<String, Object>();
            HashMap<String, Object> st = new HashMap<String, Object>();
            styleData.setIt(font.getItalic() ? 1 : 0);
            styleData.setBl(font.getBold() ? 1 : 0);
            XSSFColor fontColor = this.getFontColor(font);
            if (fontColor != null) {
                Map<String, String> rgb = this.rgbToMap(fontColor);
                styleData.setCl(rgb);
                ul.put("cl", rgb);
                st.put("st", rgb);
            }
            if (font.getUnderline() != 0) {
                ul.put("s", 1);
            }
            styleData.setUl(ul);
            if (font.getStrikeout()) {
                st.put("s", 1);
            }
            styleData.setSt(st);
        }
        if (HussarUtils.isNotEmpty((Object)(rotation = style.getRotation()))) {
            HashMap<String, Short> tr = new HashMap<String, Short>();
            if (rotation > 90) {
                rotation = (short)(90 - rotation);
            }
            tr.put("a", -rotation);
            styleData.setTr(tr);
        }
        if (HussarUtils.isNotEmpty((Object)(borderStyleData = this.createBorderStyleData(style)))) {
            styleData.setBd(borderStyleData);
        }
        this.setAlignmentData(style, styleData);
        styleData.setTb(Integer.valueOf(style.getWrapText() ? 3 : 2));
        styles.put(styleId, styleData);
        return styleId;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case BLANK: {
                return "";
            }
            case NUMERIC: {
                double value = cell.getNumericCellValue();
                if (value == Math.floor(value) && !Double.isInfinite(value)) {
                    return String.valueOf((long)value);
                }
                return String.valueOf(value);
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return "=" + cell.getCellFormula();
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case ERROR: {
                return "#ERROR!";
            }
        }
        return "";
    }

    private String getFormulaValue(Cell cell) {
        switch (cell.getCachedFormulaResultType()) {
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
            case STRING: {
                return cell.getRichStringCellValue().getString();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case ERROR: {
                return "#ERROR!";
            }
        }
        return cell.getCellFormula();
    }

    private int getCellType(CellType cellType) {
        switch (cellType) {
            case NUMERIC: {
                return CellValueType.NUMBER.getValue();
            }
            case BOOLEAN: {
                return CellValueType.BOOLEAN.getValue();
            }
            case STRING: {
                return CellValueType.STRING.getValue();
            }
        }
        return CellValueType.STRING.getValue();
    }

    private XSSFColor getBackgroundColor(XSSFCellStyle style, Sheet sheet) {
        CTColor ctColor;
        XSSFColor fillForeColor;
        XSSFColor color = style.getFillForegroundColorColor();
        if ((HussarUtils.isEmpty((Object)color) || color.isAuto()) && HussarUtils.isNotEmpty((Object)(fillForeColor = style.getFillForegroundXSSFColor())) && (ctColor = fillForeColor.getCTColor()) != null && ctColor.isSetTheme()) {
            byte[] rgb;
            int themeIndex = (int)ctColor.getTheme();
            short tint = (short)Math.round(ctColor.getTint() * 100.0);
            XSSFWorkbook workbook = (XSSFWorkbook)sheet.getWorkbook();
            ThemesTable theme = workbook.getTheme();
            if (theme != null && (color = theme.getThemeColor(themeIndex)) != null && tint != 0 && (rgb = color.getRGB()) != null) {
                float factor = (float)tint / 100.0f;
                int r = Math.min(255, (int)((float)(rgb[0] & 0xFF) * (1.0f - factor) + factor * 255.0f));
                int g = Math.min(255, (int)((float)(rgb[1] & 0xFF) * (1.0f - factor) + factor * 255.0f));
                int b = Math.min(255, (int)((float)(rgb[2] & 0xFF) * (1.0f - factor) + factor * 255.0f));
                color = new XSSFColor(new byte[]{(byte)r, (byte)g, (byte)b}, null);
            }
        }
        return color;
    }

    private XSSFColor getFontColor(XSSFFont font) {
        return this.getColorByIndex(font.getXSSFColor());
    }

    private XSSFColor getColorByIndex(XSSFColor color) {
        if (color == null) {
            return null;
        }
        byte[] rgb = color.getRGB();
        if (rgb != null && rgb.length >= 3) {
            return new XSSFColor(new byte[]{(byte)(rgb[0] & 0xFF), (byte)(rgb[1] & 0xFF), (byte)(rgb[2] & 0xFF)}, null);
        }
        return null;
    }

    private Map<String, String> rgbToMap(XSSFColor color) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (color == null || color.getRGB() == null) {
            return null;
        }
        byte[] rgb = color.getRGB();
        int red = rgb[0] & 0xFF;
        int green = rgb[1] & 0xFF;
        int blue = rgb[2] & 0xFF;
        String hexColor = String.format("#%02x%02x%02x", red, green, blue);
        map.put("rgb", hexColor);
        return map;
    }

    private BorderStyleData createBorderStyleData(XSSFCellStyle style) {
        BorderStyle rightStyle;
        BorderStyle leftStyle;
        BorderStyle bottomStyle;
        boolean hasBorder = false;
        BorderStyleData borderStyleData = new BorderStyleData();
        BorderStyle topStyle = style.getBorderTop();
        if (topStyle != BorderStyle.NONE) {
            BorderData borderData = new BorderData();
            borderData.setS((int)topStyle.getCode());
            XSSFColor topColor = style.getTopBorderXSSFColor();
            if (topColor != null) {
                borderData.setCl(this.rgbToMap(topColor));
            }
            borderStyleData.setT(borderData);
            hasBorder = true;
        }
        if ((bottomStyle = style.getBorderBottom()) != BorderStyle.NONE) {
            BorderData borderData = new BorderData();
            borderData.setS((int)bottomStyle.getCode());
            XSSFColor bottomColor = style.getBottomBorderXSSFColor();
            if (bottomColor != null) {
                borderData.setCl(this.rgbToMap(bottomColor));
            }
            borderStyleData.setB(borderData);
            hasBorder = true;
        }
        if ((leftStyle = style.getBorderLeft()) != BorderStyle.NONE) {
            BorderData borderData = new BorderData();
            borderData.setS((int)leftStyle.getCode());
            XSSFColor leftColor = style.getLeftBorderXSSFColor();
            if (leftColor != null) {
                borderData.setCl(this.rgbToMap(leftColor));
            }
            borderStyleData.setL(borderData);
            hasBorder = true;
        }
        if ((rightStyle = style.getBorderRight()) != BorderStyle.NONE) {
            BorderData borderData = new BorderData();
            borderData.setS((int)rightStyle.getCode());
            XSSFColor rightColor = style.getRightBorderXSSFColor();
            if (rightColor != null) {
                borderData.setCl(this.rgbToMap(rightColor));
            }
            borderStyleData.setR(borderData);
            hasBorder = true;
        }
        return hasBorder ? borderStyleData : null;
    }

    private void setAlignmentData(XSSFCellStyle style, IStyleData styleData) {
        HorizontalAlignment horizontalAlignment = style.getAlignment();
        VerticalAlignment verticalAlignment = style.getVerticalAlignment();
        switch (horizontalAlignment) {
            case LEFT: {
                styleData.setHt(Integer.valueOf(AlignConstants.HT_LEFT.getValue()));
                break;
            }
            case CENTER: {
                styleData.setHt(Integer.valueOf(AlignConstants.HT_CENTER.getValue()));
                break;
            }
            case RIGHT: {
                styleData.setHt(Integer.valueOf(AlignConstants.HT_RIGHT.getValue()));
            }
        }
        switch (verticalAlignment) {
            case TOP: {
                styleData.setVt(Integer.valueOf(AlignConstants.VT_TOP.getValue()));
                break;
            }
            case CENTER: {
                styleData.setVt(Integer.valueOf(AlignConstants.VT_CENTER.getValue()));
                break;
            }
            case BOTTOM: {
                styleData.setVt(Integer.valueOf(AlignConstants.VT_BOTTOM.getValue()));
            }
        }
    }

    static {
        ZipSecureFile.setMinInflateRatio((double)0.005);
    }
}

