/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.dataset.controller;

import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.dataset.util.FileUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.application.dataset.controller.TestApiController")
@RequestMapping(value={"/hussarTest"})
public class TestApiController {
    private static final List<SysReport> reports = new ArrayList<SysReport>();
    @Resource
    private EngineBussnessdataInvokeService engineBussnessdataInvokeService;

    @GetMapping(value={"/getReportByNameGet"})
    public ApiResponse<List<SysReport>> getSysReportByNameGet(@RequestParam(value="reportName", required=false) String reportName, @RequestParam(value="reportId", required=false) Long reportId) {
        List filteredReports = reports.stream().filter(report -> !(reportName != null && !reportName.isEmpty() && !report.getReportName().equals(reportName) || reportId != null && !report.getReportId().equals(reportId))).collect(Collectors.toList());
        return ApiResponse.success(filteredReports);
    }

    @PostMapping(value={"/getReportByNamePost"})
    public List<SysReport> getSysReportByNamePost(@RequestParam(value="reportName", required=false) String reportName, @RequestParam(value="reportId", required=false) Long reportId) {
        List<SysReport> filteredReports = reports.stream().filter(report -> !(reportName != null && !reportName.isEmpty() && !report.getReportName().equals(reportName) || reportId != null && !report.getReportId().equals(reportId))).collect(Collectors.toList());
        return filteredReports;
    }

    @PostMapping(value={"/getReportByNameFromBody"})
    public List<SysReport> getSysReportByNameFromBody(@RequestBody Map<String, Object> params) {
        String reportName = (String)params.get("reportName");
        Long reportId = (Long)params.get("reportId");
        List<SysReport> filteredReports = reports.stream().filter(report -> !(reportName != null && !reportName.isEmpty() && !report.getReportName().equals(reportName) || reportId != null && !report.getReportId().equals(reportId))).collect(Collectors.toList());
        return filteredReports;
    }

    @PostMapping(value={"/getReportByNameFromBodyTime"})
    public ApiResponse<List<SysReport>> getReportByNameFromBodyTime(@RequestBody(required=false) TimeTest timeTest) {
        if (HussarUtils.isEmpty((Object)timeTest)) {
            return ApiResponse.success(reports);
        }
        String time = timeTest.getTime();
        String name = timeTest.getName();
        String startTime1 = time;
        String endTime1 = "";
        if (HussarUtils.isNotEmpty((Object)time) && time.contains(",")) {
            startTime1 = time.split(",")[0];
            endTime1 = time.split(",")[1];
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = HussarUtils.isEmpty((Object)startTime1) ? null : LocalDateTime.parse(startTime1, formatter);
        LocalDateTime endTime = HussarUtils.isEmpty((Object)endTime1) ? null : LocalDateTime.parse(endTime1, formatter);
        List filteredReports = reports.stream().filter(report -> !(report.getCreateTime() == null || startTime != null && report.getCreateTime().isBefore(startTime) || endTime != null && report.getCreateTime().isAfter(endTime) || name != null && !name.isEmpty() && !report.getReportName().contains(name))).collect(Collectors.toList());
        return ApiResponse.success(filteredReports);
    }

    @GetMapping(value={"/getReportByNameFromTime"})
    public ApiResponse<List<SysReport>> getReportByNameFromTime(@RequestParam String time) {
        String startTime1 = time;
        String endTime1 = "";
        if (time.contains(",")) {
            startTime1 = time.split(",")[0];
            endTime1 = time.split(",")[1];
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = startTime1.isEmpty() ? null : LocalDateTime.parse(startTime1, formatter);
        LocalDateTime endTime = endTime1.isEmpty() ? null : LocalDateTime.parse(endTime1, formatter);
        List filteredReports = reports.stream().filter(report -> !(report.getCreateTime() == null || startTime != null && report.getCreateTime().isBefore(startTime) || endTime != null && report.getCreateTime().isAfter(endTime))).collect(Collectors.toList());
        return ApiResponse.success(filteredReports);
    }

    @PostMapping(value={"/getApiDashboard"})
    public ApiResponse<Object> getApiDashboard(@RequestBody(required=false) Map<String, Object> params) {
        String businessId = String.format("%s /%s", "POST", FileUtil.posixPath((String[])new String[]{"sqlModelCustomSql"}));
        params.put("tfModelId", "1004699211595522048");
        HashMap groupAggregation = new HashMap();
        ArrayList<String> group = new ArrayList<String>();
        group.add("year");
        groupAggregation.put("group", group);
        HashMap agg = new HashMap();
        ApiResponse queryResult = this.engineBussnessdataInvokeService.invoke(businessId, params);
        return queryResult;
    }

    @GetMapping(value={"/getReport"})
    public ApiResponse<List<SysReport>> getSysReportGet() {
        return ApiResponse.success(reports);
    }

    @PostMapping(value={"/getReportPost"})
    public ApiResponse<List<SysReport>> getSysReportPost() {
        return ApiResponse.success(reports);
    }

    static {
        List<SysReport> tempReports = Arrays.asList(new SysReport(1, "icon1", "#2794F8", "1", "\u8303\u56f41", "dataset1", "\u8bbe\u8ba1\u4fe1\u606f1", "\u9500\u552e\u62a5\u8868\u63cf\u8ff0", Long.valueOf(100L), "\u9500\u552e\u62a5\u8868", Long.valueOf(1L)), new SysReport(2, "icon2", "#2794F8", "2", "\u8303\u56f42", "dataset2", "\u8bbe\u8ba1\u4fe1\u606f2", "\u5e93\u5b58\u62a5\u8868\u63cf\u8ff0", Long.valueOf(101L), "\u5e93\u5b58\u62a5\u8868", Long.valueOf(2L)), new SysReport(3, "icon3", "#2794F8", "1", "\u8303\u56f43", "dataset3", "\u8bbe\u8ba1\u4fe1\u606f3", "\u8d22\u52a1\u62a5\u8868\u63cf\u8ff0", Long.valueOf(102L), "\u8d22\u52a1\u62a5\u8868", Long.valueOf(3L)), new SysReport(4, "icon4", "#2794F8", "1", "\u8303\u56f44", "dataset4", "\u8bbe\u8ba1\u4fe1\u606f4", "\u4eba\u529b\u8d44\u6e90\u62a5\u8868\u63cf\u8ff0", Long.valueOf(103L), "\u4eba\u529b\u8d44\u6e90\u62a5\u8868", Long.valueOf(4L)), new SysReport(5, "icon5", "#2794F8", "2", "\u8303\u56f45", "dataset5", "\u8bbe\u8ba1\u4fe1\u606f5", "\u91c7\u8d2d\u62a5\u8868\u63cf\u8ff0", Long.valueOf(104L), "\u91c7\u8d2d\u62a5\u8868", Long.valueOf(5L)), new SysReport(6, "icon6", "#2794F8", "1", "\u8303\u56f46", "dataset6", "\u8bbe\u8ba1\u4fe1\u606f6", "\u5e02\u573a\u62a5\u8868\u63cf\u8ff0", Long.valueOf(105L), "\u5e02\u573a\u62a5\u8868", Long.valueOf(6L)));
        LocalDateTime time1 = LocalDateTime.of(2025, 5, 28, 16, 19, 52);
        LocalDateTime time2 = LocalDateTime.of(2025, 5, 29, 10, 30, 45);
        LocalDateTime time3 = LocalDateTime.of(2025, 5, 30, 14, 45, 30);
        LocalDateTime time4 = LocalDateTime.of(2025, 6, 1, 9, 15, 20);
        LocalDateTime time5 = LocalDateTime.of(2025, 6, 2, 11, 50, 10);
        LocalDateTime time6 = LocalDateTime.of(2025, 6, 3, 15, 5, 55);
        int index = 0;
        for (SysReport report : tempReports) {
            switch (index) {
                case 0: {
                    report.setCreateTime(time1);
                    report.setLastTime(time1);
                    break;
                }
                case 1: {
                    report.setCreateTime(time2);
                    report.setLastTime(time2);
                    break;
                }
                case 2: {
                    report.setCreateTime(time3);
                    report.setLastTime(time3);
                    break;
                }
                case 3: {
                    report.setCreateTime(time4);
                    report.setLastTime(time4);
                    break;
                }
                case 4: {
                    report.setCreateTime(time5);
                    report.setLastTime(time5);
                    break;
                }
                case 5: {
                    report.setCreateTime(time6);
                    report.setLastTime(time6);
                }
            }
            report.setCreator(Long.valueOf(1001L));
            report.setLastEditor(Long.valueOf(1001L));
            ++index;
        }
        reports.addAll(tempReports);
    }

    public static class TimeTest {
        private String time;
        private String name;

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

