/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.dataset.controller;

import com.jxdinfo.hussar.application.dataset.Dto.SelectDto;
import com.jxdinfo.hussar.application.dataset.Dto.SelectPageDto;
import com.jxdinfo.hussar.application.dataset.service.IDatasetService;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.SqlDataSetDto;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetTableFieldInfo;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.dataset.vo.SqlDataSetVo;
import com.jxdinfo.hussar.dataset.vo.WordDataSetGroupAllVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.application.dataset.controller.DataSetController")
@RequestMapping(value={"/hussarReport/dataSet"})
public class DataSetController {
    @Resource
    private IDataSetService dataSetService;
    @Resource
    private IDataSetEngineService dataSetEngineService;
    @Resource
    private IDatasetService datasetService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u96c6", notes="\u521b\u5efa\u6570\u636e\u96c6")
    public ApiResponse<Object> addDataSetInfo(@ApiParam(value="\u6570\u636e\u96c6\u5b9e\u4f53") @RequestBody DataSetInfoDto wordDataSetInfoDto) {
        return this.dataSetService.addDataSetInfo(wordDataSetInfoDto);
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u96c6", notes="\u7f16\u8f91\u6570\u636e\u96c6")
    public ApiResponse<Object> editDataSetInfo(@ApiParam(value="\u6570\u636e\u96c6\u5b9e\u4f53") @RequestBody DataSetInfoDto wordDataSetInfoDto) {
        return this.dataSetService.editDataSetInfo(wordDataSetInfoDto);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u6570\u636e\u96c6\u5220\u9664", notes="\u6570\u636e\u96c6\u5220\u9664")
    public ApiResponse<Boolean> deleteDataSetInfo(@ApiParam(value="\u6570\u636e\u96c6Id") @RequestParam Long id) {
        return this.dataSetService.deleteDataSetInfo(id);
    }

    @GetMapping(value={"/manage/list"})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u96c6\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u96c6\u5217\u8868")
    public ApiResponse<List<WordDataSetInfo>> getDataSetInfoList(@ApiParam(value="\u6570\u636e\u96c6\u540d\u79f0") @RequestParam String dataSetName, @ApiParam(value="\u6570\u636e\u96c6\u540d\u79f0") @RequestParam String dataSetType) {
        return ApiResponse.success((Object)this.dataSetService.getDataSetInfoList(dataSetName, dataSetType));
    }

    @GetMapping(value={"/manage/groupList"})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u96c6\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u96c6\u5217\u8868")
    public ApiResponse<List<WordDataSetGroupAllVo>> getDataSetList(@ApiParam(value="\u6570\u636e\u96c6\u540d\u79f0") @RequestParam String dataSetName, @ApiParam(value="\u6570\u636e\u96c6\u7c7b\u578b") @RequestParam String dataSetType, @ApiParam(value="\u6570\u636e\u96c6\u5206\u7ec4") @RequestParam Long groupId) {
        return ApiResponse.success((Object)this.dataSetService.getDataSetGroupList(dataSetName, dataSetType, groupId));
    }

    @GetMapping(value={"/getDataSetInfo"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6570\u636e\u96c6\u4fe1\u606f", notes="\u6839\u636eid\u83b7\u53d6\u6570\u636e\u96c6\u4fe1\u606f")
    public ApiResponse<WordDataSetInfo> getDataSetInfo(Long id) {
        return ApiResponse.success((Object)this.dataSetService.getById((Serializable)id));
    }

    @PostMapping(value={"/getDataSetInfoByIds"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6570\u636e\u96c6\u4fe1\u606f", notes="\u6839\u636eid\u83b7\u53d6\u6570\u636e\u96c6\u4fe1\u606f")
    public ApiResponse<List<WordDataSetInfo>> getDataSetInfoByIds(@RequestBody List<Long> ids) {
        return ApiResponse.success((Object)this.dataSetService.getDataSetInfoByIds(ids));
    }

    @PostMapping(value={"/preivewDataBySql"})
    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u96c6\u81ea\u5b9a\u4e49SQL")
    public ApiResponse<SqlDataSetVo> preivewDataBySql(@RequestBody SqlDataSetDto sqlDataSetDto) {
        SqlDataSetVo sqlDataSetVo = this.dataSetService.preivewDataBySql(sqlDataSetDto);
        return ApiResponse.success((Object)sqlDataSetVo);
    }

    @GetMapping(value={"/tableInfoListByDbName"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u8868\u4fe1\u606f", notes="\u67e5\u8be2\u6240\u6709\u8868\u4fe1\u606f")
    public ApiResponse<List<DataSetTableFieldInfo>> tableInfoList(@RequestParam(value="dataSourceName") String dataSourceName) {
        return ApiResponse.success((Object)this.dataSetService.tableInfoList(dataSourceName));
    }

    @GetMapping(value={"/tableInfoList"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u8868\u4fe1\u606f", notes="\u67e5\u8be2\u6240\u6709\u8868\u4fe1\u606f")
    public ApiResponse<List<DataSetTableFieldInfo>> tableInfoList(@RequestParam(value="id") Long datasourceId, @RequestParam(value="type") String type) {
        return ApiResponse.success((Object)this.dataSetService.tableInfoList(datasourceId, type));
    }

    @PostMapping(value={"/executeResult"})
    public ApiResponse<List<DataSetExecuteVO>> executeDataSetParam(@RequestBody List<DataSetCommonParam> dataSetCommonParams) {
        return this.dataSetEngineService.executeDataSetParam(dataSetCommonParams);
    }

    @PostMapping(value={"/executeDefaultResult"})
    @ApiOperation(value="\u9ed8\u8ba4\u67e5\u8be2", notes="\u9ed8\u8ba4\u67e5\u8be2")
    public ApiResponse<List<DataSetExecuteVO>> executeDefaultResult(@RequestBody SelectDto selectDto) {
        return ApiResponse.success((Object)this.datasetService.executeDefaultResult(selectDto.getReportId(), selectDto.getSheetId(), selectDto.getSuperQueryConditionDtoMap()));
    }

    @PostMapping(value={"/executeDefaultResultByPage"})
    @ApiOperation(value="\u9ed8\u8ba4\u67e5\u8be2", notes="\u9ed8\u8ba4\u67e5\u8be2")
    public ApiResponse<List<DataSetExecuteVO>> executeDefaultResultByPage(@RequestBody SelectPageDto selectPageDto) {
        return ApiResponse.success((Object)this.datasetService.executeDefaultResultByPage(selectPageDto.getReportId(), selectPageDto.getSheetId(), selectPageDto.getDataSetCommonParams()));
    }

    @PostMapping(value={"/formatResult"})
    @ApiOperation(value="\u683c\u5f0f\u5316\u67e5\u8be2", notes="\u683c\u5f0f\u5316\u67e5\u8be2")
    public ApiResponse<List<DataSetExecuteVO>> formatResult(@RequestBody List<DataSetCommonParam> dataSetCommonParams) {
        return ApiResponse.success((Object)this.datasetService.formatResult(dataSetCommonParams));
    }

    @GetMapping(value={"/getOnlyTables"})
    @ApiOperation(value="\u6839\u636e\u8868\u540d\u67e5\u8be2\u8868\u4fe1\u606f\uff08\u4e0d\u5305\u542b\u5217\uff09", notes="\u6839\u636e\u8868\u540d\u67e5\u8be2\u5217\u4fe1\u606f\uff08\u4e0d\u5305\u542b\u5217\uff09")
    public ApiResponse<List<DataSetTableFieldInfo>> getOnlyTables(@RequestParam(value="dataSourceId") Long datasourceId, @RequestParam(value="type") String type) {
        return ApiResponse.success((Object)this.dataSetService.getOnlyTables(datasourceId, type));
    }

    @GetMapping(value={"/getColumnByTableName"})
    @ApiOperation(value="\u6839\u636e\u8868\u540d\u67e5\u8be2\u5217\u4fe1\u606f", notes="\u6839\u636e\u8868\u540d\u67e5\u8be2\u5217\u4fe1\u606f")
    public ApiResponse<List<DataSetTableFieldInfo>> getColumnByTableName(@RequestParam(value="dataSourceId") Long datasourceId, @RequestParam(value="tableName") String tableName, @RequestParam(value="type") String type) {
        return ApiResponse.success((Object)this.dataSetService.getColumnByTableName(datasourceId, tableName, type));
    }
}

